/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.config.Kryo$;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Word2VecBase;
import org.apache.spark.ml.feature.Word2VecModel$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelReader$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelWriter$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.VersionUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r]c\u0001B\u001f?\u0001%C\u0001\"\u0017\u0001\u0003\u0006\u0004%\tE\u0017\u0005\tc\u0002\u0011\t\u0011)A\u00057\"A1\u000f\u0001BC\u0002\u0013%A\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003v\u0011!\t\u0019\u0001\u0001C\u0001\u0001\u0006\u0015\u0001BCA\u0007\u0001!\u0015\r\u0011\"\u0001\u0002\u0010!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA\u001e\u0001\u0011\u0005\u0011q\n\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\tI\u0007\u0001C\u0001\u0003\u0013Cq!!%\u0001\t\u0003\t\u0019\nC\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011q\u001a\u0001\u0005B\u0005E\u0007bBAs\u0001\u0011\u0005\u0013q\u001d\u0005\b\u0003\u007f\u0004A\u0011\tB\u0001\u0011\u001d\u0011y\u0001\u0001C!\u0005#9qAa\u0007?\u0011\u0003\u0011iB\u0002\u0004>}!\u0005!q\u0004\u0005\b\u0003\u0007\u0019B\u0011\u0001B\u001a\r\u001d\u0011)d\u0005!\u0014\u0005oA\u0011\"!\u0011\u0016\u0005+\u0007I\u0011\u0001.\t\u0013\t}RC!E!\u0002\u0013Y\u0006B\u0003B!+\tU\r\u0011\"\u0001\u0003D!Q!QJ\u000b\u0003\u0012\u0003\u0006IA!\u0012\t\u000f\u0005\rQ\u0003\"\u0001\u0003P!I\u0011Q]\u000b\u0002\u0002\u0013\u0005!\u0011\f\u0005\n\u0005?*\u0012\u0013!C\u0001\u0005CB\u0011B!\u001e\u0016#\u0003%\tAa\u001e\t\u0013\tmT#!A\u0005B\tu\u0004\"\u0003BG+\u0005\u0005I\u0011\u0001BH\u0011%\u0011\t*FA\u0001\n\u0003\u0011\u0019\nC\u0005\u0003\u001aV\t\t\u0011\"\u0011\u0003\u001c\"I!\u0011V\u000b\u0002\u0002\u0013\u0005!1\u0016\u0005\n\u0005k+\u0012\u0011!C!\u0005oC\u0011Ba\u0004\u0016\u0003\u0003%\tE!/\t\u0013\tmV#!A\u0005B\tuvA\u0003Ba'\u0005\u0005\t\u0012A\n\u0003D\u001aQ!QG\n\u0002\u0002#\u00051C!2\t\u000f\u0005\rq\u0005\"\u0001\u0003T\"I!qB\u0014\u0002\u0002\u0013\u0015#\u0011\u0018\u0005\n\u0005+<\u0013\u0011!CA\u0005/D\u0011B!8(\u0003\u0003%\tIa8\t\u0013\t5x%!A\u0005\n\t=ha\u0002B|'\u0001\u0019\"\u0011 \u0005\n\u0005wl#\u0011!Q\u0001\n9Cq!a\u0001.\t\u0003\u0011i\u0010C\u0004\u0004\u00045\"\tf!\u0002\b\u0011\rE1\u0003#\u0001?\u0007'1\u0001Ba>\u0014\u0011\u0003q4Q\u0003\u0005\b\u0003\u0007\u0011D\u0011AB\f\u0011\u001d\u0019IB\rC\u0001\u000771aaa\f\u0014\t\rE\u0002bBA\u0002k\u0011\u00051\u0011\b\u0005\n\u0007{)$\u0019!C\u0005\u0005{B\u0001ba\u00106A\u0003%!q\u0010\u0005\b\u0007\u0003*D\u0011IB\"\u0011\u001d\u00199e\u0005C!\u0007\u0013Bqa!\u0011\u0014\t\u0003\u001ai\u0005C\u0005\u0003nN\t\t\u0011\"\u0003\u0003p\niqk\u001c:eeY+7-T8eK2T!a\u0010!\u0002\u000f\u0019,\u0017\r^;sK*\u0011\u0011IQ\u0001\u0003[2T!a\u0011#\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00153\u0015AB1qC\u000eDWMC\u0001H\u0003\ry'oZ\u0002\u0001'\u0011\u0001!\nU*\u0011\u0007-ce*D\u0001A\u0013\ti\u0005IA\u0003N_\u0012,G\u000e\u0005\u0002P\u00015\ta\b\u0005\u0002P#&\u0011!K\u0010\u0002\r/>\u0014HM\r,fG\n\u000b7/\u001a\t\u0003)^k\u0011!\u0016\u0006\u0003-\u0002\u000bA!\u001e;jY&\u0011\u0001,\u0016\u0002\u000b\u001b2;&/\u001b;bE2,\u0017aA;jIV\t1\f\u0005\u0002]K:\u0011Ql\u0019\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\"\u000ba\u0001\u0010:p_Rt$\"\u00012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\f\u0017A\u0002)sK\u0012,g-\u0003\u0002gO\n11\u000b\u001e:j]\u001eT!\u0001Z1)\u0007\u0005Iw\u000e\u0005\u0002k[6\t1N\u0003\u0002m\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00059\\'!B*j]\u000e,\u0017%\u00019\u0002\u000bErCG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005%|\u0017aC<pe\u00124Vm\u0019;peN,\u0012!\u001e\t\u0003mjl\u0011a\u001e\u0006\u0003\u007faT!!\u001f\"\u0002\u000b5dG.\u001b2\n\u0005u:\u0018\u0001D<pe\u00124Vm\u0019;peN\u0004\u0003F\u0001\u0003~!\tqx0D\u0001b\u0013\r\t\t!\u0019\u0002\niJ\fgn]5f]R\fa\u0001P5oSRtD#\u0002(\u0002\b\u0005-\u0001\"B-\u0006\u0001\u0004Y\u0006\u0006BA\u0004S>DQa]\u0003A\u0002U\f!bZ3u-\u0016\u001cGo\u001c:t+\t\t\t\u0002\u0005\u0003\u0002\u0014\u00055b\u0002BA\u000b\u0003OqA!a\u0006\u0002$9!\u0011\u0011DA\u0011\u001d\u0011\tY\"a\b\u000f\u0007y\u000bi\"C\u0001H\u0013\t)e)\u0003\u0002D\t&\u0019\u0011Q\u0005\"\u0002\u0007M\fH.\u0003\u0003\u0002*\u0005-\u0012a\u00029bG.\fw-\u001a\u0006\u0004\u0003K\u0011\u0015\u0002BA\u0018\u0003c\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\u0005%\u00121\u0006\u0015\u0003\ruDCAB5\u00028\u0005\u0012\u0011\u0011H\u0001\u0006c9*d\u0006M\u0001\rM&tGmU=o_:LXn\u001d\u000b\u0007\u0003#\ty$a\u0011\t\r\u0005\u0005s\u00011\u0001\\\u0003\u00119xN\u001d3\t\u000f\u0005\u0015s\u00011\u0001\u0002H\u0005\u0019a.^7\u0011\u0007y\fI%C\u0002\u0002L\u0005\u00141!\u00138uQ\u00119\u0011.a\u000e\u0015\r\u0005E\u0011\u0011KA1\u0011\u001d\t\u0019\u0006\u0003a\u0001\u0003+\n1A^3d!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.\u0001\u00061A.\u001b8bY\u001eLA!a\u0018\u0002Z\t1a+Z2u_JDq!!\u0012\t\u0001\u0004\t9\u0005\u000b\u0003\tS\u0006\u0015\u0014EAA4\u0003\u0015\u0011d\u0006\r\u00181\u0003E1\u0017N\u001c3Ts:|g._7t\u0003J\u0014\u0018-\u001f\u000b\u0007\u0003[\ny(!!\u0011\u000by\fy'a\u001d\n\u0007\u0005E\u0014MA\u0003BeJ\f\u0017\u0010\u0005\u0004\u007f\u0003kZ\u0016\u0011P\u0005\u0004\u0003o\n'A\u0002+va2,'\u0007E\u0002\u007f\u0003wJ1!! b\u0005\u0019!u.\u001e2mK\"9\u00111K\u0005A\u0002\u0005U\u0003bBA#\u0013\u0001\u0007\u0011q\t\u0015\u0005\u0013%\f))\t\u0002\u0002\b\u0006)!G\f\u001a/aQ1\u0011QNAF\u0003\u001bCa!!\u0011\u000b\u0001\u0004Y\u0006bBA#\u0015\u0001\u0007\u0011q\t\u0015\u0005\u0015%\f))A\u0006tKRLe\u000e];u\u0007>dG\u0003BAK\u0003/k\u0011\u0001\u0001\u0005\u0007\u00033[\u0001\u0019A.\u0002\u000bY\fG.^3)\u0007-Iw.\u0001\u0007tKR|U\u000f\u001e9vi\u000e{G\u000e\u0006\u0003\u0002\u0016\u0006\u0005\u0006BBAM\u0019\u0001\u00071\fK\u0002\rS>\f\u0011\u0002\u001e:b]N4wN]7\u0015\t\u0005E\u0011\u0011\u0016\u0005\b\u0003Wk\u0001\u0019AAW\u0003\u001d!\u0017\r^1tKR\u0004D!a,\u0002<B1\u0011\u0011WAZ\u0003ok!!a\u000b\n\t\u0005U\u00161\u0006\u0002\b\t\u0006$\u0018m]3u!\u0011\tI,a/\r\u0001\u0011a\u0011QXAU\u0003\u0003\u0005\tQ!\u0001\u0002@\n\u0019q\f\n\u001a\u0012\t\u0005\u0005\u0017q\u0019\t\u0004}\u0006\r\u0017bAAcC\n9aj\u001c;iS:<\u0007c\u0001@\u0002J&\u0019\u00111Z1\u0003\u0007\u0005s\u0017\u0010\u000b\u0003\u000eS\u0006\u0015\u0014a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005M\u0017q\u001c\t\u0005\u0003+\fY.\u0004\u0002\u0002X*!\u0011\u0011\\A\u0016\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ti.a6\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002b:\u0001\r!a5\u0002\rM\u001c\u0007.Z7bQ\rq\u0011n\\\u0001\u0005G>\u0004\u0018\u0010F\u0002O\u0003SDq!a;\u0010\u0001\u0004\ti/A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002p\u0006UXBAAy\u0015\r\t\u0019\u0010Q\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003o\f\tP\u0001\u0005QCJ\fW.T1qQ\u0011y\u0011.a?\"\u0005\u0005u\u0018!B\u0019/i9\n\u0014!B<sSR,WC\u0001B\u0002!\r!&QA\u0005\u0004\u0005\u000f)&\u0001C'M/JLG/\u001a:)\tAI'1B\u0011\u0003\u0005\u001b\tQ!\r\u00187]A\n\u0001\u0002^8TiJLgn\u001a\u000b\u00027\"\"\u0011#\u001bB\u000bC\t\u00119\"A\u00034]Ar\u0003\u0007K\u0002\u0001S>\fQbV8sIJ2VmY'pI\u0016d\u0007CA(\u0014'\u001d\u0019\"\u0011\u0005B\u0014\u0005[\u00012A B\u0012\u0013\r\u0011)#\u0019\u0002\u0007\u0003:L(+\u001a4\u0011\tQ\u0013ICT\u0005\u0004\u0005W)&AC'M%\u0016\fG-\u00192mKB\u0019aPa\f\n\u0007\tE\u0012M\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003\u001e\t!A)\u0019;b'\u001d)\"\u0011\u0005B\u001d\u0005[\u00012A B\u001e\u0013\r\u0011i$\u0019\u0002\b!J|G-^2u\u0003\u00159xN\u001d3!\u0003\u00191Xm\u0019;peV\u0011!Q\t\t\u0006}\u0006=$q\t\t\u0004}\n%\u0013b\u0001B&C\n)a\t\\8bi\u00069a/Z2u_J\u0004CC\u0002B)\u0005+\u00129\u0006E\u0002\u0003TUi\u0011a\u0005\u0005\u0007\u0003\u0003R\u0002\u0019A.\t\u000f\t\u0005#\u00041\u0001\u0003FQ1!\u0011\u000bB.\u0005;B\u0001\"!\u0011\u001c!\u0003\u0005\ra\u0017\u0005\n\u0005\u0003Z\u0002\u0013!a\u0001\u0005\u000b\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003d)\u001a1L!\u001a,\u0005\t\u001d\u0004\u0003\u0002B5\u0005cj!Aa\u001b\u000b\t\t5$qN\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\\1\n\t\tM$1\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005sRCA!\u0012\u0003f\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa \u0011\t\t\u0005%1R\u0007\u0003\u0005\u0007SAA!\"\u0003\b\u0006!A.\u00198h\u0015\t\u0011I)\u0001\u0003kCZ\f\u0017b\u00014\u0003\u0004\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011qI\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9M!&\t\u0013\t]\u0005%!AA\u0002\u0005\u001d\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u001eB1!q\u0014BS\u0003\u000fl!A!)\u000b\u0007\t\r\u0016-\u0001\u0006d_2dWm\u0019;j_:LAAa*\u0003\"\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011iKa-\u0011\u0007y\u0014y+C\u0002\u00032\u0006\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0003\u0018\n\n\t\u00111\u0001\u0002H\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002HQ\u0011!qP\u0001\u0007KF,\u0018\r\\:\u0015\t\t5&q\u0018\u0005\n\u0005/+\u0013\u0011!a\u0001\u0003\u000f\fA\u0001R1uCB\u0019!1K\u0014\u0014\u000b\u001d\u00129M!\f\u0011\u0013\t%'qZ.\u0003F\tESB\u0001Bf\u0015\r\u0011i-Y\u0001\beVtG/[7f\u0013\u0011\u0011\tNa3\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003D\u0006)\u0011\r\u001d9msR1!\u0011\u000bBm\u00057Da!!\u0011+\u0001\u0004Y\u0006b\u0002B!U\u0001\u0007!QI\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tO!;\u0011\u000by\u0014\u0019Oa:\n\u0007\t\u0015\u0018M\u0001\u0004PaRLwN\u001c\t\u0007}\u0006U4L!\u0012\t\u0013\t-8&!AA\u0002\tE\u0013a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0010\u0005\u0003\u0003\u0002\nM\u0018\u0002\u0002B{\u0005\u0007\u0013aa\u00142kK\u000e$(aE,pe\u0012\u0014d+Z2N_\u0012,Gn\u0016:ji\u0016\u00148cA\u0017\u0003\u0004\u0005A\u0011N\\:uC:\u001cW\r\u0006\u0003\u0003\u0000\u000e\u0005\u0001c\u0001B*[!1!1`\u0018A\u00029\u000b\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u0007\u000f\u0019i\u0001E\u0002\u007f\u0007\u0013I1aa\u0003b\u0005\u0011)f.\u001b;\t\r\r=\u0001\u00071\u0001\\\u0003\u0011\u0001\u0018\r\u001e5\u0002']{'\u000f\u001a\u001aWK\u000elu\u000eZ3m/JLG/\u001a:\u0011\u0007\tM#gE\u00023\u0005C!\"aa\u0005\u00027\r\fGnY;mCR,g*^7cKJ|e\rU1si&$\u0018n\u001c8t)!\t9e!\b\u0004(\r-\u0002bBB\u0010i\u0001\u00071\u0011E\u0001\u0012EV4g-\u001a:TSj,\u0017J\u001c\"zi\u0016\u001c\bc\u0001@\u0004$%\u00191QE1\u0003\t1{gn\u001a\u0005\b\u0007S!\u0004\u0019AA$\u0003!qW/\\,pe\u0012\u001c\bbBB\u0017i\u0001\u0007\u0011qI\u0001\u000bm\u0016\u001cGo\u001c:TSj,'aE,pe\u0012\u0014d+Z2N_\u0012,GNU3bI\u0016\u00148cA\u001b\u00044A!Ak!\u000eO\u0013\r\u00199$\u0016\u0002\t\u001b2\u0013V-\u00193feR\u001111\b\t\u0004\u0005'*\u0014!C2mCN\u001ch*Y7f\u0003)\u0019G.Y:t\u001d\u0006lW\rI\u0001\u0005Y>\fG\rF\u0002O\u0007\u000bBaaa\u0004:\u0001\u0004Y\u0016\u0001\u0002:fC\u0012,\"aa\r)\tiJ'1\u0002\u000b\u0004\u001d\u000e=\u0003BBB\bw\u0001\u00071\f\u000b\u0003<S\n-\u0001\u0006B\nj\u0005\u0017ACAE5\u0003\f\u0001")
public class Word2VecModel
extends Model<Word2VecModel>
implements Word2VecBase,
MLWritable {
    private transient Dataset<Row> getVectors;
    private final String uid;
    private final transient org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    private final IntParam vectorSize;
    private final IntParam windowSize;
    private final IntParam numPartitions;
    private final IntParam minCount;
    private final IntParam maxSentenceLength;
    private final LongParam seed;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final Param<String> outputCol;
    private final Param<String> inputCol;
    private volatile transient boolean bitmap$trans$0;

    public static Word2VecModel load(String string) {
        return Word2VecModel$.MODULE$.load(string);
    }

    public static MLReader<Word2VecModel> read() {
        return Word2VecModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getVectorSize() {
        return Word2VecBase.getVectorSize$(this);
    }

    @Override
    public int getWindowSize() {
        return Word2VecBase.getWindowSize$(this);
    }

    @Override
    public int getNumPartitions() {
        return Word2VecBase.getNumPartitions$(this);
    }

    @Override
    public int getMinCount() {
        return Word2VecBase.getMinCount$(this);
    }

    @Override
    public int getMaxSentenceLength() {
        return Word2VecBase.getMaxSentenceLength$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return Word2VecBase.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public final IntParam vectorSize() {
        return this.vectorSize;
    }

    @Override
    public final IntParam windowSize() {
        return this.windowSize;
    }

    @Override
    public final IntParam numPartitions() {
        return this.numPartitions;
    }

    @Override
    public final IntParam minCount() {
        return this.minCount;
    }

    @Override
    public final IntParam maxSentenceLength() {
        return this.maxSentenceLength;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$vectorSize_$eq(IntParam x$1) {
        this.vectorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$windowSize_$eq(IntParam x$1) {
        this.windowSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$numPartitions_$eq(IntParam x$1) {
        this.numPartitions = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$minCount_$eq(IntParam x$1) {
        this.minCount = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$maxSentenceLength_$eq(IntParam x$1) {
        this.maxSentenceLength = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors() {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    }

    private Dataset<Row> getVectors$lzycompute() {
        Word2VecModel word2VecModel = this;
        synchronized (word2VecModel) {
            if (!this.bitmap$trans$0) {
                SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
                Map wordVec = this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors().mapValues((Function1 & Serializable & scala.Serializable)vec -> Vectors$.MODULE$.dense((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vec)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$2 -> x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(Word2VecModel $outer) {
                    }
                }
                this.getVectors = spark.createDataFrame(wordVec.toSeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "vector"}));
                this.bitmap$trans$0 = true;
            }
        }
        return this.getVectors;
    }

    public Dataset<Row> getVectors() {
        return !this.bitmap$trans$0 ? this.getVectors$lzycompute() : this.getVectors;
    }

    public Dataset<Row> findSynonyms(String word, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.findSynonymsArray(word, num)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Dataset<Row> findSynonyms(Vector vec, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.findSynonymsArray(vec, num)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Tuple2<String, Object>[] findSynonymsArray(Vector vec, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(vec.toArray(), num, (Option<String>)None$.MODULE$);
    }

    public Tuple2<String, Object>[] findSynonymsArray(String word, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(word, num);
    }

    public Word2VecModel setInputCol(String value) {
        return (Word2VecModel)this.set(this.inputCol(), value);
    }

    public Word2VecModel setOutputCol(String value) {
        return (Word2VecModel)this.set(this.outputCol(), value);
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(Word2VecModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4(Word2VecModel $outer) {
            }
        }
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Broadcast bcModel = dataset.sparkSession().sparkContext().broadcast((Object)this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors(), ClassTag$.MODULE$.apply(org.apache.spark.mllib.feature.Word2VecModel.class));
        int size = BoxesRunTime.unboxToInt((Object)this.$(this.vectorSize()));
        Vector emptyVec = Vectors$.MODULE$.sparse(size, Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        UserDefinedFunction transformer = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)sentence -> {
            Vector vector;
            if (sentence.isEmpty()) {
                vector = emptyVec;
            } else {
                Map<String, Object> wordIndices = ((org.apache.spark.mllib.feature.Word2VecModel)bcModel.value()).wordIndex();
                float[] wordVectors = ((org.apache.spark.mllib.feature.Word2VecModel)bcModel.value()).wordVectors();
                double[] array = (double[])Array$.MODULE$.ofDim(size, ClassTag$.MODULE$.Double());
                IntRef count = IntRef.create((int)0);
                sentence.foreach((Function1 & Serializable & scala.Serializable)word -> {
                    Word2VecModel.$anonfun$transform$2(wordIndices, size, array, wordVectors, count, word);
                    return BoxedUnit.UNIT;
                });
                Vector vec = Vectors$.MODULE$.dense(array);
                BLAS$.MODULE$.scal(1.0 / (double)count.elem, vec);
                vector = vec;
            }
            return vector;
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(null)));
        return dataset.withColumn(this.$(this.outputCol()), transformer.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})), outputSchema.apply(this.$(this.outputCol())).metadata());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block0: {
            StructType outputSchema = this.validateAndTransformSchema(schema);
            if (!new StringOps(Predef$.MODULE$.augmentString(this.$(this.outputCol()))).nonEmpty()) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.outputCol()), BoxesRunTime.unboxToInt((Object)this.$(this.vectorSize())));
        }
        return var2_2;
    }

    @Override
    public Word2VecModel copy(ParamMap extra) {
        Word2VecModel copied = new Word2VecModel(this.uid(), this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors());
        return (Word2VecModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new Word2VecModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(43).append("Word2VecModel: uid=").append(this.uid()).append(", numWords=").append(this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().wordIndex().size()).append(", ").append("vectorSize=").append(this.$(this.vectorSize())).toString();
    }

    public static final /* synthetic */ void $anonfun$transform$2(Map wordIndices$1, int size$1, double[] array$1, float[] wordVectors$1, IntRef count$1, String word) {
        wordIndices$1.get((Object)word).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            int offset = index * size$1;
            for (int i = 0; i < size$1; ++i) {
                int n = i;
                array$1[n] = array$1[n] + (double)wordVectors$1[offset + i];
            }
        });
        ++count$1.elem;
    }

    public Word2VecModel(String uid, org.apache.spark.mllib.feature.Word2VecModel wordVectors) {
        this.uid = uid;
        this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors = wordVectors;
        HasInputCol.$init$(this);
        HasOutputCol.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasSeed.$init$(this);
        Word2VecBase.$init$(this);
        MLWritable.$init$(this);
    }

    public static class Data
    implements Product,
    scala.Serializable {
        private final String word;
        private final float[] vector;

        public String word() {
            return this.word;
        }

        public float[] vector() {
            return this.vector;
        }

        public Data copy(String word, float[] vector) {
            return new Data(word, vector);
        }

        public String copy$default$1() {
            return this.word();
        }

        public float[] copy$default$2() {
            return this.vector();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.word();
                    break;
                }
                case 1: {
                    object = this.vector();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            String string = this.word();
            String string2 = data.word();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.vector() != data.vector()) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(String word, float[] vector) {
            this.word = word;
            this.vector = vector;
            Product.$init$((Product)this);
        }
    }

    private static class Word2VecModelReader
    extends MLReader<Word2VecModel> {
        private final String className = Word2VecModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public Word2VecModel load(String path) {
            org.apache.spark.mllib.feature.Word2VecModel word2VecModel;
            SparkSession spark = this.sparkSession();
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int major = tuple2._1$mcI$sp();
            int minor = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
            Tuple2.mcII.sp sp3 = sp2;
            int major2 = sp3._1$mcI$sp();
            int minor2 = sp3._2$mcI$sp();
            String dataPath = new Path(path, "data").toString();
            if (major2 < 2 || major2 == 2 && minor2 < 2) {
                Row data = (Row)spark.read().parquet(dataPath).select("wordIndex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wordVectors"})).head();
                Map wordIndex = (Map)data.getAs(0);
                float[] wordVectors = (float[])((TraversableOnce)data.getAs(1)).toArray(ClassTag$.MODULE$.Float());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, Object>)wordIndex, wordVectors);
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator5$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator5$2(Word2VecModelReader $outer) {
                    }
                }
                Map wordVectorsMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spark.read().parquet(dataPath).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator5$2(null)))).collect())).map((Function1 & Serializable & scala.Serializable)wordVector -> new Tuple2((Object)wordVector.word(), (Object)wordVector.vector()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, float[]>)wordVectorsMap);
            }
            org.apache.spark.mllib.feature.Word2VecModel oldModel = word2VecModel;
            Word2VecModel model = new Word2VecModel(metadata.uid(), oldModel);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class Word2VecModelWriter
    extends MLWriter {
        private final Word2VecModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator6$1(Word2VecModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Map<String, float[]> wordVectors = this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors();
            String dataPath = new Path(path, "data").toString();
            long bufferSizeInBytes = Utils$.MODULE$.byteStringAsBytes(this.sc().conf().get(Kryo$.MODULE$.KRYO_SERIALIZER_MAX_BUFFER_SIZE().key(), "64m"));
            int numPartitions = Word2VecModel$Word2VecModelWriter$.MODULE$.calculateNumberOfPartitions(bufferSizeInBytes, this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().wordIndex().size(), this.instance.getVectorSize());
            SparkSession spark = this.sparkSession();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelWriter.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1(Word2VecModelWriter $outer) {
                }
            }
            spark.createDataset(wordVectors.toSeq(), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1(null)))).repartition(numPartitions).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String word = (String)tuple2._1();
                float[] vector = (float[])tuple2._2();
                Data data = new Data(word, vector);
                return data;
            }, spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator6$1(null)))).toDF().write().parquet(dataPath);
        }

        public Word2VecModelWriter(Word2VecModel instance) {
            this.instance = instance;
        }
    }
}

