/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.spark.ml.feature.PolynomialExpansion;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PolynomialExpansion$
implements DefaultParamsReadable<PolynomialExpansion>,
Serializable {
    public static PolynomialExpansion$ MODULE$;

    static {
        new PolynomialExpansion$();
    }

    @Override
    public MLReader<PolynomialExpansion> read() {
        return DefaultParamsReadable.read$(this);
    }

    private int getPolySize(int numFeatures, int degree) {
        long n = CombinatoricsUtils.binomialCoefficient((int)(numFeatures + degree), (int)degree);
        Predef$.MODULE$.require(n <= Integer.MAX_VALUE);
        return (int)n;
    }

    private int expandDense(double[] values, int lastIdx, int degree, double multiplier, double[] polyValues, int curPolyIdx) {
        if (multiplier != 0.0) {
            if (degree == 0 || lastIdx < 0) {
                if (curPolyIdx >= 0) {
                    polyValues[curPolyIdx] = multiplier;
                }
            } else {
                double v = values[lastIdx];
                int lastIdx1 = lastIdx - 1;
                double alpha = multiplier;
                int curStart = curPolyIdx;
                for (int i = 0; i <= degree && alpha != 0.0; ++i, alpha *= v) {
                    curStart = this.expandDense(values, lastIdx1, degree - i, alpha, polyValues, curStart);
                }
            }
        }
        return curPolyIdx + this.getPolySize(lastIdx + 1, degree);
    }

    private int expandSparse(int[] indices, double[] values, int lastIdx, int lastFeatureIdx, int degree, double multiplier, ArrayBuilder<Object> polyIndices, ArrayBuilder<Object> polyValues, int curPolyIdx) {
        BoxedUnit boxedUnit;
        if (multiplier == 0.0) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (degree == 0 || lastIdx < 0) {
            if (curPolyIdx >= 0) {
                polyIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)curPolyIdx));
                boxedUnit = polyValues.$plus$eq((Object)BoxesRunTime.boxToDouble((double)multiplier));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            double v = values[lastIdx];
            int lastIdx1 = lastIdx - 1;
            int lastFeatureIdx1 = indices[lastIdx] - 1;
            double alpha = multiplier;
            int curStart = curPolyIdx;
            for (int i = 0; i <= degree && alpha != 0.0; ++i, alpha *= v) {
                curStart = this.expandSparse(indices, values, lastIdx1, lastFeatureIdx1, degree - i, alpha, polyIndices, polyValues, curStart);
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return curPolyIdx + this.getPolySize(lastFeatureIdx + 1, degree);
    }

    private DenseVector expand(DenseVector dv, int degree) {
        int n = dv.size();
        int polySize = this.getPolySize(n, degree);
        double[] polyValues = new double[polySize - 1];
        this.expandDense(dv.values(), n - 1, degree, 1.0, polyValues, -1);
        return new DenseVector(polyValues);
    }

    private SparseVector expand(SparseVector sv, int degree) {
        int polySize = this.getPolySize(sv.size(), degree);
        int nnz = sv.values().length;
        int nnzPolySize = this.getPolySize(nnz, degree);
        ArrayBuilder polyIndices = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
        polyIndices.sizeHint(nnzPolySize - 1);
        ArrayBuilder polyValues = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        polyValues.sizeHint(nnzPolySize - 1);
        this.expandSparse(sv.indices(), sv.values(), nnz - 1, sv.size() - 1, degree, 1.0, (ArrayBuilder<Object>)polyIndices, (ArrayBuilder<Object>)polyValues, -1);
        return new SparseVector(polySize - 1, (int[])polyIndices.result(), (double[])polyValues.result());
    }

    public Vector expand(Vector v, int degree) {
        DenseVector denseVector;
        Vector vector = v;
        if (vector instanceof DenseVector) {
            DenseVector denseVector2 = (DenseVector)vector;
            denseVector = this.expand(denseVector2, degree);
        } else if (vector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            denseVector = this.expand(sparseVector, degree);
        } else {
            throw new IllegalArgumentException();
        }
        return denseVector;
    }

    @Override
    public PolynomialExpansion load(String path) {
        return (PolynomialExpansion)MLReadable.load$(this, path);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PolynomialExpansion$() {
        MODULE$ = this;
        MLReadable.$init$(this);
        DefaultParamsReadable.$init$(this);
    }
}

