/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.ui.StreamingQueryData;
import org.apache.spark.sql.streaming.ui.StreamingQueryData$;
import org.apache.spark.sql.streaming.ui.StreamingQueryProgressWrapper;
import org.apache.spark.sql.streaming.ui.StreamingQueryProgressWrapper$;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.util.kvstore.KVStoreView;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!\u0002\b\u0010\u0001MY\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001dBQ!\f\u0001\u0005\u00029Bqa\r\u0001C\u0002\u0013%A\u0007\u0003\u0004<\u0001\u0001\u0006I!\u000e\u0005\by\u0001\u0011\r\u0011\"\u00035\u0011\u0019i\u0004\u0001)A\u0005k!9a\b\u0001b\u0001\n\u0013y\u0004BB1\u0001A\u0003%\u0001\tC\u0003c\u0001\u0011%1\rC\u0003m\u0001\u0011\u0005S\u000eC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0003~\u0001\u0011\u0005cP\u0001\u000fTiJ,\u0017-\\5oOF+XM]=Ti\u0006$Xo\u001d'jgR,g.\u001a:\u000b\u0005A\t\u0012AA;j\u0015\t\u00112#A\u0005tiJ,\u0017-\\5oO*\u0011A#F\u0001\u0004gFd'B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0014\u0005\u0001a\u0002CA\u000f\u001f\u001b\u0005\t\u0012BA\u0010\u0012\u0005Y\u0019FO]3b[&tw-U;fefd\u0015n\u001d;f]\u0016\u0014\u0018\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002$I5\tQ#\u0003\u0002&+\tI1\u000b]1sW\u000e{gNZ\u0001\u0006gR|'/\u001a\t\u0003Q-j\u0011!\u000b\u0006\u0003UU\taa\u001d;biV\u001c\u0018B\u0001\u0017*\u0005Q)E.Z7f]R$&/Y2lS:<7\u000b^8sK\u00061A(\u001b8jiz\"2aL\u00193!\t\u0001\u0004!D\u0001\u0010\u0011\u0015\u00013\u00011\u0001#\u0011\u001513\u00011\u0001(\u0003i\u0019HO]3b[&tw\r\u0015:pOJ,7o\u001d*fi\u0016tG/[8o+\u0005)\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$aA%oi\u0006Y2\u000f\u001e:fC6Lgn\u001a)s_\u001e\u0014Xm]:SKR,g\u000e^5p]\u0002\nA$\u001b8bGRLg/Z)vKJL8\u000b^1ukN\u0014V\r^3oi&|g.A\u000fj]\u0006\u001cG/\u001b<f#V,'/_*uCR,8OU3uK:$\u0018n\u001c8!\u0003=\tX/\u001a:z)>\u0004&o\\4sKN\u001cX#\u0001!\u0011\t\u0005C%JT\u0007\u0002\u0005*\u00111\tR\u0001\u000bG>t7-\u001e:sK:$(BA#G\u0003\u0011)H/\u001b7\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011J\u0011\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bCA&M\u001b\u0005!\u0015BA'E\u0005\u0011)V+\u0013#\u0011\u0007=#f+D\u0001Q\u0015\t\t&+A\u0004nkR\f'\r\\3\u000b\u0005M;\u0014AC2pY2,7\r^5p]&\u0011Q\u000b\u0015\u0002\u0006#V,W/\u001a\t\u0003/zs!\u0001\u0017/\u0011\u0005e;T\"\u0001.\u000b\u0005m\u000b\u0013A\u0002\u001fs_>$h(\u0003\u0002^o\u00051\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\tiv'\u0001\trk\u0016\u0014\u0018\u0010V8Qe><'/Z:tA\u000512\r\\3b]V\u0004\u0018J\\1di&4X-U;fe&,7\u000f\u0006\u0002eOB\u0011a'Z\u0005\u0003M^\u0012A!\u00168ji\")\u0001N\u0003a\u0001S\u0006)1m\\;oiB\u0011aG[\u0005\u0003W^\u0012A\u0001T8oO\u0006qqN\\)vKJL8\u000b^1si\u0016$GC\u00013o\u0011\u0015y7\u00021\u0001q\u0003\u0015)g/\u001a8u!\t\tHO\u0004\u0002\u001ee&\u00111/E\u0001\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe&\u0011QO\u001e\u0002\u0012#V,'/_*uCJ$X\rZ#wK:$(BA:\u0012\u0003=yg.U;fef\u0004&o\\4sKN\u001cHC\u00013z\u0011\u0015yG\u00021\u0001{!\t\t80\u0003\u0002}m\n\u0011\u0012+^3ssB\u0013xn\u001a:fgN,e/\u001a8u\u0003Eyg.U;fef$VM]7j]\u0006$X\r\u001a\u000b\u0003I~Daa\\\u0007A\u0002\u0005\u0005\u0001cA9\u0002\u0004%\u0019\u0011Q\u0001<\u0003)E+XM]=UKJl\u0017N\\1uK\u0012,e/\u001a8u\u0001")
public class StreamingQueryStatusListener
extends StreamingQueryListener {
    private final ElementTrackingStore store;
    private final int streamingProgressRetention;
    private final int inactiveQueryStatusRetention;
    private final ConcurrentHashMap<UUID, Queue<String>> queryToProgress;

    private int streamingProgressRetention() {
        return this.streamingProgressRetention;
    }

    private int inactiveQueryStatusRetention() {
        return this.inactiveQueryStatusRetention;
    }

    private ConcurrentHashMap<UUID, Queue<String>> queryToProgress() {
        return this.queryToProgress;
    }

    private void cleanupInactiveQueries(long count) {
        KVStoreView view = this.store.view(StreamingQueryData.class).index("active").first((Object)BoxesRunTime.boxToBoolean((boolean)false)).last((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Seq inactiveQueries = KVUtils$.MODULE$.viewToSeq(view, Integer.MAX_VALUE, (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryStatusListener.$anonfun$cleanupInactiveQueries$1(x$1)));
        int numInactiveQueries = inactiveQueries.size();
        if (numInactiveQueries <= this.inactiveQueryStatusRetention()) {
            return;
        }
        Seq toDelete = (Seq)((IterableLike)inactiveQueries.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)StreamingQueryStatusListener.$anonfun$cleanupInactiveQueries$2(x$2)), (Ordering)Ordering.Long$.MODULE$)).take(numInactiveQueries - this.inactiveQueryStatusRetention());
        Seq runIds = (Seq)toDelete.map((Function1 & Serializable & scala.Serializable)e -> {
            $this.store.delete(e.getClass(), (Object)e.runId());
            return e.runId();
        }, Seq$.MODULE$.canBuildFrom());
        this.store.removeAllByIndexValues(StreamingQueryProgressWrapper.class, "runId", (Iterable)runIds);
    }

    @Override
    public void onQueryStarted(StreamingQueryListener.QueryStartedEvent event) {
        long startTimestamp = UIUtils$.MODULE$.parseProgressTimestamp(event.timestamp());
        this.store.write((Object)new StreamingQueryData(event.name(), event.id(), event.runId().toString(), true, (Option<String>)None$.MODULE$, startTimestamp, StreamingQueryData$.MODULE$.$lessinit$greater$default$7()), true);
    }

    @Override
    public void onQueryProgress(StreamingQueryListener.QueryProgressEvent event) {
        UUID runId = event.progress().runId();
        long batchId = event.progress().batchId();
        String timestamp = event.progress().timestamp();
        Queue<String> queue = !this.queryToProgress().containsKey(runId) ? this.queryToProgress().put(runId, (Queue<String>)Queue$.MODULE$.empty()) : BoxedUnit.UNIT;
        Queue<String> progressIds = this.queryToProgress().get(runId);
        progressIds.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{StreamingQueryProgressWrapper$.MODULE$.getUniqueId(runId, batchId, timestamp)}));
        this.store.write((Object)new StreamingQueryProgressWrapper(event.progress()));
        while (progressIds.length() > this.streamingProgressRetention()) {
            String uniqueId = (String)progressIds.dequeue();
            this.store.delete(StreamingQueryProgressWrapper.class, (Object)uniqueId);
        }
    }

    @Override
    public void onQueryTerminated(StreamingQueryListener.QueryTerminatedEvent event) {
        StreamingQueryData querySummary = (StreamingQueryData)this.store.read(StreamingQueryData.class, (Object)event.runId().toString());
        long curTime = System.currentTimeMillis();
        this.store.write((Object)new StreamingQueryData(querySummary.name(), querySummary.id(), querySummary.runId(), false, querySummary.exception(), querySummary.startTimestamp(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)curTime))), true);
        this.queryToProgress().remove(event.runId());
    }

    public static final /* synthetic */ boolean $anonfun$cleanupInactiveQueries$1(StreamingQueryData x$1) {
        return true;
    }

    public static final /* synthetic */ long $anonfun$cleanupInactiveQueries$2(StreamingQueryData x$2) {
        return BoxesRunTime.unboxToLong((Object)x$2.endTimestamp().get());
    }

    public StreamingQueryStatusListener(SparkConf conf, ElementTrackingStore store) {
        this.store = store;
        this.streamingProgressRetention = BoxesRunTime.unboxToInt((Object)conf.get(StaticSQLConf$.MODULE$.STREAMING_UI_RETAINED_PROGRESS_UPDATES()));
        this.inactiveQueryStatusRetention = BoxesRunTime.unboxToInt((Object)conf.get(StaticSQLConf$.MODULE$.STREAMING_UI_RETAINED_QUERIES()));
        store.addTrigger(StreamingQueryData.class, (long)this.inactiveQueryStatusRetention(), (Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)count -> this.cleanupInactiveQueries(count));
        this.queryToProgress = new ConcurrentHashMap();
    }
}

