/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.io.Serializable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.arrow.ArrayWriter;
import org.apache.spark.sql.execution.arrow.ArrowFieldWriter;
import org.apache.spark.sql.execution.arrow.ArrowWriter;
import org.apache.spark.sql.execution.arrow.BinaryWriter;
import org.apache.spark.sql.execution.arrow.BooleanWriter;
import org.apache.spark.sql.execution.arrow.ByteWriter;
import org.apache.spark.sql.execution.arrow.DateWriter;
import org.apache.spark.sql.execution.arrow.DecimalWriter;
import org.apache.spark.sql.execution.arrow.DoubleWriter;
import org.apache.spark.sql.execution.arrow.DurationWriter;
import org.apache.spark.sql.execution.arrow.FloatWriter;
import org.apache.spark.sql.execution.arrow.IntegerWriter;
import org.apache.spark.sql.execution.arrow.IntervalYearWriter;
import org.apache.spark.sql.execution.arrow.LongWriter;
import org.apache.spark.sql.execution.arrow.MapWriter;
import org.apache.spark.sql.execution.arrow.NullWriter;
import org.apache.spark.sql.execution.arrow.ShortWriter;
import org.apache.spark.sql.execution.arrow.StringWriter;
import org.apache.spark.sql.execution.arrow.StructWriter;
import org.apache.spark.sql.execution.arrow.TimestampNTZWriter;
import org.apache.spark.sql.execution.arrow.TimestampWriter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.util.ArrowUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ArrowWriter$ {
    public static ArrowWriter$ MODULE$;

    static {
        new ArrowWriter$();
    }

    public ArrowWriter create(StructType schema, String timeZoneId) {
        Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(schema, timeZoneId);
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)ArrowUtils$.MODULE$.rootAllocator());
        return this.create(root);
    }

    public ArrowWriter create(VectorSchemaRoot root) {
        Buffer children = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(root.getFieldVectors()).asScala()).map((Function1 & Serializable & scala.Serializable)vector -> {
            vector.allocateNew();
            return MODULE$.createFieldWriter((ValueVector)vector);
        }, Buffer$.MODULE$.canBuildFrom());
        return new ArrowWriter(root, (ArrowFieldWriter[])children.toArray(ClassTag$.MODULE$.apply(ArrowFieldWriter.class)));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private ArrowFieldWriter createFieldWriter(ValueVector vector) {
        void var2_26;
        Field field = vector.getField();
        Tuple2 tuple2 = new Tuple2((Object)ArrowUtils$.MODULE$.fromArrowField(field), (Object)vector);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector2 = (ValueVector)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType) && vector2 instanceof BitVector) {
                BitVector bitVector = (BitVector)vector2;
                BooleanWriter booleanWriter = new BooleanWriter(bitVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector3 = (ValueVector)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType) && vector3 instanceof TinyIntVector) {
                TinyIntVector tinyIntVector = (TinyIntVector)vector3;
                ByteWriter byteWriter = new ByteWriter(tinyIntVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector4 = (ValueVector)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType) && vector4 instanceof SmallIntVector) {
                SmallIntVector smallIntVector = (SmallIntVector)vector4;
                ShortWriter shortWriter = new ShortWriter(smallIntVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector5 = (ValueVector)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType) && vector5 instanceof IntVector) {
                IntVector intVector = (IntVector)vector5;
                IntegerWriter integerWriter = new IntegerWriter(intVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector6 = (ValueVector)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && vector6 instanceof BigIntVector) {
                BigIntVector bigIntVector = (BigIntVector)vector6;
                LongWriter longWriter = new LongWriter(bigIntVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector7 = (ValueVector)tuple2._2();
            if (FloatType$.MODULE$.equals(dataType) && vector7 instanceof Float4Vector) {
                Float4Vector float4Vector = (Float4Vector)vector7;
                FloatWriter floatWriter = new FloatWriter(float4Vector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector8 = (ValueVector)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && vector8 instanceof Float8Vector) {
                Float8Vector float8Vector = (Float8Vector)vector8;
                DoubleWriter doubleWriter = new DoubleWriter(float8Vector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DecimalType decimalType;
            Option option;
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector9 = (ValueVector)tuple2._2();
            if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                int precision = ((Tuple2)option.get())._1$mcI$sp();
                int scale = ((Tuple2)option.get())._2$mcI$sp();
                if (vector9 instanceof DecimalVector) {
                    DecimalVector decimalVector = (DecimalVector)vector9;
                    DecimalWriter decimalWriter = new DecimalWriter(decimalVector, precision, scale);
                    return var2_26;
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector10 = (ValueVector)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && vector10 instanceof VarCharVector) {
                VarCharVector varCharVector = (VarCharVector)vector10;
                StringWriter stringWriter = new StringWriter(varCharVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector11 = (ValueVector)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && vector11 instanceof VarBinaryVector) {
                VarBinaryVector varBinaryVector = (VarBinaryVector)vector11;
                BinaryWriter binaryWriter = new BinaryWriter(varBinaryVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector12 = (ValueVector)tuple2._2();
            if (DateType$.MODULE$.equals(dataType) && vector12 instanceof DateDayVector) {
                DateDayVector dateDayVector = (DateDayVector)vector12;
                DateWriter dateWriter = new DateWriter(dateDayVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector13 = (ValueVector)tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType) && vector13 instanceof TimeStampMicroTZVector) {
                TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)vector13;
                TimestampWriter timestampWriter = new TimestampWriter(timeStampMicroTZVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector14 = (ValueVector)tuple2._2();
            if (TimestampNTZType$.MODULE$.equals(dataType) && vector14 instanceof TimeStampMicroVector) {
                TimeStampMicroVector timeStampMicroVector = (TimeStampMicroVector)vector14;
                TimestampNTZWriter timestampNTZWriter = new TimestampNTZWriter(timeStampMicroVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector15 = (ValueVector)tuple2._2();
            if (dataType instanceof ArrayType && vector15 instanceof ListVector) {
                ListVector listVector = (ListVector)vector15;
                ArrowFieldWriter elementVector = this.createFieldWriter((ValueVector)listVector.getDataVector());
                ArrayWriter arrayWriter = new ArrayWriter(listVector, elementVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector16 = (ValueVector)tuple2._2();
            if (dataType instanceof MapType && vector16 instanceof MapVector) {
                MapVector mapVector = (MapVector)vector16;
                StructVector structVector = (StructVector)mapVector.getDataVector();
                ArrowFieldWriter keyWriter = this.createFieldWriter((ValueVector)structVector.getChild("key"));
                ArrowFieldWriter valueWriter = this.createFieldWriter((ValueVector)structVector.getChild("value"));
                MapWriter mapWriter = new MapWriter(mapVector, structVector, keyWriter, valueWriter);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector17 = (ValueVector)tuple2._2();
            if (dataType instanceof StructType && vector17 instanceof StructVector) {
                StructVector structVector = (StructVector)vector17;
                IndexedSeq children = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), structVector.size()).map((Function1 & Serializable & scala.Serializable)ordinal -> ArrowWriter$.MODULE$.createFieldWriter(structVector.getChildByOrdinal(BoxesRunTime.unboxToInt((Object)ordinal))), IndexedSeq$.MODULE$.canBuildFrom());
                StructWriter structWriter = new StructWriter(structVector, (ArrowFieldWriter[])children.toArray(ClassTag$.MODULE$.apply(ArrowFieldWriter.class)));
                return var2_26;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            ValueVector vector18 = (ValueVector)tuple2._2();
            if (NullType$.MODULE$.equals(dataType) && vector18 instanceof NullVector) {
                NullVector nullVector = (NullVector)vector18;
                NullWriter nullWriter = new NullWriter(nullVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            ValueVector vector19 = (ValueVector)tuple2._2();
            if (tuple2._1() instanceof YearMonthIntervalType && vector19 instanceof IntervalYearVector) {
                IntervalYearVector intervalYearVector = (IntervalYearVector)vector19;
                IntervalYearWriter intervalYearWriter = new IntervalYearWriter(intervalYearVector);
                return var2_26;
            }
        }
        if (tuple2 != null) {
            ValueVector vector20 = (ValueVector)tuple2._2();
            if (tuple2._1() instanceof DayTimeIntervalType && vector20 instanceof DurationVector) {
                DurationVector durationVector = (DurationVector)vector20;
                DurationWriter durationWriter = new DurationWriter(durationVector);
                return var2_26;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        DataType dt = (DataType)tuple2._1();
        throw QueryExecutionErrors$.MODULE$.unsupportedDataTypeError(dt.catalogString());
    }

    private ArrowWriter$() {
        MODULE$ = this;
    }
}

