/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%c!B\f\u0019\u0001i!\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000bu\u0002A\u0011\u0001 \t\u000f\u0005\u0003!\u0019!C\u0005\u0005\"1\u0001\u000b\u0001Q\u0001\n\rCq!\u0015\u0001A\u0002\u0013%!\u000bC\u0004X\u0001\u0001\u0007I\u0011\u0002-\t\ry\u0003\u0001\u0015)\u0003T\u0011\u001dy\u0006\u00011A\u0005\nICq\u0001\u0019\u0001A\u0002\u0013%\u0011\r\u0003\u0004d\u0001\u0001\u0006Ka\u0015\u0005\bI\u0002\u0001\r\u0011\"\u0003f\u0011\u001d9\b\u00011A\u0005\naDaA\u001f\u0001!B\u00131\u0007\"B>\u0001\t\u0013\u0011\u0005\"\u0002?\u0001\t\u0003j\b\"\u0002@\u0001\t\u0003z\bbBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\u0007\u0003S\u0001A\u0011I?\t\r\u0005e\u0002\u0001\"\u0003~\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aa!a\u0010\u0001\t\u0013i\bbBA!\u0001\u0011\u0005\u00131\t\u0002\u001c\u0019><w-\u001b8h!>$7\u000b^1ukN<\u0016\r^2iKJLU\u000e\u001d7\u000b\u0005eQ\u0012AB:vE6LGO\u0003\u0002\u001c9\u0005\u00191\u000eO:\u000b\u0005uq\u0012A\u00023fa2|\u0017P\u0003\u0002 A\u0005)1\u000f]1sW*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h'\u0011\u0001Q%L\u0019\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013\u0001\u00027b]\u001eT\u0011AK\u0001\u0005U\u00064\u0018-\u0003\u0002-O\t1qJ\u00196fGR\u0004\"AL\u0018\u000e\u0003aI!\u0001\r\r\u0003/1{wmZ5oOB{Gm\u0015;biV\u001cx+\u0019;dQ\u0016\u0014\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u001f\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001c4\u0005\u001daunZ4j]\u001e\fAaY8oM\u000e\u0001\u0001C\u0001\u001e<\u001b\u0005Q\u0012B\u0001\u001f\u001b\u0005QYUOY3s]\u0016$Xm\u001d#sSZ,'oQ8oM\u00061A(\u001b8jiz\"\"a\u0010!\u0011\u00059\u0002\u0001\"B\u001c\u0003\u0001\u0004I\u0014!B1qa&#W#A\"\u0011\u0005\u0011keBA#L!\t1\u0015*D\u0001H\u0015\tA\u0005(\u0001\u0004=e>|GO\u0010\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*S\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002M\u0013\u00061\u0011\r\u001d9JI\u0002\nA\u0002]8e\u0007>l\u0007\u000f\\3uK\u0012,\u0012a\u0015\t\u0003)Vk\u0011!S\u0005\u0003-&\u0013qAQ8pY\u0016\fg.\u0001\tq_\u0012\u001cu.\u001c9mKR,Gm\u0018\u0013fcR\u0011\u0011\f\u0018\t\u0003)jK!aW%\u0003\tUs\u0017\u000e\u001e\u0005\b;\u001a\t\t\u00111\u0001T\u0003\rAH%M\u0001\u000ea>$7i\\7qY\u0016$X\r\u001a\u0011\u0002-I,7o\\;sG\u0016$vn\\(mIJ+7-Z5wK\u0012\f!D]3t_V\u00148-\u001a+p_>cGMU3dK&4X\rZ0%KF$\"!\u00172\t\u000fuK\u0011\u0011!a\u0001'\u00069\"/Z:pkJ\u001cW\rV8p\u001f2$'+Z2fSZ,G\rI\u0001\u0004a>$W#\u00014\u0011\u0007Q;\u0017.\u0003\u0002i\u0013\n1q\n\u001d;j_:\u0004\"A[;\u000e\u0003-T!\u0001\\7\u0002\u000b5|G-\u001a7\u000b\u00059|\u0017aA1qS*\u0011\u0001/]\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u0001:t\u0003\u001d1\u0017M\u0019:jGbR\u0011\u0001^\u0001\u0003S>L!A^6\u0003\u0007A{G-A\u0004q_\u0012|F%Z9\u0015\u0005eK\bbB/\r\u0003\u0003\u0005\rAZ\u0001\u0005a>$\u0007%A\u0003qQ\u0006\u001cX-A\u0003sKN,G\u000fF\u0001Z\u00035)g/\u001a8u%\u0016\u001cW-\u001b<fIR)\u0011,!\u0001\u0002(!9\u00111\u0001\tA\u0002\u0005\u0015\u0011AB1di&|g\u000e\u0005\u0003\u0002\b\u0005\u0005b\u0002BA\u0005\u00037qA!a\u0003\u0002\u00189!\u0011QBA\u000b\u001d\u0011\ty!a\u0005\u000f\u0007\u0019\u000b\t\"C\u0001u\u0013\t\u00118/\u0003\u0002qc&\u0019\u0011\u0011D8\u0002\r\rd\u0017.\u001a8u\u0013\u0011\ti\"a\b\u0002\u000f]\u000bGo\u00195fe*\u0019\u0011\u0011D8\n\t\u0005\r\u0012Q\u0005\u0002\u0007\u0003\u000e$\u0018n\u001c8\u000b\t\u0005u\u0011q\u0004\u0005\u0006IB\u0001\r![\u0001\b_:\u001cEn\\:f)\rI\u0016Q\u0006\u0005\b\u0003_\t\u0002\u0019AA\u0019\u0003\u0005)\u0007\u0003BA\u001a\u0003ki!!a\b\n\t\u0005]\u0012q\u0004\u0002\u0011/\u0006$8\r[3s\u000bb\u001cW\r\u001d;j_:\fQ\u0002\\8h\u0019>twm\u0015;biV\u001c\u0018\u0001\u00045bg\u000e{W\u000e\u001d7fi\u0016$G#A*\u0002\u0015\rdwn]3XCR\u001c\u0007.A\u0006xCR\u001c\u0007n\u0014:Ti>\u0004HcA*\u0002F!1\u0011q\t\fA\u0002\r\u000b1a]%e\u0001")
public class LoggingPodStatusWatcherImpl
implements LoggingPodStatusWatcher,
Logging {
    private final KubernetesDriverConf conf;
    private final String appId;
    private boolean podCompleted;
    private boolean resourceTooOldReceived;
    private Option<Pod> pod;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String appId() {
        return this.appId;
    }

    private boolean podCompleted() {
        return this.podCompleted;
    }

    private void podCompleted_$eq(boolean x$1) {
        this.podCompleted = x$1;
    }

    private boolean resourceTooOldReceived() {
        return this.resourceTooOldReceived;
    }

    private void resourceTooOldReceived_$eq(boolean x$1) {
        this.resourceTooOldReceived = x$1;
    }

    private Option<Pod> pod() {
        return this.pod;
    }

    private void pod_$eq(Option<Pod> x$1) {
        this.pod = x$1;
    }

    private String phase() {
        return (String)this.pod().map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.getStatus().getPhase()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "unknown");
    }

    @Override
    public void reset() {
        this.resourceTooOldReceived_$eq(false);
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        this.pod_$eq((Option<Pod>)Option$.MODULE$.apply((Object)pod));
        Watcher.Action action2 = action;
        boolean bl = Watcher.Action.DELETED.equals(action2) ? true : Watcher.Action.ERROR.equals(action2);
        if (bl) {
            this.closeWatch();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            this.logLongStatus();
            if (this.hasCompleted()) {
                this.closeWatch();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void onClose(WatcherException e) {
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(56).append("Stopping watching application ").append(this.appId()).append(" with last-observed phase ").append(this.phase()).toString());
        if (e != null && e.isHttpGone()) {
            this.resourceTooOldReceived_$eq(true);
            this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(57).append("Got HTTP Gone code, resource version changed in k8s api: ").append(e).toString());
        } else {
            this.closeWatch();
        }
    }

    public void onClose() {
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(56).append("Stopping watching application ").append(this.appId()).append(" with last-observed phase ").append(this.phase()).toString());
        this.closeWatch();
    }

    private void logLongStatus() {
        this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(26).append("State changed, new state: ").append(this.pod().map((Function1 & java.io.Serializable & Serializable)pod -> KubernetesUtils$.MODULE$.formatPodState((Pod)pod)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "unknown")).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasCompleted() {
        String string = this.phase();
        String string2 = "Succeeded";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = this.phase();
        String string4 = "Failed";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private synchronized void closeWatch() {
        this.podCompleted_$eq(true);
        this.notifyAll();
    }

    @Override
    public boolean watchOrStop(String sId) {
        boolean bl;
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.WAIT_FOR_APP_COMPLETION()))) {
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(57).append("Waiting for application ").append($this.conf.appName()).append(" with submission ID ").append(sId).append(" to finish...").toString());
            long interval = BoxesRunTime.unboxToLong((Object)this.conf.get(Config$.MODULE$.REPORT_INTERVAL()));
            LoggingPodStatusWatcherImpl loggingPodStatusWatcherImpl = this;
            synchronized (loggingPodStatusWatcherImpl) {
                while (!this.podCompleted() && !this.resourceTooOldReceived()) {
                    this.wait(interval);
                    this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(33).append("Application status for ").append(this.appId()).append(" (phase: ").append(this.phase()).append(")").toString());
                }
            }
            if (this.podCompleted()) {
                this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> (String)this.pod().map((Function1 & java.io.Serializable & Serializable)p -> new StringBuilder(27).append("Container final statuses:\n\n").append(KubernetesUtils$.MODULE$.containersDescription((Pod)p, KubernetesUtils$.MODULE$.containersDescription$default$2())).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "No containers were found in the driver pod."));
                this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("Application ").append($this.conf.appName()).append(" with submission ID ").append(sId).append(" finished").toString());
            }
            bl = this.podCompleted();
        } else {
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(63).append("Deployed Spark application ").append($this.conf.appName()).append(" with submission ID ").append(sId).append(" into Kubernetes").toString());
            bl = true;
        }
        return bl;
    }

    public LoggingPodStatusWatcherImpl(KubernetesDriverConf conf) {
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.appId = conf.appId();
        this.podCompleted = false;
        this.resourceTooOldReceived = false;
        this.pod = Option$.MODULE$.empty();
    }
}

