"""
pikepdf_annotations - PikePDF helper utilities

MIT License

Copyright (c) 2021 Damian Zaremba

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
"""
from decimal import Decimal
from pathlib import PosixPath

from pikepdf_annots import EditableForm, AnnotationMatcher


def test_form_edit():
    class ExampleForm(EditableForm):
        def _get_source_pdf(self) -> PosixPath:
            return PosixPath(__file__).parent / 'data' / '10346E_Diver_Medical_Form.pdf'

    with ExampleForm() as pdf:
        # Text match - fill in name field
        pdf.update_annotation(0,
                              AnnotationMatcher("Participant Name Print",
                                                "Participant Name"),
                              "Bob Smith")

        # Text match - fill in birthday field
        pdf.update_annotation(0,
                              AnnotationMatcher("Birthdate ddmmyyyy",
                                                "Birthday"),
                              "01/01/1900")

        # Rect match - answer yes to question 1
        pdf.update_annotation(0,
                              AnnotationMatcher([Decimal('507.166'),
                                                 Decimal('542.449'),
                                                 Decimal('515.679'),
                                                 Decimal('551.858')],
                                                "Question 1"),
                              True)
