"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryDB = exports.RedisDB = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
function setupVpc(parent, props) {
    return props.existingVpc ?? new aws_cdk_lib_1.aws_ec2.Vpc(parent, 'Vpc', {
        subnetConfiguration: [
            {
                cidrMask: 24,
                name: 'Public Subnet',
                subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC,
            },
            {
                cidrMask: 24,
                name: 'Isolated Subnet',
                subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.ISOLATED,
            },
        ],
    });
}
class RedisDB extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        let isolatedSubnets = [];
        let redisVpc = setupVpc(this, props);
        redisVpc.isolatedSubnets.forEach(function (value) {
            isolatedSubnets.push(value.subnetId);
        });
        if (isolatedSubnets.length == 0) {
            redisVpc.privateSubnets.forEach(function (value) {
                isolatedSubnets.push(value.subnetId);
            });
        }
        const ecSecurityGroup = props.existingSecurityGroup ?? new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, id + '-RedisDB-SG', {
            vpc: redisVpc,
            description: 'SecurityGroup associated with RedisDB Cluster ' + id,
            allowAllOutbound: false,
        });
        let groupName;
        let ecSubnetGroup;
        if (!props.existingSubnetGroupName) {
            ecSubnetGroup = new aws_cdk_lib_1.aws_elasticache.CfnSubnetGroup(this, id + '-RedisDB-SubnetGroup', {
                description: 'RedisDB Subnet Group',
                subnetIds: isolatedSubnets,
                cacheSubnetGroupName: props.subnetGroupName || 'RedisDBSubnetGroup',
            });
            groupName = ecSubnetGroup.cacheSubnetGroupName;
        }
        else {
            groupName = props.existingSubnetGroupName;
        }
        let elasticacheReplicationGroupName = id + '-RedisDB';
        let redis_cluster = new aws_cdk_lib_1.aws_elasticache.CfnReplicationGroup(this, elasticacheReplicationGroupName, {
            numNodeGroups: props.nodes || 1,
            cacheNodeType: props.nodeType || 'cache.m6g.large',
            engine: 'Redis',
            multiAzEnabled: false,
            autoMinorVersionUpgrade: false,
            cacheParameterGroupName: props.parameterGroupName ?? 'default.redis6.x.cluster.on',
            engineVersion: props.engineVersion ?? '6.x',
            cacheSubnetGroupName: groupName,
            securityGroupIds: [ecSecurityGroup.securityGroupId],
            replicationGroupDescription: 'RedisDB setup by CDK',
            atRestEncryptionEnabled: props.atRestEncryptionEnabled,
            transitEncryptionEnabled: props.transitEncryptionEnabled,
            replicasPerNodeGroup: props.replicas || 0,
            authToken: props.authToken,
        });
        this.replicationGroup = redis_cluster;
        if (!props.existingSubnetGroupName) {
            redis_cluster.node.addDependency(ecSubnetGroup);
        }
        if (typeof props.memoryAutoscalingTarget == 'number') {
            const target = new aws_cdk_lib_1.aws_applicationautoscaling.ScalableTarget(this, 'ScalableTarget', {
                serviceNamespace: aws_cdk_lib_1.aws_applicationautoscaling.ServiceNamespace.ELASTICACHE,
                resourceId: 'replication-group/' + redis_cluster.ref,
                scalableDimension: 'elasticache:replication-group:NodeGroups',
                maxCapacity: props.nodes || 1 * 3,
                minCapacity: props.nodes || 1,
            });
            target.scaleToTrackMetric('MemTracking', {
                targetValue: props.memoryAutoscalingTarget,
                predefinedMetric: aws_cdk_lib_1.aws_applicationautoscaling.PredefinedMetric.ELASTICACHE_DATABASE_MEMORY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE,
            });
        }
        else if (typeof props.replicasCpuAutoscalingTarget == 'number') {
            const target = new aws_cdk_lib_1.aws_applicationautoscaling.ScalableTarget(this, 'ScalableTarget', {
                serviceNamespace: aws_cdk_lib_1.aws_applicationautoscaling.ServiceNamespace.ELASTICACHE,
                resourceId: 'replication-group/' + redis_cluster.ref,
                scalableDimension: 'elasticache:replication-group:group:Replicas',
                maxCapacity: props.nodes || 1 * 3,
                minCapacity: props.nodes || 1,
            });
            target.scaleToTrackMetric('CpuTracking', {
                targetValue: props.replicasCpuAutoscalingTarget,
                predefinedMetric: aws_cdk_lib_1.aws_applicationautoscaling.PredefinedMetric.ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION,
            });
        }
        else if (typeof props.nodesCpuAutoscalingTarget == 'number') {
            const target = new aws_cdk_lib_1.aws_applicationautoscaling.ScalableTarget(this, 'ScalableTarget', {
                serviceNamespace: aws_cdk_lib_1.aws_applicationautoscaling.ServiceNamespace.ELASTICACHE,
                resourceId: 'replication-group/' + redis_cluster.ref,
                scalableDimension: 'elasticache:replication-group:NodeGroups',
                maxCapacity: props.nodes || 1 * 3,
                minCapacity: props.nodes || 1,
            });
            target.scaleToTrackMetric('CpuTracking', {
                targetValue: props.nodesCpuAutoscalingTarget,
                predefinedMetric: aws_cdk_lib_1.aws_applicationautoscaling.PredefinedMetric.ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION,
            });
        }
    }
}
exports.RedisDB = RedisDB;
_a = JSII_RTTI_SYMBOL_1;
RedisDB[_a] = { fqn: "cdk-redisdb.RedisDB", version: "0.0.18" };
class MemoryDB extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        let isolatedSubnets = [];
        let redisVpc = setupVpc(this, props);
        redisVpc.isolatedSubnets.forEach(function (value) {
            isolatedSubnets.push(value.subnetId);
        });
        const ecSecurityGroup = props.existingSecurityGroup ?? new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, id + '-RedisDB-SG', {
            vpc: redisVpc,
            description: 'SecurityGroup associated with RedisDB Cluster ' + id,
            allowAllOutbound: false,
        });
        let groupName;
        let ecSubnetGroup;
        if (!props.existingSubnetGroupName) {
            ecSubnetGroup = new aws_cdk_lib_1.aws_memorydb.CfnSubnetGroup(this, id + '-RedisDB-SubnetGroup', {
                description: 'RedisDB Subnet Group',
                subnetIds: isolatedSubnets,
                subnetGroupName: props.subnetGroupName || 'memorydbsubnetgroup',
            });
            groupName = ecSubnetGroup.subnetGroupName;
        }
        else {
            groupName = props.existingSubnetGroupName;
        }
        /*
        const cfnUser = new memorydb.CfnUser(this, 'memorydb-user', {
          accessString: 'on ~* +@all',
          authenticationMode: {"Passwords":["*****hunter2*****"],"Type":"password"},
          userName: 'admin',
        });
        const cfnACL = new memorydb.CfnACL(this, 'memorydb-acl', {
          aclName: 'myacl',
          userNames: ['admin'],
        });
        */
        const memorydb_cluster = new aws_cdk_lib_1.aws_memorydb.CfnCluster(this, 'memorydb', {
            aclName: 'open-access',
            clusterName: 'clustername',
            nodeType: props.nodeType || 'db.t4g.small',
            autoMinorVersionUpgrade: false,
            description: 'description',
            engineVersion: props.engineVersion ?? '6.2',
            numShards: props.nodes || 1,
            numReplicasPerShard: props.replicas || 0,
            securityGroupIds: [ecSecurityGroup.securityGroupId],
            subnetGroupName: groupName,
            tlsEnabled: true,
        });
        if (!props.existingSubnetGroupName) {
            memorydb_cluster.node.addDependency(ecSubnetGroup);
        }
        this.cluster = memorydb_cluster;
        //memorydb_cluster.node.addDependency(cfnACL);
        //cfnACL.node.addDependency(cfnUser);
    }
}
exports.MemoryDB = MemoryDB;
_b = JSII_RTTI_SYMBOL_1;
MemoryDB[_b] = { fqn: "cdk-redisdb.MemoryDB", version: "0.0.18" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2Q0FPcUI7QUFDckIsMkNBQXVDO0FBb0J2QyxTQUFTLFFBQVEsQ0FBQyxNQUFXLEVBQUUsS0FBbUI7SUFDaEQsT0FBTyxLQUFLLENBQUMsV0FBVyxJQUFJLElBQUkscUJBQUcsQ0FBQyxHQUFHLENBQUMsTUFBTSxFQUFFLEtBQUssRUFBRTtRQUNyRCxtQkFBbUIsRUFBRTtZQUNuQjtnQkFDRSxRQUFRLEVBQUUsRUFBRTtnQkFDWixJQUFJLEVBQUUsZUFBZTtnQkFDckIsVUFBVSxFQUFFLHFCQUFHLENBQUMsVUFBVSxDQUFDLE1BQU07YUFDbEM7WUFDRDtnQkFDRSxRQUFRLEVBQUUsRUFBRTtnQkFDWixJQUFJLEVBQUUsaUJBQWlCO2dCQUN2QixVQUFVLEVBQUUscUJBQUcsQ0FBQyxVQUFVLENBQUMsUUFBUTthQUNwQztTQUNGO0tBQ0YsQ0FBQyxDQUFDO0FBQ0wsQ0FBQztBQUVELE1BQWEsT0FBUSxTQUFRLHNCQUFTO0lBRXBDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBc0IsRUFBRTtRQUNoRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksZUFBZSxHQUFhLEVBQUUsQ0FBQztRQUNuQyxJQUFJLFFBQVEsR0FBRyxRQUFRLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ3JDLFFBQVEsQ0FBQyxlQUFlLENBQUMsT0FBTyxDQUFDLFVBQVMsS0FBSztZQUM3QyxlQUFlLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUN2QyxDQUFDLENBQUMsQ0FBQztRQUNILElBQUksZUFBZSxDQUFDLE1BQU0sSUFBSSxDQUFDLEVBQUU7WUFDL0IsUUFBUSxDQUFDLGNBQWMsQ0FBQyxPQUFPLENBQUMsVUFBUyxLQUFLO2dCQUM1QyxlQUFlLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUN2QyxDQUFDLENBQUMsQ0FBQztTQUNKO1FBQ0QsTUFBTSxlQUFlLEdBQUcsS0FBSyxDQUFDLHFCQUFxQixJQUFJLElBQUkscUJBQUcsQ0FBQyxhQUFhLENBQUMsSUFBSSxFQUFFLEVBQUUsR0FBRyxhQUFhLEVBQUU7WUFDckcsR0FBRyxFQUFFLFFBQVE7WUFDYixXQUFXLEVBQUUsZ0RBQWdELEdBQUcsRUFBRTtZQUNsRSxnQkFBZ0IsRUFBRSxLQUFLO1NBQ3hCLENBQUMsQ0FBQztRQUNILElBQUksU0FBaUIsQ0FBQztRQUN0QixJQUFJLGFBQXlDLENBQUM7UUFDOUMsSUFBSSxDQUFDLEtBQUssQ0FBQyx1QkFBdUIsRUFBRTtZQUNsQyxhQUFhLEdBQUcsSUFBSSw2QkFBVyxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxHQUFHLHNCQUFzQixFQUFFO2dCQUNoRixXQUFXLEVBQUUsc0JBQXNCO2dCQUNuQyxTQUFTLEVBQUUsZUFBZTtnQkFDMUIsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLGVBQWUsSUFBSSxvQkFBb0I7YUFDcEUsQ0FBQyxDQUFDO1lBQ0gsU0FBUyxHQUFHLGFBQWEsQ0FBQyxvQkFBcUIsQ0FBQztTQUNqRDthQUFNO1lBQ0wsU0FBUyxHQUFHLEtBQUssQ0FBQyx1QkFBd0IsQ0FBQztTQUM1QztRQUVELElBQUksK0JBQStCLEdBQUcsRUFBRSxHQUFHLFVBQVUsQ0FBQztRQUN0RCxJQUFJLGFBQWEsR0FBRyxJQUFJLDZCQUFXLENBQUMsbUJBQW1CLENBQUMsSUFBSSxFQUFFLCtCQUErQixFQUFFO1lBQzdGLGFBQWEsRUFBRSxLQUFLLENBQUMsS0FBSyxJQUFJLENBQUM7WUFDL0IsYUFBYSxFQUFFLEtBQUssQ0FBQyxRQUFRLElBQUksaUJBQWlCO1lBQ2xELE1BQU0sRUFBRSxPQUFPO1lBQ2YsY0FBYyxFQUFFLEtBQUs7WUFDckIsdUJBQXVCLEVBQUUsS0FBSztZQUM5Qix1QkFBdUIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLElBQUksNkJBQTZCO1lBQ2xGLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYSxJQUFJLEtBQUs7WUFDM0Msb0JBQW9CLEVBQUUsU0FBUztZQUMvQixnQkFBZ0IsRUFBRSxDQUFDLGVBQWUsQ0FBQyxlQUFlLENBQUM7WUFDbkQsMkJBQTJCLEVBQUUsc0JBQXNCO1lBQ25ELHVCQUF1QixFQUFFLEtBQUssQ0FBQyx1QkFBdUI7WUFDdEQsd0JBQXdCLEVBQUUsS0FBSyxDQUFDLHdCQUF3QjtZQUN4RCxvQkFBb0IsRUFBRSxLQUFLLENBQUMsUUFBUSxJQUFJLENBQUM7WUFDekMsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1NBQzNCLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxhQUFhLENBQUM7UUFDdEMsSUFBSSxDQUFDLEtBQUssQ0FBQyx1QkFBdUIsRUFBRTtZQUNsQyxhQUFhLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxhQUFjLENBQUMsQ0FBQztTQUNsRDtRQUNELElBQUksT0FBTyxLQUFLLENBQUMsdUJBQXVCLElBQUksUUFBUSxFQUFFO1lBQ3BELE1BQU0sTUFBTSxHQUFHLElBQUksd0NBQVUsQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLGdCQUFnQixFQUFFO2dCQUNuRSxnQkFBZ0IsRUFBRSx3Q0FBVSxDQUFDLGdCQUFnQixDQUFDLFdBQVc7Z0JBQ3pELFVBQVUsRUFBRSxvQkFBb0IsR0FBRyxhQUFhLENBQUMsR0FBRztnQkFDcEQsaUJBQWlCLEVBQUUsMENBQTBDO2dCQUM3RCxXQUFXLEVBQUUsS0FBSyxDQUFDLEtBQUssSUFBRSxDQUFDLEdBQUUsQ0FBQztnQkFDOUIsV0FBVyxFQUFFLEtBQUssQ0FBQyxLQUFLLElBQUUsQ0FBQzthQUM1QixDQUFDLENBQUM7WUFDSCxNQUFNLENBQUMsa0JBQWtCLENBQUMsYUFBYSxFQUFFO2dCQUN2QyxXQUFXLEVBQUUsS0FBSyxDQUFDLHVCQUF1QjtnQkFDMUMsZ0JBQWdCLEVBQUUsd0NBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyw4REFBOEQ7YUFDN0csQ0FBQyxDQUFDO1NBQ0o7YUFBTSxJQUFJLE9BQU8sS0FBSyxDQUFDLDRCQUE0QixJQUFJLFFBQVEsRUFBRTtZQUNoRSxNQUFNLE1BQU0sR0FBRyxJQUFJLHdDQUFVLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxnQkFBZ0IsRUFBRTtnQkFDbkUsZ0JBQWdCLEVBQUUsd0NBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXO2dCQUN6RCxVQUFVLEVBQUUsb0JBQW9CLEdBQUcsYUFBYSxDQUFDLEdBQUc7Z0JBQ3BELGlCQUFpQixFQUFFLDhDQUE4QztnQkFDakUsV0FBVyxFQUFFLEtBQUssQ0FBQyxLQUFLLElBQUUsQ0FBQyxHQUFFLENBQUM7Z0JBQzlCLFdBQVcsRUFBRSxLQUFLLENBQUMsS0FBSyxJQUFFLENBQUM7YUFDNUIsQ0FBQyxDQUFDO1lBQ0gsTUFBTSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsRUFBRTtnQkFDdkMsV0FBVyxFQUFFLEtBQUssQ0FBQyw0QkFBNEI7Z0JBQy9DLGdCQUFnQixFQUFFLHdDQUFVLENBQUMsZ0JBQWdCLENBQUMsMENBQTBDO2FBQ3pGLENBQUMsQ0FBQztTQUNKO2FBQU0sSUFBSSxPQUFPLEtBQUssQ0FBQyx5QkFBeUIsSUFBSSxRQUFRLEVBQUU7WUFDN0QsTUFBTSxNQUFNLEdBQUcsSUFBSSx3Q0FBVSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUU7Z0JBQ25FLGdCQUFnQixFQUFFLHdDQUFVLENBQUMsZ0JBQWdCLENBQUMsV0FBVztnQkFDekQsVUFBVSxFQUFFLG9CQUFvQixHQUFHLGFBQWEsQ0FBQyxHQUFHO2dCQUNwRCxpQkFBaUIsRUFBRSwwQ0FBMEM7Z0JBQzdELFdBQVcsRUFBRSxLQUFLLENBQUMsS0FBSyxJQUFFLENBQUMsR0FBRSxDQUFDO2dCQUM5QixXQUFXLEVBQUUsS0FBSyxDQUFDLEtBQUssSUFBRSxDQUFDO2FBQzVCLENBQUMsQ0FBQztZQUNILE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLEVBQUU7Z0JBQ3ZDLFdBQVcsRUFBRSxLQUFLLENBQUMseUJBQXlCO2dCQUM1QyxnQkFBZ0IsRUFBRSx3Q0FBVSxDQUFDLGdCQUFnQixDQUFDLDBDQUEwQzthQUN6RixDQUFDLENBQUM7U0FDSjtJQUNILENBQUM7O0FBM0ZILDBCQTRGQzs7O0FBRUQsTUFBYSxRQUFTLFNBQVEsc0JBQVM7SUFFckMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUFzQixFQUFFO1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsSUFBSSxlQUFlLEdBQWEsRUFBRSxDQUFDO1FBQ25DLElBQUksUUFBUSxHQUFHLFFBQVEsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDckMsUUFBUSxDQUFDLGVBQWUsQ0FBQyxPQUFPLENBQUMsVUFBUyxLQUFLO1lBQzdDLGVBQWUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3ZDLENBQUMsQ0FBQyxDQUFDO1FBQ0gsTUFBTSxlQUFlLEdBQUcsS0FBSyxDQUFDLHFCQUFxQixJQUFJLElBQUkscUJBQUcsQ0FBQyxhQUFhLENBQUMsSUFBSSxFQUFFLEVBQUUsR0FBRyxhQUFhLEVBQUU7WUFDckcsR0FBRyxFQUFFLFFBQVE7WUFDYixXQUFXLEVBQUUsZ0RBQWdELEdBQUcsRUFBRTtZQUNsRSxnQkFBZ0IsRUFBRSxLQUFLO1NBQ3hCLENBQUMsQ0FBQztRQUNILElBQUksU0FBaUIsQ0FBQztRQUN0QixJQUFJLGFBQXNDLENBQUM7UUFDM0MsSUFBSSxDQUFDLEtBQUssQ0FBQyx1QkFBdUIsRUFBRTtZQUNsQyxhQUFhLEdBQUcsSUFBSSwwQkFBUSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxHQUFHLHNCQUFzQixFQUFFO2dCQUM3RSxXQUFXLEVBQUUsc0JBQXNCO2dCQUNuQyxTQUFTLEVBQUUsZUFBZTtnQkFDMUIsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlLElBQUkscUJBQXFCO2FBQ2hFLENBQUMsQ0FBQztZQUNILFNBQVMsR0FBRyxhQUFhLENBQUMsZUFBZ0IsQ0FBQztTQUM1QzthQUFNO1lBQ0wsU0FBUyxHQUFHLEtBQUssQ0FBQyx1QkFBd0IsQ0FBQztTQUM1QztRQUVEOzs7Ozs7Ozs7O1VBVUU7UUFDRixNQUFNLGdCQUFnQixHQUFHLElBQUksMEJBQVEsQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNqRSxPQUFPLEVBQUUsYUFBYTtZQUN0QixXQUFXLEVBQUUsYUFBYTtZQUMxQixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVEsSUFBSSxjQUFjO1lBRTFDLHVCQUF1QixFQUFFLEtBQUs7WUFDOUIsV0FBVyxFQUFFLGFBQWE7WUFDMUIsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhLElBQUksS0FBSztZQUMzQyxTQUFTLEVBQUUsS0FBSyxDQUFDLEtBQUssSUFBRSxDQUFDO1lBQ3pCLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxRQUFRLElBQUUsQ0FBQztZQUN0QyxnQkFBZ0IsRUFBRSxDQUFDLGVBQWUsQ0FBQyxlQUFlLENBQUM7WUFDbkQsZUFBZSxFQUFFLFNBQVM7WUFDMUIsVUFBVSxFQUFFLElBQUk7U0FDakIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLEtBQUssQ0FBQyx1QkFBdUIsRUFBRTtZQUNsQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGFBQWMsQ0FBQyxDQUFDO1NBQ3JEO1FBQ0QsSUFBSSxDQUFDLE9BQU8sR0FBRyxnQkFBZ0IsQ0FBQztRQUNoQyw4Q0FBOEM7UUFDOUMscUNBQXFDO0lBQ3ZDLENBQUM7O0FBMURILDRCQTJEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIGF3c19lbGFzdGljYWNoZSBhcyBlbGFzdGljYWNoZSxcbiAgYXdzX21lbW9yeWRiIGFzIG1lbW9yeWRiLFxuICBhd3NfZWMyIGFzIGVjMixcbiAgYXdzX2FwcGxpY2F0aW9uYXV0b3NjYWxpbmcgYXMgYXBwc2NhbGluZyxcbiAgU3RhY2tQcm9wcyxcbiAgSVJlc29sdmFibGUsXG59IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFJlZGlzREJQcm9wcyBleHRlbmRzIFN0YWNrUHJvcHMge1xuICByZWFkb25seSBleGlzdGluZ1ZwYz86IGVjMi5JVnBjO1xuICByZWFkb25seSBleGlzdGluZ1NlY3VyaXR5R3JvdXA/OiBlYzIuSVNlY3VyaXR5R3JvdXA7XG4gIHJlYWRvbmx5IGV4aXN0aW5nU3VibmV0R3JvdXBOYW1lPzogc3RyaW5nO1xuICByZWFkb25seSBhdFJlc3RFbmNyeXB0aW9uRW5hYmxlZD86IGJvb2xlYW4gfCBJUmVzb2x2YWJsZTtcbiAgcmVhZG9ubHkgdHJhbnNpdEVuY3J5cHRpb25FbmFibGVkPzogYm9vbGVhbiB8IElSZXNvbHZhYmxlO1xuICByZWFkb25seSBlbmdpbmVWZXJzaW9uPzogc3RyaW5nO1xuICByZWFkb25seSBwYXJhbWV0ZXJHcm91cE5hbWU/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IG1lbW9yeUF1dG9zY2FsaW5nVGFyZ2V0PzogbnVtYmVyO1xuICByZWFkb25seSByZXBsaWNhc0NwdUF1dG9zY2FsaW5nVGFyZ2V0PzogbnVtYmVyO1xuICByZWFkb25seSBub2Rlc0NwdUF1dG9zY2FsaW5nVGFyZ2V0PzogbnVtYmVyO1xuICByZWFkb25seSBub2Rlcz86IG51bWJlcjtcbiAgcmVhZG9ubHkgbm9kZVR5cGU/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlcGxpY2FzPzogbnVtYmVyO1xuICByZWFkb25seSBhdXRoVG9rZW4/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHN1Ym5ldEdyb3VwTmFtZT86IHN0cmluZztcbn1cblxuZnVuY3Rpb24gc2V0dXBWcGMocGFyZW50OiBhbnksIHByb3BzOiBSZWRpc0RCUHJvcHMpIDogZWMyLklWcGMge1xuICByZXR1cm4gcHJvcHMuZXhpc3RpbmdWcGMgPz8gbmV3IGVjMi5WcGMocGFyZW50LCAnVnBjJywge1xuICAgIHN1Ym5ldENvbmZpZ3VyYXRpb246IFtcbiAgICAgIHtcbiAgICAgICAgY2lkck1hc2s6IDI0LFxuICAgICAgICBuYW1lOiAnUHVibGljIFN1Ym5ldCcsXG4gICAgICAgIHN1Ym5ldFR5cGU6IGVjMi5TdWJuZXRUeXBlLlBVQkxJQyxcbiAgICAgIH0sXG4gICAgICB7XG4gICAgICAgIGNpZHJNYXNrOiAyNCxcbiAgICAgICAgbmFtZTogJ0lzb2xhdGVkIFN1Ym5ldCcsXG4gICAgICAgIHN1Ym5ldFR5cGU6IGVjMi5TdWJuZXRUeXBlLklTT0xBVEVELFxuICAgICAgfSxcbiAgICBdLFxuICB9KTtcbn1cblxuZXhwb3J0IGNsYXNzIFJlZGlzREIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgcmVwbGljYXRpb25Hcm91cCA6IGVsYXN0aWNhY2hlLkNmblJlcGxpY2F0aW9uR3JvdXA7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSZWRpc0RCUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBsZXQgaXNvbGF0ZWRTdWJuZXRzOiBzdHJpbmdbXSA9IFtdO1xuICAgIGxldCByZWRpc1ZwYyA9IHNldHVwVnBjKHRoaXMsIHByb3BzKTtcbiAgICByZWRpc1ZwYy5pc29sYXRlZFN1Ym5ldHMuZm9yRWFjaChmdW5jdGlvbih2YWx1ZSkge1xuICAgICAgaXNvbGF0ZWRTdWJuZXRzLnB1c2godmFsdWUuc3VibmV0SWQpO1xuICAgIH0pO1xuICAgIGlmIChpc29sYXRlZFN1Ym5ldHMubGVuZ3RoID09IDApIHtcbiAgICAgIHJlZGlzVnBjLnByaXZhdGVTdWJuZXRzLmZvckVhY2goZnVuY3Rpb24odmFsdWUpIHtcbiAgICAgICAgaXNvbGF0ZWRTdWJuZXRzLnB1c2godmFsdWUuc3VibmV0SWQpO1xuICAgICAgfSk7XG4gICAgfVxuICAgIGNvbnN0IGVjU2VjdXJpdHlHcm91cCA9IHByb3BzLmV4aXN0aW5nU2VjdXJpdHlHcm91cCA/PyBuZXcgZWMyLlNlY3VyaXR5R3JvdXAodGhpcywgaWQgKyAnLVJlZGlzREItU0cnLCB7XG4gICAgICB2cGM6IHJlZGlzVnBjLFxuICAgICAgZGVzY3JpcHRpb246ICdTZWN1cml0eUdyb3VwIGFzc29jaWF0ZWQgd2l0aCBSZWRpc0RCIENsdXN0ZXIgJyArIGlkLFxuICAgICAgYWxsb3dBbGxPdXRib3VuZDogZmFsc2UsXG4gICAgfSk7XG4gICAgbGV0IGdyb3VwTmFtZTogc3RyaW5nO1xuICAgIGxldCBlY1N1Ym5ldEdyb3VwOiBlbGFzdGljYWNoZS5DZm5TdWJuZXRHcm91cDtcbiAgICBpZiAoIXByb3BzLmV4aXN0aW5nU3VibmV0R3JvdXBOYW1lKSB7XG4gICAgICBlY1N1Ym5ldEdyb3VwID0gbmV3IGVsYXN0aWNhY2hlLkNmblN1Ym5ldEdyb3VwKHRoaXMsIGlkICsgJy1SZWRpc0RCLVN1Ym5ldEdyb3VwJywge1xuICAgICAgICBkZXNjcmlwdGlvbjogJ1JlZGlzREIgU3VibmV0IEdyb3VwJyxcbiAgICAgICAgc3VibmV0SWRzOiBpc29sYXRlZFN1Ym5ldHMsXG4gICAgICAgIGNhY2hlU3VibmV0R3JvdXBOYW1lOiBwcm9wcy5zdWJuZXRHcm91cE5hbWUgfHwgJ1JlZGlzREJTdWJuZXRHcm91cCcsXG4gICAgICB9KTtcbiAgICAgIGdyb3VwTmFtZSA9IGVjU3VibmV0R3JvdXAuY2FjaGVTdWJuZXRHcm91cE5hbWUhO1xuICAgIH0gZWxzZSB7XG4gICAgICBncm91cE5hbWUgPSBwcm9wcy5leGlzdGluZ1N1Ym5ldEdyb3VwTmFtZSE7XG4gICAgfVxuXG4gICAgbGV0IGVsYXN0aWNhY2hlUmVwbGljYXRpb25Hcm91cE5hbWUgPSBpZCArICctUmVkaXNEQic7XG4gICAgbGV0IHJlZGlzX2NsdXN0ZXIgPSBuZXcgZWxhc3RpY2FjaGUuQ2ZuUmVwbGljYXRpb25Hcm91cCh0aGlzLCBlbGFzdGljYWNoZVJlcGxpY2F0aW9uR3JvdXBOYW1lLCB7XG4gICAgICBudW1Ob2RlR3JvdXBzOiBwcm9wcy5ub2RlcyB8fCAxLFxuICAgICAgY2FjaGVOb2RlVHlwZTogcHJvcHMubm9kZVR5cGUgfHwgJ2NhY2hlLm02Zy5sYXJnZScsXG4gICAgICBlbmdpbmU6ICdSZWRpcycsXG4gICAgICBtdWx0aUF6RW5hYmxlZDogZmFsc2UsXG4gICAgICBhdXRvTWlub3JWZXJzaW9uVXBncmFkZTogZmFsc2UsXG4gICAgICBjYWNoZVBhcmFtZXRlckdyb3VwTmFtZTogcHJvcHMucGFyYW1ldGVyR3JvdXBOYW1lID8/ICdkZWZhdWx0LnJlZGlzNi54LmNsdXN0ZXIub24nLFxuICAgICAgZW5naW5lVmVyc2lvbjogcHJvcHMuZW5naW5lVmVyc2lvbiA/PyAnNi54JyxcbiAgICAgIGNhY2hlU3VibmV0R3JvdXBOYW1lOiBncm91cE5hbWUsXG4gICAgICBzZWN1cml0eUdyb3VwSWRzOiBbZWNTZWN1cml0eUdyb3VwLnNlY3VyaXR5R3JvdXBJZF0sXG4gICAgICByZXBsaWNhdGlvbkdyb3VwRGVzY3JpcHRpb246ICdSZWRpc0RCIHNldHVwIGJ5IENESycsXG4gICAgICBhdFJlc3RFbmNyeXB0aW9uRW5hYmxlZDogcHJvcHMuYXRSZXN0RW5jcnlwdGlvbkVuYWJsZWQsXG4gICAgICB0cmFuc2l0RW5jcnlwdGlvbkVuYWJsZWQ6IHByb3BzLnRyYW5zaXRFbmNyeXB0aW9uRW5hYmxlZCxcbiAgICAgIHJlcGxpY2FzUGVyTm9kZUdyb3VwOiBwcm9wcy5yZXBsaWNhcyB8fCAwLFxuICAgICAgYXV0aFRva2VuOiBwcm9wcy5hdXRoVG9rZW4sXG4gICAgfSk7XG4gICAgdGhpcy5yZXBsaWNhdGlvbkdyb3VwID0gcmVkaXNfY2x1c3RlcjtcbiAgICBpZiAoIXByb3BzLmV4aXN0aW5nU3VibmV0R3JvdXBOYW1lKSB7XG4gICAgICByZWRpc19jbHVzdGVyLm5vZGUuYWRkRGVwZW5kZW5jeShlY1N1Ym5ldEdyb3VwISk7XG4gICAgfVxuICAgIGlmICh0eXBlb2YgcHJvcHMubWVtb3J5QXV0b3NjYWxpbmdUYXJnZXQgPT0gJ251bWJlcicpIHtcbiAgICAgIGNvbnN0IHRhcmdldCA9IG5ldyBhcHBzY2FsaW5nLlNjYWxhYmxlVGFyZ2V0KHRoaXMsICdTY2FsYWJsZVRhcmdldCcsIHtcbiAgICAgICAgc2VydmljZU5hbWVzcGFjZTogYXBwc2NhbGluZy5TZXJ2aWNlTmFtZXNwYWNlLkVMQVNUSUNBQ0hFLFxuICAgICAgICByZXNvdXJjZUlkOiAncmVwbGljYXRpb24tZ3JvdXAvJyArIHJlZGlzX2NsdXN0ZXIucmVmLFxuICAgICAgICBzY2FsYWJsZURpbWVuc2lvbjogJ2VsYXN0aWNhY2hlOnJlcGxpY2F0aW9uLWdyb3VwOk5vZGVHcm91cHMnLFxuICAgICAgICBtYXhDYXBhY2l0eTogcHJvcHMubm9kZXN8fDEgKjMsXG4gICAgICAgIG1pbkNhcGFjaXR5OiBwcm9wcy5ub2Rlc3x8MSxcbiAgICAgIH0pO1xuICAgICAgdGFyZ2V0LnNjYWxlVG9UcmFja01ldHJpYygnTWVtVHJhY2tpbmcnLCB7XG4gICAgICAgIHRhcmdldFZhbHVlOiBwcm9wcy5tZW1vcnlBdXRvc2NhbGluZ1RhcmdldCxcbiAgICAgICAgcHJlZGVmaW5lZE1ldHJpYzogYXBwc2NhbGluZy5QcmVkZWZpbmVkTWV0cmljLkVMQVNUSUNBQ0hFX0RBVEFCQVNFX01FTU9SWV9VU0FHRV9DT1VOVEVEX0ZPUl9FVklDVF9QRVJDRU5UQUdFLFxuICAgICAgfSk7XG4gICAgfSBlbHNlIGlmICh0eXBlb2YgcHJvcHMucmVwbGljYXNDcHVBdXRvc2NhbGluZ1RhcmdldCA9PSAnbnVtYmVyJykge1xuICAgICAgY29uc3QgdGFyZ2V0ID0gbmV3IGFwcHNjYWxpbmcuU2NhbGFibGVUYXJnZXQodGhpcywgJ1NjYWxhYmxlVGFyZ2V0Jywge1xuICAgICAgICBzZXJ2aWNlTmFtZXNwYWNlOiBhcHBzY2FsaW5nLlNlcnZpY2VOYW1lc3BhY2UuRUxBU1RJQ0FDSEUsXG4gICAgICAgIHJlc291cmNlSWQ6ICdyZXBsaWNhdGlvbi1ncm91cC8nICsgcmVkaXNfY2x1c3Rlci5yZWYsXG4gICAgICAgIHNjYWxhYmxlRGltZW5zaW9uOiAnZWxhc3RpY2FjaGU6cmVwbGljYXRpb24tZ3JvdXA6Z3JvdXA6UmVwbGljYXMnLFxuICAgICAgICBtYXhDYXBhY2l0eTogcHJvcHMubm9kZXN8fDEgKjMsXG4gICAgICAgIG1pbkNhcGFjaXR5OiBwcm9wcy5ub2Rlc3x8MSxcbiAgICAgIH0pO1xuICAgICAgdGFyZ2V0LnNjYWxlVG9UcmFja01ldHJpYygnQ3B1VHJhY2tpbmcnLCB7XG4gICAgICAgIHRhcmdldFZhbHVlOiBwcm9wcy5yZXBsaWNhc0NwdUF1dG9zY2FsaW5nVGFyZ2V0LFxuICAgICAgICBwcmVkZWZpbmVkTWV0cmljOiBhcHBzY2FsaW5nLlByZWRlZmluZWRNZXRyaWMuRUxBU1RJQ0FDSEVfUFJJTUFSWV9FTkdJTkVfQ1BVX1VUSUxJWkFUSU9OLFxuICAgICAgfSk7XG4gICAgfSBlbHNlIGlmICh0eXBlb2YgcHJvcHMubm9kZXNDcHVBdXRvc2NhbGluZ1RhcmdldCA9PSAnbnVtYmVyJykge1xuICAgICAgY29uc3QgdGFyZ2V0ID0gbmV3IGFwcHNjYWxpbmcuU2NhbGFibGVUYXJnZXQodGhpcywgJ1NjYWxhYmxlVGFyZ2V0Jywge1xuICAgICAgICBzZXJ2aWNlTmFtZXNwYWNlOiBhcHBzY2FsaW5nLlNlcnZpY2VOYW1lc3BhY2UuRUxBU1RJQ0FDSEUsXG4gICAgICAgIHJlc291cmNlSWQ6ICdyZXBsaWNhdGlvbi1ncm91cC8nICsgcmVkaXNfY2x1c3Rlci5yZWYsXG4gICAgICAgIHNjYWxhYmxlRGltZW5zaW9uOiAnZWxhc3RpY2FjaGU6cmVwbGljYXRpb24tZ3JvdXA6Tm9kZUdyb3VwcycsXG4gICAgICAgIG1heENhcGFjaXR5OiBwcm9wcy5ub2Rlc3x8MSAqMyxcbiAgICAgICAgbWluQ2FwYWNpdHk6IHByb3BzLm5vZGVzfHwxLFxuICAgICAgfSk7XG4gICAgICB0YXJnZXQuc2NhbGVUb1RyYWNrTWV0cmljKCdDcHVUcmFja2luZycsIHtcbiAgICAgICAgdGFyZ2V0VmFsdWU6IHByb3BzLm5vZGVzQ3B1QXV0b3NjYWxpbmdUYXJnZXQsXG4gICAgICAgIHByZWRlZmluZWRNZXRyaWM6IGFwcHNjYWxpbmcuUHJlZGVmaW5lZE1ldHJpYy5FTEFTVElDQUNIRV9QUklNQVJZX0VOR0lORV9DUFVfVVRJTElaQVRJT04sXG4gICAgICB9KTtcbiAgICB9XG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIE1lbW9yeURCIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGNsdXN0ZXIgOiBtZW1vcnlkYi5DZm5DbHVzdGVyO1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUmVkaXNEQlByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIGxldCBpc29sYXRlZFN1Ym5ldHM6IHN0cmluZ1tdID0gW107XG4gICAgbGV0IHJlZGlzVnBjID0gc2V0dXBWcGModGhpcywgcHJvcHMpO1xuICAgIHJlZGlzVnBjLmlzb2xhdGVkU3VibmV0cy5mb3JFYWNoKGZ1bmN0aW9uKHZhbHVlKSB7XG4gICAgICBpc29sYXRlZFN1Ym5ldHMucHVzaCh2YWx1ZS5zdWJuZXRJZCk7XG4gICAgfSk7XG4gICAgY29uc3QgZWNTZWN1cml0eUdyb3VwID0gcHJvcHMuZXhpc3RpbmdTZWN1cml0eUdyb3VwID8/IG5ldyBlYzIuU2VjdXJpdHlHcm91cCh0aGlzLCBpZCArICctUmVkaXNEQi1TRycsIHtcbiAgICAgIHZwYzogcmVkaXNWcGMsXG4gICAgICBkZXNjcmlwdGlvbjogJ1NlY3VyaXR5R3JvdXAgYXNzb2NpYXRlZCB3aXRoIFJlZGlzREIgQ2x1c3RlciAnICsgaWQsXG4gICAgICBhbGxvd0FsbE91dGJvdW5kOiBmYWxzZSxcbiAgICB9KTtcbiAgICBsZXQgZ3JvdXBOYW1lOiBzdHJpbmc7XG4gICAgbGV0IGVjU3VibmV0R3JvdXA6IG1lbW9yeWRiLkNmblN1Ym5ldEdyb3VwO1xuICAgIGlmICghcHJvcHMuZXhpc3RpbmdTdWJuZXRHcm91cE5hbWUpIHtcbiAgICAgIGVjU3VibmV0R3JvdXAgPSBuZXcgbWVtb3J5ZGIuQ2ZuU3VibmV0R3JvdXAodGhpcywgaWQgKyAnLVJlZGlzREItU3VibmV0R3JvdXAnLCB7XG4gICAgICAgIGRlc2NyaXB0aW9uOiAnUmVkaXNEQiBTdWJuZXQgR3JvdXAnLFxuICAgICAgICBzdWJuZXRJZHM6IGlzb2xhdGVkU3VibmV0cyxcbiAgICAgICAgc3VibmV0R3JvdXBOYW1lOiBwcm9wcy5zdWJuZXRHcm91cE5hbWUgfHwgJ21lbW9yeWRic3VibmV0Z3JvdXAnLFxuICAgICAgfSk7XG4gICAgICBncm91cE5hbWUgPSBlY1N1Ym5ldEdyb3VwLnN1Ym5ldEdyb3VwTmFtZSE7XG4gICAgfSBlbHNlIHtcbiAgICAgIGdyb3VwTmFtZSA9IHByb3BzLmV4aXN0aW5nU3VibmV0R3JvdXBOYW1lITtcbiAgICB9XG5cbiAgICAvKlxuICAgIGNvbnN0IGNmblVzZXIgPSBuZXcgbWVtb3J5ZGIuQ2ZuVXNlcih0aGlzLCAnbWVtb3J5ZGItdXNlcicsIHtcbiAgICAgIGFjY2Vzc1N0cmluZzogJ29uIH4qICtAYWxsJyxcbiAgICAgIGF1dGhlbnRpY2F0aW9uTW9kZToge1wiUGFzc3dvcmRzXCI6W1wiKioqKipodW50ZXIyKioqKipcIl0sXCJUeXBlXCI6XCJwYXNzd29yZFwifSxcbiAgICAgIHVzZXJOYW1lOiAnYWRtaW4nLFxuICAgIH0pO1xuICAgIGNvbnN0IGNmbkFDTCA9IG5ldyBtZW1vcnlkYi5DZm5BQ0wodGhpcywgJ21lbW9yeWRiLWFjbCcsIHtcbiAgICAgIGFjbE5hbWU6ICdteWFjbCcsXG4gICAgICB1c2VyTmFtZXM6IFsnYWRtaW4nXSxcbiAgICB9KTtcbiAgICAqL1xuICAgIGNvbnN0IG1lbW9yeWRiX2NsdXN0ZXIgPSBuZXcgbWVtb3J5ZGIuQ2ZuQ2x1c3Rlcih0aGlzLCAnbWVtb3J5ZGInLCB7XG4gICAgICBhY2xOYW1lOiAnb3Blbi1hY2Nlc3MnLFxuICAgICAgY2x1c3Rlck5hbWU6ICdjbHVzdGVybmFtZScsXG4gICAgICBub2RlVHlwZTogcHJvcHMubm9kZVR5cGUgfHwgJ2RiLnQ0Zy5zbWFsbCcsXG5cbiAgICAgIGF1dG9NaW5vclZlcnNpb25VcGdyYWRlOiBmYWxzZSxcbiAgICAgIGRlc2NyaXB0aW9uOiAnZGVzY3JpcHRpb24nLFxuICAgICAgZW5naW5lVmVyc2lvbjogcHJvcHMuZW5naW5lVmVyc2lvbiA/PyAnNi4yJyxcbiAgICAgIG51bVNoYXJkczogcHJvcHMubm9kZXN8fDEsXG4gICAgICBudW1SZXBsaWNhc1BlclNoYXJkOiBwcm9wcy5yZXBsaWNhc3x8MCxcbiAgICAgIHNlY3VyaXR5R3JvdXBJZHM6IFtlY1NlY3VyaXR5R3JvdXAuc2VjdXJpdHlHcm91cElkXSxcbiAgICAgIHN1Ym5ldEdyb3VwTmFtZTogZ3JvdXBOYW1lLFxuICAgICAgdGxzRW5hYmxlZDogdHJ1ZSxcbiAgICB9KTtcbiAgICBpZiAoIXByb3BzLmV4aXN0aW5nU3VibmV0R3JvdXBOYW1lKSB7XG4gICAgICBtZW1vcnlkYl9jbHVzdGVyLm5vZGUuYWRkRGVwZW5kZW5jeShlY1N1Ym5ldEdyb3VwISk7XG4gICAgfVxuICAgIHRoaXMuY2x1c3RlciA9IG1lbW9yeWRiX2NsdXN0ZXI7XG4gICAgLy9tZW1vcnlkYl9jbHVzdGVyLm5vZGUuYWRkRGVwZW5kZW5jeShjZm5BQ0wpO1xuICAgIC8vY2ZuQUNMLm5vZGUuYWRkRGVwZW5kZW5jeShjZm5Vc2VyKTtcbiAgfVxufVxuIl19