# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['zenv']

package_data = \
{'': ['*']}

install_requires = \
['click', 'toml>=0.10.0,<0.11.0']

entry_points = \
{'console_scripts': ['ze = zenv.cli:exec', 'zenv = zenv.cli:cli']}

setup_kwargs = {
    'name': 'zenv-cli',
    'version': '0.3.4',
    'description': '',
    'long_description': 'Zenv: ZEN ENV\n=============\n\nZenv is an alternate to docker CLI, created specifically for developers.\nThe main goal of Zenv is to simplify running console applications inside container, making it seamless in use like native (host-machine) applications\n\n|Nativ command         |    |Command executed inside container|\n|----------------------|----|---------------------------------|\n|```> <your command>```| -> |```> ze <your command>```        |\n\n## Usage\n```shell\n> zenv init\nZenv created!\n\n> # run `ls` command inside contaner\n> ze ls\n```\n\n## Motivation\n\nAs a developer, when set up a project locally, I usually need to install additional applications on the system. Of course, modern package managers such as poetry, pipenv, npm, cargo, ext, perfectly solve for us most of the problems with dependencies within a single stack of technologies. But they do not allow to solve the problem with the installation of system libraries. If you have a lot of projects that require different versions of system libraries, then you have problems\n\nIn production, this problem has long been solved by container insulation, and as a rule, it is a `Docker`. Therefore, many of my colleagues use docker-images and docker-compose, not only to run  services in a production environment but also to develop and debug programs on a local machine\n\nUnfortunately, there are several problems along the way:\n\n- Some of your familiar utilities  may not be preinstalled in the container\n- If you try to install packages in the process, you will encounter the lack of necessary rights\n- Forget about debugging with `print`\n- The main thing is lost the usual experience, you can not use your favorite customized shell\n\nOf course, the problems described above are solved by creating a docker image specifically for developing a specific project, `zenv` just helps to create such containers very simply\n\n## Features\n\n- Simplify: all interaction with the container occurs with one short command: `ze`\n- Zenv automatically forwarded current directory to the container with the same PWD\n- Zenv automatically forwarded current UserID, GroupID to container\n\n  Therefore, files created in the container have the same rights as those created in the native console and you can also use `sudo` to get privileges\n  ```shell\n  > sudo ze <command>\n  ```\n  or\n\n  ```shell\n  > sudo !!\n  ```\n\n- Zenv can forwarded environment vars as is native\n    ```shell\n    > MYVAR=LIVE!!!! ze env\n    ```\n- And of course your could combinate native and containerized commands in Unix pipes\n  ```shell\n  > ze ls | head -7 | ze tail -5\n  ```\n- Minimal performance impact\n- Customization: you can additionally control container parameters using Zenvfile\n\n\n## Install\n  1. Make sure you have the latest version of `Docker` installed\n  2. For linux, make sure you have your user’s [rights are allowed](https://docs.docker.com/install/linux/linux-postinstall/) to interact with doker\n  3. Make sure that you have python version 3.6 or higher\n  4. Execute:\n      ```shell\n      > sudo pip install zenv-cli\n      # or\n      > sudo pip3 install zenv-cli\n      ```\n\n## How It works\nBy nature, zenv is a small automated layer over the official docker CLI\n\n### init\n\nCommand `zenv init` create `Zenvfile` in current directory. This file describes the relationship with the docker image and container that will be created to execute isolated commands.\n\nBy default, used image is `ubuntu: latest`.\nBut you can change it by setting `-i` flag. For example:\n```shell\n> zenv init -i python:latest\n```\nOr edit `Zenvfile` manually\n\n\n### Execute\n\nCommand `zenv exec <COMMAND>` or it shot alias `ze <COMMAND>` run `<COMMAND>` in a container environment. When running the command:\n- Zenv checks current container status (running, stopped, removed), and up container if need.\n- The container run with the command `sleep infinity`. Therefore it will be easily accessible\n- UID and GID that ran the command are pushed into the container. Therefor your could use `sudo ze <COMMAND>`\n- When executing the command, the directory from the path where Zenvfile is located is forwarded to the container as is a current PWD. Therefor your could run `ze` from deep into directories relative to Zenvfile\n- Environment variables are also thrown into the container as a native.\n  ```\n  > MYVAR=SUPER ze env\n  ```\n To avoid conflicts between host and container variables, all installed system variables are placed    in the blacklist when Zenvfile is created, from which editing can be removed\n\n### Other commands\n\n```shell\n> zenv --help\nUsage: zenv [OPTIONS] COMMAND [ARGS]...\n\n  ZENV(Zen-env): Containers manager for developer environment\n\n  Usage:\n\n  > zenv init -i centos:latest & ze cat /etc/redhat-release\n\nOptions:\n  --help  Show this message and exit.\n\nCommands:\n  exec      Call some command inside the container\n  info      Show current container info\n  init      Initialize Environment: create Zenvfile\n  rm        Remove container (will stop the container, if need)\n  stop      Stop container\n  stop-all  Stop all zenv containers\n```\n\n## Example install jupyter notebook\n```shell\n> mkgir notebooks\n> cd notebooks\n> zenv init -i python:3.7.3\n```\nAfter edit Zenvfile to explode notebook ports. Update `ports = []` to `ports = ["8888:8888"]`\n\n```\n> sudo ze pip install jupyter numpy scipy matplotlib\n```\nRun notebook\n```\n> ze jupyter notebook --ip 0.0.0.0\n```\nlaunch your browser with url: http://localhost:8888\n\nAlso you could add this commands to Zenvfile:\n```toml\n[run]\ninit_commands = [\n  [ "__create_user__"],\n  ["pip", "install", "jupyter", "numpy", "scipy", "matplotlib"]\n]\n\n[commands]\nnotebook = ["jupyter", "notebook", "--ip", "0.0.0.0"]\n```\n\nAnd launch notebook with command\n\n```\n> ze notebook\n```\n\n## Zenvfile\n```toml\n[main]\nimage = "ubuntu:latest"\nname = "zenv-project"    # container name\ndebug = false            # for show docker commands\n\n[run]\ncommand = [ "__sleep__",]\ninit_commands = [ [ "__create_user__",],]\n\n[exec]\nenv_file = ""\nenv_excludes = [ "TMPDIR",]\n\n[run.options]\nvolume = [ "{zenvfilepath}:{zenvfilepath}:rw",]\ndetach = "true"\npublish = []\n\n[commands]\n__sleep__ = [ "sleep", "365d",]\n__create_user__ = [ "useradd", "-m", "-r", "-u", "{uid}", "-g", "{gid}", "zenv",]\n```\n\n',
    'author': 'evegny.zuev',
    'author_email': 'zueves@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/zueve/zenv',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
