//ϵͳ
#ifdef WIN32
#include "pch.h"
#endif

#include "vnhft.h"
#include "pybind11/pybind11.h"
#include "hft/hft_trader_api.h"


using namespace pybind11;
using namespace HFT;



///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class TdApi : public TraderSpi
{
private:
	TraderApi* api;            //API
    bool active = false;       //״̬

public:
    TdApi()
    {
    };

    ~TdApi()
    {
        if (this->active)
        {
            this->exit();
        }
    };

    //-------------------------------------------------------------------------------------
    //APIص
    //-------------------------------------------------------------------------------------

    /**
     * ӶϿʱص
     */
    virtual void OnDisconnect();

    /**
     * ϢصϵͳʱŻص
     *
     * @param error_info    Ϣ
     * @param request_id    Ӧʱкţ󴥷Ĵ󣬴ֵֶΪ0
     */
    virtual void OnError(ErrorInfo* error_info, int request_id = 0);

    /**
     * ظ澯Ϣ֪ͨص
     *
     * @param risk_notify   ظ澯Ϣ
     */
    virtual void OnRiskNotify(RiskNotify* risk_notify);

    /**
    * ֪ͨϢص
    *
    * @param failback_notify   ֪ͨϢ
    */
    virtual void OnFailBackNotify(FailBackNotify* failback_notify);

    /**
     * ¼ɹʧʱص
     *
     * @param rsp           ¼ӦݣͻšͻɶϢ
     * @param error_info    Ϣ
     */
    virtual void OnLogin(LoginRsp* rsp, ErrorInfo* error_info);

    /**
     * ɽرص
     *
     * @param trade_detail  صĳɽ
     */
    virtual void OnTradeReport(TradeDetail* trade_detail);

    /**
     * ״̬仯ص
     *
     * @param order_detail  صĶ
     */
    virtual void OnOrderStatus(OrderDetail* order_detail);

    /**
     * ίеӦ
     * OrderBatchOrderAppointContractSellStockRepayɴ˽ӿӦ
     *
     * @param order_rsp     ίӦ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     */
    virtual void OnOrderRsp(OrderRsp* order_rsp, ErrorInfo* error_info, int request_id,
        bool is_last);

    /**
     * Ӧ
     *
     * @param cancel_rsp    Ӧ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     */
    virtual void OnCancelRsp(CancelRsp* cancel_rsp, ErrorInfo* error_info, int request_id,
        bool is_last);

    /**
     * ѯնӦһηһ
     * QueryOrderQueryOrderByCodeQueryOrdersɴ˽ӿӦ
     *
     * @param order_detail  
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryOrderRsp(OrderDetail* order_detail, ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
     * ѯճɽӦһηһɽ
     * QueryTradeByCodeQueryTradeByOrderIdQueryTradesQueryETFTradesɴ˽ӿӦ
     *
     * @param trade_detail  ɽ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryTradeRsp(TradeDetail* trade_detail, ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
     * ѯճֲӦһηһֲ
     * QueryPositionQueryPositionsɴ˽ӿӦ
     *
     * @param position_detail   ֲ
     * @param error_info        ӦĴϢ
     * @param request_id        Ӧʱк
     * @param is_last           ǷǱһӦ
     * @param pos_str           βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryPositionRsp(PositionDetail* position_detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ѯʽӦ
     *
     * @param cash_detail   ʽ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnQueryCashRsp(CashDetail* cash_detail, ErrorInfo* error_info, int request_id);

    /**
     * 鼯нϵͳʽ
     *
     * @param avail_balance ʽ𣬵λ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     */
    virtual void OnQueryJZJYAvailFundRsp(int64_t avail_balance, ErrorInfo* error_info,
        int request_id);

    /**
     * н׹̨ٹ̨֮ʽתת
     *
     * @param transfer_value    ת
     * @param error_info        ӦĴϢ
     * @param request_id        кţƥӦûԶ
     */
    virtual void OnTransferFundInAndOutRsp(int64_t transfer_value, ErrorInfo* error_info,
        int request_id);

    /**
     * ͬһʽ˺ţһ֮ʽת
     *
     * @param transfer_value    ת
     * @param error_info        ӦĴϢ
     * @param request_id        кţƥӦûԶ
     */
    virtual void OnTransferFundBetweenSecuidRsp(int64_t transfer_value, ErrorInfo* error_info,
        int request_id);

    /**
     * ѯETFϢӦÿηһETFϢ
     *
     * @param etf_detail    ETFϢ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryETFRsp(ETFDetail* etf_detail, ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
     * ѯһETFƱӵӦÿηETFһƱϢ
     *
     * @param etf_stock_detail      ETFһƱϢ
     * @param error_info            ӦĴϢ
     * @param request_id            Ӧʱк
     * @param is_last               ǷǱһӦ
     * @param pos_str				βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryETFStockRsp(ETFStockDetail* etf_stock_detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ѯίص
     *
     * @param detail        ί
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     */
    virtual void OnQueryMaxOrderQtyRsp(MaxOrderQtyDetail* detail, ErrorInfo* error_info,
        int request_id);

    /**
     * ѯ¹ɿ깺ȵӦ
     *
     * @param detail        ¹ɿ깺
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnQueryIPOMaxPurchaseRsp(IPOMaxPurchaseDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last);

    /**
     * ѯ¹ɵӦ
     *
     * @param detail        ¹
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryIPOStockRsp(IPOStockDetail* detail, ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
     * ѯ֤ȯϢӦ
     *
     * @param detail            ֤ȯϢ
     * @param error_info        ӦĴϢ
     * @param request_id        Ӧʱк
     * @param is_last           ǷǱһӦ
     */
    virtual void OnQuerySecurityBaseInfoRsp(SecurityBaseInfo* detail, ErrorInfo* error_info,
        int request_id, bool is_last);

    /**
     * ƷתתӦص
     *
     * @param rsp           ƷתתӦ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnCreditMortgageInOutRsp(CreditMortgageInOutRsp* rsp, ErrorInfo* error_info,
        int request_id);

    /**
     * ȯȯӦص
     *
     * @param rsp           ȯȯӦ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnCreditStockBackRsp(CreditStockBackRsp* rsp, ErrorInfo* error_info,
        int request_id);

    /**
     * ֱӻӦص
     *
     * @param rsp           ֱӻӦ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnCreditPayBackRsp(CreditPayBackRsp* rsp, ErrorInfo* error_info, int request_id);

    /**
     * ָԼֱӻ
     *
     * @param rsp           Ϣ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ
     */
    virtual void OnCreditPayBackByOrderRsp(CreditPayBackRsp* rsp, ErrorInfo* error_info,
        int request_id);

    /**
     * ñȯӦص
     *
     * @param detail        ñȯ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryCreditStockRsp(CreditStockDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ѯƷȯص
     *
     * @param detail        ƷȯϢ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryCreditMortgageHoldRsp(CreditMortgageHoldDetail* detail,
        ErrorInfo* error_info, int request_id, bool is_last,
        const char* pos_str);

    /**
     * ʲѯӦص
     *
     * @param detail        ʲ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnQueryCreditAssetsRsp(CreditAssetsDetail* detail, ErrorInfo* error_info,
        int request_id);

    /**
     * ѯʺԼӦص
     *
     * @param detail        ʺԼ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryCreditFinanceRsp(CreditFinanceDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ѯȯԼӦص
     *
     * @param detail        ȯԼ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryCreditShortsellRsp(CreditShortsellDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ѯɻʸծӦص
     *
     * @param detail        ɻ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnQueryCreditRepayAmountRsp(CreditRepayAmountDetail* detail, ErrorInfo* error_info,
        int request_id);

    /**
     * ѯɻȯծӦص
     *
     * @param detail        ɻȯծ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryCreditRepayStockRsp(CreditRepayStockDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ѯȯӦص
     *
     * @param rsp               ѯȯӦ
     * @param error_info        ӦĴϢ
     * @param request_id        кţƥӦûԶ
     * @param is_last           ǷǱһӦ
     * @param pos_str           βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryCreditSecuritySellQtyRsp(CreditSecuritySellQtyRsp* rsp,
        ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
     * ѯ˻Ȩ޻ص
     *
     * @param rsp           ѯȨӦ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     */
    virtual void OnQuerySecuidRightRsp(QrySecuidRightRsp* rsp, ErrorInfo* error_info,
        int request_id);

    // ͨͨнӿ
    /**
     * ѯͨοʵӦ
     *
     * @param detail        ͨο
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     */
    virtual void OnQueryHKRateRsp(HKRateDetail* detail, ErrorInfo* error_info, int request_id,
        bool is_last);

    /**
     * ѯͨȯӦ
     *
     * @param detail        ͨȯ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     */
    virtual void OnQueryHKStockRsp(HKStockDetail* detail, ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
     * ѯͨʽʲӦ
     *
     * @param detail        ͨʽʲ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnQueryHKFundRsp(HKFundDetail* detail, ErrorInfo* error_info, int request_id);

    /**
     * ѯͨС۲Ӧ
     *
     * @param detail        ͨС۲
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     */
    virtual void OnQueryHKMinPriceUnitRsp(HKMinPriceUnitDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ѯͨӦ
     *
     * @param detail        ͨ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     */
    virtual void OnQueryHKTradeCalendarRsp(HKTradeCalendarDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last);

    /**
     * ѯȯϸӦ
     *
     * @param detail        ȯϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryLockSecurityDetailRsp(LockSecurityDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * չӦ
     *
     * @param rsp           չӦ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     */
    virtual void OnExtendLockSecurityRsp(ExtendLockSecurityRsp* rsp, ErrorInfo* error_info,
        int request_id);

    /**
     * ѯȯչӦ
     *
     * @param detail        չϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryLockSecurityExtensionRsp(LockSecurityExtensionDetail* detail,
        ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
     * ѯʽתˮӦ
     *
     * @param detail        ʽתϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     */
    virtual void OnQueryTransferFundHistoryRsp(TransferFundDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last);

    /**
    * ѯոծˮӦ
    *
    * @param detail        ծˮϸ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    * @param is_last       ǷǱһӦ
    * @param pos_str       βѯһ¼Ķλһβѯ
    */
    virtual void OnQueryCreditDebtsFlowRsp(CreditDebtsFlowDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
    * ѯʽˮӦ
    *
    * @param detail        ʽˮϸ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    * @param is_last       ǷǱһӦ
    * @param pos_str       βѯһ¼Ķλһβѯ
    */
    virtual void OnQueryCreditAssetFlowRsp(CreditAssetFlowDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
    * ѯÿͻȯԼӦ
    *
    * @param detail        ÿͻȯԼϸ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    * @param is_last       ǷǱһӦ
    * @param pos_str       βѯһ¼Ķλһβѯ
    */
    virtual void OnQueryCreditDebtsRsp(CreditDebtsDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ΢Ӧ
     *
     * @param rsp           ΢Ӧ
     * @param request_id    Ӧʱк
     */
    virtual void OnMicroServiceRsp(MicroServiceRsp* rsp, int request_id);

    /**
     * ѯ˺Ӧص
     *
     * @param detail        ϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnQueryBankBalanceRsp(BankBalanceDetail* detail, ErrorInfo* error_info,
        int request_id);

    /**
     * ѯбӦ
     *
     * @param detail        бϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     *
     * @return              ɹ0ʧܷش룬ͨGetApiLastErrorȡϢ
     */
    virtual void OnQueryBankInfoRsp(BankInfoDetail* detail, ErrorInfo* error_info, int request_id,
        bool is_last);

    /**
     * ֤תӦص
     *
     * @param rsp           ֤תӦ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnBankSecTransferRsp(BankSecTransferRsp* rsp, ErrorInfo* error_info,
        int request_id);

    /**
     * ѯ֤תݻص
     *
     * @param rsp           ֤ת
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     */
    virtual void OnQueryBankSecTransferRsp(BankSecTransferDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last);

    /**
     * ѯ֤תʷݻص
     *
     * @param detail        ֤תʷ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryHisBankSecTransferRsp(HisBankSecTransferDetail* detail,
        ErrorInfo* error_info, int request_id, bool is_last,
        const char* pos_str);

    /**
     * ʽתӦص
     *
     * @param detail        ʽתӦϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnFundAccountTransferRsp(FundAccountTransferRsp* detail, ErrorInfo* error_info,
        int request_id);

    /**
     * ѯʽ˺֮ʽתӦص
     *
     * @param detail        ʽתϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnQueryFundAccountTransferRsp(FundAccountTransferDetail* detail,
        ErrorInfo* error_info, int request_id);

    /**
     * ѯʷίлص
     *
     * @param detail        ʷίϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryHisOrderRsp(HisOrderDetail* detail, ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
     * ѯʷɽӦص
     *
     * @param detail        ʷɽϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryHisTradeRsp(HisTradeDetail* detail, ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
     * ѯӦص -- ΢򻯰
     *
     * @param detail        ϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryDeliveryOrderRsp(DeliveryOrderDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ˵ѯӦص -- ΢򻯰
     *
     * @param detail        ˵ϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryStateOrderRsp(StateOrderDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
    * ѯ(ֱ)Ӧص -- нϸ
    *
    * @param detail        ϸ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    * @param is_last       ǷǱһӦ
    * @param pos_str       βѯһ¼Ķλһβѯ
    */
    virtual void OnQueryExchangeListsRsp(ExchangeDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ޸Ӧ
     *
     * @param rsp           ޸Ӧ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     */
    virtual void OnModifyPasswordRsp(ModifyPasswordRsp* rsp, ErrorInfo* error_info,
        int request_id);

    /**
    * ѯϢӦص
    *
    * @param detail        Ϣ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    * @param is_last       ǷǱһӦ
    * @param pos_str       βѯһ¼Ķλһβѯ
    */
    virtual void OnQueryPHXXRsp(QueryPHXXRecord* detail, ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
    * ѯǩϢӦص
    *
    * @param detail        ǩϢ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    * @param is_last       ǷǱһӦ
    * @param pos_str       βѯһ¼Ķλһβѯ
    */
    virtual void OnQueryZQXXRsp(QueryZQXXRecord* detail, ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
     * ѯȯͬӦ
     *
     * @param detail        ȯͬ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryLockSecurityContractRsp(LockSecurityContractDetail* detail,
        ErrorInfo* error_info, int request_id, bool is_last,
        const char* pos_str);

    /**
     * ѯúͬӦ
     *
     * @param detail        úͬ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     */
    virtual void OnQueryCreditContractRsp(CreditContractDetail* detail, ErrorInfo* error_info,
        int request_id);

    /**
     * ѯȯԼϢӦ
     *
     * @param detail        ȯԼϢ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryCreditDebtsCollectRsp(CreditDebtsCollectDetail* detail,
        ErrorInfo* error_info, int request_id, bool is_last,
        const char* pos_str);

    /**
     * ѯȯӦ
     *
     * @param detail        ȯ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     */
    virtual void OnQueryCreditDataRsp(CreditDataDetail* detail, ErrorInfo* error_info,
        int request_id);

    /**
     * ѯԤںԼӦ
     *
     * @param detail        ԤںԼ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryPreMaturityDebtsRsp(PreMaturityDebtsDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ԤںԼչӦ
     *
     * @param detail        ԤںԼչӦ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     */
    virtual void OnExtendPreMaturityDebtsRsp(ExtendPreMaturityDebtsRsp* detail,
        ErrorInfo* error_info, int request_id);

    /**
     * ѯԤںԼչӦ
     *
     * @param detail        ԤںԼչ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryPreMaturityDebtsExtensionRsp(PreMaturityDebtsExtensionDetail* detail,
        ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
     * ѯͶƱ鰸Ӧ
     *
     * @param rsp           ͶƱ鰸
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     * @param is_last       ǷǱһӦ
     */
    virtual void OnQueryVoteProposalRsp(VoteProposalDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last);

    /**
     * ѯͶƱͶƱӦ
     *
     * @param detail        ͶƱͶƱ
     * @param error_info    ӦĴϢ
     * @param request_id    кţƥӦûԶ壬0
     */
    virtual void OnQueryCreditVoteCountRsp(CreditVoteCountDetail* detail, ErrorInfo* error_info,
        int request_id);

    /**
     * ѯͶƱӦ
     *
     * @param detail        ͶƱ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryCreditVoteRsp(CreditVoteDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ѯͶƱͻȨӦ
     *
     * @param detail        ͶƱͻȨϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryNetVoteRightsRsp(NetVoteRightsDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ѯͶƱӦ
     *
     * @param detail        ͶƱϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     * @param pos_str       βѯһ¼Ķλһβѯ
     */
    virtual void OnQueryNetVoteResultRsp(NetVoteResultDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
     * ѯͶƱͶƱӦ
     *
     * @param detail        ͶƱͶƱϸ
     * @param error_info    ӦĴϢ
     * @param request_id    Ӧʱк
     * @param is_last       ǷǱһӦ
     */
    virtual void OnQueryNetVoteCountRsp(NetVoteCountDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last);

    /**
    * ƱжȲѯӦ
    *
    * @param detail        Ʊжϸ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    * @param is_last       ǷǱһӦ
    * @param pos_str       βѯһ¼Ķλһβѯ
    */
    virtual void OnQueryStkConcentrationRsp(StkConcentrationDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
    * ѯͨʷίϸӦ
    *
    * @param detail        ʷίϸ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    * @param is_last       ǷǱһӦ
    * @param pos_str       βѯһ¼Ķλһβѯ
    */
    virtual void OnQueryHKHisOrderRsp(HKHisOrderDetail* detail, ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
    * ѯȡʽӦ
    *
    * @param detail        ȡʽ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    */
    virtual void OnQueryWithdrawCashRsp(WithdrawCashRecord* detail, ErrorInfo* error_info, int request_id);

    /**
    * ѯͶƱίӦ
    *
    * @param detail        ͶƱί
    * @param error_info    ӦĴϢ
    * @param request_id    кţƥӦûԶ壬0
    * @param is_last       ǷǱһӦ
    * @param pos_str       βѯһ¼Ķλһβѯ
    */
    virtual void OnQueryNetVoteOrderRsp(NetVoteOrderDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
    * ѯίбеĻܳɽϢӦһηһɽ
    *
    * @param trade_detail  ɽ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    * @param is_last       ǷǱһӦ
    * @param pos_str       βѯһ¼Ķλһβѯ
    */
    virtual void OnQueryTradeTotalRsp(TradeDetail* trade_detail, ErrorInfo* error_info, int request_id,
        bool is_last, const char* pos_str);

    /**
    * ETF Ϲ Ӧ
    *
    * @param order_rsp     ETF Ϲ Ӧ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    */
    virtual void OnETFSubscriptCancelRsp(ETFSubscriptCancelRsp* order_rsp, ErrorInfo* error_info,
        int request_id);

    /**
    * ͶƱίеӦ
    *
    * @param order_rsp     ͶƱίӦ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    */
    virtual void OnNetVoteOrderRsp(NetVoteOrderRsp* order_rsp, ErrorInfo* error_info,
        int request_id);

    /**
    * ͶƱίеӦ
    *
    * @param order_rsp     ͶƱίӦ
    * @param error_info    ӦĴϢ
    * @param request_id    Ӧʱк
    */
    virtual void OnCreditNetVoteOrderRsp(CreditNetVoteOrderRsp* order_rsp, ErrorInfo* error_info,
        int request_id);

    /**
       * ͻʽѯӦص΢
       *
       * @param detail        ϸϢ
       * @param error_info    ӦĴϢ
       * @param request_id    Ӧʱк
       * @param is_last       ǷǱһӦ
       * @param pos_str       βѯһ¼Ķλһβѯ
       */
    virtual void OnQueryMSCashRsp(MSCashDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
       * ͻֲֲѯӦص΢
       *
       * @param detail        ϸϢ
       * @param error_info    ӦĴϢ
       * @param request_id    Ӧʱк
       * @param is_last       ǷǱһӦ
       * @param pos_str       βѯһ¼Ķλһβѯ
       */
    virtual void OnQueryMSPositionsRsp(MSPositionsDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    /**
       * øծˮѯӦص΢
       *
       * @param detail        ϸϢ
       * @param error_info    ӦĴϢ
       * @param request_id    Ӧʱк
       * @param is_last       ǷǱһӦ
       * @param pos_str       βѯһ¼Ķλһβѯ
       */
    virtual void OnQueryMSCreditDebtsFlowRsp(MSCreditDebtsFlowDetail* detail, ErrorInfo* error_info,
        int request_id, bool is_last, const char* pos_str);

    //-------------------------------------------------------------------------------------
    //dataصֵ
    //errorصĴֵ
    //idid
    //lastǷΪ󷵻
    //i
    //-------------------------------------------------------------------------------------
    virtual void onDisconnect() {};

    virtual void onError(const dict& error, int request_id) {};

    virtual void onRiskNotify(const dict& data) {};

    virtual void onFailBackNotify(const dict& data) {};

    virtual void onLogin(const dict& data, const dict& error) {};

    virtual void onTradeReport(const dict& data) {};

    virtual void onOrderStatus(const dict& data) {};

    virtual void onOrderRsp(const dict& data, const dict& error, int request_id, bool last) {};

    virtual void onCancelRsp(const dict& data, const dict& error, int request_id, bool last) {};

    virtual void onQueryOrderRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryTradeRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryPositionRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryCashRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryJZJYAvailFundRsp(int64_t avail_balance, const dict& error, int request_id) {};

    virtual void onTransferFundInAndOutRsp(int64_t transfer_value, const dict& error, int request_id) {};

    virtual void onTransferFundBetweenSecuidRsp(int64_t transfer_value, const dict& error, int request_id) {};

    virtual void onQueryETFRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryETFStockRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryMaxOrderQtyRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryIPOMaxPurchaseRsp(const dict& data, const dict& error, int request_id, bool last) {};

    virtual void onQueryIPOStockRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQuerySecurityBaseInfoRsp(const dict& data, const dict& error, int request_id, bool last) {};

    virtual void onCreditMortgageInOutRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onCreditStockBackRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onCreditPayBackRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onCreditPayBackByOrderRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryCreditStockRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryCreditMortgageHoldRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryCreditAssetsRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryCreditFinanceRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryCreditShortsellRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryCreditRepayAmountRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryCreditRepayStockRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryCreditSecuritySellQtyRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQuerySecuidRightRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryHKRateRsp(const dict& data, const dict& error, int request_id, bool last) {};

    virtual void onQueryHKStockRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryHKFundRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryHKMinPriceUnitRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryHKTradeCalendarRsp(const dict& data, const dict& error, int request_id, bool last) {};

    virtual void onQueryLockSecurityDetailRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onExtendLockSecurityRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryLockSecurityExtensionRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryTransferFundHistoryRsp(const dict& data, const dict& error, int request_id, bool last) {};

    virtual void onQueryCreditDebtsFlowRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryCreditAssetFlowRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryCreditDebtsRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onMicroServiceRsp(const dict& data, int request_id) {};

    virtual void onQueryBankBalanceRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryBankInfoRsp(const dict& data, const dict& error, int request_id, bool last) {};

    virtual void onBankSecTransferRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryBankSecTransferRsp(const dict& data, const dict& error, int request_id, bool last) {};

    virtual void onQueryHisBankSecTransferRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onFundAccountTransferRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryFundAccountTransferRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryHisOrderRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryHisTradeRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryDeliveryOrderRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryStateOrderRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryExchangeListsRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onModifyPasswordRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryPHXXRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryZQXXRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryLockSecurityContractRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryCreditContractRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryCreditDebtsCollectRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryCreditDataRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryPreMaturityDebtsRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onExtendPreMaturityDebtsRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryPreMaturityDebtsExtensionRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryVoteProposalRsp(const dict& data, const dict& error, int request_id, bool last) {};

    virtual void onQueryCreditVoteCountRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryCreditVoteRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryNetVoteRightsRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryNetVoteResultRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryNetVoteCountRsp(const dict& data, const dict& error, int request_id, bool last) {};

    virtual void onQueryStkConcentrationRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryHKHisOrderRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryWithdrawCashRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryNetVoteOrderRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryTradeTotalRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onETFSubscriptCancelRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onNetVoteOrderRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onCreditNetVoteOrderRsp(const dict& data, const dict& error, int request_id) {};

    virtual void onQueryMSCashRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryMSPositionsRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    virtual void onQueryMSCreditDebtsFlowRsp(const dict& data, const dict& error, int request_id, bool last, string pos_str) {};

    //-------------------------------------------------------------------------------------
    //req:ֵ
    //-------------------------------------------------------------------------------------
	void setLogConfig(string log_path);

    void createTraderApi();

    void release();

    int exit();

    string getApiVersion();

	void setCriticalMsgLog(bool enable);

	void setLoginRetryCount(int login_retry_count);

	void setLoginRetryInterval(int login_retry_interval);

	void setReconnectConfig(int max_retry_count, int min_interval, int max_interval);

    dict getApiLastError();

    int login(string svr_ip, int svr_port, const dict& req, string terminal_info);

    int getCounterType();

    int getSecuidInfo(const dict& req, int count);

    int getAllSecuidInfo(const dict& req, int count);

    int getApiLocalAddr(const dict& req);

    int order(const dict& req, int request_id);

    int batchOrder(const dict& req, int count, int request_id);

    int cancelOrder(const dict& req, int request_id);

    int batchCancelOrder(const dict& req, int count, int request_id);

    int batchCancelAllOrder(const dict& req, int request_id);

    int queryOrder(const dict& req, int request_id);

    int queryOrderByCode(const dict& req, int request_id);

    int queryOrders(const dict& req, int request_id);

    int queryTradeByOrderId(const dict& req, int request_id);

    int queryTradeByCode(const dict& req, int request_id);

    int queryTrades(const dict& req, int request_id);

    int queryETFTrades(const dict& req, int request_id);

    int queryPosition(const dict& req, int request_id);

    int queryPositions(const dict& req, int request_id);

    int queryCash(const dict& req, int request_id);

    int queryJZJYAvailFund(int request_id);

    int transferFundInAndOut(const dict& req, int request_id);

    int transferFundBetweenSecuid(const dict& req, int request_id);

    int queryETFs(const dict& req, int request_id);

    int queryETFStocks(const dict& req, int request_id);

    int queryMaxOrderQty(const dict& req, int request_id);

    int queryIPOMaxPurchase(int request_id);

    int queryIPOStock(const dict& req, int request_id);

    int querySecurityBaseInfo(const dict& req, int request_id);

    int creditMortgageInOut(const dict& req, int request_id);

    int creditStockBack(const dict& req, int request_id);

    int creditPayBack(const dict& req, int request_id);

    int creditPayBackByOrder(const dict& req, int request_id);

    int queryCreditStock(const dict& req, int request_id);

    int queryCreditMortgageHold(const dict& req, int request_id);

    int queryCreditAssets(int request_id);

    int queryCreditFinance(const dict& req, int request_id);

    int queryCreditShortsell(const dict& req, int request_id);

    int queryCreditRepayAmount(int request_id);

    int queryCreditRepayStock(const dict& req, int request_id);

    int queryCreditSecuritySellQty(const dict& req, int request_id);

    int querySecuidRight(const dict& req, int request_id);

    int queryHKRate(const dict& req, int request_id);

    int queryHKStock(const dict& req, int request_id);

    int queryHKFund(int request_id);

    int queryHKMinPriceUnit(const dict& req, int request_id);

    int queryHKTradeCalendar(const dict& req, int request_id);

    int queryLockSecurityDetail(const dict& req, int request_id);

    int extendLockSecurity(const dict& req, int request_id);

    int queryLockSecurityExtension(const dict& req, int request_id);

    int queryTransferFundHistory(int request_id);

    int queryCreditDebtsFlow(const dict& req, int request_id);

    int queryCreditAssetFlow(const dict& req, int request_id);

    int queryCreditDebts(const dict& req, int request_id);

    int doMicroServiceReq(const dict& req, int request_id);

    int queryBankBalance(const dict& req, int request_id);

    int queryBankInfo(const dict& req, int request_id);

    int bankSecTransfer(const dict& req, int request_id);

    int queryBankSecTransfer(const dict& req, int request_id);

    int queryHisBankSecTransfer(const dict& req, int request_id);

    int fundAccountTransfer(const dict& req, int request_id);

    int queryFundAccountTransfer(const dict& req, int request_id);

    int queryHisOrders(const dict& req, int request_id);

    int queryHisTrades(const dict& req, int request_id);

    int queryDeliveryOrders(const dict& req, int request_id);

    int queryStateOrders(const dict& req, int request_id);

    int queryExchangeLists(const dict& req, int request_id);

    int modifyPassword(const dict& req, int request_id);

    int queryPHXX(const dict& req, int request_id);

    int queryZQXX(const dict& req, int request_id);

    int queryLockSecurityContract(const dict& req, int request_id);

    int queryCreditContract(int request_id);

    int queryCreditDebtsCollect(const dict& req, int request_id);

    int queryCreditData(const dict& req, int request_id);

    int queryPreMaturityDebts(const dict& req, int request_id);

    int extendPreMaturityDebts(const dict& req, int request_id);

    int queryPreMaturityDebtsExtension(const dict& req, int request_id);

    int queryVoteProposal(const dict& req, int request_id);

    int queryCreditVoteCount(const dict& req, int request_id);

    int queryCreditVote(const dict& req, int request_id);

    int queryNetVoteRights(const dict& req, int request_id);

    int queryNetVoteResult(const dict& req, int request_id);

    int queryNetVoteCount(const dict& req, int request_id);

    int appointContractSellStockRepay(const dict& req, int request_id);

    int queryStkConcentration(const dict& req, int request_id);

    int queryHKHisOrders(const dict& req, int request_id);

    int queryWithdrawCash(const dict& req, int request_id);

    int queryTradeListTotal(const dict& req, int request_id);

    int eTFSubscriptCancel(const dict& req, int request_id);

    int queryNetVoteOrder(const dict& req, int request_id);

    int netVoteOrder(const dict& req, int request_id, string terminal_info);

    int creditNetVoteOrder(const dict& req, int request_id, string terminal_info);

    int queryMSCash(const dict& req, int request_id);

    int queryMSPositions(const dict& req, int request_id);

    int queryMSCreditDebtsFlow(const dict& req, int request_id);

};
