import pathlib
from setuptools import setup

# The directory containing this file
HERE = pathlib.Path(__file__).parent

# The text of the README file
README = (HERE / "README.md").read_text()

# This call to setup() does all the work
setup(
    name="control-plotly",
    version="0.1.1",
    description="A plotting library for the analysis of continuous and discrete time systems",
    long_description=README,
    long_description_content_type="text/markdown",
    url="https://github.com/vincentchoqueuse/python-control-plotly",
    author="Vincent Choqueuse",
    author_email="vincent.choqueuse@gmail.com",
    license="MIT",
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
    ],
    packages=["control_plotly"],
    include_package_data=True,
    install_requires=["control", "plotly"]
)