# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
import pulumi_kubernetes

__all__ = [
    'CoreDNSAutoscalerArgs',
    'CoreDNSAutoscalerArgsDict',
    'CoreDNSDeploymentArgs',
    'CoreDNSDeploymentArgsDict',
    'CoreDNSHPAArgs',
    'CoreDNSHPAArgsDict',
    'CoreDNSImageArgs',
    'CoreDNSImageArgsDict',
    'CoreDNSPrometheusMonitorArgs',
    'CoreDNSPrometheusMonitorArgsDict',
    'CoreDNSPrometheusServiceArgs',
    'CoreDNSPrometheusServiceArgsDict',
    'CoreDNSPrometheusArgs',
    'CoreDNSPrometheusArgsDict',
    'CoreDNSRBACArgs',
    'CoreDNSRBACArgsDict',
    'CoreDNSServerPluginArgs',
    'CoreDNSServerPluginArgsDict',
    'CoreDNSServerZoneArgs',
    'CoreDNSServerZoneArgsDict',
    'CoreDNSServerArgs',
    'CoreDNSServerArgsDict',
    'CoreDNSServiceAccountArgs',
    'CoreDNSServiceAccountArgsDict',
    'CoreDNSServiceArgs',
    'CoreDNSServiceArgsDict',
    'CoreDNSZoneFileArgs',
    'CoreDNSZoneFileArgsDict',
    'ReleaseArgs',
    'ReleaseArgsDict',
    'RepositoryOptsArgs',
    'RepositoryOptsArgsDict',
]

MYPY = False

if not MYPY:
    class CoreDNSAutoscalerArgsDict(TypedDict):
        cores_per_replica: NotRequired[pulumi.Input[int]]
        """
        Number of cores in the cluster per coredns replica.
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Enabled the cluster-proportional-autoscaler.
        """
        image: NotRequired[pulumi.Input['CoreDNSImageArgsDict']]
        """
        The image to pull from for the autoscaler.
        """
        include_unschedulable_nodes: NotRequired[pulumi.Input[bool]]
        """
        Whether to include unschedulable nodes in the nodes/cores calculations - this requires version 1.8.0+ of the autoscaler.
        """
        max: NotRequired[pulumi.Input[int]]
        """
        Max size of replicaCount
        """
        min: NotRequired[pulumi.Input[int]]
        """
        Min size of replicaCount
        """
        nodes_per_replica: NotRequired[pulumi.Input[int]]
        """
        Number of nodes in the cluster per coredns replica.
        """
        prevent_single_point_failure: NotRequired[pulumi.Input[bool]]
        """
        If true does not allow single points of failure to form.
        """
elif False:
    CoreDNSAutoscalerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSAutoscalerArgs:
    def __init__(__self__, *,
                 cores_per_replica: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input['CoreDNSImageArgs']] = None,
                 include_unschedulable_nodes: Optional[pulumi.Input[bool]] = None,
                 max: Optional[pulumi.Input[int]] = None,
                 min: Optional[pulumi.Input[int]] = None,
                 nodes_per_replica: Optional[pulumi.Input[int]] = None,
                 prevent_single_point_failure: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[int] cores_per_replica: Number of cores in the cluster per coredns replica.
        :param pulumi.Input[bool] enabled: Enabled the cluster-proportional-autoscaler.
        :param pulumi.Input['CoreDNSImageArgs'] image: The image to pull from for the autoscaler.
        :param pulumi.Input[bool] include_unschedulable_nodes: Whether to include unschedulable nodes in the nodes/cores calculations - this requires version 1.8.0+ of the autoscaler.
        :param pulumi.Input[int] max: Max size of replicaCount
        :param pulumi.Input[int] min: Min size of replicaCount
        :param pulumi.Input[int] nodes_per_replica: Number of nodes in the cluster per coredns replica.
        :param pulumi.Input[bool] prevent_single_point_failure: If true does not allow single points of failure to form.
        """
        if cores_per_replica is not None:
            pulumi.set(__self__, "cores_per_replica", cores_per_replica)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if include_unschedulable_nodes is not None:
            pulumi.set(__self__, "include_unschedulable_nodes", include_unschedulable_nodes)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if nodes_per_replica is not None:
            pulumi.set(__self__, "nodes_per_replica", nodes_per_replica)
        if prevent_single_point_failure is not None:
            pulumi.set(__self__, "prevent_single_point_failure", prevent_single_point_failure)

    @property
    @pulumi.getter(name="coresPerReplica")
    def cores_per_replica(self) -> Optional[pulumi.Input[int]]:
        """
        Number of cores in the cluster per coredns replica.
        """
        return pulumi.get(self, "cores_per_replica")

    @cores_per_replica.setter
    def cores_per_replica(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cores_per_replica", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabled the cluster-proportional-autoscaler.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['CoreDNSImageArgs']]:
        """
        The image to pull from for the autoscaler.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['CoreDNSImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="includeUnschedulableNodes")
    def include_unschedulable_nodes(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to include unschedulable nodes in the nodes/cores calculations - this requires version 1.8.0+ of the autoscaler.
        """
        return pulumi.get(self, "include_unschedulable_nodes")

    @include_unschedulable_nodes.setter
    def include_unschedulable_nodes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_unschedulable_nodes", value)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[int]]:
        """
        Max size of replicaCount
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[int]]:
        """
        Min size of replicaCount
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min", value)

    @property
    @pulumi.getter(name="nodesPerReplica")
    def nodes_per_replica(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nodes in the cluster per coredns replica.
        """
        return pulumi.get(self, "nodes_per_replica")

    @nodes_per_replica.setter
    def nodes_per_replica(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nodes_per_replica", value)

    @property
    @pulumi.getter(name="preventSinglePointFailure")
    def prevent_single_point_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        If true does not allow single points of failure to form.
        """
        return pulumi.get(self, "prevent_single_point_failure")

    @prevent_single_point_failure.setter
    def prevent_single_point_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prevent_single_point_failure", value)


if not MYPY:
    class CoreDNSDeploymentArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Optionally disable the main deployment and its respective resources.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        Name of the deployment if deployment.enabled is true. Otherwise the name of an existing deployment for the autoscaler or HPA to target.
        """
elif False:
    CoreDNSDeploymentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSDeploymentArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Optionally disable the main deployment and its respective resources.
        :param pulumi.Input[str] name: Name of the deployment if deployment.enabled is true. Otherwise the name of an existing deployment for the autoscaler or HPA to target.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optionally disable the main deployment and its respective resources.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the deployment if deployment.enabled is true. Otherwise the name of an existing deployment for the autoscaler or HPA to target.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class CoreDNSHPAArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        max_replicas: NotRequired[pulumi.Input[int]]
        metrics: NotRequired[pulumi.Input['pulumi_kubernetes.autoscaling.v2beta2.MetricSpecArgsDict']]
        min_replicas: NotRequired[pulumi.Input[int]]
elif False:
    CoreDNSHPAArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSHPAArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 max_replicas: Optional[pulumi.Input[int]] = None,
                 metrics: Optional[pulumi.Input['pulumi_kubernetes.autoscaling.v2beta2.MetricSpecArgs']] = None,
                 min_replicas: Optional[pulumi.Input[int]] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_replicas")

    @max_replicas.setter
    def max_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_replicas", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input['pulumi_kubernetes.autoscaling.v2beta2.MetricSpecArgs']]:
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input['pulumi_kubernetes.autoscaling.v2beta2.MetricSpecArgs']]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "min_replicas")

    @min_replicas.setter
    def min_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_replicas", value)


if not MYPY:
    class CoreDNSImageArgsDict(TypedDict):
        pull_policy: NotRequired[pulumi.Input[str]]
        """
        Image pull policy.
        """
        pull_secrets: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Specify container image pull secrets.
        """
        repository: NotRequired[pulumi.Input[str]]
        """
        The image repository to pull from.
        """
        tag: NotRequired[pulumi.Input[str]]
        """
        The image tag to pull from.
        """
elif False:
    CoreDNSImageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSImageArgs:
    def __init__(__self__, *,
                 pull_policy: Optional[pulumi.Input[str]] = None,
                 pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] pull_policy: Image pull policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pull_secrets: Specify container image pull secrets.
        :param pulumi.Input[str] repository: The image repository to pull from.
        :param pulumi.Input[str] tag: The image tag to pull from.
        """
        if pull_policy is not None:
            pulumi.set(__self__, "pull_policy", pull_policy)
        if pull_secrets is not None:
            pulumi.set(__self__, "pull_secrets", pull_secrets)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="pullPolicy")
    def pull_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Image pull policy.
        """
        return pulumi.get(self, "pull_policy")

    @pull_policy.setter
    def pull_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pull_policy", value)

    @property
    @pulumi.getter(name="pullSecrets")
    def pull_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify container image pull secrets.
        """
        return pulumi.get(self, "pull_secrets")

    @pull_secrets.setter
    def pull_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pull_secrets", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        The image repository to pull from.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        The image tag to pull from.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


if not MYPY:
    class CoreDNSPrometheusMonitorArgsDict(TypedDict):
        additional_labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Additional labels that can be used so ServiceMonitor will be discovered by Prometheus.
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Set this to true to create ServiceMonitor for Prometheus operator.
        """
        namespace: NotRequired[pulumi.Input[str]]
        """
        Selector to select which namespaces the Endpoints objects are discovered from.
        """
elif False:
    CoreDNSPrometheusMonitorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSPrometheusMonitorArgs:
    def __init__(__self__, *,
                 additional_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_labels: Additional labels that can be used so ServiceMonitor will be discovered by Prometheus.
        :param pulumi.Input[bool] enabled: Set this to true to create ServiceMonitor for Prometheus operator.
        :param pulumi.Input[str] namespace: Selector to select which namespaces the Endpoints objects are discovered from.
        """
        if additional_labels is not None:
            pulumi.set(__self__, "additional_labels", additional_labels)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="additionalLabels")
    def additional_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional labels that can be used so ServiceMonitor will be discovered by Prometheus.
        """
        return pulumi.get(self, "additional_labels")

    @additional_labels.setter
    def additional_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "additional_labels", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this to true to create ServiceMonitor for Prometheus operator.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Selector to select which namespaces the Endpoints objects are discovered from.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


if not MYPY:
    class CoreDNSPrometheusServiceArgsDict(TypedDict):
        annotations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Annotations to add to the metrics Service.
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Set this to true to create Service for Prometheus metrics.
        """
elif False:
    CoreDNSPrometheusServiceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSPrometheusServiceArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations to add to the metrics Service.
        :param pulumi.Input[bool] enabled: Set this to true to create Service for Prometheus metrics.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations to add to the metrics Service.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this to true to create Service for Prometheus metrics.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class CoreDNSPrometheusArgsDict(TypedDict):
        monitor: NotRequired[pulumi.Input['CoreDNSPrometheusMonitorArgsDict']]
        service: NotRequired[pulumi.Input['CoreDNSPrometheusServiceArgsDict']]
elif False:
    CoreDNSPrometheusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSPrometheusArgs:
    def __init__(__self__, *,
                 monitor: Optional[pulumi.Input['CoreDNSPrometheusMonitorArgs']] = None,
                 service: Optional[pulumi.Input['CoreDNSPrometheusServiceArgs']] = None):
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['CoreDNSPrometheusMonitorArgs']]:
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['CoreDNSPrometheusMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input['CoreDNSPrometheusServiceArgs']]:
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input['CoreDNSPrometheusServiceArgs']]):
        pulumi.set(self, "service", value)


if not MYPY:
    class CoreDNSRBACArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[bool]]
        """
        If true, create & use RBAC resources
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the ServiceAccount to use. If not set and create is true, a name is generated using the fullname template.
        """
        psp_enable: NotRequired[pulumi.Input[bool]]
        """
        If true, create and use PodSecurityPolicy
        """
elif False:
    CoreDNSRBACArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSRBACArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 psp_enable: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] create: If true, create & use RBAC resources
        :param pulumi.Input[str] name: The name of the ServiceAccount to use. If not set and create is true, a name is generated using the fullname template.
        :param pulumi.Input[bool] psp_enable: If true, create and use PodSecurityPolicy
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if psp_enable is not None:
            pulumi.set(__self__, "psp_enable", psp_enable)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, create & use RBAC resources
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ServiceAccount to use. If not set and create is true, a name is generated using the fullname template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pspEnable")
    def psp_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, create and use PodSecurityPolicy
        """
        return pulumi.get(self, "psp_enable")

    @psp_enable.setter
    def psp_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "psp_enable", value)


if not MYPY:
    class CoreDNSServerPluginArgsDict(TypedDict):
        config_block: NotRequired[pulumi.Input[str]]
        """
        if the plugin supports extra block style config, supply it here
        """
        name: NotRequired[pulumi.Input[str]]
        """
        name of plugin, if used multiple times ensure that the plugin supports it!
        """
        parameters: NotRequired[pulumi.Input[str]]
        """
        list of parameters after the plugin
        """
elif False:
    CoreDNSServerPluginArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSServerPluginArgs:
    def __init__(__self__, *,
                 config_block: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] config_block: if the plugin supports extra block style config, supply it here
        :param pulumi.Input[str] name: name of plugin, if used multiple times ensure that the plugin supports it!
        :param pulumi.Input[str] parameters: list of parameters after the plugin
        """
        if config_block is not None:
            pulumi.set(__self__, "config_block", config_block)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="configBlock")
    def config_block(self) -> Optional[pulumi.Input[str]]:
        """
        if the plugin supports extra block style config, supply it here
        """
        return pulumi.get(self, "config_block")

    @config_block.setter
    def config_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_block", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of plugin, if used multiple times ensure that the plugin supports it!
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[str]]:
        """
        list of parameters after the plugin
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameters", value)


if not MYPY:
    class CoreDNSServerZoneArgsDict(TypedDict):
        scheme: NotRequired[pulumi.Input[str]]
        """
        optional, defaults to "" (which equals "dns://" in CoreDNS)
        """
        use_tcp: NotRequired[pulumi.Input[bool]]
        """
        set this parameter to optionally expose the port on tcp as well as udp for the DNS protocol. Note that this will not work if you are also exposing tls or grpc on the same server.
        """
        zone: NotRequired[pulumi.Input[str]]
        """
        optional, defaults to "."
        """
elif False:
    CoreDNSServerZoneArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSServerZoneArgs:
    def __init__(__self__, *,
                 scheme: Optional[pulumi.Input[str]] = None,
                 use_tcp: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] scheme: optional, defaults to "" (which equals "dns://" in CoreDNS)
        :param pulumi.Input[bool] use_tcp: set this parameter to optionally expose the port on tcp as well as udp for the DNS protocol. Note that this will not work if you are also exposing tls or grpc on the same server.
        :param pulumi.Input[str] zone: optional, defaults to "."
        """
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if use_tcp is not None:
            pulumi.set(__self__, "use_tcp", use_tcp)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[str]]:
        """
        optional, defaults to "" (which equals "dns://" in CoreDNS)
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheme", value)

    @property
    @pulumi.getter
    def use_tcp(self) -> Optional[pulumi.Input[bool]]:
        """
        set this parameter to optionally expose the port on tcp as well as udp for the DNS protocol. Note that this will not work if you are also exposing tls or grpc on the same server.
        """
        return pulumi.get(self, "use_tcp")

    @use_tcp.setter
    def use_tcp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_tcp", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        optional, defaults to "."
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class CoreDNSServerArgsDict(TypedDict):
        plugins: NotRequired[pulumi.Input[Sequence[pulumi.Input['CoreDNSServerPluginArgsDict']]]]
        """
        the plugins to use for this server block.
        """
        port: NotRequired[pulumi.Input[int]]
        """
        optional, defaults to "" (which equals 53 in CoreDNS).
        """
        zones: NotRequired[pulumi.Input[Sequence[pulumi.Input['CoreDNSServerZoneArgsDict']]]]
        """
        the `zones` block can be left out entirely, defaults to "."
        """
elif False:
    CoreDNSServerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSServerArgs:
    def __init__(__self__, *,
                 plugins: Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSServerPluginArgs']]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSServerZoneArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['CoreDNSServerPluginArgs']]] plugins: the plugins to use for this server block.
        :param pulumi.Input[int] port: optional, defaults to "" (which equals 53 in CoreDNS).
        :param pulumi.Input[Sequence[pulumi.Input['CoreDNSServerZoneArgs']]] zones: the `zones` block can be left out entirely, defaults to "."
        """
        if plugins is not None:
            pulumi.set(__self__, "plugins", plugins)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def plugins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSServerPluginArgs']]]]:
        """
        the plugins to use for this server block.
        """
        return pulumi.get(self, "plugins")

    @plugins.setter
    def plugins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSServerPluginArgs']]]]):
        pulumi.set(self, "plugins", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        optional, defaults to "" (which equals 53 in CoreDNS).
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSServerZoneArgs']]]]:
        """
        the `zones` block can be left out entirely, defaults to "."
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CoreDNSServerZoneArgs']]]]):
        pulumi.set(self, "zones", value)


if not MYPY:
    class CoreDNSServiceAccountArgsDict(TypedDict):
        annotations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        create: NotRequired[pulumi.Input[bool]]
        """
        If true, create & use serviceAccount.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the ServiceAccount to use. If not set and create is true, a name is generated using the fullname template
        """
elif False:
    CoreDNSServiceAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSServiceAccountArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 create: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] create: If true, create & use serviceAccount.
        :param pulumi.Input[str] name: The name of the ServiceAccount to use. If not set and create is true, a name is generated using the fullname template
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if create is not None:
            pulumi.set(__self__, "create", create)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, create & use serviceAccount.
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ServiceAccount to use. If not set and create is true, a name is generated using the fullname template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class CoreDNSServiceArgsDict(TypedDict):
        annotations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Annotations to add to service.
        """
        cluster_ip: NotRequired[pulumi.Input[str]]
        """
        IP address to assign to service.
        """
        external_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        External IP addresses.
        """
        external_traffic_policy: NotRequired[pulumi.Input[str]]
        """
        Enable client source IP preservation.
        """
        load_balancer_ip: NotRequired[pulumi.Input[str]]
        """
        IP address to assign to load balancer (if supported).
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the Service. If not set, a name is generated using the fullname template.
        """
elif False:
    CoreDNSServiceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSServiceArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_ip: Optional[pulumi.Input[str]] = None,
                 external_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 external_traffic_policy: Optional[pulumi.Input[str]] = None,
                 load_balancer_ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations to add to service.
        :param pulumi.Input[str] cluster_ip: IP address to assign to service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] external_ips: External IP addresses.
        :param pulumi.Input[str] external_traffic_policy: Enable client source IP preservation.
        :param pulumi.Input[str] load_balancer_ip: IP address to assign to load balancer (if supported).
        :param pulumi.Input[str] name: The name of the Service. If not set, a name is generated using the fullname template.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_ip is not None:
            pulumi.set(__self__, "cluster_ip", cluster_ip)
        if external_ips is not None:
            pulumi.set(__self__, "external_ips", external_ips)
        if external_traffic_policy is not None:
            pulumi.set(__self__, "external_traffic_policy", external_traffic_policy)
        if load_balancer_ip is not None:
            pulumi.set(__self__, "load_balancer_ip", load_balancer_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations to add to service.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="clusterIP")
    def cluster_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP address to assign to service.
        """
        return pulumi.get(self, "cluster_ip")

    @cluster_ip.setter
    def cluster_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ip", value)

    @property
    @pulumi.getter(name="externalIPs")
    def external_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        External IP addresses.
        """
        return pulumi.get(self, "external_ips")

    @external_ips.setter
    def external_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "external_ips", value)

    @property
    @pulumi.getter(name="externalTrafficPolicy")
    def external_traffic_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Enable client source IP preservation.
        """
        return pulumi.get(self, "external_traffic_policy")

    @external_traffic_policy.setter
    def external_traffic_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_traffic_policy", value)

    @property
    @pulumi.getter(name="loadBalancerIP")
    def load_balancer_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP address to assign to load balancer (if supported).
        """
        return pulumi.get(self, "load_balancer_ip")

    @load_balancer_ip.setter
    def load_balancer_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Service. If not set, a name is generated using the fullname template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class CoreDNSZoneFileArgsDict(TypedDict):
        contents: NotRequired[pulumi.Input[str]]
        domain: NotRequired[pulumi.Input[str]]
        string: NotRequired[pulumi.Input[str]]
elif False:
    CoreDNSZoneFileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDNSZoneFileArgs:
    def __init__(__self__, *,
                 contents: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 string: Optional[pulumi.Input[str]] = None):
        if contents is not None:
            pulumi.set(__self__, "contents", contents)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if string is not None:
            pulumi.set(__self__, "string", string)

    @property
    @pulumi.getter
    def contents(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "contents")

    @contents.setter
    def contents(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contents", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def string(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "string")

    @string.setter
    def string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "string", value)


if not MYPY:
    class ReleaseArgsDict(TypedDict):
        """
        A Release is an instance of a chart running in a Kubernetes cluster.
        A Chart is a Helm package. It contains all of the resource definitions necessary to run an application, tool, or service inside of a Kubernetes cluster.
        Note - Helm Release is currently in BETA and may change. Use in production environment is discouraged.
        """
        atomic: NotRequired[pulumi.Input[bool]]
        """
        If set, installation process purges chart on fail. `skipAwait` will be disabled automatically if atomic is used.
        """
        chart: NotRequired[pulumi.Input[str]]
        """
        Chart name to be installed. A path may be used.
        """
        cleanup_on_fail: NotRequired[pulumi.Input[bool]]
        """
        Allow deletion of new resources created in this upgrade when upgrade fails.
        """
        create_namespace: NotRequired[pulumi.Input[bool]]
        """
        Create the namespace if it does not exist.
        """
        dependency_update: NotRequired[pulumi.Input[bool]]
        """
        Run helm dependency update before installing the chart.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        Add a custom description
        """
        devel: NotRequired[pulumi.Input[bool]]
        """
        Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
        """
        disable_crd_hooks: NotRequired[pulumi.Input[bool]]
        """
        Prevent CRD hooks from, running, but run other hooks.  See helm install --no-crd-hook
        """
        disable_openapi_validation: NotRequired[pulumi.Input[bool]]
        """
        If set, the installation process will not validate rendered templates against the Kubernetes OpenAPI Schema
        """
        disable_webhooks: NotRequired[pulumi.Input[bool]]
        """
        Prevent hooks from running.
        """
        force_update: NotRequired[pulumi.Input[bool]]
        """
        Force resource update through delete/recreate if needed.
        """
        keyring: NotRequired[pulumi.Input[str]]
        """
        Location of public keys used for verification. Used only if `verify` is true
        """
        lint: NotRequired[pulumi.Input[bool]]
        """
        Run helm lint when planning.
        """
        manifest: NotRequired[pulumi.Input[Mapping[str, Any]]]
        """
        The rendered manifests as JSON. Not yet supported.
        """
        max_history: NotRequired[pulumi.Input[int]]
        """
        Limit the maximum number of revisions saved per release. Use 0 for no limit.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        Release name.
        """
        namespace: NotRequired[pulumi.Input[str]]
        """
        Namespace to install the release into.
        """
        postrender: NotRequired[pulumi.Input[str]]
        """
        Postrender command to run.
        """
        recreate_pods: NotRequired[pulumi.Input[bool]]
        """
        Perform pods restart during upgrade/rollback.
        """
        render_subchart_notes: NotRequired[pulumi.Input[bool]]
        """
        If set, render subchart notes along with the parent.
        """
        replace: NotRequired[pulumi.Input[bool]]
        """
        Re-use the given name, even if that name is already used. This is unsafe in production
        """
        repository_opts: NotRequired[pulumi.Input['RepositoryOptsArgsDict']]
        """
        Specification defining the Helm chart repository to use.
        """
        reset_values: NotRequired[pulumi.Input[bool]]
        """
        When upgrading, reset the values to the ones built into the chart.
        """
        resource_names: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]
        """
        Names of resources created by the release grouped by "kind/version".
        """
        reuse_values: NotRequired[pulumi.Input[bool]]
        """
        When upgrading, reuse the last release's values and merge in any overrides. If 'resetValues' is specified, this is ignored
        """
        skip_await: NotRequired[pulumi.Input[bool]]
        """
        By default, the provider waits until all resources are in a ready state before marking the release as successful. Setting this to true will skip such await logic.
        """
        skip_crds: NotRequired[pulumi.Input[bool]]
        """
        If set, no CRDs will be installed. By default, CRDs are installed if not already present.
        """
        timeout: NotRequired[pulumi.Input[int]]
        """
        Time in seconds to wait for any individual kubernetes operation.
        """
        value_yaml_files: NotRequired[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]]
        """
        List of assets (raw yaml files). Content is read and merged with values. Not yet supported.
        """
        values: NotRequired[pulumi.Input[Mapping[str, Any]]]
        """
        Custom values set for the release.
        """
        verify: NotRequired[pulumi.Input[bool]]
        """
        Verify the package before installing it.
        """
        version: NotRequired[pulumi.Input[str]]
        """
        Specify the exact chart version to install. If this is not specified, the latest version is installed.
        """
        wait_for_jobs: NotRequired[pulumi.Input[bool]]
        """
        Will wait until all Jobs have been completed before marking the release as successful. This is ignored if `skipAwait` is enabled.
        """
elif False:
    ReleaseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReleaseArgs:
    def __init__(__self__, *,
                 atomic: Optional[pulumi.Input[bool]] = None,
                 chart: Optional[pulumi.Input[str]] = None,
                 cleanup_on_fail: Optional[pulumi.Input[bool]] = None,
                 create_namespace: Optional[pulumi.Input[bool]] = None,
                 dependency_update: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 devel: Optional[pulumi.Input[bool]] = None,
                 disable_crd_hooks: Optional[pulumi.Input[bool]] = None,
                 disable_openapi_validation: Optional[pulumi.Input[bool]] = None,
                 disable_webhooks: Optional[pulumi.Input[bool]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 keyring: Optional[pulumi.Input[str]] = None,
                 lint: Optional[pulumi.Input[bool]] = None,
                 manifest: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_history: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 postrender: Optional[pulumi.Input[str]] = None,
                 recreate_pods: Optional[pulumi.Input[bool]] = None,
                 render_subchart_notes: Optional[pulumi.Input[bool]] = None,
                 replace: Optional[pulumi.Input[bool]] = None,
                 repository_opts: Optional[pulumi.Input['RepositoryOptsArgs']] = None,
                 reset_values: Optional[pulumi.Input[bool]] = None,
                 resource_names: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 reuse_values: Optional[pulumi.Input[bool]] = None,
                 skip_await: Optional[pulumi.Input[bool]] = None,
                 skip_crds: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 value_yaml_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]] = None,
                 values: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 verify: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_for_jobs: Optional[pulumi.Input[bool]] = None):
        """
        A Release is an instance of a chart running in a Kubernetes cluster.
        A Chart is a Helm package. It contains all of the resource definitions necessary to run an application, tool, or service inside of a Kubernetes cluster.
        Note - Helm Release is currently in BETA and may change. Use in production environment is discouraged.
        :param pulumi.Input[bool] atomic: If set, installation process purges chart on fail. `skipAwait` will be disabled automatically if atomic is used.
        :param pulumi.Input[str] chart: Chart name to be installed. A path may be used.
        :param pulumi.Input[bool] cleanup_on_fail: Allow deletion of new resources created in this upgrade when upgrade fails.
        :param pulumi.Input[bool] create_namespace: Create the namespace if it does not exist.
        :param pulumi.Input[bool] dependency_update: Run helm dependency update before installing the chart.
        :param pulumi.Input[str] description: Add a custom description
        :param pulumi.Input[bool] devel: Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
        :param pulumi.Input[bool] disable_crd_hooks: Prevent CRD hooks from, running, but run other hooks.  See helm install --no-crd-hook
        :param pulumi.Input[bool] disable_openapi_validation: If set, the installation process will not validate rendered templates against the Kubernetes OpenAPI Schema
        :param pulumi.Input[bool] disable_webhooks: Prevent hooks from running.
        :param pulumi.Input[bool] force_update: Force resource update through delete/recreate if needed.
        :param pulumi.Input[str] keyring: Location of public keys used for verification. Used only if `verify` is true
        :param pulumi.Input[bool] lint: Run helm lint when planning.
        :param pulumi.Input[Mapping[str, Any]] manifest: The rendered manifests as JSON. Not yet supported.
        :param pulumi.Input[int] max_history: Limit the maximum number of revisions saved per release. Use 0 for no limit.
        :param pulumi.Input[str] name: Release name.
        :param pulumi.Input[str] namespace: Namespace to install the release into.
        :param pulumi.Input[str] postrender: Postrender command to run.
        :param pulumi.Input[bool] recreate_pods: Perform pods restart during upgrade/rollback.
        :param pulumi.Input[bool] render_subchart_notes: If set, render subchart notes along with the parent.
        :param pulumi.Input[bool] replace: Re-use the given name, even if that name is already used. This is unsafe in production
        :param pulumi.Input['RepositoryOptsArgs'] repository_opts: Specification defining the Helm chart repository to use.
        :param pulumi.Input[bool] reset_values: When upgrading, reset the values to the ones built into the chart.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]] resource_names: Names of resources created by the release grouped by "kind/version".
        :param pulumi.Input[bool] reuse_values: When upgrading, reuse the last release's values and merge in any overrides. If 'resetValues' is specified, this is ignored
        :param pulumi.Input[bool] skip_await: By default, the provider waits until all resources are in a ready state before marking the release as successful. Setting this to true will skip such await logic.
        :param pulumi.Input[bool] skip_crds: If set, no CRDs will be installed. By default, CRDs are installed if not already present.
        :param pulumi.Input[int] timeout: Time in seconds to wait for any individual kubernetes operation.
        :param pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]] value_yaml_files: List of assets (raw yaml files). Content is read and merged with values. Not yet supported.
        :param pulumi.Input[Mapping[str, Any]] values: Custom values set for the release.
        :param pulumi.Input[bool] verify: Verify the package before installing it.
        :param pulumi.Input[str] version: Specify the exact chart version to install. If this is not specified, the latest version is installed.
        :param pulumi.Input[bool] wait_for_jobs: Will wait until all Jobs have been completed before marking the release as successful. This is ignored if `skipAwait` is enabled.
        """
        if atomic is not None:
            pulumi.set(__self__, "atomic", atomic)
        if chart is not None:
            pulumi.set(__self__, "chart", chart)
        if cleanup_on_fail is not None:
            pulumi.set(__self__, "cleanup_on_fail", cleanup_on_fail)
        if create_namespace is not None:
            pulumi.set(__self__, "create_namespace", create_namespace)
        if dependency_update is not None:
            pulumi.set(__self__, "dependency_update", dependency_update)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if devel is not None:
            pulumi.set(__self__, "devel", devel)
        if disable_crd_hooks is not None:
            pulumi.set(__self__, "disable_crd_hooks", disable_crd_hooks)
        if disable_openapi_validation is not None:
            pulumi.set(__self__, "disable_openapi_validation", disable_openapi_validation)
        if disable_webhooks is not None:
            pulumi.set(__self__, "disable_webhooks", disable_webhooks)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if keyring is not None:
            pulumi.set(__self__, "keyring", keyring)
        if lint is not None:
            pulumi.set(__self__, "lint", lint)
        if manifest is not None:
            pulumi.set(__self__, "manifest", manifest)
        if max_history is not None:
            pulumi.set(__self__, "max_history", max_history)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if postrender is not None:
            pulumi.set(__self__, "postrender", postrender)
        if recreate_pods is not None:
            pulumi.set(__self__, "recreate_pods", recreate_pods)
        if render_subchart_notes is not None:
            pulumi.set(__self__, "render_subchart_notes", render_subchart_notes)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)
        if repository_opts is not None:
            pulumi.set(__self__, "repository_opts", repository_opts)
        if reset_values is not None:
            pulumi.set(__self__, "reset_values", reset_values)
        if resource_names is not None:
            pulumi.set(__self__, "resource_names", resource_names)
        if reuse_values is not None:
            pulumi.set(__self__, "reuse_values", reuse_values)
        if skip_await is not None:
            pulumi.set(__self__, "skip_await", skip_await)
        if skip_crds is not None:
            pulumi.set(__self__, "skip_crds", skip_crds)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if value_yaml_files is not None:
            pulumi.set(__self__, "value_yaml_files", value_yaml_files)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if verify is not None:
            pulumi.set(__self__, "verify", verify)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wait_for_jobs is not None:
            pulumi.set(__self__, "wait_for_jobs", wait_for_jobs)

    @property
    @pulumi.getter
    def atomic(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, installation process purges chart on fail. `skipAwait` will be disabled automatically if atomic is used.
        """
        return pulumi.get(self, "atomic")

    @atomic.setter
    def atomic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "atomic", value)

    @property
    @pulumi.getter
    def chart(self) -> Optional[pulumi.Input[str]]:
        """
        Chart name to be installed. A path may be used.
        """
        return pulumi.get(self, "chart")

    @chart.setter
    def chart(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chart", value)

    @property
    @pulumi.getter(name="cleanupOnFail")
    def cleanup_on_fail(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow deletion of new resources created in this upgrade when upgrade fails.
        """
        return pulumi.get(self, "cleanup_on_fail")

    @cleanup_on_fail.setter
    def cleanup_on_fail(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cleanup_on_fail", value)

    @property
    @pulumi.getter(name="createNamespace")
    def create_namespace(self) -> Optional[pulumi.Input[bool]]:
        """
        Create the namespace if it does not exist.
        """
        return pulumi.get(self, "create_namespace")

    @create_namespace.setter
    def create_namespace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_namespace", value)

    @property
    @pulumi.getter(name="dependencyUpdate")
    def dependency_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Run helm dependency update before installing the chart.
        """
        return pulumi.get(self, "dependency_update")

    @dependency_update.setter
    def dependency_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dependency_update", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Add a custom description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def devel(self) -> Optional[pulumi.Input[bool]]:
        """
        Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
        """
        return pulumi.get(self, "devel")

    @devel.setter
    def devel(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "devel", value)

    @property
    @pulumi.getter(name="disableCRDHooks")
    def disable_crd_hooks(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent CRD hooks from, running, but run other hooks.  See helm install --no-crd-hook
        """
        return pulumi.get(self, "disable_crd_hooks")

    @disable_crd_hooks.setter
    def disable_crd_hooks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_crd_hooks", value)

    @property
    @pulumi.getter(name="disableOpenapiValidation")
    def disable_openapi_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, the installation process will not validate rendered templates against the Kubernetes OpenAPI Schema
        """
        return pulumi.get(self, "disable_openapi_validation")

    @disable_openapi_validation.setter
    def disable_openapi_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_openapi_validation", value)

    @property
    @pulumi.getter(name="disableWebhooks")
    def disable_webhooks(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent hooks from running.
        """
        return pulumi.get(self, "disable_webhooks")

    @disable_webhooks.setter
    def disable_webhooks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_webhooks", value)

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Force resource update through delete/recreate if needed.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_update", value)

    @property
    @pulumi.getter
    def keyring(self) -> Optional[pulumi.Input[str]]:
        """
        Location of public keys used for verification. Used only if `verify` is true
        """
        return pulumi.get(self, "keyring")

    @keyring.setter
    def keyring(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keyring", value)

    @property
    @pulumi.getter
    def lint(self) -> Optional[pulumi.Input[bool]]:
        """
        Run helm lint when planning.
        """
        return pulumi.get(self, "lint")

    @lint.setter
    def lint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lint", value)

    @property
    @pulumi.getter
    def manifest(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The rendered manifests as JSON. Not yet supported.
        """
        return pulumi.get(self, "manifest")

    @manifest.setter
    def manifest(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "manifest", value)

    @property
    @pulumi.getter(name="maxHistory")
    def max_history(self) -> Optional[pulumi.Input[int]]:
        """
        Limit the maximum number of revisions saved per release. Use 0 for no limit.
        """
        return pulumi.get(self, "max_history")

    @max_history.setter
    def max_history(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_history", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Release name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace to install the release into.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def postrender(self) -> Optional[pulumi.Input[str]]:
        """
        Postrender command to run.
        """
        return pulumi.get(self, "postrender")

    @postrender.setter
    def postrender(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postrender", value)

    @property
    @pulumi.getter(name="recreatePods")
    def recreate_pods(self) -> Optional[pulumi.Input[bool]]:
        """
        Perform pods restart during upgrade/rollback.
        """
        return pulumi.get(self, "recreate_pods")

    @recreate_pods.setter
    def recreate_pods(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "recreate_pods", value)

    @property
    @pulumi.getter(name="renderSubchartNotes")
    def render_subchart_notes(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, render subchart notes along with the parent.
        """
        return pulumi.get(self, "render_subchart_notes")

    @render_subchart_notes.setter
    def render_subchart_notes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "render_subchart_notes", value)

    @property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[bool]]:
        """
        Re-use the given name, even if that name is already used. This is unsafe in production
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace", value)

    @property
    @pulumi.getter(name="repositoryOpts")
    def repository_opts(self) -> Optional[pulumi.Input['RepositoryOptsArgs']]:
        """
        Specification defining the Helm chart repository to use.
        """
        return pulumi.get(self, "repository_opts")

    @repository_opts.setter
    def repository_opts(self, value: Optional[pulumi.Input['RepositoryOptsArgs']]):
        pulumi.set(self, "repository_opts", value)

    @property
    @pulumi.getter(name="resetValues")
    def reset_values(self) -> Optional[pulumi.Input[bool]]:
        """
        When upgrading, reset the values to the ones built into the chart.
        """
        return pulumi.get(self, "reset_values")

    @reset_values.setter
    def reset_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reset_values", value)

    @property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]:
        """
        Names of resources created by the release grouped by "kind/version".
        """
        return pulumi.get(self, "resource_names")

    @resource_names.setter
    def resource_names(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]):
        pulumi.set(self, "resource_names", value)

    @property
    @pulumi.getter(name="reuseValues")
    def reuse_values(self) -> Optional[pulumi.Input[bool]]:
        """
        When upgrading, reuse the last release's values and merge in any overrides. If 'resetValues' is specified, this is ignored
        """
        return pulumi.get(self, "reuse_values")

    @reuse_values.setter
    def reuse_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reuse_values", value)

    @property
    @pulumi.getter(name="skipAwait")
    def skip_await(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, the provider waits until all resources are in a ready state before marking the release as successful. Setting this to true will skip such await logic.
        """
        return pulumi.get(self, "skip_await")

    @skip_await.setter
    def skip_await(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_await", value)

    @property
    @pulumi.getter(name="skipCrds")
    def skip_crds(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, no CRDs will be installed. By default, CRDs are installed if not already present.
        """
        return pulumi.get(self, "skip_crds")

    @skip_crds.setter
    def skip_crds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_crds", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Time in seconds to wait for any individual kubernetes operation.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="valueYamlFiles")
    def value_yaml_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]]:
        """
        List of assets (raw yaml files). Content is read and merged with values. Not yet supported.
        """
        return pulumi.get(self, "value_yaml_files")

    @value_yaml_files.setter
    def value_yaml_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]]]):
        pulumi.set(self, "value_yaml_files", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Custom values set for the release.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def verify(self) -> Optional[pulumi.Input[bool]]:
        """
        Verify the package before installing it.
        """
        return pulumi.get(self, "verify")

    @verify.setter
    def verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the exact chart version to install. If this is not specified, the latest version is installed.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="waitForJobs")
    def wait_for_jobs(self) -> Optional[pulumi.Input[bool]]:
        """
        Will wait until all Jobs have been completed before marking the release as successful. This is ignored if `skipAwait` is enabled.
        """
        return pulumi.get(self, "wait_for_jobs")

    @wait_for_jobs.setter
    def wait_for_jobs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_jobs", value)


if not MYPY:
    class RepositoryOptsArgsDict(TypedDict):
        """
        Specification defining the Helm chart repository to use.
        """
        ca_file: NotRequired[pulumi.Input[str]]
        """
        The Repository's CA File
        """
        cert_file: NotRequired[pulumi.Input[str]]
        """
        The repository's cert file
        """
        key_file: NotRequired[pulumi.Input[str]]
        """
        The repository's cert key file
        """
        password: NotRequired[pulumi.Input[str]]
        """
        Password for HTTP basic authentication
        """
        repo: NotRequired[pulumi.Input[str]]
        """
        Repository where to locate the requested chart. If is a URL the chart is installed without installing the repository.
        """
        username: NotRequired[pulumi.Input[str]]
        """
        Username for HTTP basic authentication
        """
elif False:
    RepositoryOptsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryOptsArgs:
    def __init__(__self__, *,
                 ca_file: Optional[pulumi.Input[str]] = None,
                 cert_file: Optional[pulumi.Input[str]] = None,
                 key_file: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 repo: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Specification defining the Helm chart repository to use.
        :param pulumi.Input[str] ca_file: The Repository's CA File
        :param pulumi.Input[str] cert_file: The repository's cert file
        :param pulumi.Input[str] key_file: The repository's cert key file
        :param pulumi.Input[str] password: Password for HTTP basic authentication
        :param pulumi.Input[str] repo: Repository where to locate the requested chart. If is a URL the chart is installed without installing the repository.
        :param pulumi.Input[str] username: Username for HTTP basic authentication
        """
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[pulumi.Input[str]]:
        """
        The Repository's CA File
        """
        return pulumi.get(self, "ca_file")

    @ca_file.setter
    def ca_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_file", value)

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[pulumi.Input[str]]:
        """
        The repository's cert file
        """
        return pulumi.get(self, "cert_file")

    @cert_file.setter
    def cert_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_file", value)

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[pulumi.Input[str]]:
        """
        The repository's cert key file
        """
        return pulumi.get(self, "key_file")

    @key_file.setter
    def key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_file", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for HTTP basic authentication
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def repo(self) -> Optional[pulumi.Input[str]]:
        """
        Repository where to locate the requested chart. If is a URL the chart is installed without installing the repository.
        """
        return pulumi.get(self, "repo")

    @repo.setter
    def repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username for HTTP basic authentication
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


