from setuptools import setup

def readme():
    with open('README.md') as f:
        README = f.read()
    return README


setup(
    name="yengde",
    version="1.0",
    description="A Python package to get number table.",
    long_description=readme(),
    long_description_content_type="text/markdown",
   
    author="Shubham Yengde",
    author_email="shubhamyengde@gmail.com",
    license="MIT",
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
    ],
    packages=["yengde"],
    include_package_data=True,
    install_requires=["requests"],
    entry_points={
        "console_scripts": [
            "yengde=yengde.cli:main",
        ]
    },
)