# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiSnapshotPolicy(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'hourly_snapshots': 'int',
        'daily_snapshots': 'int',
        'weekly_snapshots': 'int',
        'monthly_snapshots': 'int',
        'yearly_snapshots': 'int',
        'minute_of_hour': 'int',
        'hours_for_hourly_snapshots': 'list[int]',
        'hour_of_day': 'int',
        'day_of_week': 'int',
        'day_of_month': 'int',
        'month_of_year': 'int',
        'alert_on_start': 'bool',
        'alert_on_success': 'bool',
        'alert_on_fail': 'bool',
        'alert_on_abort': 'bool',
        'hbase_arguments': 'ApiHBaseSnapshotPolicyArguments',
        'hdfs_arguments': 'ApiHdfsSnapshotPolicyArguments',
        'last_command': 'ApiSnapshotCommand',
        'last_successful_command': 'ApiSnapshotCommand',
        'paused': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'hourly_snapshots': 'hourlySnapshots',
        'daily_snapshots': 'dailySnapshots',
        'weekly_snapshots': 'weeklySnapshots',
        'monthly_snapshots': 'monthlySnapshots',
        'yearly_snapshots': 'yearlySnapshots',
        'minute_of_hour': 'minuteOfHour',
        'hours_for_hourly_snapshots': 'hoursForHourlySnapshots',
        'hour_of_day': 'hourOfDay',
        'day_of_week': 'dayOfWeek',
        'day_of_month': 'dayOfMonth',
        'month_of_year': 'monthOfYear',
        'alert_on_start': 'alertOnStart',
        'alert_on_success': 'alertOnSuccess',
        'alert_on_fail': 'alertOnFail',
        'alert_on_abort': 'alertOnAbort',
        'hbase_arguments': 'hbaseArguments',
        'hdfs_arguments': 'hdfsArguments',
        'last_command': 'lastCommand',
        'last_successful_command': 'lastSuccessfulCommand',
        'paused': 'paused'
    }

    def __init__(self, name=None, description=None, hourly_snapshots=None, daily_snapshots=None, weekly_snapshots=None, monthly_snapshots=None, yearly_snapshots=None, minute_of_hour=None, hours_for_hourly_snapshots=None, hour_of_day=None, day_of_week=None, day_of_month=None, month_of_year=None, alert_on_start=None, alert_on_success=None, alert_on_fail=None, alert_on_abort=None, hbase_arguments=None, hdfs_arguments=None, last_command=None, last_successful_command=None, paused=None):
        """
        ApiSnapshotPolicy - a model defined in Swagger
        """

        self._name = None
        self._description = None
        self._hourly_snapshots = None
        self._daily_snapshots = None
        self._weekly_snapshots = None
        self._monthly_snapshots = None
        self._yearly_snapshots = None
        self._minute_of_hour = None
        self._hours_for_hourly_snapshots = None
        self._hour_of_day = None
        self._day_of_week = None
        self._day_of_month = None
        self._month_of_year = None
        self._alert_on_start = None
        self._alert_on_success = None
        self._alert_on_fail = None
        self._alert_on_abort = None
        self._hbase_arguments = None
        self._hdfs_arguments = None
        self._last_command = None
        self._last_successful_command = None
        self._paused = None

        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if hourly_snapshots is not None:
          self.hourly_snapshots = hourly_snapshots
        if daily_snapshots is not None:
          self.daily_snapshots = daily_snapshots
        if weekly_snapshots is not None:
          self.weekly_snapshots = weekly_snapshots
        if monthly_snapshots is not None:
          self.monthly_snapshots = monthly_snapshots
        if yearly_snapshots is not None:
          self.yearly_snapshots = yearly_snapshots
        if minute_of_hour is not None:
          self.minute_of_hour = minute_of_hour
        if hours_for_hourly_snapshots is not None:
          self.hours_for_hourly_snapshots = hours_for_hourly_snapshots
        if hour_of_day is not None:
          self.hour_of_day = hour_of_day
        if day_of_week is not None:
          self.day_of_week = day_of_week
        if day_of_month is not None:
          self.day_of_month = day_of_month
        if month_of_year is not None:
          self.month_of_year = month_of_year
        if alert_on_start is not None:
          self.alert_on_start = alert_on_start
        if alert_on_success is not None:
          self.alert_on_success = alert_on_success
        if alert_on_fail is not None:
          self.alert_on_fail = alert_on_fail
        if alert_on_abort is not None:
          self.alert_on_abort = alert_on_abort
        if hbase_arguments is not None:
          self.hbase_arguments = hbase_arguments
        if hdfs_arguments is not None:
          self.hdfs_arguments = hdfs_arguments
        if last_command is not None:
          self.last_command = last_command
        if last_successful_command is not None:
          self.last_successful_command = last_successful_command
        if paused is not None:
          self.paused = paused

    @property
    def name(self):
        """
        Gets the name of this ApiSnapshotPolicy.
        Name of the snapshot policy.

        :return: The name of this ApiSnapshotPolicy.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiSnapshotPolicy.
        Name of the snapshot policy.

        :param name: The name of this ApiSnapshotPolicy.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ApiSnapshotPolicy.
        Description of the snapshot policy.

        :return: The description of this ApiSnapshotPolicy.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ApiSnapshotPolicy.
        Description of the snapshot policy.

        :param description: The description of this ApiSnapshotPolicy.
        :type: str
        """

        self._description = description

    @property
    def hourly_snapshots(self):
        """
        Gets the hourly_snapshots of this ApiSnapshotPolicy.
        Number of hourly snapshots to be retained. Defaults to 0

        :return: The hourly_snapshots of this ApiSnapshotPolicy.
        :rtype: int
        """
        return self._hourly_snapshots

    @hourly_snapshots.setter
    def hourly_snapshots(self, hourly_snapshots):
        """
        Sets the hourly_snapshots of this ApiSnapshotPolicy.
        Number of hourly snapshots to be retained. Defaults to 0

        :param hourly_snapshots: The hourly_snapshots of this ApiSnapshotPolicy.
        :type: int
        """

        self._hourly_snapshots = hourly_snapshots

    @property
    def daily_snapshots(self):
        """
        Gets the daily_snapshots of this ApiSnapshotPolicy.
        Number of daily snapshots to be retained. Defaults to 0

        :return: The daily_snapshots of this ApiSnapshotPolicy.
        :rtype: int
        """
        return self._daily_snapshots

    @daily_snapshots.setter
    def daily_snapshots(self, daily_snapshots):
        """
        Sets the daily_snapshots of this ApiSnapshotPolicy.
        Number of daily snapshots to be retained. Defaults to 0

        :param daily_snapshots: The daily_snapshots of this ApiSnapshotPolicy.
        :type: int
        """

        self._daily_snapshots = daily_snapshots

    @property
    def weekly_snapshots(self):
        """
        Gets the weekly_snapshots of this ApiSnapshotPolicy.
        Number of weekly snapshots to be retained. Defaults to 0

        :return: The weekly_snapshots of this ApiSnapshotPolicy.
        :rtype: int
        """
        return self._weekly_snapshots

    @weekly_snapshots.setter
    def weekly_snapshots(self, weekly_snapshots):
        """
        Sets the weekly_snapshots of this ApiSnapshotPolicy.
        Number of weekly snapshots to be retained. Defaults to 0

        :param weekly_snapshots: The weekly_snapshots of this ApiSnapshotPolicy.
        :type: int
        """

        self._weekly_snapshots = weekly_snapshots

    @property
    def monthly_snapshots(self):
        """
        Gets the monthly_snapshots of this ApiSnapshotPolicy.
        Number of monthly snapshots to be retained. Defaults to 0

        :return: The monthly_snapshots of this ApiSnapshotPolicy.
        :rtype: int
        """
        return self._monthly_snapshots

    @monthly_snapshots.setter
    def monthly_snapshots(self, monthly_snapshots):
        """
        Sets the monthly_snapshots of this ApiSnapshotPolicy.
        Number of monthly snapshots to be retained. Defaults to 0

        :param monthly_snapshots: The monthly_snapshots of this ApiSnapshotPolicy.
        :type: int
        """

        self._monthly_snapshots = monthly_snapshots

    @property
    def yearly_snapshots(self):
        """
        Gets the yearly_snapshots of this ApiSnapshotPolicy.
        Number of yearly snapshots to be retained. Defaults to 0

        :return: The yearly_snapshots of this ApiSnapshotPolicy.
        :rtype: int
        """
        return self._yearly_snapshots

    @yearly_snapshots.setter
    def yearly_snapshots(self, yearly_snapshots):
        """
        Sets the yearly_snapshots of this ApiSnapshotPolicy.
        Number of yearly snapshots to be retained. Defaults to 0

        :param yearly_snapshots: The yearly_snapshots of this ApiSnapshotPolicy.
        :type: int
        """

        self._yearly_snapshots = yearly_snapshots

    @property
    def minute_of_hour(self):
        """
        Gets the minute_of_hour of this ApiSnapshotPolicy.
        Minute in the hour that hourly, daily, weekly, monthly and yearly snapshots should be created. Valid values are 0 to 59. Default value is 0.

        :return: The minute_of_hour of this ApiSnapshotPolicy.
        :rtype: int
        """
        return self._minute_of_hour

    @minute_of_hour.setter
    def minute_of_hour(self, minute_of_hour):
        """
        Sets the minute_of_hour of this ApiSnapshotPolicy.
        Minute in the hour that hourly, daily, weekly, monthly and yearly snapshots should be created. Valid values are 0 to 59. Default value is 0.

        :param minute_of_hour: The minute_of_hour of this ApiSnapshotPolicy.
        :type: int
        """

        self._minute_of_hour = minute_of_hour

    @property
    def hours_for_hourly_snapshots(self):
        """
        Gets the hours_for_hourly_snapshots of this ApiSnapshotPolicy.
        Hours of the day that hourly snapshots should be created. Valid values are 0 to 23. If this list is null or empty, then hourly snapshots are created for every hour.

        :return: The hours_for_hourly_snapshots of this ApiSnapshotPolicy.
        :rtype: list[int]
        """
        return self._hours_for_hourly_snapshots

    @hours_for_hourly_snapshots.setter
    def hours_for_hourly_snapshots(self, hours_for_hourly_snapshots):
        """
        Sets the hours_for_hourly_snapshots of this ApiSnapshotPolicy.
        Hours of the day that hourly snapshots should be created. Valid values are 0 to 23. If this list is null or empty, then hourly snapshots are created for every hour.

        :param hours_for_hourly_snapshots: The hours_for_hourly_snapshots of this ApiSnapshotPolicy.
        :type: list[int]
        """

        self._hours_for_hourly_snapshots = hours_for_hourly_snapshots

    @property
    def hour_of_day(self):
        """
        Gets the hour_of_day of this ApiSnapshotPolicy.
        Hour in the day that daily, weekly, monthly and yearly snapshots should be created. Valid values are 0 to 23. Default value is 0.

        :return: The hour_of_day of this ApiSnapshotPolicy.
        :rtype: int
        """
        return self._hour_of_day

    @hour_of_day.setter
    def hour_of_day(self, hour_of_day):
        """
        Sets the hour_of_day of this ApiSnapshotPolicy.
        Hour in the day that daily, weekly, monthly and yearly snapshots should be created. Valid values are 0 to 23. Default value is 0.

        :param hour_of_day: The hour_of_day of this ApiSnapshotPolicy.
        :type: int
        """

        self._hour_of_day = hour_of_day

    @property
    def day_of_week(self):
        """
        Gets the day_of_week of this ApiSnapshotPolicy.
        Day of the week that weekly snapshots should be created. Valid values are 1 to 7, 1 representing Sunday. Default value is 1.

        :return: The day_of_week of this ApiSnapshotPolicy.
        :rtype: int
        """
        return self._day_of_week

    @day_of_week.setter
    def day_of_week(self, day_of_week):
        """
        Sets the day_of_week of this ApiSnapshotPolicy.
        Day of the week that weekly snapshots should be created. Valid values are 1 to 7, 1 representing Sunday. Default value is 1.

        :param day_of_week: The day_of_week of this ApiSnapshotPolicy.
        :type: int
        """

        self._day_of_week = day_of_week

    @property
    def day_of_month(self):
        """
        Gets the day_of_month of this ApiSnapshotPolicy.
        Day of the month that monthly and yearly snapshots should be created. Values from 1 to 31 are allowed. Additionally 0 to -30 can be used to specify offsets from the last day of the month. Default value is 1. <p/> If this value is invalid for any month for which snapshots are required, the backend will throw an exception.

        :return: The day_of_month of this ApiSnapshotPolicy.
        :rtype: int
        """
        return self._day_of_month

    @day_of_month.setter
    def day_of_month(self, day_of_month):
        """
        Sets the day_of_month of this ApiSnapshotPolicy.
        Day of the month that monthly and yearly snapshots should be created. Values from 1 to 31 are allowed. Additionally 0 to -30 can be used to specify offsets from the last day of the month. Default value is 1. <p/> If this value is invalid for any month for which snapshots are required, the backend will throw an exception.

        :param day_of_month: The day_of_month of this ApiSnapshotPolicy.
        :type: int
        """

        self._day_of_month = day_of_month

    @property
    def month_of_year(self):
        """
        Gets the month_of_year of this ApiSnapshotPolicy.
        Month of the year that yearly snapshots should be created. Valid values are 1 to 12, 1 representing January. Default value is 1.

        :return: The month_of_year of this ApiSnapshotPolicy.
        :rtype: int
        """
        return self._month_of_year

    @month_of_year.setter
    def month_of_year(self, month_of_year):
        """
        Sets the month_of_year of this ApiSnapshotPolicy.
        Month of the year that yearly snapshots should be created. Valid values are 1 to 12, 1 representing January. Default value is 1.

        :param month_of_year: The month_of_year of this ApiSnapshotPolicy.
        :type: int
        """

        self._month_of_year = month_of_year

    @property
    def alert_on_start(self):
        """
        Gets the alert_on_start of this ApiSnapshotPolicy.
        Whether to alert on start of snapshot creation/deletion activity. Defaults to false

        :return: The alert_on_start of this ApiSnapshotPolicy.
        :rtype: bool
        """
        return self._alert_on_start

    @alert_on_start.setter
    def alert_on_start(self, alert_on_start):
        """
        Sets the alert_on_start of this ApiSnapshotPolicy.
        Whether to alert on start of snapshot creation/deletion activity. Defaults to false

        :param alert_on_start: The alert_on_start of this ApiSnapshotPolicy.
        :type: bool
        """

        self._alert_on_start = alert_on_start

    @property
    def alert_on_success(self):
        """
        Gets the alert_on_success of this ApiSnapshotPolicy.
        Whether to alert on successful completion of snapshot creation/deletion activity. Defaults to false.

        :return: The alert_on_success of this ApiSnapshotPolicy.
        :rtype: bool
        """
        return self._alert_on_success

    @alert_on_success.setter
    def alert_on_success(self, alert_on_success):
        """
        Sets the alert_on_success of this ApiSnapshotPolicy.
        Whether to alert on successful completion of snapshot creation/deletion activity. Defaults to false.

        :param alert_on_success: The alert_on_success of this ApiSnapshotPolicy.
        :type: bool
        """

        self._alert_on_success = alert_on_success

    @property
    def alert_on_fail(self):
        """
        Gets the alert_on_fail of this ApiSnapshotPolicy.
        Whether to alert on failure of snapshot creation/deletion activity. Defaults to false.

        :return: The alert_on_fail of this ApiSnapshotPolicy.
        :rtype: bool
        """
        return self._alert_on_fail

    @alert_on_fail.setter
    def alert_on_fail(self, alert_on_fail):
        """
        Sets the alert_on_fail of this ApiSnapshotPolicy.
        Whether to alert on failure of snapshot creation/deletion activity. Defaults to false.

        :param alert_on_fail: The alert_on_fail of this ApiSnapshotPolicy.
        :type: bool
        """

        self._alert_on_fail = alert_on_fail

    @property
    def alert_on_abort(self):
        """
        Gets the alert_on_abort of this ApiSnapshotPolicy.
        Whether to alert on abort of snapshot creation/deletion activity. Defaults to false.

        :return: The alert_on_abort of this ApiSnapshotPolicy.
        :rtype: bool
        """
        return self._alert_on_abort

    @alert_on_abort.setter
    def alert_on_abort(self, alert_on_abort):
        """
        Sets the alert_on_abort of this ApiSnapshotPolicy.
        Whether to alert on abort of snapshot creation/deletion activity. Defaults to false.

        :param alert_on_abort: The alert_on_abort of this ApiSnapshotPolicy.
        :type: bool
        """

        self._alert_on_abort = alert_on_abort

    @property
    def hbase_arguments(self):
        """
        Gets the hbase_arguments of this ApiSnapshotPolicy.
        Arguments specific to HBase snapshot policies.

        :return: The hbase_arguments of this ApiSnapshotPolicy.
        :rtype: ApiHBaseSnapshotPolicyArguments
        """
        return self._hbase_arguments

    @hbase_arguments.setter
    def hbase_arguments(self, hbase_arguments):
        """
        Sets the hbase_arguments of this ApiSnapshotPolicy.
        Arguments specific to HBase snapshot policies.

        :param hbase_arguments: The hbase_arguments of this ApiSnapshotPolicy.
        :type: ApiHBaseSnapshotPolicyArguments
        """

        self._hbase_arguments = hbase_arguments

    @property
    def hdfs_arguments(self):
        """
        Gets the hdfs_arguments of this ApiSnapshotPolicy.
        Arguments specific to Hdfs snapshot policies.

        :return: The hdfs_arguments of this ApiSnapshotPolicy.
        :rtype: ApiHdfsSnapshotPolicyArguments
        """
        return self._hdfs_arguments

    @hdfs_arguments.setter
    def hdfs_arguments(self, hdfs_arguments):
        """
        Sets the hdfs_arguments of this ApiSnapshotPolicy.
        Arguments specific to Hdfs snapshot policies.

        :param hdfs_arguments: The hdfs_arguments of this ApiSnapshotPolicy.
        :type: ApiHdfsSnapshotPolicyArguments
        """

        self._hdfs_arguments = hdfs_arguments

    @property
    def last_command(self):
        """
        Gets the last_command of this ApiSnapshotPolicy.
        Latest command of this policy. The command might still be active.

        :return: The last_command of this ApiSnapshotPolicy.
        :rtype: ApiSnapshotCommand
        """
        return self._last_command

    @last_command.setter
    def last_command(self, last_command):
        """
        Sets the last_command of this ApiSnapshotPolicy.
        Latest command of this policy. The command might still be active.

        :param last_command: The last_command of this ApiSnapshotPolicy.
        :type: ApiSnapshotCommand
        """

        self._last_command = last_command

    @property
    def last_successful_command(self):
        """
        Gets the last_successful_command of this ApiSnapshotPolicy.
        Last successful command of this policy. Returns null if there has been no successful command.

        :return: The last_successful_command of this ApiSnapshotPolicy.
        :rtype: ApiSnapshotCommand
        """
        return self._last_successful_command

    @last_successful_command.setter
    def last_successful_command(self, last_successful_command):
        """
        Sets the last_successful_command of this ApiSnapshotPolicy.
        Last successful command of this policy. Returns null if there has been no successful command.

        :param last_successful_command: The last_successful_command of this ApiSnapshotPolicy.
        :type: ApiSnapshotCommand
        """

        self._last_successful_command = last_successful_command

    @property
    def paused(self):
        """
        Gets the paused of this ApiSnapshotPolicy.
        Whether to pause a snapshot policy, available since V11.

        :return: The paused of this ApiSnapshotPolicy.
        :rtype: bool
        """
        return self._paused

    @paused.setter
    def paused(self, paused):
        """
        Sets the paused of this ApiSnapshotPolicy.
        Whether to pause a snapshot policy, available since V11.

        :param paused: The paused of this ApiSnapshotPolicy.
        :type: bool
        """

        self._paused = paused

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiSnapshotPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
