# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiServiceRef(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'peer_name': 'str',
        'cluster_name': 'str',
        'service_name': 'str',
        'service_display_name': 'str',
        'service_type': 'str'
    }

    attribute_map = {
        'peer_name': 'peerName',
        'cluster_name': 'clusterName',
        'service_name': 'serviceName',
        'service_display_name': 'serviceDisplayName',
        'service_type': 'serviceType'
    }

    def __init__(self, peer_name=None, cluster_name=None, service_name=None, service_display_name=None, service_type=None):
        """
        ApiServiceRef - a model defined in Swagger
        """

        self._peer_name = None
        self._cluster_name = None
        self._service_name = None
        self._service_display_name = None
        self._service_type = None

        if peer_name is not None:
          self.peer_name = peer_name
        if cluster_name is not None:
          self.cluster_name = cluster_name
        if service_name is not None:
          self.service_name = service_name
        if service_display_name is not None:
          self.service_display_name = service_display_name
        if service_type is not None:
          self.service_type = service_type

    @property
    def peer_name(self):
        """
        Gets the peer_name of this ApiServiceRef.
        The name of the CM peer corresponding to the remote CM that manages the referenced service. This should only be set when referencing a remote service.

        :return: The peer_name of this ApiServiceRef.
        :rtype: str
        """
        return self._peer_name

    @peer_name.setter
    def peer_name(self, peer_name):
        """
        Sets the peer_name of this ApiServiceRef.
        The name of the CM peer corresponding to the remote CM that manages the referenced service. This should only be set when referencing a remote service.

        :param peer_name: The peer_name of this ApiServiceRef.
        :type: str
        """

        self._peer_name = peer_name

    @property
    def cluster_name(self):
        """
        Gets the cluster_name of this ApiServiceRef.
        The enclosing cluster for this service.

        :return: The cluster_name of this ApiServiceRef.
        :rtype: str
        """
        return self._cluster_name

    @cluster_name.setter
    def cluster_name(self, cluster_name):
        """
        Sets the cluster_name of this ApiServiceRef.
        The enclosing cluster for this service.

        :param cluster_name: The cluster_name of this ApiServiceRef.
        :type: str
        """

        self._cluster_name = cluster_name

    @property
    def service_name(self):
        """
        Gets the service_name of this ApiServiceRef.
        The service name.

        :return: The service_name of this ApiServiceRef.
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """
        Sets the service_name of this ApiServiceRef.
        The service name.

        :param service_name: The service_name of this ApiServiceRef.
        :type: str
        """

        self._service_name = service_name

    @property
    def service_display_name(self):
        """
        Gets the service_display_name of this ApiServiceRef.
        

        :return: The service_display_name of this ApiServiceRef.
        :rtype: str
        """
        return self._service_display_name

    @service_display_name.setter
    def service_display_name(self, service_display_name):
        """
        Sets the service_display_name of this ApiServiceRef.
        

        :param service_display_name: The service_display_name of this ApiServiceRef.
        :type: str
        """

        self._service_display_name = service_display_name

    @property
    def service_type(self):
        """
        Gets the service_type of this ApiServiceRef.
        The service type. This is available since version 32

        :return: The service_type of this ApiServiceRef.
        :rtype: str
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type):
        """
        Sets the service_type of this ApiServiceRef.
        The service type. This is available since version 32

        :param service_type: The service_type of this ApiServiceRef.
        :type: str
        """

        self._service_type = service_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiServiceRef):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
