# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiService(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'type': 'str',
        'cluster_ref': 'ApiClusterRef',
        'service_state': 'ApiServiceState',
        'health_summary': 'ApiHealthSummary',
        'config_stale': 'bool',
        'config_staleness_status': 'ApiConfigStalenessStatus',
        'client_config_staleness_status': 'ApiConfigStalenessStatus',
        'health_checks': 'list[ApiHealthCheck]',
        'service_url': 'str',
        'role_instances_url': 'str',
        'maintenance_mode': 'bool',
        'maintenance_owners': 'list[ApiEntityType]',
        'config': 'ApiServiceConfig',
        'roles': 'list[ApiRole]',
        'display_name': 'str',
        'role_config_groups': 'list[ApiRoleConfigGroup]',
        'replication_schedules': 'list[ApiReplicationSchedule]',
        'snapshot_policies': 'list[ApiSnapshotPolicy]',
        'entity_status': 'ApiEntityStatus',
        'tags': 'list[ApiEntityTag]',
        'service_version': 'str'
    }

    attribute_map = {
        'name': 'name',
        'type': 'type',
        'cluster_ref': 'clusterRef',
        'service_state': 'serviceState',
        'health_summary': 'healthSummary',
        'config_stale': 'configStale',
        'config_staleness_status': 'configStalenessStatus',
        'client_config_staleness_status': 'clientConfigStalenessStatus',
        'health_checks': 'healthChecks',
        'service_url': 'serviceUrl',
        'role_instances_url': 'roleInstancesUrl',
        'maintenance_mode': 'maintenanceMode',
        'maintenance_owners': 'maintenanceOwners',
        'config': 'config',
        'roles': 'roles',
        'display_name': 'displayName',
        'role_config_groups': 'roleConfigGroups',
        'replication_schedules': 'replicationSchedules',
        'snapshot_policies': 'snapshotPolicies',
        'entity_status': 'entityStatus',
        'tags': 'tags',
        'service_version': 'serviceVersion'
    }

    def __init__(self, name=None, type=None, cluster_ref=None, service_state=None, health_summary=None, config_stale=None, config_staleness_status=None, client_config_staleness_status=None, health_checks=None, service_url=None, role_instances_url=None, maintenance_mode=None, maintenance_owners=None, config=None, roles=None, display_name=None, role_config_groups=None, replication_schedules=None, snapshot_policies=None, entity_status=None, tags=None, service_version=None):
        """
        ApiService - a model defined in Swagger
        """

        self._name = None
        self._type = None
        self._cluster_ref = None
        self._service_state = None
        self._health_summary = None
        self._config_stale = None
        self._config_staleness_status = None
        self._client_config_staleness_status = None
        self._health_checks = None
        self._service_url = None
        self._role_instances_url = None
        self._maintenance_mode = None
        self._maintenance_owners = None
        self._config = None
        self._roles = None
        self._display_name = None
        self._role_config_groups = None
        self._replication_schedules = None
        self._snapshot_policies = None
        self._entity_status = None
        self._tags = None
        self._service_version = None

        if name is not None:
          self.name = name
        if type is not None:
          self.type = type
        if cluster_ref is not None:
          self.cluster_ref = cluster_ref
        if service_state is not None:
          self.service_state = service_state
        if health_summary is not None:
          self.health_summary = health_summary
        if config_stale is not None:
          self.config_stale = config_stale
        if config_staleness_status is not None:
          self.config_staleness_status = config_staleness_status
        if client_config_staleness_status is not None:
          self.client_config_staleness_status = client_config_staleness_status
        if health_checks is not None:
          self.health_checks = health_checks
        if service_url is not None:
          self.service_url = service_url
        if role_instances_url is not None:
          self.role_instances_url = role_instances_url
        if maintenance_mode is not None:
          self.maintenance_mode = maintenance_mode
        if maintenance_owners is not None:
          self.maintenance_owners = maintenance_owners
        if config is not None:
          self.config = config
        if roles is not None:
          self.roles = roles
        if display_name is not None:
          self.display_name = display_name
        if role_config_groups is not None:
          self.role_config_groups = role_config_groups
        if replication_schedules is not None:
          self.replication_schedules = replication_schedules
        if snapshot_policies is not None:
          self.snapshot_policies = snapshot_policies
        if entity_status is not None:
          self.entity_status = entity_status
        if tags is not None:
          self.tags = tags
        if service_version is not None:
          self.service_version = service_version

    @property
    def name(self):
        """
        Gets the name of this ApiService.
        The name of the service.

        :return: The name of this ApiService.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiService.
        The name of the service.

        :param name: The name of this ApiService.
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """
        Gets the type of this ApiService.
        The type of the service, e.g. HDFS, MAPREDUCE, HBASE.

        :return: The type of this ApiService.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ApiService.
        The type of the service, e.g. HDFS, MAPREDUCE, HBASE.

        :param type: The type of this ApiService.
        :type: str
        """

        self._type = type

    @property
    def cluster_ref(self):
        """
        Gets the cluster_ref of this ApiService.
        Readonly. A reference to the enclosing cluster.

        :return: The cluster_ref of this ApiService.
        :rtype: ApiClusterRef
        """
        return self._cluster_ref

    @cluster_ref.setter
    def cluster_ref(self, cluster_ref):
        """
        Sets the cluster_ref of this ApiService.
        Readonly. A reference to the enclosing cluster.

        :param cluster_ref: The cluster_ref of this ApiService.
        :type: ApiClusterRef
        """

        self._cluster_ref = cluster_ref

    @property
    def service_state(self):
        """
        Gets the service_state of this ApiService.
        Readonly. The configured run state of this service. Whether it's running, etc.

        :return: The service_state of this ApiService.
        :rtype: ApiServiceState
        """
        return self._service_state

    @service_state.setter
    def service_state(self, service_state):
        """
        Sets the service_state of this ApiService.
        Readonly. The configured run state of this service. Whether it's running, etc.

        :param service_state: The service_state of this ApiService.
        :type: ApiServiceState
        """

        self._service_state = service_state

    @property
    def health_summary(self):
        """
        Gets the health_summary of this ApiService.
        Readonly. The high-level health status of this service.

        :return: The health_summary of this ApiService.
        :rtype: ApiHealthSummary
        """
        return self._health_summary

    @health_summary.setter
    def health_summary(self, health_summary):
        """
        Sets the health_summary of this ApiService.
        Readonly. The high-level health status of this service.

        :param health_summary: The health_summary of this ApiService.
        :type: ApiHealthSummary
        """

        self._health_summary = health_summary

    @property
    def config_stale(self):
        """
        Gets the config_stale of this ApiService.
        Readonly. Expresses whether the service configuration is stale.

        :return: The config_stale of this ApiService.
        :rtype: bool
        """
        return self._config_stale

    @config_stale.setter
    def config_stale(self, config_stale):
        """
        Sets the config_stale of this ApiService.
        Readonly. Expresses whether the service configuration is stale.

        :param config_stale: The config_stale of this ApiService.
        :type: bool
        """

        self._config_stale = config_stale

    @property
    def config_staleness_status(self):
        """
        Gets the config_staleness_status of this ApiService.
        Readonly. Expresses the service's configuration staleness status which is based on the staleness status of its roles. Available since API v6.

        :return: The config_staleness_status of this ApiService.
        :rtype: ApiConfigStalenessStatus
        """
        return self._config_staleness_status

    @config_staleness_status.setter
    def config_staleness_status(self, config_staleness_status):
        """
        Sets the config_staleness_status of this ApiService.
        Readonly. Expresses the service's configuration staleness status which is based on the staleness status of its roles. Available since API v6.

        :param config_staleness_status: The config_staleness_status of this ApiService.
        :type: ApiConfigStalenessStatus
        """

        self._config_staleness_status = config_staleness_status

    @property
    def client_config_staleness_status(self):
        """
        Gets the client_config_staleness_status of this ApiService.
        Readonly. Expresses the service's client configuration staleness status which is marked as stale if any of the service's hosts have missing client configurations or if any of the deployed client configurations are stale. Available since API v6.

        :return: The client_config_staleness_status of this ApiService.
        :rtype: ApiConfigStalenessStatus
        """
        return self._client_config_staleness_status

    @client_config_staleness_status.setter
    def client_config_staleness_status(self, client_config_staleness_status):
        """
        Sets the client_config_staleness_status of this ApiService.
        Readonly. Expresses the service's client configuration staleness status which is marked as stale if any of the service's hosts have missing client configurations or if any of the deployed client configurations are stale. Available since API v6.

        :param client_config_staleness_status: The client_config_staleness_status of this ApiService.
        :type: ApiConfigStalenessStatus
        """

        self._client_config_staleness_status = client_config_staleness_status

    @property
    def health_checks(self):
        """
        Gets the health_checks of this ApiService.
        Readonly. The list of health checks of this service.

        :return: The health_checks of this ApiService.
        :rtype: list[ApiHealthCheck]
        """
        return self._health_checks

    @health_checks.setter
    def health_checks(self, health_checks):
        """
        Sets the health_checks of this ApiService.
        Readonly. The list of health checks of this service.

        :param health_checks: The health_checks of this ApiService.
        :type: list[ApiHealthCheck]
        """

        self._health_checks = health_checks

    @property
    def service_url(self):
        """
        Gets the service_url of this ApiService.
        Readonly. Link into the Cloudera Manager web UI for this specific service.

        :return: The service_url of this ApiService.
        :rtype: str
        """
        return self._service_url

    @service_url.setter
    def service_url(self, service_url):
        """
        Sets the service_url of this ApiService.
        Readonly. Link into the Cloudera Manager web UI for this specific service.

        :param service_url: The service_url of this ApiService.
        :type: str
        """

        self._service_url = service_url

    @property
    def role_instances_url(self):
        """
        Gets the role_instances_url of this ApiService.
        Readonly. Link into the Cloudera Manager web UI for role instances table for this specific service. Available since API v11.

        :return: The role_instances_url of this ApiService.
        :rtype: str
        """
        return self._role_instances_url

    @role_instances_url.setter
    def role_instances_url(self, role_instances_url):
        """
        Sets the role_instances_url of this ApiService.
        Readonly. Link into the Cloudera Manager web UI for role instances table for this specific service. Available since API v11.

        :param role_instances_url: The role_instances_url of this ApiService.
        :type: str
        """

        self._role_instances_url = role_instances_url

    @property
    def maintenance_mode(self):
        """
        Gets the maintenance_mode of this ApiService.
        Readonly. Whether the service is in maintenance mode. Available since API v2.

        :return: The maintenance_mode of this ApiService.
        :rtype: bool
        """
        return self._maintenance_mode

    @maintenance_mode.setter
    def maintenance_mode(self, maintenance_mode):
        """
        Sets the maintenance_mode of this ApiService.
        Readonly. Whether the service is in maintenance mode. Available since API v2.

        :param maintenance_mode: The maintenance_mode of this ApiService.
        :type: bool
        """

        self._maintenance_mode = maintenance_mode

    @property
    def maintenance_owners(self):
        """
        Gets the maintenance_owners of this ApiService.
        Readonly. The list of objects that trigger this service to be in maintenance mode. Available since API v2.

        :return: The maintenance_owners of this ApiService.
        :rtype: list[ApiEntityType]
        """
        return self._maintenance_owners

    @maintenance_owners.setter
    def maintenance_owners(self, maintenance_owners):
        """
        Sets the maintenance_owners of this ApiService.
        Readonly. The list of objects that trigger this service to be in maintenance mode. Available since API v2.

        :param maintenance_owners: The maintenance_owners of this ApiService.
        :type: list[ApiEntityType]
        """

        self._maintenance_owners = maintenance_owners

    @property
    def config(self):
        """
        Gets the config of this ApiService.
        Configuration of the service being created. Optional.

        :return: The config of this ApiService.
        :rtype: ApiServiceConfig
        """
        return self._config

    @config.setter
    def config(self, config):
        """
        Sets the config of this ApiService.
        Configuration of the service being created. Optional.

        :param config: The config of this ApiService.
        :type: ApiServiceConfig
        """

        self._config = config

    @property
    def roles(self):
        """
        Gets the roles of this ApiService.
        The list of service roles. Optional.

        :return: The roles of this ApiService.
        :rtype: list[ApiRole]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """
        Sets the roles of this ApiService.
        The list of service roles. Optional.

        :param roles: The roles of this ApiService.
        :type: list[ApiRole]
        """

        self._roles = roles

    @property
    def display_name(self):
        """
        Gets the display_name of this ApiService.
        The display name for the service that is shown in the UI. Available since API v2.

        :return: The display_name of this ApiService.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApiService.
        The display name for the service that is shown in the UI. Available since API v2.

        :param display_name: The display_name of this ApiService.
        :type: str
        """

        self._display_name = display_name

    @property
    def role_config_groups(self):
        """
        Gets the role_config_groups of this ApiService.
        The list of role configuration groups in this service. Optional. Available since API v3.

        :return: The role_config_groups of this ApiService.
        :rtype: list[ApiRoleConfigGroup]
        """
        return self._role_config_groups

    @role_config_groups.setter
    def role_config_groups(self, role_config_groups):
        """
        Sets the role_config_groups of this ApiService.
        The list of role configuration groups in this service. Optional. Available since API v3.

        :param role_config_groups: The role_config_groups of this ApiService.
        :type: list[ApiRoleConfigGroup]
        """

        self._role_config_groups = role_config_groups

    @property
    def replication_schedules(self):
        """
        Gets the replication_schedules of this ApiService.
        The list of replication schedules for this service. Optional. Available since API v6.

        :return: The replication_schedules of this ApiService.
        :rtype: list[ApiReplicationSchedule]
        """
        return self._replication_schedules

    @replication_schedules.setter
    def replication_schedules(self, replication_schedules):
        """
        Sets the replication_schedules of this ApiService.
        The list of replication schedules for this service. Optional. Available since API v6.

        :param replication_schedules: The replication_schedules of this ApiService.
        :type: list[ApiReplicationSchedule]
        """

        self._replication_schedules = replication_schedules

    @property
    def snapshot_policies(self):
        """
        Gets the snapshot_policies of this ApiService.
        The list of snapshot policies for this service. Optional. Available since API v6.

        :return: The snapshot_policies of this ApiService.
        :rtype: list[ApiSnapshotPolicy]
        """
        return self._snapshot_policies

    @snapshot_policies.setter
    def snapshot_policies(self, snapshot_policies):
        """
        Sets the snapshot_policies of this ApiService.
        The list of snapshot policies for this service. Optional. Available since API v6.

        :param snapshot_policies: The snapshot_policies of this ApiService.
        :type: list[ApiSnapshotPolicy]
        """

        self._snapshot_policies = snapshot_policies

    @property
    def entity_status(self):
        """
        Gets the entity_status of this ApiService.
        Readonly. The entity status for this service. Available since API v11.

        :return: The entity_status of this ApiService.
        :rtype: ApiEntityStatus
        """
        return self._entity_status

    @entity_status.setter
    def entity_status(self, entity_status):
        """
        Sets the entity_status of this ApiService.
        Readonly. The entity status for this service. Available since API v11.

        :param entity_status: The entity_status of this ApiService.
        :type: ApiEntityStatus
        """

        self._entity_status = entity_status

    @property
    def tags(self):
        """
        Gets the tags of this ApiService.
        Tags associated with the service. Available since V41.

        :return: The tags of this ApiService.
        :rtype: list[ApiEntityTag]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ApiService.
        Tags associated with the service. Available since V41.

        :param tags: The tags of this ApiService.
        :type: list[ApiEntityTag]
        """

        self._tags = tags

    @property
    def service_version(self):
        """
        Gets the service_version of this ApiService.
        Service version (optional) Available since V41.

        :return: The service_version of this ApiService.
        :rtype: str
        """
        return self._service_version

    @service_version.setter
    def service_version(self, service_version):
        """
        Sets the service_version of this ApiService.
        Service version (optional) Available since V41.

        :param service_version: The service_version of this ApiService.
        :type: str
        """

        self._service_version = service_version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiService):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
