# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiRollingRestartClusterArgs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'slave_batch_size': 'int',
        'sleep_seconds': 'int',
        'slave_fail_count_threshold': 'int',
        'stale_configs_only': 'bool',
        'un_upgraded_only': 'bool',
        'redeploy_client_configuration': 'bool',
        'roles_to_include': 'ApiRolesToInclude',
        'restart_service_names': 'list[str]'
    }

    attribute_map = {
        'slave_batch_size': 'slaveBatchSize',
        'sleep_seconds': 'sleepSeconds',
        'slave_fail_count_threshold': 'slaveFailCountThreshold',
        'stale_configs_only': 'staleConfigsOnly',
        'un_upgraded_only': 'unUpgradedOnly',
        'redeploy_client_configuration': 'redeployClientConfiguration',
        'roles_to_include': 'rolesToInclude',
        'restart_service_names': 'restartServiceNames'
    }

    def __init__(self, slave_batch_size=None, sleep_seconds=None, slave_fail_count_threshold=None, stale_configs_only=None, un_upgraded_only=None, redeploy_client_configuration=None, roles_to_include=None, restart_service_names=None):
        """
        ApiRollingRestartClusterArgs - a model defined in Swagger
        """

        self._slave_batch_size = None
        self._sleep_seconds = None
        self._slave_fail_count_threshold = None
        self._stale_configs_only = None
        self._un_upgraded_only = None
        self._redeploy_client_configuration = None
        self._roles_to_include = None
        self._restart_service_names = None

        if slave_batch_size is not None:
          self.slave_batch_size = slave_batch_size
        if sleep_seconds is not None:
          self.sleep_seconds = sleep_seconds
        if slave_fail_count_threshold is not None:
          self.slave_fail_count_threshold = slave_fail_count_threshold
        if stale_configs_only is not None:
          self.stale_configs_only = stale_configs_only
        if un_upgraded_only is not None:
          self.un_upgraded_only = un_upgraded_only
        if redeploy_client_configuration is not None:
          self.redeploy_client_configuration = redeploy_client_configuration
        if roles_to_include is not None:
          self.roles_to_include = roles_to_include
        if restart_service_names is not None:
          self.restart_service_names = restart_service_names

    @property
    def slave_batch_size(self):
        """
        Gets the slave_batch_size of this ApiRollingRestartClusterArgs.
        Number of hosts with slave roles to restart at a time. Must be greater than zero. Default is 1.

        :return: The slave_batch_size of this ApiRollingRestartClusterArgs.
        :rtype: int
        """
        return self._slave_batch_size

    @slave_batch_size.setter
    def slave_batch_size(self, slave_batch_size):
        """
        Sets the slave_batch_size of this ApiRollingRestartClusterArgs.
        Number of hosts with slave roles to restart at a time. Must be greater than zero. Default is 1.

        :param slave_batch_size: The slave_batch_size of this ApiRollingRestartClusterArgs.
        :type: int
        """

        self._slave_batch_size = slave_batch_size

    @property
    def sleep_seconds(self):
        """
        Gets the sleep_seconds of this ApiRollingRestartClusterArgs.
        Number of seconds to sleep between restarts of slave host batches. <p> Must be greater than or equal to 0. Default is 0.

        :return: The sleep_seconds of this ApiRollingRestartClusterArgs.
        :rtype: int
        """
        return self._sleep_seconds

    @sleep_seconds.setter
    def sleep_seconds(self, sleep_seconds):
        """
        Sets the sleep_seconds of this ApiRollingRestartClusterArgs.
        Number of seconds to sleep between restarts of slave host batches. <p> Must be greater than or equal to 0. Default is 0.

        :param sleep_seconds: The sleep_seconds of this ApiRollingRestartClusterArgs.
        :type: int
        """

        self._sleep_seconds = sleep_seconds

    @property
    def slave_fail_count_threshold(self):
        """
        Gets the slave_fail_count_threshold of this ApiRollingRestartClusterArgs.
        The threshold for number of slave host batches that are allowed to fail to restart before the entire command is considered failed. <p> Must be greater than or equal to 0. Default is 0. <p> This argument is for ADVANCED users only. </p>

        :return: The slave_fail_count_threshold of this ApiRollingRestartClusterArgs.
        :rtype: int
        """
        return self._slave_fail_count_threshold

    @slave_fail_count_threshold.setter
    def slave_fail_count_threshold(self, slave_fail_count_threshold):
        """
        Sets the slave_fail_count_threshold of this ApiRollingRestartClusterArgs.
        The threshold for number of slave host batches that are allowed to fail to restart before the entire command is considered failed. <p> Must be greater than or equal to 0. Default is 0. <p> This argument is for ADVANCED users only. </p>

        :param slave_fail_count_threshold: The slave_fail_count_threshold of this ApiRollingRestartClusterArgs.
        :type: int
        """

        self._slave_fail_count_threshold = slave_fail_count_threshold

    @property
    def stale_configs_only(self):
        """
        Gets the stale_configs_only of this ApiRollingRestartClusterArgs.
        Restart roles with stale configs only.

        :return: The stale_configs_only of this ApiRollingRestartClusterArgs.
        :rtype: bool
        """
        return self._stale_configs_only

    @stale_configs_only.setter
    def stale_configs_only(self, stale_configs_only):
        """
        Sets the stale_configs_only of this ApiRollingRestartClusterArgs.
        Restart roles with stale configs only.

        :param stale_configs_only: The stale_configs_only of this ApiRollingRestartClusterArgs.
        :type: bool
        """

        self._stale_configs_only = stale_configs_only

    @property
    def un_upgraded_only(self):
        """
        Gets the un_upgraded_only of this ApiRollingRestartClusterArgs.
        Restart roles that haven't been upgraded yet.

        :return: The un_upgraded_only of this ApiRollingRestartClusterArgs.
        :rtype: bool
        """
        return self._un_upgraded_only

    @un_upgraded_only.setter
    def un_upgraded_only(self, un_upgraded_only):
        """
        Sets the un_upgraded_only of this ApiRollingRestartClusterArgs.
        Restart roles that haven't been upgraded yet.

        :param un_upgraded_only: The un_upgraded_only of this ApiRollingRestartClusterArgs.
        :type: bool
        """

        self._un_upgraded_only = un_upgraded_only

    @property
    def redeploy_client_configuration(self):
        """
        Gets the redeploy_client_configuration of this ApiRollingRestartClusterArgs.
        Re-deploy client configuration. Available since API v6.

        :return: The redeploy_client_configuration of this ApiRollingRestartClusterArgs.
        :rtype: bool
        """
        return self._redeploy_client_configuration

    @redeploy_client_configuration.setter
    def redeploy_client_configuration(self, redeploy_client_configuration):
        """
        Sets the redeploy_client_configuration of this ApiRollingRestartClusterArgs.
        Re-deploy client configuration. Available since API v6.

        :param redeploy_client_configuration: The redeploy_client_configuration of this ApiRollingRestartClusterArgs.
        :type: bool
        """

        self._redeploy_client_configuration = redeploy_client_configuration

    @property
    def roles_to_include(self):
        """
        Gets the roles_to_include of this ApiRollingRestartClusterArgs.
        Role types to restart. Default is slave roles only.

        :return: The roles_to_include of this ApiRollingRestartClusterArgs.
        :rtype: ApiRolesToInclude
        """
        return self._roles_to_include

    @roles_to_include.setter
    def roles_to_include(self, roles_to_include):
        """
        Sets the roles_to_include of this ApiRollingRestartClusterArgs.
        Role types to restart. Default is slave roles only.

        :param roles_to_include: The roles_to_include of this ApiRollingRestartClusterArgs.
        :type: ApiRolesToInclude
        """

        self._roles_to_include = roles_to_include

    @property
    def restart_service_names(self):
        """
        Gets the restart_service_names of this ApiRollingRestartClusterArgs.
        List of services to restart.

        :return: The restart_service_names of this ApiRollingRestartClusterArgs.
        :rtype: list[str]
        """
        return self._restart_service_names

    @restart_service_names.setter
    def restart_service_names(self, restart_service_names):
        """
        Sets the restart_service_names of this ApiRollingRestartClusterArgs.
        List of services to restart.

        :param restart_service_names: The restart_service_names of this ApiRollingRestartClusterArgs.
        :type: list[str]
        """

        self._restart_service_names = restart_service_names

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiRollingRestartClusterArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
