# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiInstallEmbeddedControlPlaneArgs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'remote_repo_url': 'str',
        'values_yaml': 'str',
        'experience_cluster_name': 'str',
        'datalake_cluster_name': 'str'
    }

    attribute_map = {
        'remote_repo_url': 'remoteRepoUrl',
        'values_yaml': 'valuesYaml',
        'experience_cluster_name': 'experienceClusterName',
        'datalake_cluster_name': 'datalakeClusterName'
    }

    def __init__(self, remote_repo_url=None, values_yaml=None, experience_cluster_name=None, datalake_cluster_name=None):
        """
        ApiInstallEmbeddedControlPlaneArgs - a model defined in Swagger
        """

        self._remote_repo_url = None
        self._values_yaml = None
        self._experience_cluster_name = None
        self._datalake_cluster_name = None

        if remote_repo_url is not None:
          self.remote_repo_url = remote_repo_url
        if values_yaml is not None:
          self.values_yaml = values_yaml
        if experience_cluster_name is not None:
          self.experience_cluster_name = experience_cluster_name
        if datalake_cluster_name is not None:
          self.datalake_cluster_name = datalake_cluster_name

    @property
    def remote_repo_url(self):
        """
        Gets the remote_repo_url of this ApiInstallEmbeddedControlPlaneArgs.
        The url of the remote repository where the private cloud artifacts to install are hosted

        :return: The remote_repo_url of this ApiInstallEmbeddedControlPlaneArgs.
        :rtype: str
        """
        return self._remote_repo_url

    @remote_repo_url.setter
    def remote_repo_url(self, remote_repo_url):
        """
        Sets the remote_repo_url of this ApiInstallEmbeddedControlPlaneArgs.
        The url of the remote repository where the private cloud artifacts to install are hosted

        :param remote_repo_url: The remote_repo_url of this ApiInstallEmbeddedControlPlaneArgs.
        :type: str
        """

        self._remote_repo_url = remote_repo_url

    @property
    def values_yaml(self):
        """
        Gets the values_yaml of this ApiInstallEmbeddedControlPlaneArgs.
        A yaml file containing configuration parameters for the installation.

        :return: The values_yaml of this ApiInstallEmbeddedControlPlaneArgs.
        :rtype: str
        """
        return self._values_yaml

    @values_yaml.setter
    def values_yaml(self, values_yaml):
        """
        Sets the values_yaml of this ApiInstallEmbeddedControlPlaneArgs.
        A yaml file containing configuration parameters for the installation.

        :param values_yaml: The values_yaml of this ApiInstallEmbeddedControlPlaneArgs.
        :type: str
        """

        self._values_yaml = values_yaml

    @property
    def experience_cluster_name(self):
        """
        Gets the experience_cluster_name of this ApiInstallEmbeddedControlPlaneArgs.
        The name of the Experience cluster that will bring up this control plane

        :return: The experience_cluster_name of this ApiInstallEmbeddedControlPlaneArgs.
        :rtype: str
        """
        return self._experience_cluster_name

    @experience_cluster_name.setter
    def experience_cluster_name(self, experience_cluster_name):
        """
        Sets the experience_cluster_name of this ApiInstallEmbeddedControlPlaneArgs.
        The name of the Experience cluster that will bring up this control plane

        :param experience_cluster_name: The experience_cluster_name of this ApiInstallEmbeddedControlPlaneArgs.
        :type: str
        """

        self._experience_cluster_name = experience_cluster_name

    @property
    def datalake_cluster_name(self):
        """
        Gets the datalake_cluster_name of this ApiInstallEmbeddedControlPlaneArgs.
        The name of the datalake cluster to use for the initial environment in this control plane

        :return: The datalake_cluster_name of this ApiInstallEmbeddedControlPlaneArgs.
        :rtype: str
        """
        return self._datalake_cluster_name

    @datalake_cluster_name.setter
    def datalake_cluster_name(self, datalake_cluster_name):
        """
        Sets the datalake_cluster_name of this ApiInstallEmbeddedControlPlaneArgs.
        The name of the datalake cluster to use for the initial environment in this control plane

        :param datalake_cluster_name: The datalake_cluster_name of this ApiInstallEmbeddedControlPlaneArgs.
        :type: str
        """

        self._datalake_cluster_name = datalake_cluster_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiInstallEmbeddedControlPlaneArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
