# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHdfsUsageReportRow(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'date': 'str',
        'user': 'str',
        'size': 'int',
        'raw_size': 'int',
        'num_files': 'int'
    }

    attribute_map = {
        'date': 'date',
        'user': 'user',
        'size': 'size',
        'raw_size': 'rawSize',
        'num_files': 'numFiles'
    }

    def __init__(self, date=None, user=None, size=None, raw_size=None, num_files=None):
        """
        ApiHdfsUsageReportRow - a model defined in Swagger
        """

        self._date = None
        self._user = None
        self._size = None
        self._raw_size = None
        self._num_files = None

        if date is not None:
          self.date = date
        if user is not None:
          self.user = user
        if size is not None:
          self.size = size
        if raw_size is not None:
          self.raw_size = raw_size
        if num_files is not None:
          self.num_files = num_files

    @property
    def date(self):
        """
        Gets the date of this ApiHdfsUsageReportRow.
        The date of the report row data.

        :return: The date of this ApiHdfsUsageReportRow.
        :rtype: str
        """
        return self._date

    @date.setter
    def date(self, date):
        """
        Sets the date of this ApiHdfsUsageReportRow.
        The date of the report row data.

        :param date: The date of this ApiHdfsUsageReportRow.
        :type: str
        """

        self._date = date

    @property
    def user(self):
        """
        Gets the user of this ApiHdfsUsageReportRow.
        The user being reported.

        :return: The user of this ApiHdfsUsageReportRow.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this ApiHdfsUsageReportRow.
        The user being reported.

        :param user: The user of this ApiHdfsUsageReportRow.
        :type: str
        """

        self._user = user

    @property
    def size(self):
        """
        Gets the size of this ApiHdfsUsageReportRow.
        Total size (in bytes) of the files owned by this user. This does not include replication in HDFS.

        :return: The size of this ApiHdfsUsageReportRow.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """
        Sets the size of this ApiHdfsUsageReportRow.
        Total size (in bytes) of the files owned by this user. This does not include replication in HDFS.

        :param size: The size of this ApiHdfsUsageReportRow.
        :type: int
        """

        self._size = size

    @property
    def raw_size(self):
        """
        Gets the raw_size of this ApiHdfsUsageReportRow.
        Total size (in bytes) of all the replicas of all the files owned by this user.

        :return: The raw_size of this ApiHdfsUsageReportRow.
        :rtype: int
        """
        return self._raw_size

    @raw_size.setter
    def raw_size(self, raw_size):
        """
        Sets the raw_size of this ApiHdfsUsageReportRow.
        Total size (in bytes) of all the replicas of all the files owned by this user.

        :param raw_size: The raw_size of this ApiHdfsUsageReportRow.
        :type: int
        """

        self._raw_size = raw_size

    @property
    def num_files(self):
        """
        Gets the num_files of this ApiHdfsUsageReportRow.
        Number of files owned by this user.

        :return: The num_files of this ApiHdfsUsageReportRow.
        :rtype: int
        """
        return self._num_files

    @num_files.setter
    def num_files(self, num_files):
        """
        Sets the num_files of this ApiHdfsUsageReportRow.
        Number of files owned by this user.

        :param num_files: The num_files of this ApiHdfsUsageReportRow.
        :type: int
        """

        self._num_files = num_files

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHdfsUsageReportRow):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
