# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiExternalUserMapping(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'type': 'ApiExternalUserMappingType',
        'uuid': 'str',
        'auth_roles': 'list[ApiAuthRoleRef]'
    }

    attribute_map = {
        'name': 'name',
        'type': 'type',
        'uuid': 'uuid',
        'auth_roles': 'authRoles'
    }

    def __init__(self, name=None, type=None, uuid=None, auth_roles=None):
        """
        ApiExternalUserMapping - a model defined in Swagger
        """

        self._name = None
        self._type = None
        self._uuid = None
        self._auth_roles = None

        if name is not None:
          self.name = name
        if type is not None:
          self.type = type
        if uuid is not None:
          self.uuid = uuid
        if auth_roles is not None:
          self.auth_roles = auth_roles

    @property
    def name(self):
        """
        Gets the name of this ApiExternalUserMapping.
        The name of the external mapping

        :return: The name of this ApiExternalUserMapping.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiExternalUserMapping.
        The name of the external mapping

        :param name: The name of this ApiExternalUserMapping.
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """
        Gets the type of this ApiExternalUserMapping.
        The type of the external mapping

        :return: The type of this ApiExternalUserMapping.
        :rtype: ApiExternalUserMappingType
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ApiExternalUserMapping.
        The type of the external mapping

        :param type: The type of this ApiExternalUserMapping.
        :type: ApiExternalUserMappingType
        """

        self._type = type

    @property
    def uuid(self):
        """
        Gets the uuid of this ApiExternalUserMapping.
        Readonly. The UUID of the authRole. <p>

        :return: The uuid of this ApiExternalUserMapping.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """
        Sets the uuid of this ApiExternalUserMapping.
        Readonly. The UUID of the authRole. <p>

        :param uuid: The uuid of this ApiExternalUserMapping.
        :type: str
        """

        self._uuid = uuid

    @property
    def auth_roles(self):
        """
        Gets the auth_roles of this ApiExternalUserMapping.
        A list of ApiAuthRole that this user possesses.  Each custom role with be a built-in role with a set of scopes. ApiAuthRole is the model for specifying custom roles. Only admins and user admins can create/delete/update external user mappings.

        :return: The auth_roles of this ApiExternalUserMapping.
        :rtype: list[ApiAuthRoleRef]
        """
        return self._auth_roles

    @auth_roles.setter
    def auth_roles(self, auth_roles):
        """
        Sets the auth_roles of this ApiExternalUserMapping.
        A list of ApiAuthRole that this user possesses.  Each custom role with be a built-in role with a set of scopes. ApiAuthRole is the model for specifying custom roles. Only admins and user admins can create/delete/update external user mappings.

        :param auth_roles: The auth_roles of this ApiExternalUserMapping.
        :type: list[ApiAuthRoleRef]
        """

        self._auth_roles = auth_roles

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiExternalUserMapping):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
