# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiEndPoint(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'version': 'str',
        'service_configs': 'list[ApiMapEntry]',
        'end_point_host_list': 'list[ApiEndPointHost]',
        'service_type': 'str'
    }

    attribute_map = {
        'name': 'name',
        'version': 'version',
        'service_configs': 'serviceConfigs',
        'end_point_host_list': 'endPointHostList',
        'service_type': 'serviceType'
    }

    def __init__(self, name=None, version=None, service_configs=None, end_point_host_list=None, service_type=None):
        """
        ApiEndPoint - a model defined in Swagger
        """

        self._name = None
        self._version = None
        self._service_configs = None
        self._end_point_host_list = None
        self._service_type = None

        if name is not None:
          self.name = name
        if version is not None:
          self.version = version
        if service_configs is not None:
          self.service_configs = service_configs
        if end_point_host_list is not None:
          self.end_point_host_list = end_point_host_list
        if service_type is not None:
          self.service_type = service_type

    @property
    def name(self):
        """
        Gets the name of this ApiEndPoint.
        Name for the endPoint.

        :return: The name of this ApiEndPoint.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiEndPoint.
        Name for the endPoint.

        :param name: The name of this ApiEndPoint.
        :type: str
        """

        self._name = name

    @property
    def version(self):
        """
        Gets the version of this ApiEndPoint.
        Endpoint specific version.

        :return: The version of this ApiEndPoint.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ApiEndPoint.
        Endpoint specific version.

        :param version: The version of this ApiEndPoint.
        :type: str
        """

        self._version = version

    @property
    def service_configs(self):
        """
        Gets the service_configs of this ApiEndPoint.
        Additional configs for the endPoint.

        :return: The service_configs of this ApiEndPoint.
        :rtype: list[ApiMapEntry]
        """
        return self._service_configs

    @service_configs.setter
    def service_configs(self, service_configs):
        """
        Sets the service_configs of this ApiEndPoint.
        Additional configs for the endPoint.

        :param service_configs: The service_configs of this ApiEndPoint.
        :type: list[ApiMapEntry]
        """

        self._service_configs = service_configs

    @property
    def end_point_host_list(self):
        """
        Gets the end_point_host_list of this ApiEndPoint.
        List hosts (uris) for this endPoint.

        :return: The end_point_host_list of this ApiEndPoint.
        :rtype: list[ApiEndPointHost]
        """
        return self._end_point_host_list

    @end_point_host_list.setter
    def end_point_host_list(self, end_point_host_list):
        """
        Sets the end_point_host_list of this ApiEndPoint.
        List hosts (uris) for this endPoint.

        :param end_point_host_list: The end_point_host_list of this ApiEndPoint.
        :type: list[ApiEndPointHost]
        """

        self._end_point_host_list = end_point_host_list

    @property
    def service_type(self):
        """
        Gets the service_type of this ApiEndPoint.
        Endpoint service type.

        :return: The service_type of this ApiEndPoint.
        :rtype: str
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type):
        """
        Sets the service_type of this ApiEndPoint.
        Endpoint service type.

        :param service_type: The service_type of this ApiEndPoint.
        :type: str
        """

        self._service_type = service_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiEndPoint):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
