# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiControlPlane(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'namespace': 'str',
        'dns_suffix': 'str',
        'uuid': 'str',
        'remote_repo_url': 'str',
        'version': 'str',
        'manifest': 'str',
        'values_yaml': 'str',
        'kubernetes_type': 'str'
    }

    attribute_map = {
        'namespace': 'namespace',
        'dns_suffix': 'dnsSuffix',
        'uuid': 'uuid',
        'remote_repo_url': 'remoteRepoUrl',
        'version': 'version',
        'manifest': 'manifest',
        'values_yaml': 'valuesYaml',
        'kubernetes_type': 'kubernetesType'
    }

    def __init__(self, namespace=None, dns_suffix=None, uuid=None, remote_repo_url=None, version=None, manifest=None, values_yaml=None, kubernetes_type=None):
        """
        ApiControlPlane - a model defined in Swagger
        """

        self._namespace = None
        self._dns_suffix = None
        self._uuid = None
        self._remote_repo_url = None
        self._version = None
        self._manifest = None
        self._values_yaml = None
        self._kubernetes_type = None

        if namespace is not None:
          self.namespace = namespace
        if dns_suffix is not None:
          self.dns_suffix = dns_suffix
        if uuid is not None:
          self.uuid = uuid
        if remote_repo_url is not None:
          self.remote_repo_url = remote_repo_url
        if version is not None:
          self.version = version
        if manifest is not None:
          self.manifest = manifest
        if values_yaml is not None:
          self.values_yaml = values_yaml
        if kubernetes_type is not None:
          self.kubernetes_type = kubernetes_type

    @property
    def namespace(self):
        """
        Gets the namespace of this ApiControlPlane.
        The namespace where the control plane is installed. Append the domain to the namespace to get the url of the control plane.

        :return: The namespace of this ApiControlPlane.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this ApiControlPlane.
        The namespace where the control plane is installed. Append the domain to the namespace to get the url of the control plane.

        :param namespace: The namespace of this ApiControlPlane.
        :type: str
        """

        self._namespace = namespace

    @property
    def dns_suffix(self):
        """
        Gets the dns_suffix of this ApiControlPlane.
        The domain where the control plane is installed. Append the domain to the namespace to get the url of the control plane.

        :return: The dns_suffix of this ApiControlPlane.
        :rtype: str
        """
        return self._dns_suffix

    @dns_suffix.setter
    def dns_suffix(self, dns_suffix):
        """
        Sets the dns_suffix of this ApiControlPlane.
        The domain where the control plane is installed. Append the domain to the namespace to get the url of the control plane.

        :param dns_suffix: The dns_suffix of this ApiControlPlane.
        :type: str
        """

        self._dns_suffix = dns_suffix

    @property
    def uuid(self):
        """
        Gets the uuid of this ApiControlPlane.
        The universally unique ID of this control plane in Cloudera Manager

        :return: The uuid of this ApiControlPlane.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """
        Sets the uuid of this ApiControlPlane.
        The universally unique ID of this control plane in Cloudera Manager

        :param uuid: The uuid of this ApiControlPlane.
        :type: str
        """

        self._uuid = uuid

    @property
    def remote_repo_url(self):
        """
        Gets the remote_repo_url of this ApiControlPlane.
        The url of the remote repository where the artifacts used to install the control plane are hosted

        :return: The remote_repo_url of this ApiControlPlane.
        :rtype: str
        """
        return self._remote_repo_url

    @remote_repo_url.setter
    def remote_repo_url(self, remote_repo_url):
        """
        Sets the remote_repo_url of this ApiControlPlane.
        The url of the remote repository where the artifacts used to install the control plane are hosted

        :param remote_repo_url: The remote_repo_url of this ApiControlPlane.
        :type: str
        """

        self._remote_repo_url = remote_repo_url

    @property
    def version(self):
        """
        Gets the version of this ApiControlPlane.
        The CDP version of the control plane

        :return: The version of this ApiControlPlane.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ApiControlPlane.
        The CDP version of the control plane

        :param version: The version of this ApiControlPlane.
        :type: str
        """

        self._version = version

    @property
    def manifest(self):
        """
        Gets the manifest of this ApiControlPlane.
        The content of the manifest.json of the control plane

        :return: The manifest of this ApiControlPlane.
        :rtype: str
        """
        return self._manifest

    @manifest.setter
    def manifest(self, manifest):
        """
        Sets the manifest of this ApiControlPlane.
        The content of the manifest.json of the control plane

        :param manifest: The manifest of this ApiControlPlane.
        :type: str
        """

        self._manifest = manifest

    @property
    def values_yaml(self):
        """
        Gets the values_yaml of this ApiControlPlane.
        The content of the values.yaml used to configure the control plane

        :return: The values_yaml of this ApiControlPlane.
        :rtype: str
        """
        return self._values_yaml

    @values_yaml.setter
    def values_yaml(self, values_yaml):
        """
        Sets the values_yaml of this ApiControlPlane.
        The content of the values.yaml used to configure the control plane

        :param values_yaml: The values_yaml of this ApiControlPlane.
        :type: str
        """

        self._values_yaml = values_yaml

    @property
    def kubernetes_type(self):
        """
        Gets the kubernetes_type of this ApiControlPlane.
        The kubernetes type on which the control plane is running

        :return: The kubernetes_type of this ApiControlPlane.
        :rtype: str
        """
        return self._kubernetes_type

    @kubernetes_type.setter
    def kubernetes_type(self, kubernetes_type):
        """
        Sets the kubernetes_type of this ApiControlPlane.
        The kubernetes type on which the control plane is running

        :param kubernetes_type: The kubernetes_type of this ApiControlPlane.
        :type: str
        """

        self._kubernetes_type = kubernetes_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiControlPlane):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
