# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v44</h1>       <p>Introduced in Cloudera Manager 7.4.3</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiClusterUtilization(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'total_cpu_cores': 'float',
        'avg_cpu_utilization': 'float',
        'max_cpu_utilization': 'float',
        'avg_cpu_daily_peak': 'float',
        'avg_workload_cpu': 'float',
        'max_workload_cpu': 'float',
        'avg_workload_cpu_daily_peak': 'float',
        'total_memory': 'float',
        'avg_memory_utilization': 'float',
        'max_memory_utilization': 'float',
        'avg_memory_daily_peak': 'float',
        'avg_workload_memory': 'float',
        'max_workload_memory': 'float',
        'avg_workload_memory_daily_peak': 'float',
        'tenant_utilizations': 'ApiTenantUtilizationList',
        'max_cpu_utilization_timestamp_ms': 'int',
        'max_memory_utilization_timestamp_ms': 'int',
        'max_workload_cpu_timestamp_ms': 'int',
        'max_workload_memory_timestamp_ms': 'int',
        'error_message': 'str'
    }

    attribute_map = {
        'total_cpu_cores': 'totalCpuCores',
        'avg_cpu_utilization': 'avgCpuUtilization',
        'max_cpu_utilization': 'maxCpuUtilization',
        'avg_cpu_daily_peak': 'avgCpuDailyPeak',
        'avg_workload_cpu': 'avgWorkloadCpu',
        'max_workload_cpu': 'maxWorkloadCpu',
        'avg_workload_cpu_daily_peak': 'avgWorkloadCpuDailyPeak',
        'total_memory': 'totalMemory',
        'avg_memory_utilization': 'avgMemoryUtilization',
        'max_memory_utilization': 'maxMemoryUtilization',
        'avg_memory_daily_peak': 'avgMemoryDailyPeak',
        'avg_workload_memory': 'avgWorkloadMemory',
        'max_workload_memory': 'maxWorkloadMemory',
        'avg_workload_memory_daily_peak': 'avgWorkloadMemoryDailyPeak',
        'tenant_utilizations': 'tenantUtilizations',
        'max_cpu_utilization_timestamp_ms': 'maxCpuUtilizationTimestampMs',
        'max_memory_utilization_timestamp_ms': 'maxMemoryUtilizationTimestampMs',
        'max_workload_cpu_timestamp_ms': 'maxWorkloadCpuTimestampMs',
        'max_workload_memory_timestamp_ms': 'maxWorkloadMemoryTimestampMs',
        'error_message': 'errorMessage'
    }

    def __init__(self, total_cpu_cores=None, avg_cpu_utilization=None, max_cpu_utilization=None, avg_cpu_daily_peak=None, avg_workload_cpu=None, max_workload_cpu=None, avg_workload_cpu_daily_peak=None, total_memory=None, avg_memory_utilization=None, max_memory_utilization=None, avg_memory_daily_peak=None, avg_workload_memory=None, max_workload_memory=None, avg_workload_memory_daily_peak=None, tenant_utilizations=None, max_cpu_utilization_timestamp_ms=None, max_memory_utilization_timestamp_ms=None, max_workload_cpu_timestamp_ms=None, max_workload_memory_timestamp_ms=None, error_message=None):
        """
        ApiClusterUtilization - a model defined in Swagger
        """

        self._total_cpu_cores = None
        self._avg_cpu_utilization = None
        self._max_cpu_utilization = None
        self._avg_cpu_daily_peak = None
        self._avg_workload_cpu = None
        self._max_workload_cpu = None
        self._avg_workload_cpu_daily_peak = None
        self._total_memory = None
        self._avg_memory_utilization = None
        self._max_memory_utilization = None
        self._avg_memory_daily_peak = None
        self._avg_workload_memory = None
        self._max_workload_memory = None
        self._avg_workload_memory_daily_peak = None
        self._tenant_utilizations = None
        self._max_cpu_utilization_timestamp_ms = None
        self._max_memory_utilization_timestamp_ms = None
        self._max_workload_cpu_timestamp_ms = None
        self._max_workload_memory_timestamp_ms = None
        self._error_message = None

        if total_cpu_cores is not None:
          self.total_cpu_cores = total_cpu_cores
        if avg_cpu_utilization is not None:
          self.avg_cpu_utilization = avg_cpu_utilization
        if max_cpu_utilization is not None:
          self.max_cpu_utilization = max_cpu_utilization
        if avg_cpu_daily_peak is not None:
          self.avg_cpu_daily_peak = avg_cpu_daily_peak
        if avg_workload_cpu is not None:
          self.avg_workload_cpu = avg_workload_cpu
        if max_workload_cpu is not None:
          self.max_workload_cpu = max_workload_cpu
        if avg_workload_cpu_daily_peak is not None:
          self.avg_workload_cpu_daily_peak = avg_workload_cpu_daily_peak
        if total_memory is not None:
          self.total_memory = total_memory
        if avg_memory_utilization is not None:
          self.avg_memory_utilization = avg_memory_utilization
        if max_memory_utilization is not None:
          self.max_memory_utilization = max_memory_utilization
        if avg_memory_daily_peak is not None:
          self.avg_memory_daily_peak = avg_memory_daily_peak
        if avg_workload_memory is not None:
          self.avg_workload_memory = avg_workload_memory
        if max_workload_memory is not None:
          self.max_workload_memory = max_workload_memory
        if avg_workload_memory_daily_peak is not None:
          self.avg_workload_memory_daily_peak = avg_workload_memory_daily_peak
        if tenant_utilizations is not None:
          self.tenant_utilizations = tenant_utilizations
        if max_cpu_utilization_timestamp_ms is not None:
          self.max_cpu_utilization_timestamp_ms = max_cpu_utilization_timestamp_ms
        if max_memory_utilization_timestamp_ms is not None:
          self.max_memory_utilization_timestamp_ms = max_memory_utilization_timestamp_ms
        if max_workload_cpu_timestamp_ms is not None:
          self.max_workload_cpu_timestamp_ms = max_workload_cpu_timestamp_ms
        if max_workload_memory_timestamp_ms is not None:
          self.max_workload_memory_timestamp_ms = max_workload_memory_timestamp_ms
        if error_message is not None:
          self.error_message = error_message

    @property
    def total_cpu_cores(self):
        """
        Gets the total_cpu_cores of this ApiClusterUtilization.
        Average number of CPU cores available in the cluster during the report window.

        :return: The total_cpu_cores of this ApiClusterUtilization.
        :rtype: float
        """
        return self._total_cpu_cores

    @total_cpu_cores.setter
    def total_cpu_cores(self, total_cpu_cores):
        """
        Sets the total_cpu_cores of this ApiClusterUtilization.
        Average number of CPU cores available in the cluster during the report window.

        :param total_cpu_cores: The total_cpu_cores of this ApiClusterUtilization.
        :type: float
        """

        self._total_cpu_cores = total_cpu_cores

    @property
    def avg_cpu_utilization(self):
        """
        Gets the avg_cpu_utilization of this ApiClusterUtilization.
        Average CPU consumption for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :return: The avg_cpu_utilization of this ApiClusterUtilization.
        :rtype: float
        """
        return self._avg_cpu_utilization

    @avg_cpu_utilization.setter
    def avg_cpu_utilization(self, avg_cpu_utilization):
        """
        Sets the avg_cpu_utilization of this ApiClusterUtilization.
        Average CPU consumption for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :param avg_cpu_utilization: The avg_cpu_utilization of this ApiClusterUtilization.
        :type: float
        """

        self._avg_cpu_utilization = avg_cpu_utilization

    @property
    def max_cpu_utilization(self):
        """
        Gets the max_cpu_utilization of this ApiClusterUtilization.
        Maximum CPU consumption for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :return: The max_cpu_utilization of this ApiClusterUtilization.
        :rtype: float
        """
        return self._max_cpu_utilization

    @max_cpu_utilization.setter
    def max_cpu_utilization(self, max_cpu_utilization):
        """
        Sets the max_cpu_utilization of this ApiClusterUtilization.
        Maximum CPU consumption for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :param max_cpu_utilization: The max_cpu_utilization of this ApiClusterUtilization.
        :type: float
        """

        self._max_cpu_utilization = max_cpu_utilization

    @property
    def avg_cpu_daily_peak(self):
        """
        Gets the avg_cpu_daily_peak of this ApiClusterUtilization.
        Average daily peak CPU consumption for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :return: The avg_cpu_daily_peak of this ApiClusterUtilization.
        :rtype: float
        """
        return self._avg_cpu_daily_peak

    @avg_cpu_daily_peak.setter
    def avg_cpu_daily_peak(self, avg_cpu_daily_peak):
        """
        Sets the avg_cpu_daily_peak of this ApiClusterUtilization.
        Average daily peak CPU consumption for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :param avg_cpu_daily_peak: The avg_cpu_daily_peak of this ApiClusterUtilization.
        :type: float
        """

        self._avg_cpu_daily_peak = avg_cpu_daily_peak

    @property
    def avg_workload_cpu(self):
        """
        Gets the avg_workload_cpu of this ApiClusterUtilization.
        Average CPU consumption by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.

        :return: The avg_workload_cpu of this ApiClusterUtilization.
        :rtype: float
        """
        return self._avg_workload_cpu

    @avg_workload_cpu.setter
    def avg_workload_cpu(self, avg_workload_cpu):
        """
        Sets the avg_workload_cpu of this ApiClusterUtilization.
        Average CPU consumption by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.

        :param avg_workload_cpu: The avg_workload_cpu of this ApiClusterUtilization.
        :type: float
        """

        self._avg_workload_cpu = avg_workload_cpu

    @property
    def max_workload_cpu(self):
        """
        Gets the max_workload_cpu of this ApiClusterUtilization.
        Maximum CPU consumption by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.

        :return: The max_workload_cpu of this ApiClusterUtilization.
        :rtype: float
        """
        return self._max_workload_cpu

    @max_workload_cpu.setter
    def max_workload_cpu(self, max_workload_cpu):
        """
        Sets the max_workload_cpu of this ApiClusterUtilization.
        Maximum CPU consumption by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.

        :param max_workload_cpu: The max_workload_cpu of this ApiClusterUtilization.
        :type: float
        """

        self._max_workload_cpu = max_workload_cpu

    @property
    def avg_workload_cpu_daily_peak(self):
        """
        Gets the avg_workload_cpu_daily_peak of this ApiClusterUtilization.
        Average daily peak CPU consumption by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.

        :return: The avg_workload_cpu_daily_peak of this ApiClusterUtilization.
        :rtype: float
        """
        return self._avg_workload_cpu_daily_peak

    @avg_workload_cpu_daily_peak.setter
    def avg_workload_cpu_daily_peak(self, avg_workload_cpu_daily_peak):
        """
        Sets the avg_workload_cpu_daily_peak of this ApiClusterUtilization.
        Average daily peak CPU consumption by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.

        :param avg_workload_cpu_daily_peak: The avg_workload_cpu_daily_peak of this ApiClusterUtilization.
        :type: float
        """

        self._avg_workload_cpu_daily_peak = avg_workload_cpu_daily_peak

    @property
    def total_memory(self):
        """
        Gets the total_memory of this ApiClusterUtilization.
        Average physical memory (in bytes) available in the cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :return: The total_memory of this ApiClusterUtilization.
        :rtype: float
        """
        return self._total_memory

    @total_memory.setter
    def total_memory(self, total_memory):
        """
        Sets the total_memory of this ApiClusterUtilization.
        Average physical memory (in bytes) available in the cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :param total_memory: The total_memory of this ApiClusterUtilization.
        :type: float
        """

        self._total_memory = total_memory

    @property
    def avg_memory_utilization(self):
        """
        Gets the avg_memory_utilization of this ApiClusterUtilization.
        Average memory consumption (as percentage of total memory) for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :return: The avg_memory_utilization of this ApiClusterUtilization.
        :rtype: float
        """
        return self._avg_memory_utilization

    @avg_memory_utilization.setter
    def avg_memory_utilization(self, avg_memory_utilization):
        """
        Sets the avg_memory_utilization of this ApiClusterUtilization.
        Average memory consumption (as percentage of total memory) for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :param avg_memory_utilization: The avg_memory_utilization of this ApiClusterUtilization.
        :type: float
        """

        self._avg_memory_utilization = avg_memory_utilization

    @property
    def max_memory_utilization(self):
        """
        Gets the max_memory_utilization of this ApiClusterUtilization.
        Maximum memory consumption (as percentage of total memory) for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :return: The max_memory_utilization of this ApiClusterUtilization.
        :rtype: float
        """
        return self._max_memory_utilization

    @max_memory_utilization.setter
    def max_memory_utilization(self, max_memory_utilization):
        """
        Sets the max_memory_utilization of this ApiClusterUtilization.
        Maximum memory consumption (as percentage of total memory) for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :param max_memory_utilization: The max_memory_utilization of this ApiClusterUtilization.
        :type: float
        """

        self._max_memory_utilization = max_memory_utilization

    @property
    def avg_memory_daily_peak(self):
        """
        Gets the avg_memory_daily_peak of this ApiClusterUtilization.
        Average daily peak memory consumption (as percentage of total memory) for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :return: The avg_memory_daily_peak of this ApiClusterUtilization.
        :rtype: float
        """
        return self._avg_memory_daily_peak

    @avg_memory_daily_peak.setter
    def avg_memory_daily_peak(self, avg_memory_daily_peak):
        """
        Sets the avg_memory_daily_peak of this ApiClusterUtilization.
        Average daily peak memory consumption (as percentage of total memory) for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.

        :param avg_memory_daily_peak: The avg_memory_daily_peak of this ApiClusterUtilization.
        :type: float
        """

        self._avg_memory_daily_peak = avg_memory_daily_peak

    @property
    def avg_workload_memory(self):
        """
        Gets the avg_workload_memory of this ApiClusterUtilization.
        Average memory consumption (as percentage of total memory) by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.

        :return: The avg_workload_memory of this ApiClusterUtilization.
        :rtype: float
        """
        return self._avg_workload_memory

    @avg_workload_memory.setter
    def avg_workload_memory(self, avg_workload_memory):
        """
        Sets the avg_workload_memory of this ApiClusterUtilization.
        Average memory consumption (as percentage of total memory) by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.

        :param avg_workload_memory: The avg_workload_memory of this ApiClusterUtilization.
        :type: float
        """

        self._avg_workload_memory = avg_workload_memory

    @property
    def max_workload_memory(self):
        """
        Gets the max_workload_memory of this ApiClusterUtilization.
        Maximum memory consumption (as percentage of total memory) by workloads that ran on the cluster. This includes consumption by user workloads in YARN and Impala

        :return: The max_workload_memory of this ApiClusterUtilization.
        :rtype: float
        """
        return self._max_workload_memory

    @max_workload_memory.setter
    def max_workload_memory(self, max_workload_memory):
        """
        Sets the max_workload_memory of this ApiClusterUtilization.
        Maximum memory consumption (as percentage of total memory) by workloads that ran on the cluster. This includes consumption by user workloads in YARN and Impala

        :param max_workload_memory: The max_workload_memory of this ApiClusterUtilization.
        :type: float
        """

        self._max_workload_memory = max_workload_memory

    @property
    def avg_workload_memory_daily_peak(self):
        """
        Gets the avg_workload_memory_daily_peak of this ApiClusterUtilization.
        Average daily peak memory consumption (as percentage of total memory) by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.

        :return: The avg_workload_memory_daily_peak of this ApiClusterUtilization.
        :rtype: float
        """
        return self._avg_workload_memory_daily_peak

    @avg_workload_memory_daily_peak.setter
    def avg_workload_memory_daily_peak(self, avg_workload_memory_daily_peak):
        """
        Sets the avg_workload_memory_daily_peak of this ApiClusterUtilization.
        Average daily peak memory consumption (as percentage of total memory) by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.

        :param avg_workload_memory_daily_peak: The avg_workload_memory_daily_peak of this ApiClusterUtilization.
        :type: float
        """

        self._avg_workload_memory_daily_peak = avg_workload_memory_daily_peak

    @property
    def tenant_utilizations(self):
        """
        Gets the tenant_utilizations of this ApiClusterUtilization.
        A list of tenant utilization reports.

        :return: The tenant_utilizations of this ApiClusterUtilization.
        :rtype: ApiTenantUtilizationList
        """
        return self._tenant_utilizations

    @tenant_utilizations.setter
    def tenant_utilizations(self, tenant_utilizations):
        """
        Sets the tenant_utilizations of this ApiClusterUtilization.
        A list of tenant utilization reports.

        :param tenant_utilizations: The tenant_utilizations of this ApiClusterUtilization.
        :type: ApiTenantUtilizationList
        """

        self._tenant_utilizations = tenant_utilizations

    @property
    def max_cpu_utilization_timestamp_ms(self):
        """
        Gets the max_cpu_utilization_timestamp_ms of this ApiClusterUtilization.
        Timestamp corresponding to maximum CPU utilization for the entire cluster during the report window.

        :return: The max_cpu_utilization_timestamp_ms of this ApiClusterUtilization.
        :rtype: int
        """
        return self._max_cpu_utilization_timestamp_ms

    @max_cpu_utilization_timestamp_ms.setter
    def max_cpu_utilization_timestamp_ms(self, max_cpu_utilization_timestamp_ms):
        """
        Sets the max_cpu_utilization_timestamp_ms of this ApiClusterUtilization.
        Timestamp corresponding to maximum CPU utilization for the entire cluster during the report window.

        :param max_cpu_utilization_timestamp_ms: The max_cpu_utilization_timestamp_ms of this ApiClusterUtilization.
        :type: int
        """

        self._max_cpu_utilization_timestamp_ms = max_cpu_utilization_timestamp_ms

    @property
    def max_memory_utilization_timestamp_ms(self):
        """
        Gets the max_memory_utilization_timestamp_ms of this ApiClusterUtilization.
        Timestamp corresponding to maximum memory utilization for the entire cluster during the report window.

        :return: The max_memory_utilization_timestamp_ms of this ApiClusterUtilization.
        :rtype: int
        """
        return self._max_memory_utilization_timestamp_ms

    @max_memory_utilization_timestamp_ms.setter
    def max_memory_utilization_timestamp_ms(self, max_memory_utilization_timestamp_ms):
        """
        Sets the max_memory_utilization_timestamp_ms of this ApiClusterUtilization.
        Timestamp corresponding to maximum memory utilization for the entire cluster during the report window.

        :param max_memory_utilization_timestamp_ms: The max_memory_utilization_timestamp_ms of this ApiClusterUtilization.
        :type: int
        """

        self._max_memory_utilization_timestamp_ms = max_memory_utilization_timestamp_ms

    @property
    def max_workload_cpu_timestamp_ms(self):
        """
        Gets the max_workload_cpu_timestamp_ms of this ApiClusterUtilization.
        Timestamp corresponds to maximum CPU consumption by workloads that ran on the cluster during the report window.

        :return: The max_workload_cpu_timestamp_ms of this ApiClusterUtilization.
        :rtype: int
        """
        return self._max_workload_cpu_timestamp_ms

    @max_workload_cpu_timestamp_ms.setter
    def max_workload_cpu_timestamp_ms(self, max_workload_cpu_timestamp_ms):
        """
        Sets the max_workload_cpu_timestamp_ms of this ApiClusterUtilization.
        Timestamp corresponds to maximum CPU consumption by workloads that ran on the cluster during the report window.

        :param max_workload_cpu_timestamp_ms: The max_workload_cpu_timestamp_ms of this ApiClusterUtilization.
        :type: int
        """

        self._max_workload_cpu_timestamp_ms = max_workload_cpu_timestamp_ms

    @property
    def max_workload_memory_timestamp_ms(self):
        """
        Gets the max_workload_memory_timestamp_ms of this ApiClusterUtilization.
        Timestamp corresponds to maximum memory resource consumption by workloads that ran on the cluster during the report window.

        :return: The max_workload_memory_timestamp_ms of this ApiClusterUtilization.
        :rtype: int
        """
        return self._max_workload_memory_timestamp_ms

    @max_workload_memory_timestamp_ms.setter
    def max_workload_memory_timestamp_ms(self, max_workload_memory_timestamp_ms):
        """
        Sets the max_workload_memory_timestamp_ms of this ApiClusterUtilization.
        Timestamp corresponds to maximum memory resource consumption by workloads that ran on the cluster during the report window.

        :param max_workload_memory_timestamp_ms: The max_workload_memory_timestamp_ms of this ApiClusterUtilization.
        :type: int
        """

        self._max_workload_memory_timestamp_ms = max_workload_memory_timestamp_ms

    @property
    def error_message(self):
        """
        Gets the error_message of this ApiClusterUtilization.
        Error message while generating utilization report.

        :return: The error_message of this ApiClusterUtilization.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this ApiClusterUtilization.
        Error message while generating utilization report.

        :param error_message: The error_message of this ApiClusterUtilization.
        :type: str
        """

        self._error_message = error_message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiClusterUtilization):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
