"""This module provides a collection of SVG Icons"""
# pylint: disable=line-too-long
GIF_SVG = """ <svg class="pnx-icon" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" d="M12.002 4h-10a1 1 0 0 0-1 1v8l2.256-2.354a.5.5 0 0 1 .63-.062l2.66 1.773 3.71-3.71a.5.5 0 0 1 .577-.094l1.777 1.947V5a1 1 0 0 0-1-1zm-10-1a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2h-10zm4 4.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z"/>
<path fill-rule="evenodd" d="M4 2h10a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1v1a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2h1a1 1 0 0 1 1-1z"/>
</svg>"""
MP4_SVG = """
<svg class="pnx-icon" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
    <path fill-rule="evenodd" d="M0 1a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v14a1 1 0 0 1-1 1H1a1 1 0 0 1-1-1V1zm4 0h8v6H4V1zm8 8H4v6h8V9zM1 1h2v2H1V1zm2 3H1v2h2V4zM1 7h2v2H1V7zm2 3H1v2h2v-2zm-2 3h2v2H1v-2zM15 1h-2v2h2V1zm-2 3h2v2h-2V4zm2 3h-2v2h2V7zm-2 3h2v2h-2v-2zm2 3h-2v2h2v-2z"/>
</svg>"""

YOUTUBE_SVG = """
<svg class="pnx-icon" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false" role="img" viewBox="0 0 576 512">
    <path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 25 288 25 288 25S117.22 25 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.251-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.308V175.185l142.739 81.205-142.739 81.201z"/>
</svg>
"""
DOC_SVG = """
<svg class="pnx-icon" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
    <path fill-rule="evenodd" d="M1 2.828v9.923c.918-.35 2.107-.692 3.287-.81 1.094-.111 2.278-.039 3.213.492V2.687c-.654-.689-1.782-.886-3.112-.752-1.234.124-2.303.523-3.388.893zm7.5-.141v9.746c.935-.53 2.12-.603 3.213-.493 1.18.12 2.25.461 3.287.811V2.828c-.885-.25-2.154-.769-3.388-.893-1.33-.134-2.458.063-3.112.752zM8 1.783C7.015.936 5.587.81 4.287.94c-1.514.153-3.042.672-3.994 1.105A.5.5 0 0 0 0 2.5v11a.5.5 0 0 0 .707.455c.882-.4 2.303-.881 3.68-1.02 1.409-.142 2.59.087 3.223.877a.5.5 0 0 0 .78 0c.633-.79 1.814-1.019 3.222-.877 1.258.139 2.8.62 3.681 1.02A.5.5 0 0 0 16 13.5v-11a.5.5 0 0 0-.293-.455c-.952-.433-2.48-.952-3.994-1.105C10.413.809 8.985.936 8 1.783z"/>
</svg>
"""

CODE_SVG = """
<svg class="pnx-icon" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
    <path fill-rule="evenodd" d="M4.854 4.146a.5.5 0 0 1 0 .708L1.707 8l3.147 3.146a.5.5 0 0 1-.708.708l-3.5-3.5a.5.5 0 0 1 0-.708l3.5-3.5a.5.5 0 0 1 .708 0zm6.292 0a.5.5 0 0 0 0 .708L14.293 8l-3.147 3.146a.5.5 0 0 0 .708.708l3.5-3.5a.5.5 0 0 0 0-.708l-3.5-3.5a.5.5 0 0 0-.708 0zm-.999-3.124a.5.5 0 0 1 .33.625l-4 13a.5.5 0 0 1-.955-.294l4-13a.5.5 0 0 1 .625-.33z"/>
</svg>
"""

# Source: https://fontawesome.com/icons/external-link-alt
EXTERNAL_LINK = """<svg xmlns="http://www.w3.org/2000/svg" class="pnx-icon" aria-hidden="true" focusable="false" role="img" viewBox="0 0 512 512"><path fill="currentColor" d="M432,320H400a16,16,0,0,0-16,16V448H64V128H208a16,16,0,0,0,16-16V80a16,16,0,0,0-16-16H48A48,48,0,0,0,0,112V464a48,48,0,0,0,48,48H400a48,48,0,0,0,48-48V336A16,16,0,0,0,432,320ZM488,0h-128c-21.37,0-32.05,25.91-17,41l35.73,35.73L135,320.37a24,24,0,0,0,0,34L157.67,377a24,24,0,0,0,34,0L435.28,133.32,471,169c15,15,41,4.5,41-17V24A24,24,0,0,0,488,0Z"/></svg>"""
FACEBOOK = """<svg xmlns="http://www.w3.org/2000/svg" class="pnx-icon" aria-hidden="true" focusable="false" role="img" viewBox="0 0 320 512"><path fill="currentColor" d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"/></svg>"""
LINKED_IN = """<svg xmlns="http://www.w3.org/2000/svg" class="pnx-icon" aria-hidden="true" focusable="false" role="img" viewBox="0 0 448 512"><path fill="currentColor" d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"/></svg>"""
TWITTER = """<svg xmlns="http://www.w3.org/2000/svg" class="pnx-icon" aria-hidden="true" focusable="false" role="img" viewBox="0 0 512 512"><path fill="currentColor" d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"/></svg>"""
REDDIT = """<svg xmlns="http://www.w3.org/2000/svg" class="pnx-icon" aria-hidden="true" focusable="false" role="img" viewBox="0 0 512 512"><path fill="currentColor" d="M440.3 203.5c-15 0-28.2 6.2-37.9 15.9-35.7-24.7-83.8-40.6-137.1-42.3L293 52.3l88.2 19.8c0 21.6 17.6 39.2 39.2 39.2 22 0 39.7-18.1 39.7-39.7s-17.6-39.7-39.7-39.7c-15.4 0-28.7 9.3-35.3 22l-97.4-21.6c-4.9-1.3-9.7 2.2-11 7.1L246.3 177c-52.9 2.2-100.5 18.1-136.3 42.8-9.7-10.1-23.4-16.3-38.4-16.3-55.6 0-73.8 74.6-22.9 100.1-1.8 7.9-2.6 16.3-2.6 24.7 0 83.8 94.4 151.7 210.3 151.7 116.4 0 210.8-67.9 210.8-151.7 0-8.4-.9-17.2-3.1-25.1 49.9-25.6 31.5-99.7-23.8-99.7zM129.4 308.9c0-22 17.6-39.7 39.7-39.7 21.6 0 39.2 17.6 39.2 39.7 0 21.6-17.6 39.2-39.2 39.2-22 .1-39.7-17.6-39.7-39.2zm214.3 93.5c-36.4 36.4-139.1 36.4-175.5 0-4-3.5-4-9.7 0-13.7 3.5-3.5 9.7-3.5 13.2 0 27.8 28.5 120 29 149 0 3.5-3.5 9.7-3.5 13.2 0 4.1 4 4.1 10.2.1 13.7zm-.8-54.2c-21.6 0-39.2-17.6-39.2-39.2 0-22 17.6-39.7 39.2-39.7 22 0 39.7 17.6 39.7 39.7-.1 21.5-17.7 39.2-39.7 39.2z"/></svg>"""
ENVELOPE = """<svg xmlns="http://www.w3.org/2000/svg" class="pnx-icon" aria-hidden="true" focusable="false" role="img" viewBox="0 0 512 512"><path fill="currentColor" d="M502.3 190.8c3.9-3.1 9.7-.2 9.7 4.7V400c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V195.6c0-5 5.7-7.8 9.7-4.7 22.4 17.4 52.1 39.5 154.1 113.6 21.1 15.4 56.7 47.8 92.2 47.6 35.7.3 72-32.8 92.3-47.6 102-74.1 131.6-96.3 154-113.7zM256 320c23.2.4 56.6-29.2 73.4-41.4 132.7-96.3 142.8-104.7 173.4-128.7 5.8-4.5 9.2-11.5 9.2-18.9v-19c0-26.5-21.5-48-48-48H48C21.5 64 0 85.5 0 112v19c0 7.4 3.4 14.3 9.2 18.9 30.6 23.9 40.7 32.4 173.4 128.7 16.8 12.2 50.2 41.8 73.4 41.4z"/></svg>"""
BINDER = """<svg version="1.1" id="Layer_1"
	 xmlns="http://www.w3.org/2000/svg" class="pnx-icon pnx-icon-binder" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 212.118 65.883" enable-background="new 0 0 212.118 65.883" xml:space="preserve">
<switch>
	<g>
		<g>
			<path fill="#545454" d="M50.751,48.727V12.472h7.251v17.547c1.885-2.32,4.544-3.094,7.299-3.094
				c6.042,0,10.586,5.269,10.586,11.167S71.344,49.21,65.302,49.21c-2.755,0-5.849-0.87-7.299-3.046v2.562H50.751z M63.078,43.409
				c2.9,0,5.076-2.514,5.076-5.317s-2.175-5.317-5.076-5.317s-5.076,2.514-5.076,5.317S60.178,43.409,63.078,43.409z"/>
			<path fill="#545454" d="M84.35,15.855c2.32,0,4.254,1.885,4.254,4.254c0,2.32-1.934,4.254-4.254,4.254
				c-2.369,0-4.254-1.934-4.254-4.254C80.096,17.741,81.981,15.855,84.35,15.855z M80.724,48.727V27.409h7.251v21.318H80.724z"/>
			<path fill="#545454" d="M115.819,48.727h-7.25V36.642c0-2.514-0.967-3.867-3.239-3.867s-4.061,2.417-4.061,5.317v10.635h-7.251
				V27.409h7.251v2.61c1.45-1.837,3.722-3.094,6.526-3.094c5.704,0,8.024,3.916,8.024,9.716V48.727z"/>
			<path fill="#545454" d="M144.826,48.727h-7.251v-2.562c-1.45,2.176-4.592,3.046-7.299,3.046c-6.043,0-10.587-5.221-10.587-11.118
				s4.544-11.167,10.587-11.167c2.707,0,5.414,0.773,7.299,3.094V12.472h7.251V48.727z M132.499,32.774
				c-2.9,0-5.075,2.514-5.075,5.317s2.175,5.317,5.075,5.317s5.076-2.514,5.076-5.317S135.399,32.774,132.499,32.774z"/>
			<path fill="#545454" d="M173.639,38.962h-16.532c0,2.466,1.74,5.075,4.592,5.075c2.562,0,4.158-1.691,4.206-3.238h7.396
				c-1.256,5.607-5.801,8.411-11.456,8.411c-7.348,0-12.423-4.351-12.423-11.118c0-6.671,5.269-11.167,12.423-11.167
				c6.478,0,11.843,3.867,11.843,10.683C173.687,38.043,173.639,38.527,173.639,38.962z M166.726,35.53c0,0-0.338-3.964-4.736-3.964
				c-4.545,0-4.786,3.964-4.786,3.964H166.726z"/>
			<path fill="#545454" d="M185.532,38.092v10.635h-7.251V27.409h7.251v2.61c1.111-1.595,2.949-3.094,5.607-3.094
				c0.629,0,1.596,0.193,2.176,0.483v6.574h-0.098c-0.725-0.87-1.788-1.208-2.9-1.208C187.61,32.774,185.532,35.53,185.532,38.092z"
				/>
		</g>
		<circle fill="none" stroke="#F5A252" stroke-width="4.8342" stroke-miterlimit="10" cx="27.879" cy="23.939" r="9.542"/>
		<circle fill="none" stroke="#579ACA" stroke-width="4.8342" stroke-miterlimit="10" cx="27.879" cy="42.499" r="9.543"/>
		<circle fill="none" stroke="#E66581" stroke-width="4.8342" stroke-miterlimit="10" cx="18.551" cy="33.289" r="9.543"/>
		<path fill="none" stroke="#579ACA" stroke-width="4.8342" stroke-miterlimit="10" d="M20.196,36.836
			c0.759-1.031,1.74-1.927,2.921-2.607c4.566-2.63,10.401-1.06,13.031,3.507"/>
		<path fill="none" stroke="#F5A252" stroke-width="4.8342" stroke-miterlimit="10" d="M19.61,28.701
			c-2.63-4.566-1.061-10.401,3.507-13.032c4.567-2.63,10.401-1.059,13.031,3.508"/>
	</g>
</switch>
</svg>"""
FAST_COLLAPSED_ICON = """
<svg style="stroke: #E62F63" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg" slot="collapsed-icon">
            <path d="M15.2222 1H2.77778C1.79594 1 1 1.79594 1 2.77778V15.2222C1 16.2041 1.79594 17 2.77778 17H15.2222C16.2041 17 17 16.2041 17 15.2222V2.77778C17 1.79594 16.2041 1 15.2222 1Z" stroke-linecap="round" stroke-linejoin="round"></path>
            <path d="M9 5.44446V12.5556" stroke-linecap="round" stroke-linejoin="round"></path>
            <path d="M5.44446 9H12.5556" stroke-linecap="round" stroke-linejoin="round"></path>
        </svg>
"""

FAST_EXPANDED_ICON = """
<svg style="stroke: #E62F63" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg" slot="expanded-icon">
    <path d="M15.2222 1H2.77778C1.79594 1 1 1.79594 1 2.77778V15.2222C1 16.2041 1.79594 17 2.77778 17H15.2222C16.2041 17 17 16.2041 17 15.2222V2.77778C17 1.79594 16.2041 1 15.2222 1Z" stroke-linecap="round" stroke-linejoin="round"></path>
    <path d="M5.44446 9H12.5556" stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
"""


ICONS = {
    "binder": BINDER,
    "code": CODE_SVG,
    "doc": DOC_SVG,
    "envelope": ENVELOPE,
    "external_link": EXTERNAL_LINK,
    "facebook": FACEBOOK,
    "gif": GIF_SVG,
    "linked_in": LINKED_IN,
    "mp4": MP4_SVG,
    "reddit": REDDIT,
    "twitter": TWITTER,
    "youtube": YOUTUBE_SVG,
    "collapsed": FAST_COLLAPSED_ICON,
    "expanded": FAST_EXPANDED_ICON,
}
