from typing import Dict


class BinaryWriteChunkImpulse:
    uri: str
    upload_id: str
    ordinal: int
    size_in_bytes: int
    file: bytes

    def __init__(self, uri: str, upload_id: str, ordinal: int, size_in_bytes: int, file: bytes):
        self.uri = uri
        self.upload_id = upload_id
        self.ordinal = ordinal
        self.size_in_bytes = size_in_bytes
        self.file = file

    def __eq__(self, other):
        return self.uri == other.uri \
               and self.upload_id == other.upload_id \
               and self.ordinal == other.ordinal \
               and self.size_in_bytes == other.size_in_bytes \
               and self.file == other.file

    def __repr__(self):
        return {'uri': self.uri,
                'upload_id': self.upload_id,
                'ordinal': self.ordinal,
                'size_in_bytes': self.size_in_bytes,
                'file': self.file}

    def as_form_data(self) -> Dict[str, tuple]:
        return {
            "uri": (None, self.uri),
            "uploadId": (None, self.upload_id),
            "ordinal": (None, self.ordinal),
            "sizeInBytes": (None, self.size_in_bytes),
            "file": ("someFileName", self.file, "application/octet-stream")
        }
