"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadOnlyDBInstance = exports.ReadOnlyDBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "ReadOnlyDBInstanceProperty", { enumerable: true, get: function () { return rds_generated_1.RosReadOnlyDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::ReadOnlyDBInstance`
 */
class ReadOnlyDBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::ReadOnlyDBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosReadOnlyDBInstance = new rds_generated_1.RosReadOnlyDBInstance(this, id, {
            periodType: props.periodType === undefined || props.periodType === null ? 'Month' : props.periodType,
            category: props.category,
            engineVersion: props.engineVersion,
            privateIpAddress: props.privateIpAddress,
            zoneId: props.zoneId,
            resourceGroupId: props.resourceGroupId,
            vpcId: props.vpcId,
            dbInstanceClass: props.dbInstanceClass,
            vSwitchId: props.vSwitchId,
            autoRenew: props.autoRenew,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            dbInstanceStorageType: props.dbInstanceStorageType,
            dbInstanceId: props.dbInstanceId,
            dbInstanceStorage: props.dbInstanceStorage,
            dbInstanceDescription: props.dbInstanceDescription,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosReadOnlyDBInstance;
        this.attrConnectionString = rosReadOnlyDBInstance.attrConnectionString;
        this.attrDbInstanceId = rosReadOnlyDBInstance.attrDbInstanceId;
        this.attrPort = rosReadOnlyDBInstance.attrPort;
    }
}
exports.ReadOnlyDBInstance = ReadOnlyDBInstance;
//# sourceMappingURL=data:application/json;base64,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