"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafwebaclToCloudFront = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
/**
 * @summary The WafwebaclToCloudFront class.
 */
class WafwebaclToCloudFront extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the WafwebaclToCloudFront class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {WafwebaclToCloudFrontProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Build the Web ACL
        this.webacl = defaults.buildWebacl(this, 'CLOUDFRONT', {
            existingWebaclObj: props.existingWebaclObj,
            webaclProps: props.webaclProps,
        });
        // Property override of CloudFront Cfn Template
        const cfnExistingCloudFrontWebDistribution = props.existingCloudFrontWebDistribution.node.defaultChild;
        cfnExistingCloudFrontWebDistribution.addPropertyOverride('DistributionConfig.WebACLId', this.webacl.attrArn);
        this.cloudFrontWebDistribution = props.existingCloudFrontWebDistribution;
    }
}
exports.WafwebaclToCloudFront = WafwebaclToCloudFront;
_a = JSII_RTTI_SYMBOL_1;
WafwebaclToCloudFront[_a] = { fqn: "@aws-solutions-constructs/aws-wafwebacl-cloudfront.WafwebaclToCloudFront", version: "2.31.0" };
//# sourceMappingURL=data:application/json;base64,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