from setuptools import setup

setup(
    name='tagui',
    version='1.26.1',
    py_modules=['tagui'],
    author='Ken Soh',
    author_email='opensource@tebel.org',
    license='Apache License 2.0',
    url='https://github.com/tebelorg/RPA-Python',
    description='RPA for Python is a Python package for RPA (robotic process automation)',
    long_description='RPA for Python\'s simple and powerful API makes robotic process automation fun! You can use it to quickly automate repetitive time-consuming tasks, whether the tasks involve websites, desktop applications, or the command line.\n\nBuilt on AI Singapore\'s TagUI open-source RPA software, RPA capabilities out-of-the-box for this package include website automation, computer vision automation, optical character recognition, keyboard & mouse automation.\n\nTables can\'t be displayed here, please refer to RPA for Python homepage for full API - https://github.com/tebelorg/RPA-Python',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: Apache Software License',
        'Intended Audience :: Developers',
        'Intended Audience :: Education',
        'Intended Audience :: Science/Research',
        'Operating System :: POSIX :: Linux',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: Microsoft :: Windows',
        'Topic :: Scientific/Engineering :: Artificial Intelligence',
        'Topic :: Software Development :: Libraries :: Python Modules'
    ]
)
