"""
Mappings of USB keyboard codes (SDL scancodes) to and from human-friendly names.
"""

__all__ = ['SCANCODES', 'LOOKUP_SCANCODE']

# Pulled from here:
# https://wiki.libsdl.org/SDLScancodeLookup
# Official definitions here:
# https://usb.org/sites/default/files/hut1_21.pdf (HID Usages and Descriptions)

# Main sections of interest:
# 4-29: Letters
# 30-39: Numbers
# 40-44: Enter/Esc/Backspace/Tab/Space
# 45-56: Punctuation
# 57: Caps Lock
# 58-69: Function Keys
# 70-82: Arrow Keys and Above
# 83-93: Standard Numpad Keys
# 224-231: Meta/Control Keys

SCANCODES = {
    0: 'Unknown',
    4: 'A',
    5: 'B',
    6: 'C',
    7: 'D',
    8: 'E',
    9: 'F',
    10: 'G',
    11: 'H',
    12: 'I',
    13: 'J',
    14: 'K',
    15: 'L',
    16: 'M',
    17: 'N',
    18: 'O',
    19: 'P',
    20: 'Q',
    21: 'R',
    22: 'S',
    23: 'T',
    24: 'U',
    25: 'V',
    26: 'W',
    27: 'X',
    28: 'Y',
    29: 'Z',
    30: '1',
    31: '2',
    32: '3',
    33: '4',
    34: '5',
    35: '6',
    36: '7',
    37: '8',
    38: '9',
    39: '0',
    40: 'Enter',
    41: 'Escape',
    42: 'Backspace',
    43: 'Tab',
    44: 'Space',
    45: '-',
    46: '=',
    47: '[',
    48: ']',
    49: '\\',
    # NONUSHASH
    50: '\\',
    51: ';',
    52: '\'',
    53: '`',
    54: ',',
    55: '.',
    56: '/',
    57: 'Caps Lock',
    58: 'F1',
    59: 'F2',
    60: 'F3',
    61: 'F4',
    62: 'F5',
    63: 'F6',
    64: 'F7',
    65: 'F8',
    66: 'F9',
    67: 'F10',
    68: 'F11',
    69: 'F12',
    70: 'Print Screen',
    71: 'Scroll Lock',
    72: 'Pause',
    73: 'Insert',
    74: 'Home',
    75: 'Page Up',
    76: 'Delete',
    77: 'End',
    78: 'Page Down',
    79: 'Right',
    80: 'Left',
    81: 'Down',
    82: 'Up',
    83: 'Numlock Clear',
    84: 'KP /',
    85: 'KP *',
    86: 'KP -',
    87: 'KP +',
    88: 'KP Enter',
    89: 'KP 1',
    90: 'KP 2',
    91: 'KP 3',
    92: 'KP 4',
    93: 'KP 5',
    94: 'KP 6',
    95: 'KP 7',
    96: 'KP 8',
    97: 'KP 9',
    98: 'KP 0',
    99: 'KP .',
    100: 'ISO \\',
    101: 'Application',
    102: 'Power',
    103: 'KP =',
    104: 'F13',
    105: 'F14',
    106: 'F15',
    107: 'F16',
    108: 'F17',
    109: 'F18',
    110: 'F19',
    111: 'F20',
    112: 'F21',
    113: 'F22',
    114: 'F23',
    115: 'F24',
    116: 'Execute',
    117: 'Help',
    118: 'Menu',
    119: 'Select',
    120: 'Stop',
    121: 'Again',
    122: 'Undo',
    123: 'Cut',
    124: 'Copy',
    125: 'Paste',
    126: 'Find',
    127: 'Mute',
    128: 'Volume Up',
    129: 'Volume Down',
    133: 'KP ,',
    134: 'KP =',
    135: 'International 1',
    136: 'International 2',
    137: '¥',
    138: 'International 4',
    139: 'International 5',
    140: 'International 6',
    141: 'International 7',
    142: 'International 8',
    143: 'International 9',
    144: 'Hangul/English',
    145: 'Hanja',
    146: 'Katakana',
    147: 'Hiragana',
    148: 'Zenkaku/Hankaku',
    149: 'LANG6',
    150: 'LANG7',
    151: 'LANG8',
    152: 'LANG9',
    153: 'Alternate Erase',
    154: 'SysReq',
    155: 'Cancel',
    156: 'Clear',
    157: 'Prior',
    158: 'Return',
    159: 'Separator',
    160: 'Out',
    161: 'Oper',
    162: 'Clear Again',
    163: 'CrSel',
    164: 'ExSel',
    176: 'KP 00',
    177: 'KP 000',
    178: 'Thousands Separator',
    179: 'Decimal Separator',
    180: '$',
    181: '¢',
    182: 'KP (',
    183: 'KP )',
    184: 'KP {',
    185: 'KP }',
    186: 'KP Tab',
    187: 'KP Backspace',
    188: 'KP A',
    189: 'KP B',
    190: 'KP C',
    191: 'KP D',
    192: 'KP E',
    193: 'KP F',
    194: 'KP XOR',
    195: 'KP Power',
    196: 'KP %',
    197: 'KP <',
    198: 'KP >',
    199: 'KP &',
    200: 'KP &&',
    201: 'KP |',
    202: 'KP ||',
    203: 'KP :',
    204: 'KP #',
    205: 'KP Space',
    206: 'KP @',
    207: 'KP !',
    208: 'KP Memory Store',
    209: 'KP Memory Recall',
    210: 'KP Memory Clear',
    211: 'KP Memory +',
    212: 'KP Memory -',
    213: 'KP Memory *',
    214: 'KP Memory /',
    215: 'KP +/-',
    216: 'KP Clear',
    217: 'KP Clear Entry',
    218: 'KP Binary',
    219: 'KP Octal',
    220: 'KP Decimal',
    221: 'KP Hexadecimal',
    224: 'Left Ctrl',
    225: 'Left Shift',
    226: 'Left Alt',
    227: 'Left Meta',
    228: 'Right Ctrl',
    229: 'Right Shift',
    230: 'Right Alt',
    231: 'Right Meta',
    257: 'Mode',
    258: 'Audio Next',
    259: 'Audio Prev',
    260: 'Audio Stop',
    261: 'Audio Play',
    262: 'Audio Mute',
    263: 'Media Select',
    264: 'WWW',
    265: 'Mail',
    266: 'Calculator',
    267: 'Computer',
    268: 'AC Search',
    269: 'AC Home',
    270: 'AC Back',
    271: 'AC Forward',
    272: 'AC Stop',
    273: 'AC Refresh',
    274: 'AC Bookmarks',
    275: 'Brightness Down',
    276: 'Brightness Up',
    277: 'Switch Display',
    278: 'Keyboard Illum Toggle',
    279: 'Keyboard Illum Down',
    280: 'Keyboard Illum Up',
    281: 'Eject',
    282: 'Sleep',
    283: 'App 1',
    284: 'App 2',
}

# Go in reversed order to prefer lower scancodes for the same name
LOOKUP_SCANCODE = {v: k for k, v in reversed(list(SCANCODES.items()))}
