"use strict";
const stepfunctions = require("../lib");
function assertRendersTo(test, cond, expected) {
    test.deepEqual(cond.renderCondition(), expected);
}
module.exports = {
    'Condition variables must start with $. or $['(test) {
        test.throws(() => {
            stepfunctions.Condition.stringEquals('a', 'b');
        });
        test.done();
    },
    'Condition variables can start with $.'(test) {
        test.doesNotThrow(() => {
            stepfunctions.Condition.stringEquals('$.a', 'b');
        });
        test.done();
    },
    'Condition variables can start with $['(test) {
        test.doesNotThrow(() => {
            stepfunctions.Condition.stringEquals('$[0]', 'a');
        });
        test.done();
    },
    'NotConditon must render properly'(test) {
        assertRendersTo(test, stepfunctions.Condition.not(stepfunctions.Condition.stringEquals('$.a', 'b')), { Not: { Variable: '$.a', StringEquals: 'b' } });
        test.done();
    },
    'CompoundCondition must render properly'(test) {
        assertRendersTo(test, stepfunctions.Condition.and(stepfunctions.Condition.booleanEquals('$.a', true), stepfunctions.Condition.numberGreaterThan('$.b', 3)), { And: [{ Variable: '$.a', BooleanEquals: true }, { Variable: '$.b', NumericGreaterThan: 3 }] });
        test.done();
    },
    'Exercise a number of other conditions'(test) {
        const cases = [
            [
                stepfunctions.Condition.stringLessThan('$.a', 'foo'),
                { Variable: '$.a', StringLessThan: 'foo' },
            ],
            [
                stepfunctions.Condition.stringLessThanEquals('$.a', 'foo'),
                { Variable: '$.a', StringLessThanEquals: 'foo' },
            ],
            [
                stepfunctions.Condition.stringGreaterThan('$.a', 'foo'),
                { Variable: '$.a', StringGreaterThan: 'foo' },
            ],
            [
                stepfunctions.Condition.stringGreaterThanEquals('$.a', 'foo'),
                { Variable: '$.a', StringGreaterThanEquals: 'foo' },
            ],
            [
                stepfunctions.Condition.numberEquals('$.a', 5),
                { Variable: '$.a', NumericEquals: 5 }
            ],
        ];
        for (const [cond, expected] of cases) {
            assertRendersTo(test, cond, expected);
        }
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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