# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dexa_sdk',
 'dexa_sdk.agent',
 'dexa_sdk.agent.admin',
 'dexa_sdk.agent.admin.aiohttp_apispec',
 'dexa_sdk.agent.commands',
 'dexa_sdk.agent.config',
 'dexa_sdk.agent.core',
 'dexa_sdk.agreements',
 'dexa_sdk.agreements.da',
 'dexa_sdk.agreements.da.v1_0',
 'dexa_sdk.agreements.da.v1_0.models',
 'dexa_sdk.agreements.da.v1_0.models.tests',
 'dexa_sdk.agreements.da.v1_0.records',
 'dexa_sdk.agreements.da.v1_0.records.tests',
 'dexa_sdk.agreements.dda',
 'dexa_sdk.agreements.dda.v1_0',
 'dexa_sdk.agreements.dda.v1_0.models',
 'dexa_sdk.agreements.dda.v1_0.models.fields',
 'dexa_sdk.agreements.dda.v1_0.models.tests',
 'dexa_sdk.agreements.dda.v1_0.records',
 'dexa_sdk.connections',
 'dexa_sdk.connections.records',
 'dexa_sdk.data_controller',
 'dexa_sdk.data_controller.records',
 'dexa_sdk.did_mydata',
 'dexa_sdk.jsonld',
 'dexa_sdk.ledgers',
 'dexa_sdk.ledgers.ethereum',
 'dexa_sdk.ledgers.indy',
 'dexa_sdk.logs',
 'dexa_sdk.managers',
 'dexa_sdk.managers.tests',
 'dexa_sdk.marketplace',
 'dexa_sdk.marketplace.models',
 'dexa_sdk.marketplace.records',
 'dexa_sdk.storage',
 'dexa_sdk.storage.records',
 'dexa_sdk.storage.records.tests',
 'dexa_sdk.utils',
 'dexa_sdk.utils.tests']

package_data = \
{'': ['*'], 'dexa_sdk.agent.admin.aiohttp_apispec': ['static/*']}

install_requires = \
['MarkupSafe==2.0.1',
 'PyJWT>=2.4.0,<3.0.0',
 'PyLD==2.0.1',
 'acapy-mydata-did-protocol==0.1.6',
 'acapy-patched==0.5.6.dev1',
 'asynctest>=0.13.0,<0.14.0',
 'dexa-protocol==0.1.2',
 'green>=3.4.2,<4.0.0',
 'ipykernel>=6.15.1,<7.0.0',
 'jcs>=0.2.1,<0.3.0',
 'loguru>=0.6.0,<0.7.0',
 'marshmallow==3.5.1',
 'merklelib>=1.0,<2.0',
 'merkletools>=1.0.3,<2.0.0',
 'py-multibase>=1.0.3,<2.0.0',
 'py-multicodec>=0.2.1,<0.3.0',
 'py-solc-x>=1.1.1,<2.0.0',
 'pydantic>=1.9.1,<2.0.0',
 'pytest>=7.1.2,<8.0.0',
 'python3-indy>=1.16.0,<2.0.0',
 'rdflib>=6.2.0,<7.0.0',
 'requests>=2.23.0,<2.24.0',
 'rich>=12.5.1,<13.0.0',
 'semver>=2.13.0,<3.0.0',
 'uvloop>=0.16.0,<0.17.0',
 'validators>=0.20.0,<0.21.0',
 'web3>=5.30.0,<6.0.0']

setup_kwargs = {
    'name': 'dexa-sdk',
    'version': '0.1.4',
    'description': 'Store and manage Data Exchange Agreements (DEXA)',
    'long_description': '<h1 align="center">\n    Data Exchange Agreements (DEXA) SDKs\n</h1>\n\n<p align="center">\n    <a href="/../../commits/" title="Last Commit"><img src="https://img.shields.io/github/last-commit/decentralised-dataexchange/dexa-sdk?style=flat"></a>\n    <a href="/../../issues" title="Open Issues"><img src="https://img.shields.io/github/issues/decentralised-dataexchange/dexa-sdk?style=flat"></a>\n    <a href="./LICENSE" title="License"><img src="https://img.shields.io/badge/License-Apache%202.0-green.svg?style=flat"></a>\n</p>\n\n<p align="center">\n  <a href="#about">About</a> •\n  <a href="#release-status">Release Status</a> •\n  <a href="#contributing">Contributing</a> •\n  <a href="#licensing">Licensing</a>\n</p>\n\n## About\n\nThis repository hosts the source code for DEXA SDKs and is part of the deliverables for Provenance services with smart data agreement ([PS-SDA](https://ontochain.ngi.eu/content/ps-sda)) project that has received funding from the European Union’s Horizon 2020 research and innovation programme under grant agreement No 957338. It implements common functions for DEXA that is used to implement dexa-protocols. \n## Release Status\n\nNot released, work in progress.\n\n## Compile, deploy and run\n\nFollow the instructions as given below:\n\n1. Run `git clone git@github.com:decentralised-dataexchange/dexa-sdk.git` to clone the repository.\n2. `cd` in to the cloned folder.\n\nTBD\n\n## Contributing\n\nFeel free to improve the plugin and send us a pull request. If you found any problems, please create an issue in this repo.\n\n## Licensing\nCopyright (c) 2022-25 LCubed AB (iGrant.io), Sweden\n\nLicensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.\n\nYou may obtain a copy of the License at https://www.apache.org/licenses/LICENSE-2.0.\n\nUnless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the LICENSE for the specific language governing permissions and limitations under the License.\n',
    'author': 'George J Padayatti',
    'author_email': 'george.padayatti@igrant.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/decentralised-dataexchange/dexa-sdk',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
