# Generated by Django 3.0.3 on 2021-01-23 14:21

import core.fields
import core.models
import datetime
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0009_mutationlog_client_mutation_details'),
    ]

    operations = [
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('validity_from', core.fields.DateTimeField(db_column='ValidityFrom', default=datetime.datetime.now)),
                ('validity_to', core.fields.DateTimeField(blank=True, db_column='ValidityTo', null=True)),
                ('legacy_id', models.IntegerField(blank=True, db_column='LegacyID', null=True)),
                ('id', models.BigAutoField(db_column='PaymentID', primary_key=True, serialize=False)),
                ('uuid', models.CharField(db_column='PaymentUUID', default=uuid.uuid4, max_length=36, unique=True)),
                ('expected_amount', models.DecimalField(blank=True, db_column='ExpectedAmount', decimal_places=2, max_digits=18, null=True)),
                ('received_amount', models.DecimalField(blank=True, db_column='ReceivedAmount', decimal_places=2, max_digits=18, null=True)),
                ('officer_code', models.CharField(blank=True, db_column='OfficerCode', max_length=50, null=True)),
                ('phone_number', models.CharField(blank=True, db_column='PhoneNumber', max_length=12, null=True)),
                ('request_date', core.fields.DateField(blank=True, db_column='RequestDate', null=True)),
                ('received_date', core.fields.DateField(blank=True, db_column='ReceivedDate', null=True)),
                ('status', models.IntegerField(blank=True, choices=[(-3, 'STATUS_REJECTEDPOSTED_3'), (-2, 'STATUS_REJECTEDPOSTED_2'), (-1, 'STATUS_REJECTEDPOSTED_1'), (1, 'STATUS_NOTYETCONFIRMED'), (2, 'STATUS_POSTED'), (3, 'STATUS_ASSIGNED'), (4, 'STATUS_UNMATCHED'), (5, 'STATUS_PAYMENTMATCHED')], db_column='PaymentStatus', null=True)),
                ('transaction_no', models.CharField(blank=True, db_column='TransactionNo', max_length=50, null=True)),
                ('origin', models.CharField(blank=True, db_column='PaymentOrigin', max_length=50, null=True)),
                ('matched_date', core.fields.DateField(blank=True, db_column='MatchedDate', null=True)),
                ('receipt_no', models.CharField(blank=True, db_column='ReceiptNo', max_length=100, null=True)),
                ('payment_date', core.fields.DateField(blank=True, db_column='PaymentDate', null=True)),
                ('rejected_reason', models.CharField(blank=True, db_column='RejectedReason', max_length=255, null=True)),
                ('date_last_sms', core.fields.DateField(blank=True, db_column='DateLastSMS', null=True)),
                ('language_name', models.CharField(blank=True, db_column='LanguageName', max_length=10, null=True)),
                ('type_of_payment', models.CharField(blank=True, choices=[('B', 'Bank transfer'), ('C', 'Cash'), ('M', 'Mobile phone'), ('F', 'Funding')], db_column='TypeOfPayment', max_length=50, null=True)),
                ('transfer_fee', models.DecimalField(blank=True, db_column='TransferFee', decimal_places=2, max_digits=18, null=True)),
            ],
            options={
                'db_table': 'tblPayment',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='PaymentDetail',
            fields=[
                ('validity_from', core.fields.DateTimeField(db_column='ValidityFrom', default=datetime.datetime.now)),
                ('validity_to', core.fields.DateTimeField(blank=True, db_column='ValidityTo', null=True)),
                ('legacy_id', models.IntegerField(blank=True, db_column='LegacyID', null=True)),
                ('id', models.BigAutoField(db_column='PaymentDetailsID', primary_key=True, serialize=False)),
                ('product_code', models.CharField(blank=True, db_column='ProductCode', max_length=8, null=True)),
                ('insurance_number', models.CharField(blank=True, db_column='InsuranceNumber', max_length=12, null=True)),
                ('policy_stage', models.CharField(blank=True, db_column='PolicyStage', max_length=1, null=True)),
                ('amount', models.DecimalField(blank=True, db_column='Amount', decimal_places=2, max_digits=18, null=True)),
                ('enrollment_date', core.fields.DateField(blank=True, db_column='enrollmentDate', null=True)),
                ('expected_amount', models.DecimalField(blank=True, db_column='ExpectedAmount', decimal_places=2, max_digits=18, null=True)),
                ('audit_user_id', models.IntegerField(blank=True, db_column='AuditedUserId', null=True)),
            ],
            options={
                'db_table': 'tblPaymentDetails',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='PaymentMutation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('mutation', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='payments', to='core.MutationLog')),
                ('payment', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='mutations', to='payment.Payment')),
            ],
            options={
                'db_table': 'payment_PaymentMutation',
                'managed': True,
            },
            bases=(models.Model, core.models.ObjectMutation),
        ),
    ]
