# coding: utf-8

"""
    MAGIC™ API

    --- # The API for accessing Cythereal MAGIC products and services.  ---  ## Authentication  **(Head to our [/auth](../auth/swagger) api to register, login, or generate a token)**  Supported Authentication Schemes:   * HTTP Basic Authentication  * API-KEY in the `X-API-KEY` request header  * JWT token in the `Authorization:\"Bearer {token}\"` request header  ---  ## Content Negotiation    There are two ways to specify the content type of the response. In order of precedence:     * The **Accept** request header can be set with the desired mime type. The most specific version will prevail. i.e. *application/json* > *application/\\**.       *Accept:\"application/json\"*     * The **format** query parameter. (MUST be in lower case)       *?format=json*    Supported Formats:     | query parameter | Accept Header            |         |    |-----------------|--------------------------|---------|    | **json**        | application/json         | Default |    | **xml**         | application/xml          |         |    | **csv**         | text/csv                 |         |    | **txt**         | text/plain               |         |    | **explain**     | application/explain+json | Custom type that returns a description of usage of the endpoint |  --- ## Requests  Supported HTTP Methods:   * **GET**  * **POST**  * **PATCH**  * **DELETE**  * **HEAD**  * **OPTIONS**  Every request supports the following query parameters:   * **explain** - (bool) - Returns a detailed explanation of what the endpoint does, as well as potential query parameters that can be used to customize the results    * **download** - (bool) - If set to a truthy value, acts as setting the 'Content-Disposition' header to *\"attachment;\"* and will download the response as a file.   * **filename** - (str) - The filename to use for a downloaded file. Ignored if no file is being downloaded.        * **format** - (str) - Used in a similar manner to the *Accept* Header. Use this to specify which format you want the response returned in. Defaults to *application/json*. Current acceptable values are:      * **json** - (application/json)     * **xml** - (application/xml)     * **csv** - (text/csv)     * **txt** - (text/plain)     * **explain** - (application/explain+json)         * Custom type that returns a description of usage of the endpoint   * **no_links** - (bool) - If set to a truthy value, links will be disabled from the response   * **uri** - (bool) - If set to a truthy value, id lists will be returned as uris instead of id strings.  ---  ## GET Conventions ### Possible query parameters:   **(Check each endpoint description, or use *explain*, for a list of available values for each parameter)**    * **read_mask** - A list of values (keys) to return for the resource or each resource within the list     * Comma separated string of variables     * Leaving this field blank will return the default values.     * Setting this value equal to **`*`** will include **ALL** possible keys.     * Traversal is allowed with the **`.`** operator.     * There are three special keys that can be used with all endponts         * **`*`** - This will return all possible values available         * **`_self`** - This will include the resources uri         * **`_default`** - This will include all default values (Those given with an empty read_mask)           * This would typically be used in conjunction with other 'non-default' fields       * Ex:         * `_default,family,category,_self`    * **dynamic_mask** - A list of dynamically generated values to return about the resource or each resource within the list     * Comma separated string of variables     * Operates the same as read_mask, but each variable will incur a much greater time cost.     * *May* cause timeouts     * Leaving this field blank or empty will return no dynamic variables.    * **expand_mask** - A list of relational variables to *expand* upon and return more than just the ids     * Comma separated string of variables     * Leaving this field blank will cause all relational data to be returned as a list of ids     * Ex:         * The `children` field for a file may return a list of ids normally, but with `children` set in the           `expand_mask`, it can return a list of child File objects with greater details.  ---  ## POST Conventions  This will create a new resource.  The resource data shall be provided in the request body.  The response will be either a 200 or 201, along with a uri to the newly created resource in the `Location` header.  In the case of a long running job, or reprocess, the response will be a 202 along with a **job_id** and it's corresponding **job_uri** that can be used in the */jobs/* endpoint to see the updated status  ---  ## PATCH Conventions   * The update data shall be provided in the request body.  ### Possible query parameters:   **(Check each endpoint description, or use *explain*, for a list of available values for each parameter)**    * **update_mask** - A list of values to update with this request.     * Comma separated string of variables     * This is required to be set for any and all **PATCH** requests to be processed.     * ONLY the specified variables in the update_mask will be updated regardless of the data in the request body.     * An empty or missing *update_mask* **WILL** result in a 400 Bad Request response  ---  ## DELETE Conventions  A successful response will return 204 No Content  ### Possible query parameters:   * **force** - Forces the deletion to go through     * This is required to be set as a truthy value for any and all **DELETE** requests to be processed.     * Not specifying this on a DELETE request (without *explain* set) **WILL** return a 400 Bad Request response   ---  ## *bulk* endpoints  **Bulk** endpoints are the ones that follow the  '*/<resource\\>/bulk/*' convention. They operate in the same fashion as the single resource endpoints ('*/<resource\\>/<resource_id\\>/*') except they can process multiple resources on a single call.  They **MUST** be a **POST** request along with the accompanying request body parameter to work:    * **ids** - A list of ids to operate on (For **GET**, **PATCH**, and **DELETE** bulk requests)   * **resources** - A list of resources to operate on (For **POST** bulk requests)  ### Possible query parameters:   **(Check each endpoint description, or use *explain*, for a list of available actions)**    * **action** - This is a string and can only be one of four values:      * **GET** - Returns a list of the resources, in the same order as provided in the request body.      * **POST** - Acts the same as a post on the pluralized resource endpoint.         * Instead of an **ids** request body parameter being provided in the request body, a **resources** list of new resources must be provided.      * **PATCH** - Acts the same as a patch on a single resource.          * Follows the same **PATCH** conventions from above*      * **DELETE** - Acts the same as a delete on a single resource.          * Follows the same **DELETE** conventions from above*    * **strict** - Causes the bulk endpoint to fail if a single provided id fails     * Boolean     * If set to True, the bulk call will ONLY operate if it is successful on ALL requested resources.     * If even a single resource is non-existent/forbidden, the call will fail and no side effects will take place.  ---  ## Pagination:  Pagination can be done in combination with sorting and filtering on most endpoints that deal with lists (including **PATCH** and **DELETE** calls)  ### Pagination query paramters:        * **page_size** - The number of results to return (default: 50)   * **page_count** - The page used in pagination (default: 1)   * **skip_count** - A specified number of values to skip before collecting values (default: 0)  ---  ## Sorting:  Sorting can be done in combination with filtering and pagination on most endpoints that deal with lists (including **PATCH** and **DELETE** calls)  ### Sorting query parameter:   **(Check each endpoint description, or use *explain*, for a list of available sorters)**    * **order_by** - A list of variables to sort the query on     * Comma separated string of variables     * Regex Pattern - `^(-?[\\w]+,?)*$`     * Variables are sorted in ascending order by default     * Prepend the variable with a `-` to change it to descending order     * Multiple sorters can be specified, with precedence matching the order of the parameter     * Ex:         * `-object_class,create_time`  ---  ## Filtering:  Filtering can be done in combination with pagination and sorting on most endpoints that deal with lists (including **PATCH** and **DELETE** calls)  ### Filters query parameter:   **(Check each endpoint description, or use *explain*, for a list of available filters)**    * **filters** - A string of filters used to narrow down the query results.     * Semi-colon separated string of variables     * Regex patterns:         * Single filter:             * `^\\ *(NOT\\ +)?[\\w]+__[a-z]+\\(.+\\)\\ *`              * `NOT variable__comparator(value)`          * Multiple Filters:             * `^{SINGLE_FILTER_REGEX}(\\ +(AND|OR|;)\\ +{SINGLE_FILTER_REGEX})*$`              * `NOT variable__comparator(value) AND NOT variable__comparator(value); variable__comparator(value)`      * Logical operator order of precedence:         * **AND**         * **OR**         * **;** **(Semi-colon separation denotes conjunction)**         * Example order of precedence:             * **exp1;exp2 AND exp3 OR exp4** is equivalent to **(exp1) AND ((exp2 AND exp3) OR (exp4))**      * Available Comparators:         * **eq** - Equal         * **ne** - Not Equal         * **lt** - Less than         * **lte** - Less than or equal         * **gt** - Greater than         * **gte** - Greater than or equal         * **in** - In (for list values)         * **nin** - Not In (for list values)         * **regex** - Regular Expression Match         * **iregex** - Case Insensitive Regular Expression Match      * The format for **in** and **nin** which operate on arrays is:         * **[]** - The list of values must be enclosed within brackets.         * **,** - The value separtion token is a comma.         * **<variable\\>__<comp\\>([<value1\\>,<value2\\>])**      * Examples:         * `create_time__gte(2022-01-01T13:11:02);object_class__regex(binary.*)`          * `create_time__gte(2022-01-01) AND create_time__lt(2022-02-01) AND NOT match_count__gt(10)`          * `create_time__gte(2022-01-01) AND create_time__lt(2022-02-01)`  ---  ## Responses  All responses **WILL** be of type `APIResponse` and contain the following fields:  * `success` | Boolean value indicating if the operation succeeded.  * `status` | Status code. Corresponds to the HTTP status code.   * `message` | A human readable message providing more details about the operation.  * `links` | A dictionary of `name`: `uri` links providing navigation and state-based actions on resources  * `errors` | Array of error objects. An error object contains the following properties:      * `reason` | Unique identifier for this error. Ex: \"FileNotFoundError\".      * `message`| Human readable error message.      * `parameter`| The parameter (if any) that caused the issue.  Successful operations **MUST** return a `SuccessResponse`, which extends `APIResponse` by adding:  * `success` | **MUST** equal True  * `resource` | Properties containing the response object.     * (In the case of a single entity being returned)  **OR**  * `resources` | A list of response objects.     * (In the case of a list of entities being returned)  Failed Operations **MUST** return an `ErrorResponse`, which extends `APIResponse` by adding:  * `success` | **MUST** equal False.  Common Failed Operations that you may hit on any of the endpoint operations:  * 400 - Bad Request - The request is malformed  * 401 - Unauthorized - All endpoints require authorization  * 403 - Forbidden - The endpoint (with the given parameters) is not available to you  * 404 - Not Found - The endpoint doesn't exist, or the resource being searched for doesn't exist  ---  ## Example Inputs  Here are some example inputs that can be used for testing the service:  * `binary_id`: **ff9790d7902fea4c910b182f6e0b00221a40d616**  * `proc_rva`: **0x1000**  * `search_query`: **ransomware**  ---   # noqa: E501

    OpenAPI spec version: 2.0.0 (v2)
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cythereal_magic.api_client import ApiClient


class IndicatorsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_ioc(self, value2, type2, value, type, **kwargs):  # noqa: E501
        """Manually creates a new indicator of compromise  # noqa: E501

           Manually creates a new indicator of compromise           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ioc(value2, type2, value, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str value2: (required)
        :param object type2: (required)
        :param str value: (required)
        :param object type: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ioc_with_http_info(value2, type2, value, type, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ioc_with_http_info(value2, type2, value, type, **kwargs)  # noqa: E501
            return data

    def create_ioc_with_http_info(self, value2, type2, value, type, **kwargs):  # noqa: E501
        """Manually creates a new indicator of compromise  # noqa: E501

           Manually creates a new indicator of compromise           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ioc_with_http_info(value2, type2, value, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str value2: (required)
        :param object type2: (required)
        :param str value: (required)
        :param object type: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['value2', 'type2', 'value', 'type', 'explain', 'format', 'download', 'filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ioc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'value2' is set
        if ('value2' not in params or
                params['value2'] is None):
            raise ValueError("Missing the required parameter `value2` when calling `create_ioc`")  # noqa: E501
        # verify the required parameter 'type2' is set
        if ('type2' not in params or
                params['type2'] is None):
            raise ValueError("Missing the required parameter `type2` when calling `create_ioc`")  # noqa: E501
        # verify the required parameter 'value' is set
        if ('value' not in params or
                params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `create_ioc`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `create_ioc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'explain' in params:
            query_params.append(('explain', params['explain']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'download' in params:
            query_params.append(('download', params['download']))  # noqa: E501
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'value' in params:
            form_params.append(('value', params['value']))  # noqa: E501
        if 'type' in params:
            form_params.append(('type', params['type']))  # noqa: E501
        if 'value' in params:
            form_params.append(('value', params['value']))  # noqa: E501
        if 'type' in params:
            form_params.append(('type', params['type']))  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Api Key Header Authentication', 'Api Key Query Authentication', 'Basic Authentication', 'JWT Access Token Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ioc(self, value2, type2, value, type, **kwargs):  # noqa: E501
        """Manually creates a new indicator of compromise  # noqa: E501

           Manually creates a new indicator of compromise           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ioc(value2, type2, value, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str value2: (required)
        :param object type2: (required)
        :param str value: (required)
        :param object type: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ioc_with_http_info(value2, type2, value, type, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ioc_with_http_info(value2, type2, value, type, **kwargs)  # noqa: E501
            return data

    def create_ioc_with_http_info(self, value2, type2, value, type, **kwargs):  # noqa: E501
        """Manually creates a new indicator of compromise  # noqa: E501

           Manually creates a new indicator of compromise           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ioc_with_http_info(value2, type2, value, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str value2: (required)
        :param object type2: (required)
        :param str value: (required)
        :param object type: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['value2', 'type2', 'value', 'type', 'explain', 'format', 'download', 'filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ioc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'value2' is set
        if ('value2' not in params or
                params['value2'] is None):
            raise ValueError("Missing the required parameter `value2` when calling `create_ioc`")  # noqa: E501
        # verify the required parameter 'type2' is set
        if ('type2' not in params or
                params['type2'] is None):
            raise ValueError("Missing the required parameter `type2` when calling `create_ioc`")  # noqa: E501
        # verify the required parameter 'value' is set
        if ('value' not in params or
                params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `create_ioc`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `create_ioc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'explain' in params:
            query_params.append(('explain', params['explain']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'download' in params:
            query_params.append(('download', params['download']))  # noqa: E501
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'value' in params:
            form_params.append(('value', params['value']))  # noqa: E501
        if 'type' in params:
            form_params.append(('type', params['type']))  # noqa: E501
        if 'value' in params:
            form_params.append(('value', params['value']))  # noqa: E501
        if 'type' in params:
            form_params.append(('type', params['type']))  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Api Key Header Authentication', 'Api Key Query Authentication', 'Basic Authentication', 'JWT Access Token Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ioc(self, body, **kwargs):  # noqa: E501
        """Manually creates a new indicator of compromise  # noqa: E501

           Manually creates a new indicator of compromise           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ioc(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IndicatorRequest body: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ioc_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ioc_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_ioc_with_http_info(self, body, **kwargs):  # noqa: E501
        """Manually creates a new indicator of compromise  # noqa: E501

           Manually creates a new indicator of compromise           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ioc_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IndicatorRequest body: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'explain', 'format', 'download', 'filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ioc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_ioc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'explain' in params:
            query_params.append(('explain', params['explain']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'download' in params:
            query_params.append(('download', params['download']))  # noqa: E501
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'value' in params:
            form_params.append(('value', params['value']))  # noqa: E501
        if 'type' in params:
            form_params.append(('type', params['type']))  # noqa: E501
        if 'value' in params:
            form_params.append(('value', params['value']))  # noqa: E501
        if 'type' in params:
            form_params.append(('type', params['type']))  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Api Key Header Authentication', 'Api Key Query Authentication', 'Basic Authentication', 'JWT Access Token Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_ioc_files(self, **kwargs):  # noqa: E501
        """Lists all ioc files  # noqa: E501

           Lists all ioc files           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ioc_files(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_ioc_files_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_ioc_files_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_ioc_files_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all ioc files  # noqa: E501

           Lists all ioc files           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ioc_files_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['explain', 'format', 'download', 'filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_ioc_files" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'explain' in params:
            query_params.append(('explain', params['explain']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'download' in params:
            query_params.append(('download', params['download']))  # noqa: E501
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Api Key Header Authentication', 'Api Key Query Authentication', 'Basic Authentication', 'JWT Access Token Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/files/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_iocs(self, **kwargs):  # noqa: E501
        """Lists all indicators associated with a user account  # noqa: E501

           Lists all indicators associated with a user account           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_iocs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_iocs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_iocs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_iocs_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all indicators associated with a user account  # noqa: E501

           Lists all indicators associated with a user account           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_iocs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['explain', 'format', 'download', 'filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_iocs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'explain' in params:
            query_params.append(('explain', params['explain']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'download' in params:
            query_params.append(('download', params['download']))  # noqa: E501
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Api Key Header Authentication', 'Api Key Query Authentication', 'Basic Authentication', 'JWT Access Token Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_ioc_file(self, filedata2, filedata, **kwargs):  # noqa: E501
        """Upload a text or csv file for IoC Extraction  # noqa: E501

           Upload a text or csv file for IoC Extraction           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_ioc_file(filedata2, filedata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filedata2: (required)
        :param str filedata: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: IocFileUploadedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_ioc_file_with_http_info(filedata2, filedata, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_ioc_file_with_http_info(filedata2, filedata, **kwargs)  # noqa: E501
            return data

    def upload_ioc_file_with_http_info(self, filedata2, filedata, **kwargs):  # noqa: E501
        """Upload a text or csv file for IoC Extraction  # noqa: E501

           Upload a text or csv file for IoC Extraction           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_ioc_file_with_http_info(filedata2, filedata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filedata2: (required)
        :param str filedata: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: IocFileUploadedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filedata2', 'filedata', 'explain', 'format', 'download', 'filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_ioc_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'filedata2' is set
        if ('filedata2' not in params or
                params['filedata2'] is None):
            raise ValueError("Missing the required parameter `filedata2` when calling `upload_ioc_file`")  # noqa: E501
        # verify the required parameter 'filedata' is set
        if ('filedata' not in params or
                params['filedata'] is None):
            raise ValueError("Missing the required parameter `filedata` when calling `upload_ioc_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'explain' in params:
            query_params.append(('explain', params['explain']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'download' in params:
            query_params.append(('download', params['download']))  # noqa: E501
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'filedata' in params:
            local_var_files['filedata'] = params['filedata']  # noqa: E501
        if 'filedata' in params:
            local_var_files['filedata'] = params['filedata']  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/explain+json', 'application/xml', 'text/csv', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Api Key Header Authentication', 'Api Key Query Authentication', 'Basic Authentication', 'JWT Access Token Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/files/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IocFileUploadedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_ioc_file(self, filedata2, filedata, **kwargs):  # noqa: E501
        """Upload a text or csv file for IoC Extraction  # noqa: E501

           Upload a text or csv file for IoC Extraction           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_ioc_file(filedata2, filedata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filedata2: (required)
        :param str filedata: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: IocFileUploadedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_ioc_file_with_http_info(filedata2, filedata, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_ioc_file_with_http_info(filedata2, filedata, **kwargs)  # noqa: E501
            return data

    def upload_ioc_file_with_http_info(self, filedata2, filedata, **kwargs):  # noqa: E501
        """Upload a text or csv file for IoC Extraction  # noqa: E501

           Upload a text or csv file for IoC Extraction           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_ioc_file_with_http_info(filedata2, filedata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filedata2: (required)
        :param str filedata: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: IocFileUploadedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filedata2', 'filedata', 'explain', 'format', 'download', 'filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_ioc_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'filedata2' is set
        if ('filedata2' not in params or
                params['filedata2'] is None):
            raise ValueError("Missing the required parameter `filedata2` when calling `upload_ioc_file`")  # noqa: E501
        # verify the required parameter 'filedata' is set
        if ('filedata' not in params or
                params['filedata'] is None):
            raise ValueError("Missing the required parameter `filedata` when calling `upload_ioc_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'explain' in params:
            query_params.append(('explain', params['explain']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'download' in params:
            query_params.append(('download', params['download']))  # noqa: E501
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'filedata' in params:
            local_var_files['filedata'] = params['filedata']  # noqa: E501
        if 'filedata' in params:
            local_var_files['filedata'] = params['filedata']  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/explain+json', 'application/xml', 'text/csv', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Api Key Header Authentication', 'Api Key Query Authentication', 'Basic Authentication', 'JWT Access Token Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/files/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IocFileUploadedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_ioc_file(self, body, **kwargs):  # noqa: E501
        """Upload a text or csv file for IoC Extraction  # noqa: E501

           Upload a text or csv file for IoC Extraction           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_ioc_file(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UploadIocFileRequest body: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: IocFileUploadedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_ioc_file_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_ioc_file_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def upload_ioc_file_with_http_info(self, body, **kwargs):  # noqa: E501
        """Upload a text or csv file for IoC Extraction  # noqa: E501

           Upload a text or csv file for IoC Extraction           # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_ioc_file_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UploadIocFileRequest body: (required)
        :param bool explain:  Shows the explain for this endpoint 
        :param str format:  Format of the response from this endpoint 
        :param bool download:  Determines whether to download the response. (Content-Disposition:\"attachment\" vs \"inline\") 
        :param str filename: If download is True, this sets the name of the file. (Content-Disposition:\"attachment; filename=`filename`\")
        :return: IocFileUploadedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'explain', 'format', 'download', 'filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_ioc_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `upload_ioc_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'explain' in params:
            query_params.append(('explain', params['explain']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'download' in params:
            query_params.append(('download', params['download']))  # noqa: E501
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'filedata' in params:
            local_var_files['filedata'] = params['filedata']  # noqa: E501
        if 'filedata' in params:
            local_var_files['filedata'] = params['filedata']  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/explain+json', 'application/xml', 'text/csv', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Api Key Header Authentication', 'Api Key Query Authentication', 'Basic Authentication', 'JWT Access Token Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/indicators/files/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IocFileUploadedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
