"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgePutEvents = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * A StepFunctions Task to send events to an EventBridge event bus.
 *
 * @stability stable
 */
class EventBridgePutEvents extends sfn.TaskStateBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EventBridgePutEventsProps(props);
        this.integrationPattern = (_b = props.integrationPattern) !== null && _b !== void 0 ? _b : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, EventBridgePutEvents.SUPPORTED_INTEGRATION_PATTERNS);
        if (this.integrationPattern === sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN) {
            if (!sfn.FieldUtils.containsTaskToken(props.entries.map(entry => entry.detail))) {
                throw new Error('Task Token is required in `entries`. Use JsonPath.taskToken to set the token.');
            }
        }
        this.validateEntries();
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: ['events:PutEvents'],
                resources: this.eventBusArns,
            }),
        ];
    }
    /**
     * Returns an array of EventBusArn strings based on this.props.entries
     */
    get eventBusArns() {
        return this.props.entries
            .map(entry => {
            if (entry.eventBus) {
                // If an eventBus is provided, use the corresponding ARN
                return entry.eventBus.eventBusArn;
            }
            else {
                // If neither an eventBus nor eventBusName is provided,
                // format the ARN for the default event bus in the account.
                return cdk.Stack.of(this).formatArn({
                    resource: 'event-bus',
                    resourceName: 'default',
                    arnFormat: cdk.ArnFormat.SLASH_RESOURCE_NAME,
                    service: 'events',
                });
            }
        });
    }
    /**
     * Provides the EventBridge put events service integration task configuration
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('events', 'putEvents', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                Entries: this.renderEntries(),
            }),
        };
    }
    renderEntries() {
        return this.props.entries.map(entry => {
            var _b, _c, _d;
            if ((_b = entry.source) === null || _b === void 0 ? void 0 : _b.startsWith('aws')) {
                throw new Error('Event source cannot start with "aws."');
            }
            else {
                return {
                    Detail: (_c = entry.detail) === null || _c === void 0 ? void 0 : _c.value,
                    DetailType: entry.detailType,
                    EventBusName: (_d = entry.eventBus) === null || _d === void 0 ? void 0 : _d.eventBusArn,
                    Source: entry.source,
                };
            }
        });
    }
    validateEntries() {
        if (this.props.entries.length <= 0) {
            throw new Error('Value for property `entries` must be a non-empty array.');
        }
    }
}
exports.EventBridgePutEvents = EventBridgePutEvents;
_a = JSII_RTTI_SYMBOL_1;
EventBridgePutEvents[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EventBridgePutEvents", version: "1.137.0" };
EventBridgePutEvents.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
];
//# sourceMappingURL=data:application/json;base64,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