# Generated by Django 2.2 on 2019-04-05 23:08

from django.db import migrations

def update_parts_to_part_history(apps, schema_editor):
    Part = apps.get_model('bom', 'Part')
    PartChangeHistory = apps.get_model('bom', 'PartChangeHistory')
    Assembly = apps.get_model('bom', 'Assembly')
    Subpart = apps.get_model('bom', 'Subpart')

    for p in Part.objects.all():
        subparts = Subpart.objects.filter(assembly_part=p)
        assembly = None
        if subparts.count() > 0:
            assembly = Assembly.objects.create()
            assembly.subparts.set(subparts)

        try:
            PartChangeHistory.objects.get_or_create(part=p, description=p.description,
                                                    revision=p.revision, assembly=assembly)
        except PartChangeHistory.MultipleObjectsReturned:
            continue

    for sp in Subpart.objects.all():
        part = sp.assembly_subpart
        pch = PartChangeHistory.objects.filter(part=part).order_by('-revision').first()
        sp.part_revision = pch
        sp.save()

class Migration(migrations.Migration):

    dependencies = [
        ('bom', '0015_auto_20190303_1915'),
    ]

    operations = [
        migrations.RunPython(update_parts_to_part_history),
        migrations.RemoveField(
            model_name='part',
            name='description',
        ),
        migrations.RemoveField(
            model_name='part',
            name='revision',
        ),
        migrations.RemoveField(
            model_name='part',
            name='subparts',
        ),
        migrations.RemoveField(
            model_name='subpart',
            name='assembly_part',
        ),
        migrations.RemoveField(
            model_name='subpart',
            name='assembly_subpart',
        ),
    ]
