# Social

## Contributing

Contributions are welcome. Follows a list of possible ways in which you could do it:

* Testing as end user. Install "nis-backend" (this repository) and execute it, launching the user interface to specify and submit case studies, maybe with the help of an external spreadsheet software. Use Github issues when you find incorrect behavior. Please follow [Mastering Issues](https://guides.github.com/features/issues/) guidelines.
* Testing as scripts developer. Install "nis-backend" and use it in your scripts using either NIS class or the subproject [nis-client](https://github.com/MAGIC-nexus/nis-python-client) connecting it to a running "nis-backend".
* Prepare reusable MuSIASEM library files, containing model parts, like structures of high level functions in different domains (water, energy, food), interface type hierarchies, technical data about structurals, mappings from specific official statistical datasets to MuSIASEM interface types, calculation of scalar indicators, benchmarks, etc. All of them may be compiled in separate files, as long as the composition of them is consistent.
* If you are a developer willing to contribute to "nis-backend", please mail one of the contact persons (see Contact below) to discuss some of the features and improvements which could be interesting to have implemented. Once you are ready to contribute, please do it through Github Pull Requests, following the [standard PR workflow](https://guides.github.com/introduction/flow/).

The standard [contributor covenant](../CODE_OF_CONDUCT.md) code of conduct is earnestly applied in interactions with the community.

## People

An enumeration of people who have contributed in different manners to the elaboration of NIS during MAGIC project lifetime:

* Rafael Nebot. ITC-DCCT (Instituto Tecnológico de Canarias - Departamento de Computación).
* Marco Galluzzi.
* Michele Staiano. UniNa (Università degli Studi di Napoli Federico II). NIS supervisor, mentor, catalyzer.
* Paula Moreno. ITC-DCCT.
* Mario Giampietro, Ansel Renner, Violeta Cabello, Cristina Madrid, Maddalena Rippa, Juan Cadillo, Raúl Velasco, Louisa di Felice, Sandra Bukkens. ICTA-UAB (Institut de Ciència i Tecnologia Ambientals - Universitat Autònoma de Barcelona). MuSIASEM creators and mentors, analysts.
* Ignacio López.
* Alberto Sosa, Francisco Socorro, María Artiles, Carlos Caraballo, Ivet Cabrera. Internship students at ITC-DCCT.

## Contact

Please send any question regarding this repository to [rnebot@itccanarias.org](mailto:rnebot@itccanarias.org).
