# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class PageConversionResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'filename': 'str',
        'file_bytes': 'str'
    }

    attribute_map = {
        'filename': 'Filename',
        'file_bytes': 'FileBytes'
    }

    def __init__(self, filename=None, file_bytes=None):  # noqa: E501
        """PageConversionResult - a model defined in Swagger"""  # noqa: E501

        self._filename = None
        self._file_bytes = None
        self.discriminator = None

        if filename is not None:
            self.filename = filename
        if file_bytes is not None:
            self.file_bytes = file_bytes

    @property
    def filename(self):
        """Gets the filename of this PageConversionResult.  # noqa: E501

        File name of the image in the converted file format  # noqa: E501

        :return: The filename of this PageConversionResult.  # noqa: E501
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """Sets the filename of this PageConversionResult.

        File name of the image in the converted file format  # noqa: E501

        :param filename: The filename of this PageConversionResult.  # noqa: E501
        :type: str
        """

        self._filename = filename

    @property
    def file_bytes(self):
        """Gets the file_bytes of this PageConversionResult.  # noqa: E501

        File bytes (contents) of the image in converted file format  # noqa: E501

        :return: The file_bytes of this PageConversionResult.  # noqa: E501
        :rtype: str
        """
        return self._file_bytes

    @file_bytes.setter
    def file_bytes(self, file_bytes):
        """Sets the file_bytes of this PageConversionResult.

        File bytes (contents) of the image in converted file format  # noqa: E501

        :param file_bytes: The file_bytes of this PageConversionResult.  # noqa: E501
        :type: str
        """
        if file_bytes is not None and not re.search(r'^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', file_bytes):  # noqa: E501
            raise ValueError(r"Invalid value for `file_bytes`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")  # noqa: E501

        self._file_bytes = file_bytes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PageConversionResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PageConversionResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
