from typing import TypeVar

from java.lang import Object

R = TypeVar("R")
T = TypeVar("T")
U = TypeVar("U")

class BiPredicate:
    def negate(self) -> BiPredicate: ...
    def test(self, t: T, u: U) -> bool: ...

class Consumer:
    def accept(self, t: T) -> None: ...
    def andThen(self, after: Consumer) -> Consumer: ...

class Function:
    def andThen(self, after: Function) -> Function: ...
    def apply(self, t: T) -> R: ...
    def compose(self, before: Function) -> Function: ...
    @staticmethod
    def identity() -> Function: ...

class Predicate:
    @staticmethod
    def isEqual(targetRef: Object) -> Predicate: ...
    def negate(self) -> Predicate: ...
    def test(self, t: T) -> bool: ...

class Supplier:
    def get(self) -> T: ...

class ToDoubleFunction:
    def applyAsDouble(self, value: T) -> object: ...

class ToIntFunction:
    def applyAsInt(self, value: T) -> object: ...

class ToLongFunction:
    def applyAsLong(self, value: T) -> object: ...
