from typing import Any, List

from com.inductiveautomation.ignition.common import Path, QualifiedPath
from com.inductiveautomation.ignition.common.config import Property
from java.lang import Class, Enum, Object, String
from java.util import Date

class EventProperty(Object):
    @staticmethod
    def create(prop: Property, type: EventPropertyType) -> EventProperty: ...
    @staticmethod
    def createDynamic(prop: Property, isConfig: bool) -> EventProperty: ...
    @staticmethod
    def createStatic(prop: Property, isConfig: bool) -> EventProperty: ...
    def getDefaultValue(self) -> Object: ...
    def getName(self) -> String: ...
    def getPropertyType(self) -> EventPropertyType: ...
    def getType(self) -> Class: ...

class EventPropertyType(Enum):
    @staticmethod
    def values() -> List[EventPropertyType]: ...

class ShelvedPath(Object):
    def __init__(self, *args: Any) -> None: ...
    def getExpiration(self) -> Date: ...
    def getHitCount(self) -> int: ...
    def getPath(self) -> Path: ...
    def getShelveTime(self) -> Date: ...
    def getUser(self) -> QualifiedPath: ...
    def incrementHitCount(self) -> None: ...
    def isExpired(self) -> bool: ...
