# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'CloudProjectContainerRegistryPlan',
    'CloudProjectContainerRegistryPlanFeature',
    'CloudProjectContainerRegistryPlanRegistryLimit',
    'CloudProjectDatabaseEndpoint',
    'CloudProjectDatabaseNode',
    'CloudProjectKubeNodePoolTemplate',
    'CloudProjectKubeNodePoolTemplateMetadata',
    'CloudProjectKubeNodePoolTemplateSpec',
    'CloudProjectKubePrivateNetworkConfiguration',
    'CloudProjectNetworkPrivateRegionsAttribute',
    'CloudProjectNetworkPrivateRegionsStatus',
    'CloudProjectNetworkPrivateSubnetIpPool',
    'CloudProjectOrder',
    'CloudProjectOrderDetail',
    'CloudProjectPlan',
    'CloudProjectPlanConfiguration',
    'CloudProjectPlanOption',
    'CloudProjectPlanOptionConfiguration',
    'CloudProjectUserRole',
    'DbaasLogsInputConfiguration',
    'DbaasLogsInputConfigurationFlowgger',
    'DbaasLogsInputConfigurationLogstash',
    'DedicatedServiceInstallTaskDetails',
    'DomainZoneOrder',
    'DomainZoneOrderDetail',
    'DomainZonePlan',
    'DomainZonePlanConfiguration',
    'DomainZonePlanOption',
    'DomainZonePlanOptionConfiguration',
    'IpLoadBalancingHttpFarmProbe',
    'IpLoadBalancingHttpRouteAction',
    'IpLoadBalancingHttpRouteRule',
    'IpLoadBalancingOrder',
    'IpLoadBalancingOrderDetail',
    'IpLoadBalancingOrderableZone',
    'IpLoadBalancingPlan',
    'IpLoadBalancingPlanConfiguration',
    'IpLoadBalancingPlanOption',
    'IpLoadBalancingPlanOptionConfiguration',
    'IpLoadBalancingTcpFarmProbe',
    'IpLoadBalancingTcpRouteAction',
    'IpLoadBalancingTcpRouteRule',
    'IpServiceOrder',
    'IpServiceOrderDetail',
    'IpServicePlan',
    'IpServicePlanConfiguration',
    'IpServicePlanOption',
    'IpServicePlanOptionConfiguration',
    'IpServiceRoutedTo',
    'VrackOrder',
    'VrackOrderDetail',
    'VrackPlan',
    'VrackPlanConfiguration',
    'VrackPlanOption',
    'VrackPlanOptionConfiguration',
    'GetCloudProjectCapabilitiesContainerFilterFeatureResult',
    'GetCloudProjectCapabilitiesContainerFilterRegistryLimitResult',
    'GetCloudProjectCapabilitiesContainerRegistryResultResult',
    'GetCloudProjectCapabilitiesContainerRegistryResultPlanResult',
    'GetCloudProjectCapabilitiesContainerRegistryResultPlanFeatureResult',
    'GetCloudProjectCapabilitiesContainerRegistryResultPlanRegistryLimitResult',
    'GetCloudProjectContainerRegistriesResultResult',
    'GetCloudProjectContainerRegistryUsersResultResult',
    'GetCloudProjectDatabaseEndpointResult',
    'GetCloudProjectDatabaseNodeResult',
    'GetCloudProjectRegionServiceResult',
    'GetDedicatedServerVniResult',
    'GetIpServiceRoutedToResult',
    'GetMeCurrencyResult',
    'GetMeInstallationTemplateCustomizationResult',
    'GetMeInstallationTemplatePartitionSchemeResult',
    'GetMeInstallationTemplatePartitionSchemeHardwareRaidResult',
    'GetMeInstallationTemplatePartitionSchemePartitionResult',
    'GetOrderCartProductOptionsPlanPriceResult',
    'GetOrderCartProductOptionsPlanPricePriceResult',
    'GetOrderCartProductOptionsPlanSelectedPriceResult',
    'GetOrderCartProductOptionsPlanSelectedPricePriceResult',
    'GetOrderCartProductOptionsResultResult',
    'GetOrderCartProductOptionsResultPriceResult',
    'GetOrderCartProductOptionsResultPricePriceResult',
    'GetOrderCartProductPlanPriceResult',
    'GetOrderCartProductPlanPricePriceResult',
    'GetOrderCartProductPlanSelectedPriceResult',
    'GetOrderCartProductPlanSelectedPricePriceResult',
    'GetOrderCartProductResultResult',
    'GetOrderCartProductResultPriceResult',
    'GetOrderCartProductResultPricePriceResult',
]

@pulumi.output_type
class CloudProjectContainerRegistryPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "registryLimits":
            suggest = "registry_limits"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudProjectContainerRegistryPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudProjectContainerRegistryPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudProjectContainerRegistryPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 created_at: Optional[str] = None,
                 features: Optional[Sequence['outputs.CloudProjectContainerRegistryPlanFeature']] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 registry_limits: Optional[Sequence['outputs.CloudProjectContainerRegistryPlanRegistryLimit']] = None,
                 updated_at: Optional[str] = None):
        """
        :param str code: Plan code from the catalog
        :param str created_at: Plan creation date
        :param Sequence['CloudProjectContainerRegistryPlanFeatureArgs'] features: Features of the plan
        :param str id: Plan ID
        :param str name: Registry name
        :param Sequence['CloudProjectContainerRegistryPlanRegistryLimitArgs'] registry_limits: Container registry limits
        :param str updated_at: Registry last update date
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registry_limits is not None:
            pulumi.set(__self__, "registry_limits", registry_limits)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Plan code from the catalog
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        Plan creation date
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def features(self) -> Optional[Sequence['outputs.CloudProjectContainerRegistryPlanFeature']]:
        """
        Features of the plan
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Plan ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Registry name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="registryLimits")
    def registry_limits(self) -> Optional[Sequence['outputs.CloudProjectContainerRegistryPlanRegistryLimit']]:
        """
        Container registry limits
        """
        return pulumi.get(self, "registry_limits")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        Registry last update date
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class CloudProjectContainerRegistryPlanFeature(dict):
    def __init__(__self__, *,
                 vulnerability: Optional[bool] = None):
        """
        :param bool vulnerability: Vulnerability scanning
        """
        if vulnerability is not None:
            pulumi.set(__self__, "vulnerability", vulnerability)

    @property
    @pulumi.getter
    def vulnerability(self) -> Optional[bool]:
        """
        Vulnerability scanning
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class CloudProjectContainerRegistryPlanRegistryLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageStorage":
            suggest = "image_storage"
        elif key == "parallelRequest":
            suggest = "parallel_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudProjectContainerRegistryPlanRegistryLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudProjectContainerRegistryPlanRegistryLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudProjectContainerRegistryPlanRegistryLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_storage: Optional[int] = None,
                 parallel_request: Optional[int] = None):
        """
        :param int image_storage: Docker image storage limits in bytes
        :param int parallel_request: Parallel requests on Docker image API (/v2 Docker registry API)
        """
        if image_storage is not None:
            pulumi.set(__self__, "image_storage", image_storage)
        if parallel_request is not None:
            pulumi.set(__self__, "parallel_request", parallel_request)

    @property
    @pulumi.getter(name="imageStorage")
    def image_storage(self) -> Optional[int]:
        """
        Docker image storage limits in bytes
        """
        return pulumi.get(self, "image_storage")

    @property
    @pulumi.getter(name="parallelRequest")
    def parallel_request(self) -> Optional[int]:
        """
        Parallel requests on Docker image API (/v2 Docker registry API)
        """
        return pulumi.get(self, "parallel_request")


@pulumi.output_type
class CloudProjectDatabaseEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sslMode":
            suggest = "ssl_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudProjectDatabaseEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudProjectDatabaseEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudProjectDatabaseEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component: Optional[str] = None,
                 domain: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None,
                 scheme: Optional[str] = None,
                 ssl: Optional[bool] = None,
                 ssl_mode: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str component: Type of component the URI relates to.
        :param str domain: Domain of the cluster.
        :param str path: Path of the endpoint.
        :param int port: Connection port for the endpoint.
        :param str scheme: Scheme used to generate the URI.
        :param bool ssl: Defines whether the endpoint uses SSL.
        :param str ssl_mode: SSL mode used to connect to the service if the SSL is enabled.
        :param str uri: URI of the endpoint.
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def component(self) -> Optional[str]:
        """
        Type of component the URI relates to.
        """
        return pulumi.get(self, "component")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        Domain of the cluster.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path of the endpoint.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Connection port for the endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[str]:
        """
        Scheme used to generate the URI.
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def ssl(self) -> Optional[bool]:
        """
        Defines whether the endpoint uses SSL.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[str]:
        """
        SSL mode used to connect to the service if the SSL is enabled.
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        URI of the endpoint.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class CloudProjectDatabaseNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudProjectDatabaseNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudProjectDatabaseNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudProjectDatabaseNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: str,
                 network_id: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        :param str region: Public cloud region in which the node should be deployed.
               Ex: "GRA'.
        :param str network_id: Private network id in which the node should be deployed.
        :param str subnet_id: Private subnet ID in which the node is.
        """
        pulumi.set(__self__, "region", region)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Public cloud region in which the node should be deployed.
        Ex: "GRA'.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[str]:
        """
        Private network id in which the node should be deployed.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        Private subnet ID in which the node is.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class CloudProjectKubeNodePoolTemplate(dict):
    def __init__(__self__, *,
                 metadata: Optional['outputs.CloudProjectKubeNodePoolTemplateMetadata'] = None,
                 spec: Optional['outputs.CloudProjectKubeNodePoolTemplateSpec'] = None):
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.CloudProjectKubeNodePoolTemplateMetadata']:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.CloudProjectKubeNodePoolTemplateSpec']:
        return pulumi.get(self, "spec")


@pulumi.output_type
class CloudProjectKubeNodePoolTemplateMetadata(dict):
    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, str]] = None,
                 finalizers: Optional[Sequence[str]] = None,
                 labels: Optional[Mapping[str, str]] = None):
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def finalizers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "finalizers")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "labels")


@pulumi.output_type
class CloudProjectKubeNodePoolTemplateSpec(dict):
    def __init__(__self__, *,
                 taints: Optional[Sequence[Mapping[str, Any]]] = None,
                 unschedulable: Optional[bool] = None):
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence[Mapping[str, Any]]]:
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter
    def unschedulable(self) -> Optional[bool]:
        return pulumi.get(self, "unschedulable")


@pulumi.output_type
class CloudProjectKubePrivateNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultVrackGateway":
            suggest = "default_vrack_gateway"
        elif key == "privateNetworkRoutingAsDefault":
            suggest = "private_network_routing_as_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudProjectKubePrivateNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudProjectKubePrivateNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudProjectKubePrivateNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_vrack_gateway: str,
                 private_network_routing_as_default: bool):
        pulumi.set(__self__, "default_vrack_gateway", default_vrack_gateway)
        pulumi.set(__self__, "private_network_routing_as_default", private_network_routing_as_default)

    @property
    @pulumi.getter(name="defaultVrackGateway")
    def default_vrack_gateway(self) -> str:
        return pulumi.get(self, "default_vrack_gateway")

    @property
    @pulumi.getter(name="privateNetworkRoutingAsDefault")
    def private_network_routing_as_default(self) -> bool:
        return pulumi.get(self, "private_network_routing_as_default")


@pulumi.output_type
class CloudProjectNetworkPrivateRegionsAttribute(dict):
    def __init__(__self__, *,
                 status: str,
                 openstackid: Optional[str] = None,
                 region: Optional[str] = None):
        """
        :param str status: the status of the network. should be normally set to 'ACTIVE'.
        """
        pulumi.set(__self__, "status", status)
        if openstackid is not None:
            pulumi.set(__self__, "openstackid", openstackid)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        the status of the network. should be normally set to 'ACTIVE'.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def openstackid(self) -> Optional[str]:
        return pulumi.get(self, "openstackid")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")


@pulumi.output_type
class CloudProjectNetworkPrivateRegionsStatus(dict):
    def __init__(__self__, *,
                 status: str,
                 region: Optional[str] = None):
        """
        :param str status: the status of the network. should be normally set to 'ACTIVE'.
        """
        pulumi.set(__self__, "status", status)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        the status of the network. should be normally set to 'ACTIVE'.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")


@pulumi.output_type
class CloudProjectNetworkPrivateSubnetIpPool(dict):
    def __init__(__self__, *,
                 dhcp: Optional[bool] = None,
                 end: Optional[str] = None,
                 network: Optional[str] = None,
                 region: Optional[str] = None,
                 start: Optional[str] = None):
        """
        :param bool dhcp: Enable DHCP.
               Changing this forces a new resource to be created. Defaults to false.
               _
        :param str end: Last ip for this region.
               Changing this value recreates the subnet.
        :param str network: Global network in CIDR format.
               Changing this value recreates the subnet
        :param str region: The region in which the network subnet will be created.
               Ex.: "GRA1". Changing this value recreates the resource.
        :param str start: First ip for this region.
               Changing this value recreates the subnet.
        """
        if dhcp is not None:
            pulumi.set(__self__, "dhcp", dhcp)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def dhcp(self) -> Optional[bool]:
        """
        Enable DHCP.
        Changing this forces a new resource to be created. Defaults to false.
        _
        """
        return pulumi.get(self, "dhcp")

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        Last ip for this region.
        Changing this value recreates the subnet.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        Global network in CIDR format.
        Changing this value recreates the subnet
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region in which the network subnet will be created.
        Ex.: "GRA1". Changing this value recreates the resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        First ip for this region.
        Changing this value recreates the subnet.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class CloudProjectOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudProjectOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudProjectOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudProjectOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 details: Optional[Sequence['outputs.CloudProjectOrderDetail']] = None,
                 expiration_date: Optional[str] = None,
                 order_id: Optional[int] = None):
        """
        :param str date: date
        :param Sequence['CloudProjectOrderDetailArgs'] details: Information about a Bill entry
        :param str expiration_date: expiration date
        :param int order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        date
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.CloudProjectOrderDetail']]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[int]:
        """
        order id
        """
        return pulumi.get(self, "order_id")


@pulumi.output_type
class CloudProjectOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudProjectOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudProjectOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudProjectOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 domain: Optional[str] = None,
                 order_detail_id: Optional[int] = None,
                 quantity: Optional[str] = None):
        """
        :param str description: A description associated with the user.
        :param str domain: expiration date
        :param int order_detail_id: order detail id
        :param str quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[int]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[str]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class CloudProjectPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudProjectPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudProjectPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudProjectPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.CloudProjectPlanConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['CloudProjectPlanConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.CloudProjectPlanConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class CloudProjectPlanConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CloudProjectPlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudProjectPlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudProjectPlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudProjectPlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.CloudProjectPlanOptionConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['CloudProjectPlanOptionConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.CloudProjectPlanOptionConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class CloudProjectPlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CloudProjectUserRole(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 permissions: Optional[Sequence[str]] = None):
        """
        :param str description: A description associated with the user.
        :param str id: id of the role
        :param str name: name of the role
        :param Sequence[str] permissions: list of permissions associated with the role
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description associated with the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        id of the role
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name of the role
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[str]]:
        """
        list of permissions associated with the role
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class DbaasLogsInputConfiguration(dict):
    def __init__(__self__, *,
                 flowgger: Optional['outputs.DbaasLogsInputConfigurationFlowgger'] = None,
                 logstash: Optional['outputs.DbaasLogsInputConfigurationLogstash'] = None):
        """
        :param 'DbaasLogsInputConfigurationFlowggerArgs' flowgger: Flowgger configuration
        :param 'DbaasLogsInputConfigurationLogstashArgs' logstash: Logstash configuration
        """
        if flowgger is not None:
            pulumi.set(__self__, "flowgger", flowgger)
        if logstash is not None:
            pulumi.set(__self__, "logstash", logstash)

    @property
    @pulumi.getter
    def flowgger(self) -> Optional['outputs.DbaasLogsInputConfigurationFlowgger']:
        """
        Flowgger configuration
        """
        return pulumi.get(self, "flowgger")

    @property
    @pulumi.getter
    def logstash(self) -> Optional['outputs.DbaasLogsInputConfigurationLogstash']:
        """
        Logstash configuration
        """
        return pulumi.get(self, "logstash")


@pulumi.output_type
class DbaasLogsInputConfigurationFlowgger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logFormat":
            suggest = "log_format"
        elif key == "logFraming":
            suggest = "log_framing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbaasLogsInputConfigurationFlowgger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbaasLogsInputConfigurationFlowgger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbaasLogsInputConfigurationFlowgger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_format: str,
                 log_framing: str):
        """
        :param str log_format: Type of format to decode. One of "RFC5424", "LTSV", "GELF", "CAPNP"
        :param str log_framing: Indicates how messages are delimited. One of "LINE", "NUL", "SYSLEN", "CAPNP"
        """
        pulumi.set(__self__, "log_format", log_format)
        pulumi.set(__self__, "log_framing", log_framing)

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> str:
        """
        Type of format to decode. One of "RFC5424", "LTSV", "GELF", "CAPNP"
        """
        return pulumi.get(self, "log_format")

    @property
    @pulumi.getter(name="logFraming")
    def log_framing(self) -> str:
        """
        Indicates how messages are delimited. One of "LINE", "NUL", "SYSLEN", "CAPNP"
        """
        return pulumi.get(self, "log_framing")


@pulumi.output_type
class DbaasLogsInputConfigurationLogstash(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputSection":
            suggest = "input_section"
        elif key == "filterSection":
            suggest = "filter_section"
        elif key == "patternSection":
            suggest = "pattern_section"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbaasLogsInputConfigurationLogstash. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbaasLogsInputConfigurationLogstash.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbaasLogsInputConfigurationLogstash.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_section: str,
                 filter_section: Optional[str] = None,
                 pattern_section: Optional[str] = None):
        """
        :param str input_section: The filter section of logstash.conf
        :param str filter_section: The filter section of logstash.conf
        :param str pattern_section: The list of customs Grok patterns
        """
        pulumi.set(__self__, "input_section", input_section)
        if filter_section is not None:
            pulumi.set(__self__, "filter_section", filter_section)
        if pattern_section is not None:
            pulumi.set(__self__, "pattern_section", pattern_section)

    @property
    @pulumi.getter(name="inputSection")
    def input_section(self) -> str:
        """
        The filter section of logstash.conf
        """
        return pulumi.get(self, "input_section")

    @property
    @pulumi.getter(name="filterSection")
    def filter_section(self) -> Optional[str]:
        """
        The filter section of logstash.conf
        """
        return pulumi.get(self, "filter_section")

    @property
    @pulumi.getter(name="patternSection")
    def pattern_section(self) -> Optional[str]:
        """
        The list of customs Grok patterns
        """
        return pulumi.get(self, "pattern_section")


@pulumi.output_type
class DedicatedServiceInstallTaskDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "changeLog":
            suggest = "change_log"
        elif key == "customHostname":
            suggest = "custom_hostname"
        elif key == "diskGroupId":
            suggest = "disk_group_id"
        elif key == "installRtm":
            suggest = "install_rtm"
        elif key == "installSqlServer":
            suggest = "install_sql_server"
        elif key == "noRaid":
            suggest = "no_raid"
        elif key == "postInstallationScriptLink":
            suggest = "post_installation_script_link"
        elif key == "postInstallationScriptReturn":
            suggest = "post_installation_script_return"
        elif key == "resetHwRaid":
            suggest = "reset_hw_raid"
        elif key == "softRaidDevices":
            suggest = "soft_raid_devices"
        elif key == "sshKeyName":
            suggest = "ssh_key_name"
        elif key == "useDistribKernel":
            suggest = "use_distrib_kernel"
        elif key == "useSpla":
            suggest = "use_spla"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DedicatedServiceInstallTaskDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DedicatedServiceInstallTaskDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DedicatedServiceInstallTaskDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 change_log: Optional[str] = None,
                 custom_hostname: Optional[str] = None,
                 disk_group_id: Optional[int] = None,
                 install_rtm: Optional[bool] = None,
                 install_sql_server: Optional[bool] = None,
                 language: Optional[str] = None,
                 no_raid: Optional[bool] = None,
                 post_installation_script_link: Optional[str] = None,
                 post_installation_script_return: Optional[str] = None,
                 reset_hw_raid: Optional[bool] = None,
                 soft_raid_devices: Optional[int] = None,
                 ssh_key_name: Optional[str] = None,
                 use_distrib_kernel: Optional[bool] = None,
                 use_spla: Optional[bool] = None):
        """
        :param str change_log: Template change log details.
        :param str custom_hostname: Set up the server using the provided hostname instead of the default hostname.
        :param int disk_group_id: Disk group id.
        :param bool install_rtm: set to true to install RTM.
        :param bool install_sql_server: set to true to install sql server (Windows template only).
        :param str language: language.
        :param bool no_raid: set to true to disable RAID.
        :param str post_installation_script_link: Indicate the URL where your postinstall customisation script is located.
        :param str post_installation_script_return: Indicate the string returned by your postinstall customisation script on successful execution. Advice: your script should return a unique validation string in case of succes. A good example is 'loh1Xee7eo OK OK OK UGh8Ang1Gu'.
        :param bool reset_hw_raid: set to true to make a hardware raid reset.
        :param int soft_raid_devices: soft raid devices.
        :param str ssh_key_name: Name of the ssh key that should be installed. Password login will be disabled.
        :param bool use_distrib_kernel: Use the distribution's native kernel instead of the recommended OVH Kernel.
        :param bool use_spla: set to true to use SPLA.
        """
        if change_log is not None:
            pulumi.set(__self__, "change_log", change_log)
        if custom_hostname is not None:
            pulumi.set(__self__, "custom_hostname", custom_hostname)
        if disk_group_id is not None:
            pulumi.set(__self__, "disk_group_id", disk_group_id)
        if install_rtm is not None:
            pulumi.set(__self__, "install_rtm", install_rtm)
        if install_sql_server is not None:
            pulumi.set(__self__, "install_sql_server", install_sql_server)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if no_raid is not None:
            pulumi.set(__self__, "no_raid", no_raid)
        if post_installation_script_link is not None:
            pulumi.set(__self__, "post_installation_script_link", post_installation_script_link)
        if post_installation_script_return is not None:
            pulumi.set(__self__, "post_installation_script_return", post_installation_script_return)
        if reset_hw_raid is not None:
            pulumi.set(__self__, "reset_hw_raid", reset_hw_raid)
        if soft_raid_devices is not None:
            pulumi.set(__self__, "soft_raid_devices", soft_raid_devices)
        if ssh_key_name is not None:
            pulumi.set(__self__, "ssh_key_name", ssh_key_name)
        if use_distrib_kernel is not None:
            pulumi.set(__self__, "use_distrib_kernel", use_distrib_kernel)
        if use_spla is not None:
            pulumi.set(__self__, "use_spla", use_spla)

    @property
    @pulumi.getter(name="changeLog")
    def change_log(self) -> Optional[str]:
        """
        Template change log details.
        """
        return pulumi.get(self, "change_log")

    @property
    @pulumi.getter(name="customHostname")
    def custom_hostname(self) -> Optional[str]:
        """
        Set up the server using the provided hostname instead of the default hostname.
        """
        return pulumi.get(self, "custom_hostname")

    @property
    @pulumi.getter(name="diskGroupId")
    def disk_group_id(self) -> Optional[int]:
        """
        Disk group id.
        """
        return pulumi.get(self, "disk_group_id")

    @property
    @pulumi.getter(name="installRtm")
    def install_rtm(self) -> Optional[bool]:
        """
        set to true to install RTM.
        """
        return pulumi.get(self, "install_rtm")

    @property
    @pulumi.getter(name="installSqlServer")
    def install_sql_server(self) -> Optional[bool]:
        """
        set to true to install sql server (Windows template only).
        """
        return pulumi.get(self, "install_sql_server")

    @property
    @pulumi.getter
    def language(self) -> Optional[str]:
        """
        language.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="noRaid")
    def no_raid(self) -> Optional[bool]:
        """
        set to true to disable RAID.
        """
        return pulumi.get(self, "no_raid")

    @property
    @pulumi.getter(name="postInstallationScriptLink")
    def post_installation_script_link(self) -> Optional[str]:
        """
        Indicate the URL where your postinstall customisation script is located.
        """
        return pulumi.get(self, "post_installation_script_link")

    @property
    @pulumi.getter(name="postInstallationScriptReturn")
    def post_installation_script_return(self) -> Optional[str]:
        """
        Indicate the string returned by your postinstall customisation script on successful execution. Advice: your script should return a unique validation string in case of succes. A good example is 'loh1Xee7eo OK OK OK UGh8Ang1Gu'.
        """
        return pulumi.get(self, "post_installation_script_return")

    @property
    @pulumi.getter(name="resetHwRaid")
    def reset_hw_raid(self) -> Optional[bool]:
        """
        set to true to make a hardware raid reset.
        """
        return pulumi.get(self, "reset_hw_raid")

    @property
    @pulumi.getter(name="softRaidDevices")
    def soft_raid_devices(self) -> Optional[int]:
        """
        soft raid devices.
        """
        return pulumi.get(self, "soft_raid_devices")

    @property
    @pulumi.getter(name="sshKeyName")
    def ssh_key_name(self) -> Optional[str]:
        """
        Name of the ssh key that should be installed. Password login will be disabled.
        """
        return pulumi.get(self, "ssh_key_name")

    @property
    @pulumi.getter(name="useDistribKernel")
    def use_distrib_kernel(self) -> Optional[bool]:
        """
        Use the distribution's native kernel instead of the recommended OVH Kernel.
        """
        return pulumi.get(self, "use_distrib_kernel")

    @property
    @pulumi.getter(name="useSpla")
    def use_spla(self) -> Optional[bool]:
        """
        set to true to use SPLA.
        """
        return pulumi.get(self, "use_spla")


@pulumi.output_type
class DomainZoneOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainZoneOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainZoneOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainZoneOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 details: Optional[Sequence['outputs.DomainZoneOrderDetail']] = None,
                 expiration_date: Optional[str] = None,
                 order_id: Optional[int] = None):
        """
        :param str date: date
        :param Sequence['DomainZoneOrderDetailArgs'] details: Information about a Bill entry
        :param str expiration_date: expiration date
        :param int order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        date
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.DomainZoneOrderDetail']]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[int]:
        """
        order id
        """
        return pulumi.get(self, "order_id")


@pulumi.output_type
class DomainZoneOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainZoneOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainZoneOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainZoneOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 domain: Optional[str] = None,
                 order_detail_id: Optional[int] = None,
                 quantity: Optional[str] = None):
        """
        :param str description: description
        :param str domain: expiration date
        :param int order_detail_id: order detail id
        :param str quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[int]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[str]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class DomainZonePlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainZonePlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainZonePlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainZonePlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.DomainZonePlanConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['DomainZonePlanConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.DomainZonePlanConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class DomainZonePlanConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DomainZonePlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainZonePlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainZonePlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainZonePlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.DomainZonePlanOptionConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['DomainZonePlanOptionConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.DomainZonePlanOptionConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class DomainZonePlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IpLoadBalancingHttpFarmProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forceSsl":
            suggest = "force_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpLoadBalancingHttpFarmProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpLoadBalancingHttpFarmProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpLoadBalancingHttpFarmProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 force_ssl: Optional[bool] = None,
                 interval: Optional[int] = None,
                 match: Optional[str] = None,
                 method: Optional[str] = None,
                 negate: Optional[bool] = None,
                 pattern: Optional[str] = None,
                 port: Optional[int] = None,
                 url: Optional[str] = None):
        """
        :param str type: Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        :param bool force_ssl: Force use of SSL (TLS)
        :param int interval: probe interval, Value between 30 and 3600 seconds, default 30
        :param str match: What to mach `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        :param str method: HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        :param bool negate: Negate probe result
        :param str pattern: Pattern to match against `match`
        :param int port: Port for backends to recieve traffic on.
        :param str url: URL for HTTP probe type.
        """
        pulumi.set(__self__, "type", type)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[bool]:
        """
        Force use of SSL (TLS)
        """
        return pulumi.get(self, "force_ssl")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        probe interval, Value between 30 and 3600 seconds, default 30
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def match(self) -> Optional[str]:
        """
        What to mach `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Negate probe result
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        Pattern to match against `match`
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for backends to recieve traffic on.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        URL for HTTP probe type.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class IpLoadBalancingHttpRouteAction(dict):
    def __init__(__self__, *,
                 type: str,
                 status: Optional[int] = None,
                 target: Optional[str] = None):
        """
        :param str type: Action to trigger if all the rules of this route matches
        :param int status: HTTP status code for "redirect" and "reject" actions
        :param str target: Farm ID for "farm" action type or URL template for "redirect" action. You may use ${uri}, ${protocol}, ${host}, ${port} and ${path} variables in redirect target
        """
        pulumi.set(__self__, "type", type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Action to trigger if all the rules of this route matches
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def status(self) -> Optional[int]:
        """
        HTTP status code for "redirect" and "reject" actions
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Farm ID for "farm" action type or URL template for "redirect" action. You may use ${uri}, ${protocol}, ${host}, ${port} and ${path} variables in redirect target
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class IpLoadBalancingHttpRouteRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "subField":
            suggest = "sub_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpLoadBalancingHttpRouteRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpLoadBalancingHttpRouteRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpLoadBalancingHttpRouteRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: Optional[str] = None,
                 match: Optional[str] = None,
                 negate: Optional[bool] = None,
                 pattern: Optional[str] = None,
                 rule_id: Optional[int] = None,
                 sub_field: Optional[str] = None):
        """
        :param str field: Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        :param str match: Matching operator. Not all operators are available for all fields. See "availableRules"
               * `negate`- Invert the matching operator effect
        :param str pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param int rule_id: Id of your rule
        :param str sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def match(self) -> Optional[str]:
        """
        Matching operator. Not all operators are available for all fields. See "availableRules"
        * `negate`- Invert the matching operator effect
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[int]:
        """
        Id of your rule
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[str]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")


@pulumi.output_type
class IpLoadBalancingOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpLoadBalancingOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpLoadBalancingOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpLoadBalancingOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 details: Optional[Sequence['outputs.IpLoadBalancingOrderDetail']] = None,
                 expiration_date: Optional[str] = None,
                 order_id: Optional[int] = None):
        """
        :param str date: date
        :param Sequence['IpLoadBalancingOrderDetailArgs'] details: Information about a Bill entry
        :param str expiration_date: expiration date
        :param int order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        date
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.IpLoadBalancingOrderDetail']]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[int]:
        """
        order id
        """
        return pulumi.get(self, "order_id")


@pulumi.output_type
class IpLoadBalancingOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpLoadBalancingOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpLoadBalancingOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpLoadBalancingOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 domain: Optional[str] = None,
                 order_detail_id: Optional[int] = None,
                 quantity: Optional[str] = None):
        """
        :param str description: description
        :param str domain: expiration date
        :param int order_detail_id: order detail id
        :param str quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[int]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[str]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class IpLoadBalancingOrderableZone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpLoadBalancingOrderableZone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpLoadBalancingOrderableZone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpLoadBalancingOrderableZone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 plan_code: Optional[str] = None):
        """
        :param str name: The zone three letter code
        :param str plan_code: Plan code
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan_code is not None:
            pulumi.set(__self__, "plan_code", plan_code)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The zone three letter code
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> Optional[str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")


@pulumi.output_type
class IpLoadBalancingPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpLoadBalancingPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpLoadBalancingPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpLoadBalancingPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.IpLoadBalancingPlanConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['IpLoadBalancingPlanConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.IpLoadBalancingPlanConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class IpLoadBalancingPlanConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IpLoadBalancingPlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpLoadBalancingPlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpLoadBalancingPlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpLoadBalancingPlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.IpLoadBalancingPlanOptionConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['IpLoadBalancingPlanOptionConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.IpLoadBalancingPlanOptionConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class IpLoadBalancingPlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IpLoadBalancingTcpFarmProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forceSsl":
            suggest = "force_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpLoadBalancingTcpFarmProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpLoadBalancingTcpFarmProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpLoadBalancingTcpFarmProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 force_ssl: Optional[bool] = None,
                 interval: Optional[int] = None,
                 match: Optional[str] = None,
                 method: Optional[str] = None,
                 negate: Optional[bool] = None,
                 pattern: Optional[str] = None,
                 port: Optional[int] = None,
                 url: Optional[str] = None):
        """
        :param str type: Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        :param bool force_ssl: Force use of SSL (TLS)
        :param int interval: probe interval, Value between 30 and 3600 seconds, default 30
        :param str match: What to mach `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        :param str method: HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        :param bool negate: Negate probe result
        :param str pattern: Pattern to match against `match`
        :param int port: Port for backends to recieve traffic on.
        :param str url: URL for HTTP probe type.
        """
        pulumi.set(__self__, "type", type)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[bool]:
        """
        Force use of SSL (TLS)
        """
        return pulumi.get(self, "force_ssl")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        probe interval, Value between 30 and 3600 seconds, default 30
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def match(self) -> Optional[str]:
        """
        What to mach `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Negate probe result
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        Pattern to match against `match`
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for backends to recieve traffic on.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        URL for HTTP probe type.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class IpLoadBalancingTcpRouteAction(dict):
    def __init__(__self__, *,
                 type: str,
                 target: Optional[str] = None):
        """
        :param str type: Action to trigger if all the rules of this route matches
        :param str target: Farm ID for "farm" action type, empty for others.
        """
        pulumi.set(__self__, "type", type)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Action to trigger if all the rules of this route matches
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Farm ID for "farm" action type, empty for others.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class IpLoadBalancingTcpRouteRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "subField":
            suggest = "sub_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpLoadBalancingTcpRouteRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpLoadBalancingTcpRouteRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpLoadBalancingTcpRouteRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field: Optional[str] = None,
                 match: Optional[str] = None,
                 negate: Optional[bool] = None,
                 pattern: Optional[str] = None,
                 rule_id: Optional[int] = None,
                 sub_field: Optional[str] = None):
        """
        :param str field: Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        :param str match: Matching operator. Not all operators are available for all fields. See "availableRules"
               * `negate`- Invert the matching operator effect
        :param str pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param int rule_id: Id of your rule
        :param str sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def match(self) -> Optional[str]:
        """
        Matching operator. Not all operators are available for all fields. See "availableRules"
        * `negate`- Invert the matching operator effect
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[int]:
        """
        Id of your rule
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[str]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")


@pulumi.output_type
class IpServiceOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpServiceOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpServiceOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpServiceOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 details: Optional[Sequence['outputs.IpServiceOrderDetail']] = None,
                 expiration_date: Optional[str] = None,
                 order_id: Optional[int] = None):
        """
        :param str date: date
        :param Sequence['IpServiceOrderDetailArgs'] details: Information about a Bill entry
        :param str expiration_date: expiration date
        :param int order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        date
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.IpServiceOrderDetail']]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[int]:
        """
        order id
        """
        return pulumi.get(self, "order_id")


@pulumi.output_type
class IpServiceOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpServiceOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpServiceOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpServiceOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 domain: Optional[str] = None,
                 order_detail_id: Optional[int] = None,
                 quantity: Optional[str] = None):
        """
        :param str description: Custom description on your ip.
        :param str domain: expiration date
        :param int order_detail_id: order detail id
        :param str quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Custom description on your ip.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[int]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[str]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class IpServicePlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpServicePlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpServicePlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpServicePlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.IpServicePlanConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['IpServicePlanConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.IpServicePlanConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class IpServicePlanConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IpServicePlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpServicePlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpServicePlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpServicePlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.IpServicePlanOptionConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['IpServicePlanOptionConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.IpServicePlanOptionConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class IpServicePlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IpServiceRoutedTo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpServiceRoutedTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpServiceRoutedTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpServiceRoutedTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: Optional[str] = None):
        """
        :param str service_name: Service where ip is routed to
               * `service_name`: service name
        """
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        Service where ip is routed to
        * `service_name`: service name
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class VrackOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VrackOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VrackOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VrackOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 details: Optional[Sequence['outputs.VrackOrderDetail']] = None,
                 expiration_date: Optional[str] = None,
                 order_id: Optional[int] = None):
        """
        :param str date: date
        :param Sequence['VrackOrderDetailArgs'] details: Information about a Bill entry
        :param str expiration_date: expiration date
        :param int order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        date
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.VrackOrderDetail']]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[int]:
        """
        order id
        """
        return pulumi.get(self, "order_id")


@pulumi.output_type
class VrackOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VrackOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VrackOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VrackOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 domain: Optional[str] = None,
                 order_detail_id: Optional[int] = None,
                 quantity: Optional[str] = None):
        """
        :param str description: yourvrackdescription
        :param str domain: expiration date
        :param int order_detail_id: order detail id
        :param str quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        yourvrackdescription
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[int]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[str]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class VrackPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VrackPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VrackPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VrackPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.VrackPlanConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['VrackPlanConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.VrackPlanConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class VrackPlanConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class VrackPlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VrackPlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VrackPlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VrackPlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 plan_code: str,
                 pricing_mode: str,
                 catalog_name: Optional[str] = None,
                 configurations: Optional[Sequence['outputs.VrackPlanOptionConfiguration']] = None):
        """
        :param str duration: duration
        :param str plan_code: Plan code
        :param str pricing_mode: Pricing model identifier
        :param str catalog_name: Catalog name
        :param Sequence['VrackPlanOptionConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.VrackPlanOptionConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class VrackPlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: str,
                 value: str):
        """
        :param str label: Identifier of the resource
        :param str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetCloudProjectCapabilitiesContainerFilterFeatureResult(dict):
    def __init__(__self__, *,
                 vulnerability: bool):
        """
        :param bool vulnerability: Vulnerability scanning
        """
        pulumi.set(__self__, "vulnerability", vulnerability)

    @property
    @pulumi.getter
    def vulnerability(self) -> bool:
        """
        Vulnerability scanning
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class GetCloudProjectCapabilitiesContainerFilterRegistryLimitResult(dict):
    def __init__(__self__, *,
                 image_storage: int,
                 parallel_request: int):
        """
        :param int image_storage: Docker image storage limits in bytes
        :param int parallel_request: Parallel requests on Docker image API (/v2 Docker registry API)
        """
        pulumi.set(__self__, "image_storage", image_storage)
        pulumi.set(__self__, "parallel_request", parallel_request)

    @property
    @pulumi.getter(name="imageStorage")
    def image_storage(self) -> int:
        """
        Docker image storage limits in bytes
        """
        return pulumi.get(self, "image_storage")

    @property
    @pulumi.getter(name="parallelRequest")
    def parallel_request(self) -> int:
        """
        Parallel requests on Docker image API (/v2 Docker registry API)
        """
        return pulumi.get(self, "parallel_request")


@pulumi.output_type
class GetCloudProjectCapabilitiesContainerRegistryResultResult(dict):
    def __init__(__self__, *,
                 plans: Sequence['outputs.GetCloudProjectCapabilitiesContainerRegistryResultPlanResult'],
                 region_name: str):
        """
        :param Sequence['GetCloudProjectCapabilitiesContainerRegistryResultPlanArgs'] plans: Available plans in the region
        :param str region_name: The region name
        """
        pulumi.set(__self__, "plans", plans)
        pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetCloudProjectCapabilitiesContainerRegistryResultPlanResult']:
        """
        Available plans in the region
        """
        return pulumi.get(self, "plans")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> str:
        """
        The region name
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class GetCloudProjectCapabilitiesContainerRegistryResultPlanResult(dict):
    def __init__(__self__, *,
                 code: str,
                 created_at: str,
                 features: Sequence['outputs.GetCloudProjectCapabilitiesContainerRegistryResultPlanFeatureResult'],
                 id: str,
                 name: str,
                 registry_limits: Sequence['outputs.GetCloudProjectCapabilitiesContainerRegistryResultPlanRegistryLimitResult'],
                 updated_at: str):
        """
        :param str code: Plan code from the catalog
        :param str created_at: Plan creation date
        :param Sequence['GetCloudProjectCapabilitiesContainerRegistryResultPlanFeatureArgs'] features: Features of the plan
        :param str id: Plan ID
        :param str name: Plan name
        :param Sequence['GetCloudProjectCapabilitiesContainerRegistryResultPlanRegistryLimitArgs'] registry_limits: Container registry limits
        :param str updated_at: Plan last update date
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "registry_limits", registry_limits)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Plan code from the catalog
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Plan creation date
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def features(self) -> Sequence['outputs.GetCloudProjectCapabilitiesContainerRegistryResultPlanFeatureResult']:
        """
        Features of the plan
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Plan ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Plan name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="registryLimits")
    def registry_limits(self) -> Sequence['outputs.GetCloudProjectCapabilitiesContainerRegistryResultPlanRegistryLimitResult']:
        """
        Container registry limits
        """
        return pulumi.get(self, "registry_limits")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Plan last update date
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetCloudProjectCapabilitiesContainerRegistryResultPlanFeatureResult(dict):
    def __init__(__self__, *,
                 vulnerability: bool):
        """
        :param bool vulnerability: Vulnerability scanning
        """
        pulumi.set(__self__, "vulnerability", vulnerability)

    @property
    @pulumi.getter
    def vulnerability(self) -> bool:
        """
        Vulnerability scanning
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class GetCloudProjectCapabilitiesContainerRegistryResultPlanRegistryLimitResult(dict):
    def __init__(__self__, *,
                 image_storage: int,
                 parallel_request: int):
        """
        :param int image_storage: Docker image storage limits in bytes
        :param int parallel_request: Parallel requests on Docker image API (/v2 Docker registry API)
        """
        pulumi.set(__self__, "image_storage", image_storage)
        pulumi.set(__self__, "parallel_request", parallel_request)

    @property
    @pulumi.getter(name="imageStorage")
    def image_storage(self) -> int:
        """
        Docker image storage limits in bytes
        """
        return pulumi.get(self, "image_storage")

    @property
    @pulumi.getter(name="parallelRequest")
    def parallel_request(self) -> int:
        """
        Parallel requests on Docker image API (/v2 Docker registry API)
        """
        return pulumi.get(self, "parallel_request")


@pulumi.output_type
class GetCloudProjectContainerRegistriesResultResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 id: str,
                 name: str,
                 project_id: str,
                 region: str,
                 size: int,
                 status: str,
                 updated_at: str,
                 url: str,
                 version: str):
        """
        :param str created_at: Registry creation date
        :param str id: Registry ID
        :param str name: Registry name
        :param str project_id: Project ID of your registry
        :param str region: Region of the registry
        :param int size: Current size of the registry (bytes)
        :param str status: Registry status
        :param str updated_at: Registry last update date
        :param str url: Access url of the registry
        :param str version: Version of your registry
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Registry creation date
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Registry ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Registry name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Project ID of your registry
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region of the registry
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Current size of the registry (bytes)
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Registry status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Registry last update date
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Access url of the registry
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of your registry
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetCloudProjectContainerRegistryUsersResultResult(dict):
    def __init__(__self__, *,
                 email: str,
                 id: str,
                 user: str):
        """
        :param str email: User email
        :param str id: User ID
        :param str user: User name
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        User email
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        User ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        User name
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetCloudProjectDatabaseEndpointResult(dict):
    def __init__(__self__, *,
                 component: str,
                 domain: str,
                 path: str,
                 port: int,
                 scheme: str,
                 ssl: bool,
                 ssl_mode: str,
                 uri: str):
        """
        :param str component: Type of component the URI relates to.
        :param str domain: Domain of the cluster.
        :param str path: Path of the endpoint.
        :param int port: Connection port for the endpoint.
        :param str scheme: Scheme used to generate the URI.
        :param bool ssl: Defines whether the endpoint uses SSL.
        :param str ssl_mode: SSL mode used to connect to the service if the SSL is enabled.
        :param str uri: URI of the endpoint.
        """
        pulumi.set(__self__, "component", component)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "ssl", ssl)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def component(self) -> str:
        """
        Type of component the URI relates to.
        """
        return pulumi.get(self, "component")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Domain of the cluster.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path of the endpoint.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Connection port for the endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        Scheme used to generate the URI.
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def ssl(self) -> bool:
        """
        Defines whether the endpoint uses SSL.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> str:
        """
        SSL mode used to connect to the service if the SSL is enabled.
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of the endpoint.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetCloudProjectDatabaseNodeResult(dict):
    def __init__(__self__, *,
                 network_id: str,
                 region: str,
                 subnet_id: str):
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetCloudProjectRegionServiceResult(dict):
    def __init__(__self__, *,
                 name: str,
                 status: str):
        """
        :param str name: The name of the region associated with the public cloud
               project.
        :param str status: the status of the service
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the region associated with the public cloud
        project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        the status of the service
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDedicatedServerVniResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 mode: str,
                 name: str,
                 nics: Sequence[str],
                 server_name: str,
                 uuid: str,
                 vrack: str):
        """
        :param bool enabled: VirtualNetworkInterface activation state
        :param str mode: VirtualNetworkInterface mode (public,vrack,vrack_aggregation)
        :param str name: User defined VirtualNetworkInterface name
        :param str server_name: Server bound to this VirtualNetworkInterface
        :param str uuid: VirtualNetworkInterface unique id
        :param str vrack: vRack name
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nics", nics)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "vrack", vrack)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        VirtualNetworkInterface activation state
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        VirtualNetworkInterface mode (public,vrack,vrack_aggregation)
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        User defined VirtualNetworkInterface name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nics(self) -> Sequence[str]:
        return pulumi.get(self, "nics")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> str:
        """
        Server bound to this VirtualNetworkInterface
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        VirtualNetworkInterface unique id
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter
    def vrack(self) -> str:
        """
        vRack name
        """
        return pulumi.get(self, "vrack")


@pulumi.output_type
class GetIpServiceRoutedToResult(dict):
    def __init__(__self__, *,
                 service_name: str):
        """
        :param str service_name: The service name
        """
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The service name
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class GetMeCurrencyResult(dict):
    def __init__(__self__, *,
                 code: str,
                 symbol: str):
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "symbol", symbol)

    @property
    @pulumi.getter
    def code(self) -> str:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def symbol(self) -> str:
        return pulumi.get(self, "symbol")


@pulumi.output_type
class GetMeInstallationTemplateCustomizationResult(dict):
    def __init__(__self__, *,
                 change_log: str,
                 custom_hostname: str,
                 post_installation_script_link: str,
                 post_installation_script_return: str,
                 rating: int,
                 ssh_key_name: str,
                 use_distribution_kernel: bool):
        pulumi.set(__self__, "change_log", change_log)
        pulumi.set(__self__, "custom_hostname", custom_hostname)
        pulumi.set(__self__, "post_installation_script_link", post_installation_script_link)
        pulumi.set(__self__, "post_installation_script_return", post_installation_script_return)
        pulumi.set(__self__, "rating", rating)
        pulumi.set(__self__, "ssh_key_name", ssh_key_name)
        pulumi.set(__self__, "use_distribution_kernel", use_distribution_kernel)

    @property
    @pulumi.getter(name="changeLog")
    def change_log(self) -> str:
        return pulumi.get(self, "change_log")

    @property
    @pulumi.getter(name="customHostname")
    def custom_hostname(self) -> str:
        return pulumi.get(self, "custom_hostname")

    @property
    @pulumi.getter(name="postInstallationScriptLink")
    def post_installation_script_link(self) -> str:
        return pulumi.get(self, "post_installation_script_link")

    @property
    @pulumi.getter(name="postInstallationScriptReturn")
    def post_installation_script_return(self) -> str:
        return pulumi.get(self, "post_installation_script_return")

    @property
    @pulumi.getter
    def rating(self) -> int:
        return pulumi.get(self, "rating")

    @property
    @pulumi.getter(name="sshKeyName")
    def ssh_key_name(self) -> str:
        return pulumi.get(self, "ssh_key_name")

    @property
    @pulumi.getter(name="useDistributionKernel")
    def use_distribution_kernel(self) -> bool:
        return pulumi.get(self, "use_distribution_kernel")


@pulumi.output_type
class GetMeInstallationTemplatePartitionSchemeResult(dict):
    def __init__(__self__, *,
                 hardware_raids: Sequence['outputs.GetMeInstallationTemplatePartitionSchemeHardwareRaidResult'],
                 name: str,
                 partitions: Sequence['outputs.GetMeInstallationTemplatePartitionSchemePartitionResult'],
                 priority: int):
        pulumi.set(__self__, "hardware_raids", hardware_raids)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "partitions", partitions)
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter(name="hardwareRaids")
    def hardware_raids(self) -> Sequence['outputs.GetMeInstallationTemplatePartitionSchemeHardwareRaidResult']:
        return pulumi.get(self, "hardware_raids")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partitions(self) -> Sequence['outputs.GetMeInstallationTemplatePartitionSchemePartitionResult']:
        return pulumi.get(self, "partitions")

    @property
    @pulumi.getter
    def priority(self) -> int:
        return pulumi.get(self, "priority")


@pulumi.output_type
class GetMeInstallationTemplatePartitionSchemeHardwareRaidResult(dict):
    def __init__(__self__, *,
                 disks: Sequence[str],
                 mode: str,
                 name: str,
                 step: int):
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "step", step)

    @property
    @pulumi.getter
    def disks(self) -> Sequence[str]:
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def mode(self) -> str:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def step(self) -> int:
        return pulumi.get(self, "step")


@pulumi.output_type
class GetMeInstallationTemplatePartitionSchemePartitionResult(dict):
    def __init__(__self__, *,
                 filesystem: str,
                 mountpoint: str,
                 order: int,
                 raid: str,
                 size: int,
                 type: str,
                 volume_name: str):
        pulumi.set(__self__, "filesystem", filesystem)
        pulumi.set(__self__, "mountpoint", mountpoint)
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "raid", raid)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter
    def filesystem(self) -> str:
        return pulumi.get(self, "filesystem")

    @property
    @pulumi.getter
    def mountpoint(self) -> str:
        return pulumi.get(self, "mountpoint")

    @property
    @pulumi.getter
    def order(self) -> int:
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def raid(self) -> str:
        return pulumi.get(self, "raid")

    @property
    @pulumi.getter
    def size(self) -> int:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> str:
        return pulumi.get(self, "volume_name")


@pulumi.output_type
class GetOrderCartProductOptionsPlanPriceResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence[Any],
                 description: str,
                 duration: str,
                 interval: int,
                 maximum_quantity: int,
                 maximum_repeat: int,
                 minimum_quantity: int,
                 minimum_repeat: int,
                 price_in_ucents: int,
                 prices: Sequence['outputs.GetOrderCartProductOptionsPlanPricePriceResult'],
                 pricing_mode: str,
                 pricing_type: str):
        """
        :param Sequence[Any] capacities: Capacities of the pricing (type of pricing)
        :param str description: Description of the pricing
        :param str duration: Duration for ordering the product
        :param int interval: Interval of renewal
        :param int maximum_quantity: Maximum quantity that can be ordered
        :param int maximum_repeat: Maximum repeat for renewal
        :param int minimum_quantity: Minimum quantity that can be ordered
        :param int minimum_repeat: Minimum repeat for renewal
        :param int price_in_ucents: Price of the product in micro-centims
        :param Sequence['GetOrderCartProductOptionsPlanPricePriceArgs'] prices: Price of the product (Price with its currency and textual representation)
        :param str pricing_mode: Pricing model identifier
        :param str pricing_type: Pricing type
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "maximum_quantity", maximum_quantity)
        pulumi.set(__self__, "maximum_repeat", maximum_repeat)
        pulumi.set(__self__, "minimum_quantity", minimum_quantity)
        pulumi.set(__self__, "minimum_repeat", minimum_repeat)
        pulumi.set(__self__, "price_in_ucents", price_in_ucents)
        pulumi.set(__self__, "prices", prices)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        pulumi.set(__self__, "pricing_type", pricing_type)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence[Any]:
        """
        Capacities of the pricing (type of pricing)
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the pricing
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration for ordering the product
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        Interval of renewal
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="maximumQuantity")
    def maximum_quantity(self) -> int:
        """
        Maximum quantity that can be ordered
        """
        return pulumi.get(self, "maximum_quantity")

    @property
    @pulumi.getter(name="maximumRepeat")
    def maximum_repeat(self) -> int:
        """
        Maximum repeat for renewal
        """
        return pulumi.get(self, "maximum_repeat")

    @property
    @pulumi.getter(name="minimumQuantity")
    def minimum_quantity(self) -> int:
        """
        Minimum quantity that can be ordered
        """
        return pulumi.get(self, "minimum_quantity")

    @property
    @pulumi.getter(name="minimumRepeat")
    def minimum_repeat(self) -> int:
        """
        Minimum repeat for renewal
        """
        return pulumi.get(self, "minimum_repeat")

    @property
    @pulumi.getter(name="priceInUcents")
    def price_in_ucents(self) -> int:
        """
        Price of the product in micro-centims
        """
        return pulumi.get(self, "price_in_ucents")

    @property
    @pulumi.getter
    def prices(self) -> Sequence['outputs.GetOrderCartProductOptionsPlanPricePriceResult']:
        """
        Price of the product (Price with its currency and textual representation)
        """
        return pulumi.get(self, "prices")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="pricingType")
    def pricing_type(self) -> str:
        """
        Pricing type
        """
        return pulumi.get(self, "pricing_type")


@pulumi.output_type
class GetOrderCartProductOptionsPlanPricePriceResult(dict):
    def __init__(__self__, *,
                 currency_code: str,
                 text: str,
                 value: float):
        """
        :param str currency_code: Currency code
        :param str text: Textual representation
        :param float value: The effective price
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Textual representation
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The effective price
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetOrderCartProductOptionsPlanSelectedPriceResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence[Any],
                 description: str,
                 duration: str,
                 interval: int,
                 maximum_quantity: int,
                 maximum_repeat: int,
                 minimum_quantity: int,
                 minimum_repeat: int,
                 price_in_ucents: int,
                 prices: Sequence['outputs.GetOrderCartProductOptionsPlanSelectedPricePriceResult'],
                 pricing_mode: str,
                 pricing_type: str):
        """
        :param Sequence[Any] capacities: Capacities of the pricing (type of pricing)
        :param str description: Description of the pricing
        :param str duration: Duration for ordering the product
        :param int interval: Interval of renewal
        :param int maximum_quantity: Maximum quantity that can be ordered
        :param int maximum_repeat: Maximum repeat for renewal
        :param int minimum_quantity: Minimum quantity that can be ordered
        :param int minimum_repeat: Minimum repeat for renewal
        :param int price_in_ucents: Price of the product in micro-centims
        :param Sequence['GetOrderCartProductOptionsPlanSelectedPricePriceArgs'] prices: Price of the product (Price with its currency and textual representation)
        :param str pricing_mode: Pricing model identifier
        :param str pricing_type: Pricing type
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "maximum_quantity", maximum_quantity)
        pulumi.set(__self__, "maximum_repeat", maximum_repeat)
        pulumi.set(__self__, "minimum_quantity", minimum_quantity)
        pulumi.set(__self__, "minimum_repeat", minimum_repeat)
        pulumi.set(__self__, "price_in_ucents", price_in_ucents)
        pulumi.set(__self__, "prices", prices)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        pulumi.set(__self__, "pricing_type", pricing_type)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence[Any]:
        """
        Capacities of the pricing (type of pricing)
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the pricing
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration for ordering the product
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        Interval of renewal
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="maximumQuantity")
    def maximum_quantity(self) -> int:
        """
        Maximum quantity that can be ordered
        """
        return pulumi.get(self, "maximum_quantity")

    @property
    @pulumi.getter(name="maximumRepeat")
    def maximum_repeat(self) -> int:
        """
        Maximum repeat for renewal
        """
        return pulumi.get(self, "maximum_repeat")

    @property
    @pulumi.getter(name="minimumQuantity")
    def minimum_quantity(self) -> int:
        """
        Minimum quantity that can be ordered
        """
        return pulumi.get(self, "minimum_quantity")

    @property
    @pulumi.getter(name="minimumRepeat")
    def minimum_repeat(self) -> int:
        """
        Minimum repeat for renewal
        """
        return pulumi.get(self, "minimum_repeat")

    @property
    @pulumi.getter(name="priceInUcents")
    def price_in_ucents(self) -> int:
        """
        Price of the product in micro-centims
        """
        return pulumi.get(self, "price_in_ucents")

    @property
    @pulumi.getter
    def prices(self) -> Sequence['outputs.GetOrderCartProductOptionsPlanSelectedPricePriceResult']:
        """
        Price of the product (Price with its currency and textual representation)
        """
        return pulumi.get(self, "prices")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="pricingType")
    def pricing_type(self) -> str:
        """
        Pricing type
        """
        return pulumi.get(self, "pricing_type")


@pulumi.output_type
class GetOrderCartProductOptionsPlanSelectedPricePriceResult(dict):
    def __init__(__self__, *,
                 currency_code: str,
                 text: str,
                 value: float):
        """
        :param str currency_code: Currency code
        :param str text: Textual representation
        :param float value: The effective price
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Textual representation
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The effective price
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetOrderCartProductOptionsResultResult(dict):
    def __init__(__self__, *,
                 exclusive: bool,
                 family: str,
                 mandatory: bool,
                 plan_code: str,
                 prices: Sequence['outputs.GetOrderCartProductOptionsResultPriceResult'],
                 product_name: str,
                 product_type: str):
        """
        :param bool exclusive: Define if options of this family are exclusive with each other
        :param str family: Option family
        :param bool mandatory: Define if an option of this family is mandatory
        :param str plan_code: Product offer identifier
        :param Sequence['GetOrderCartProductOptionsResultPriceArgs'] prices: Prices of the product offer
        :param str product_name: Name of the product
        :param str product_type: Product type
        """
        pulumi.set(__self__, "exclusive", exclusive)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "mandatory", mandatory)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "prices", prices)
        pulumi.set(__self__, "product_name", product_name)
        pulumi.set(__self__, "product_type", product_type)

    @property
    @pulumi.getter
    def exclusive(self) -> bool:
        """
        Define if options of this family are exclusive with each other
        """
        return pulumi.get(self, "exclusive")

    @property
    @pulumi.getter
    def family(self) -> str:
        """
        Option family
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def mandatory(self) -> bool:
        """
        Define if an option of this family is mandatory
        """
        return pulumi.get(self, "mandatory")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Product offer identifier
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter
    def prices(self) -> Sequence['outputs.GetOrderCartProductOptionsResultPriceResult']:
        """
        Prices of the product offer
        """
        return pulumi.get(self, "prices")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> str:
        """
        Name of the product
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> str:
        """
        Product type
        """
        return pulumi.get(self, "product_type")


@pulumi.output_type
class GetOrderCartProductOptionsResultPriceResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence[Any],
                 description: str,
                 duration: str,
                 interval: int,
                 maximum_quantity: int,
                 maximum_repeat: int,
                 minimum_quantity: int,
                 minimum_repeat: int,
                 price_in_ucents: int,
                 prices: Sequence['outputs.GetOrderCartProductOptionsResultPricePriceResult'],
                 pricing_mode: str,
                 pricing_type: str):
        """
        :param Sequence[Any] capacities: Capacities of the pricing (type of pricing)
        :param str description: Description of the pricing
        :param str duration: Duration for ordering the product
        :param int interval: Interval of renewal
        :param int maximum_quantity: Maximum quantity that can be ordered
        :param int maximum_repeat: Maximum repeat for renewal
        :param int minimum_quantity: Minimum quantity that can be ordered
        :param int minimum_repeat: Minimum repeat for renewal
        :param int price_in_ucents: Price of the product in micro-centims
        :param Sequence['GetOrderCartProductOptionsResultPricePriceArgs'] prices: Price of the product (Price with its currency and textual representation)
        :param str pricing_mode: Pricing model identifier
        :param str pricing_type: Pricing type
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "maximum_quantity", maximum_quantity)
        pulumi.set(__self__, "maximum_repeat", maximum_repeat)
        pulumi.set(__self__, "minimum_quantity", minimum_quantity)
        pulumi.set(__self__, "minimum_repeat", minimum_repeat)
        pulumi.set(__self__, "price_in_ucents", price_in_ucents)
        pulumi.set(__self__, "prices", prices)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        pulumi.set(__self__, "pricing_type", pricing_type)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence[Any]:
        """
        Capacities of the pricing (type of pricing)
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the pricing
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration for ordering the product
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        Interval of renewal
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="maximumQuantity")
    def maximum_quantity(self) -> int:
        """
        Maximum quantity that can be ordered
        """
        return pulumi.get(self, "maximum_quantity")

    @property
    @pulumi.getter(name="maximumRepeat")
    def maximum_repeat(self) -> int:
        """
        Maximum repeat for renewal
        """
        return pulumi.get(self, "maximum_repeat")

    @property
    @pulumi.getter(name="minimumQuantity")
    def minimum_quantity(self) -> int:
        """
        Minimum quantity that can be ordered
        """
        return pulumi.get(self, "minimum_quantity")

    @property
    @pulumi.getter(name="minimumRepeat")
    def minimum_repeat(self) -> int:
        """
        Minimum repeat for renewal
        """
        return pulumi.get(self, "minimum_repeat")

    @property
    @pulumi.getter(name="priceInUcents")
    def price_in_ucents(self) -> int:
        """
        Price of the product in micro-centims
        """
        return pulumi.get(self, "price_in_ucents")

    @property
    @pulumi.getter
    def prices(self) -> Sequence['outputs.GetOrderCartProductOptionsResultPricePriceResult']:
        """
        Price of the product (Price with its currency and textual representation)
        """
        return pulumi.get(self, "prices")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="pricingType")
    def pricing_type(self) -> str:
        """
        Pricing type
        """
        return pulumi.get(self, "pricing_type")


@pulumi.output_type
class GetOrderCartProductOptionsResultPricePriceResult(dict):
    def __init__(__self__, *,
                 currency_code: str,
                 text: str,
                 value: float):
        """
        :param str currency_code: Currency code
        :param str text: Textual representation
        :param float value: The effective price
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Textual representation
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The effective price
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetOrderCartProductPlanPriceResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence[Any],
                 description: str,
                 duration: str,
                 interval: int,
                 maximum_quantity: int,
                 maximum_repeat: int,
                 minimum_quantity: int,
                 minimum_repeat: int,
                 price_in_ucents: int,
                 prices: Sequence['outputs.GetOrderCartProductPlanPricePriceResult'],
                 pricing_mode: str,
                 pricing_type: str):
        """
        :param Sequence[Any] capacities: Capacities of the pricing (type of pricing)
        :param str description: Description of the pricing
        :param str duration: Duration for ordering the product
        :param int interval: Interval of renewal
        :param int maximum_quantity: Maximum quantity that can be ordered
        :param int maximum_repeat: Maximum repeat for renewal
        :param int minimum_quantity: Minimum quantity that can be ordered
        :param int minimum_repeat: Minimum repeat for renewal
        :param int price_in_ucents: Price of the product in micro-centims
        :param Sequence['GetOrderCartProductPlanPricePriceArgs'] prices: Price of the product (Price with its currency and textual representation)
        :param str pricing_mode: Pricing model identifier
        :param str pricing_type: Pricing type
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "maximum_quantity", maximum_quantity)
        pulumi.set(__self__, "maximum_repeat", maximum_repeat)
        pulumi.set(__self__, "minimum_quantity", minimum_quantity)
        pulumi.set(__self__, "minimum_repeat", minimum_repeat)
        pulumi.set(__self__, "price_in_ucents", price_in_ucents)
        pulumi.set(__self__, "prices", prices)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        pulumi.set(__self__, "pricing_type", pricing_type)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence[Any]:
        """
        Capacities of the pricing (type of pricing)
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the pricing
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration for ordering the product
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        Interval of renewal
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="maximumQuantity")
    def maximum_quantity(self) -> int:
        """
        Maximum quantity that can be ordered
        """
        return pulumi.get(self, "maximum_quantity")

    @property
    @pulumi.getter(name="maximumRepeat")
    def maximum_repeat(self) -> int:
        """
        Maximum repeat for renewal
        """
        return pulumi.get(self, "maximum_repeat")

    @property
    @pulumi.getter(name="minimumQuantity")
    def minimum_quantity(self) -> int:
        """
        Minimum quantity that can be ordered
        """
        return pulumi.get(self, "minimum_quantity")

    @property
    @pulumi.getter(name="minimumRepeat")
    def minimum_repeat(self) -> int:
        """
        Minimum repeat for renewal
        """
        return pulumi.get(self, "minimum_repeat")

    @property
    @pulumi.getter(name="priceInUcents")
    def price_in_ucents(self) -> int:
        """
        Price of the product in micro-centims
        """
        return pulumi.get(self, "price_in_ucents")

    @property
    @pulumi.getter
    def prices(self) -> Sequence['outputs.GetOrderCartProductPlanPricePriceResult']:
        """
        Price of the product (Price with its currency and textual representation)
        """
        return pulumi.get(self, "prices")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="pricingType")
    def pricing_type(self) -> str:
        """
        Pricing type
        """
        return pulumi.get(self, "pricing_type")


@pulumi.output_type
class GetOrderCartProductPlanPricePriceResult(dict):
    def __init__(__self__, *,
                 currency_code: str,
                 text: str,
                 value: float):
        """
        :param str currency_code: Currency code
        :param str text: Textual representation
        :param float value: The effective price
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Textual representation
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The effective price
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetOrderCartProductPlanSelectedPriceResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence[Any],
                 description: str,
                 duration: str,
                 interval: int,
                 maximum_quantity: int,
                 maximum_repeat: int,
                 minimum_quantity: int,
                 minimum_repeat: int,
                 price_in_ucents: int,
                 prices: Sequence['outputs.GetOrderCartProductPlanSelectedPricePriceResult'],
                 pricing_mode: str,
                 pricing_type: str):
        """
        :param Sequence[Any] capacities: Capacities of the pricing (type of pricing)
        :param str description: Description of the pricing
        :param str duration: Duration for ordering the product
        :param int interval: Interval of renewal
        :param int maximum_quantity: Maximum quantity that can be ordered
        :param int maximum_repeat: Maximum repeat for renewal
        :param int minimum_quantity: Minimum quantity that can be ordered
        :param int minimum_repeat: Minimum repeat for renewal
        :param int price_in_ucents: Price of the product in micro-centims
        :param Sequence['GetOrderCartProductPlanSelectedPricePriceArgs'] prices: Price of the product (Price with its currency and textual representation)
        :param str pricing_mode: Pricing model identifier
        :param str pricing_type: Pricing type
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "maximum_quantity", maximum_quantity)
        pulumi.set(__self__, "maximum_repeat", maximum_repeat)
        pulumi.set(__self__, "minimum_quantity", minimum_quantity)
        pulumi.set(__self__, "minimum_repeat", minimum_repeat)
        pulumi.set(__self__, "price_in_ucents", price_in_ucents)
        pulumi.set(__self__, "prices", prices)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        pulumi.set(__self__, "pricing_type", pricing_type)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence[Any]:
        """
        Capacities of the pricing (type of pricing)
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the pricing
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration for ordering the product
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        Interval of renewal
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="maximumQuantity")
    def maximum_quantity(self) -> int:
        """
        Maximum quantity that can be ordered
        """
        return pulumi.get(self, "maximum_quantity")

    @property
    @pulumi.getter(name="maximumRepeat")
    def maximum_repeat(self) -> int:
        """
        Maximum repeat for renewal
        """
        return pulumi.get(self, "maximum_repeat")

    @property
    @pulumi.getter(name="minimumQuantity")
    def minimum_quantity(self) -> int:
        """
        Minimum quantity that can be ordered
        """
        return pulumi.get(self, "minimum_quantity")

    @property
    @pulumi.getter(name="minimumRepeat")
    def minimum_repeat(self) -> int:
        """
        Minimum repeat for renewal
        """
        return pulumi.get(self, "minimum_repeat")

    @property
    @pulumi.getter(name="priceInUcents")
    def price_in_ucents(self) -> int:
        """
        Price of the product in micro-centims
        """
        return pulumi.get(self, "price_in_ucents")

    @property
    @pulumi.getter
    def prices(self) -> Sequence['outputs.GetOrderCartProductPlanSelectedPricePriceResult']:
        """
        Price of the product (Price with its currency and textual representation)
        """
        return pulumi.get(self, "prices")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="pricingType")
    def pricing_type(self) -> str:
        """
        Pricing type
        """
        return pulumi.get(self, "pricing_type")


@pulumi.output_type
class GetOrderCartProductPlanSelectedPricePriceResult(dict):
    def __init__(__self__, *,
                 currency_code: str,
                 text: str,
                 value: float):
        """
        :param str currency_code: Currency code
        :param str text: Textual representation
        :param float value: The effective price
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Textual representation
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The effective price
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetOrderCartProductResultResult(dict):
    def __init__(__self__, *,
                 plan_code: str,
                 prices: Sequence['outputs.GetOrderCartProductResultPriceResult'],
                 product_name: str,
                 product_type: str):
        """
        :param str plan_code: Product offer identifier
        :param Sequence['GetOrderCartProductResultPriceArgs'] prices: Prices of the product offer
        :param str product_name: Name of the product
        :param str product_type: Product type
        """
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "prices", prices)
        pulumi.set(__self__, "product_name", product_name)
        pulumi.set(__self__, "product_type", product_type)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Product offer identifier
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter
    def prices(self) -> Sequence['outputs.GetOrderCartProductResultPriceResult']:
        """
        Prices of the product offer
        """
        return pulumi.get(self, "prices")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> str:
        """
        Name of the product
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> str:
        """
        Product type
        """
        return pulumi.get(self, "product_type")


@pulumi.output_type
class GetOrderCartProductResultPriceResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence[Any],
                 description: str,
                 duration: str,
                 interval: int,
                 maximum_quantity: int,
                 maximum_repeat: int,
                 minimum_quantity: int,
                 minimum_repeat: int,
                 price_in_ucents: int,
                 prices: Sequence['outputs.GetOrderCartProductResultPricePriceResult'],
                 pricing_mode: str,
                 pricing_type: str):
        """
        :param Sequence[Any] capacities: Capacities of the pricing (type of pricing)
        :param str description: Description of the pricing
        :param str duration: Duration for ordering the product
        :param int interval: Interval of renewal
        :param int maximum_quantity: Maximum quantity that can be ordered
        :param int maximum_repeat: Maximum repeat for renewal
        :param int minimum_quantity: Minimum quantity that can be ordered
        :param int minimum_repeat: Minimum repeat for renewal
        :param int price_in_ucents: Price of the product in micro-centims
        :param Sequence['GetOrderCartProductResultPricePriceArgs'] prices: Price of the product (Price with its currency and textual representation)
        :param str pricing_mode: Pricing model identifier
        :param str pricing_type: Pricing type
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "maximum_quantity", maximum_quantity)
        pulumi.set(__self__, "maximum_repeat", maximum_repeat)
        pulumi.set(__self__, "minimum_quantity", minimum_quantity)
        pulumi.set(__self__, "minimum_repeat", minimum_repeat)
        pulumi.set(__self__, "price_in_ucents", price_in_ucents)
        pulumi.set(__self__, "prices", prices)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        pulumi.set(__self__, "pricing_type", pricing_type)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence[Any]:
        """
        Capacities of the pricing (type of pricing)
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the pricing
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration for ordering the product
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        Interval of renewal
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="maximumQuantity")
    def maximum_quantity(self) -> int:
        """
        Maximum quantity that can be ordered
        """
        return pulumi.get(self, "maximum_quantity")

    @property
    @pulumi.getter(name="maximumRepeat")
    def maximum_repeat(self) -> int:
        """
        Maximum repeat for renewal
        """
        return pulumi.get(self, "maximum_repeat")

    @property
    @pulumi.getter(name="minimumQuantity")
    def minimum_quantity(self) -> int:
        """
        Minimum quantity that can be ordered
        """
        return pulumi.get(self, "minimum_quantity")

    @property
    @pulumi.getter(name="minimumRepeat")
    def minimum_repeat(self) -> int:
        """
        Minimum repeat for renewal
        """
        return pulumi.get(self, "minimum_repeat")

    @property
    @pulumi.getter(name="priceInUcents")
    def price_in_ucents(self) -> int:
        """
        Price of the product in micro-centims
        """
        return pulumi.get(self, "price_in_ucents")

    @property
    @pulumi.getter
    def prices(self) -> Sequence['outputs.GetOrderCartProductResultPricePriceResult']:
        """
        Price of the product (Price with its currency and textual representation)
        """
        return pulumi.get(self, "prices")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="pricingType")
    def pricing_type(self) -> str:
        """
        Pricing type
        """
        return pulumi.get(self, "pricing_type")


@pulumi.output_type
class GetOrderCartProductResultPricePriceResult(dict):
    def __init__(__self__, *,
                 currency_code: str,
                 text: str,
                 value: float):
        """
        :param str currency_code: Currency code
        :param str text: Textual representation
        :param float value: The effective price
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Textual representation
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The effective price
        """
        return pulumi.get(self, "value")


