"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.access_group import AccessGroup
from delphix.api.gateway.model.access_group_account_ids_request import AccessGroupAccountIdsRequest
from delphix.api.gateway.model.access_group_policies_request import AccessGroupPoliciesRequest
from delphix.api.gateway.model.access_group_update_parameters import AccessGroupUpdateParameters
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.list_access_groups_response import ListAccessGroupsResponse
from delphix.api.gateway.model.list_roles_response import ListRolesResponse
from delphix.api.gateway.model.role import Role
from delphix.api.gateway.model.tags_request import TagsRequest


class AuthorizationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_access_group_account_ids(
            self,
            access_group_id,
            access_group_account_ids_request,
            **kwargs
        ):
            """Add account ids to an Access group  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_access_group_account_ids(access_group_id, access_group_account_ids_request, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                access_group_account_ids_request (AccessGroupAccountIdsRequest): Account ids to add to the Access group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['access_group_account_ids_request'] = \
                access_group_account_ids_request
            return self.call_with_http_info(**kwargs)

        self.add_access_group_account_ids = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/account-ids',
                'operation_id': 'add_access_group_account_ids',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'access_group_account_ids_request',
                ],
                'required': [
                    'access_group_id',
                    'access_group_account_ids_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'access_group_account_ids_request':
                        (AccessGroupAccountIdsRequest,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'access_group_account_ids_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_access_group_account_ids
        )

        def __add_access_group_account_tags(
            self,
            access_group_id,
            tags_request,
            **kwargs
        ):
            """Add account tags to an Access group  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_access_group_account_tags(access_group_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                tags_request (TagsRequest): Account Tags to add to the Access group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.add_access_group_account_tags = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/tags',
                'operation_id': 'add_access_group_account_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'tags_request',
                ],
                'required': [
                    'access_group_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_access_group_account_tags
        )

        def __add_access_group_policies(
            self,
            access_group_id,
            access_group_policies_request,
            **kwargs
        ):
            """Add policies to an Access group  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_access_group_policies(access_group_id, access_group_policies_request, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                access_group_policies_request (AccessGroupPoliciesRequest): Policies to add to the Access group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['access_group_policies_request'] = \
                access_group_policies_request
            return self.call_with_http_info(**kwargs)

        self.add_access_group_policies = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/policies',
                'operation_id': 'add_access_group_policies',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'access_group_policies_request',
                ],
                'required': [
                    'access_group_id',
                    'access_group_policies_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'access_group_policies_request':
                        (AccessGroupPoliciesRequest,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'access_group_policies_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_access_group_policies
        )

        def __create_access_group(
            self,
            access_group,
            **kwargs
        ):
            """Create a new access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_access_group(access_group, async_req=True)
            >>> result = thread.get()

            Args:
                access_group (AccessGroup):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group'] = \
                access_group
            return self.call_with_http_info(**kwargs)

        self.create_access_group = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups',
                'operation_id': 'create_access_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group',
                ],
                'required': [
                    'access_group',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group':
                        (AccessGroup,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'access_group': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_access_group
        )

        def __delete_access_group(
            self,
            access_group_id,
            **kwargs
        ):
            """Delete an Access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_access_group(access_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            return self.call_with_http_info(**kwargs)

        self.delete_access_group = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}',
                'operation_id': 'delete_access_group',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                ],
                'required': [
                    'access_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_access_group
        )

        def __get_access_group_by_id(
            self,
            access_group_id,
            **kwargs
        ):
            """Returns an Access group by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_access_group_by_id(access_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            return self.call_with_http_info(**kwargs)

        self.get_access_group_by_id = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}',
                'operation_id': 'get_access_group_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                ],
                'required': [
                    'access_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_access_group_by_id
        )

        def __get_access_groups(
            self,
            **kwargs
        ):
            """List all access groups.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_access_groups(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListAccessGroupsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_access_groups = _Endpoint(
            settings={
                'response_type': (ListAccessGroupsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups',
                'operation_id': 'get_access_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_access_groups
        )

        def __get_role_by_id(
            self,
            role_id,
            **kwargs
        ):
            """Returns role by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_role_by_id(role_id, async_req=True)
            >>> result = thread.get()

            Args:
                role_id (str): The ID of the role.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Role
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['role_id'] = \
                role_id
            return self.call_with_http_info(**kwargs)

        self.get_role_by_id = _Endpoint(
            settings={
                'response_type': (Role,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/roles/{roleId}',
                'operation_id': 'get_role_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'role_id',
                ],
                'required': [
                    'role_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'role_id',
                ]
            },
            root_map={
                'validations': {
                    ('role_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'role_id':
                        (str,),
                },
                'attribute_map': {
                    'role_id': 'roleId',
                },
                'location_map': {
                    'role_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_role_by_id
        )

        def __get_roles(
            self,
            **kwargs
        ):
            """List all roles  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_roles(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListRolesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_roles = _Endpoint(
            settings={
                'response_type': (ListRolesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/roles',
                'operation_id': 'get_roles',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_roles
        )

        def __remove_access_group_account_id(
            self,
            access_group_id,
            account_id,
            **kwargs
        ):
            """Remove the account from the access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_access_group_account_id(access_group_id, account_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                account_id (int): The ID of the account.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.remove_access_group_account_id = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/account-ids/{accountId}',
                'operation_id': 'remove_access_group_account_id',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'account_id',
                ],
                'required': [
                    'access_group_id',
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'account_id':
                        (int,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'account_id': 'accountId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__remove_access_group_account_id
        )

        def __remove_access_group_account_tags(
            self,
            access_group_id,
            **kwargs
        ):
            """Remove account tags from an access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_access_group_account_tags(access_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            return self.call_with_http_info(**kwargs)

        self.remove_access_group_account_tags = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/tags/delete',
                'operation_id': 'remove_access_group_account_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'delete_tag',
                ],
                'required': [
                    'access_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__remove_access_group_account_tags
        )

        def __remove_access_group_policy(
            self,
            access_group_id,
            policy_id,
            **kwargs
        ):
            """Remove the policy from the Access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_access_group_policy(access_group_id, policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.
                policy_id (str): The ID of the Access group policy.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            kwargs['policy_id'] = \
                policy_id
            return self.call_with_http_info(**kwargs)

        self.remove_access_group_policy = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}/policies/{policyId}',
                'operation_id': 'remove_access_group_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'policy_id',
                ],
                'required': [
                    'access_group_id',
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                    'policy_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                    ('policy_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'policy_id':
                        (str,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__remove_access_group_policy
        )

        def __update_access_group(
            self,
            access_group_id,
            **kwargs
        ):
            """Update an Access group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_access_group(access_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                access_group_id (str): The ID of the Access group.

            Keyword Args:
                access_group_update_parameters (AccessGroupUpdateParameters): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AccessGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['access_group_id'] = \
                access_group_id
            return self.call_with_http_info(**kwargs)

        self.update_access_group = _Endpoint(
            settings={
                'response_type': (AccessGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/access-groups/{accessGroupId}',
                'operation_id': 'update_access_group',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'access_group_id',
                    'access_group_update_parameters',
                ],
                'required': [
                    'access_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'access_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('access_group_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'access_group_id':
                        (str,),
                    'access_group_update_parameters':
                        (AccessGroupUpdateParameters,),
                },
                'attribute_map': {
                    'access_group_id': 'accessGroupId',
                },
                'location_map': {
                    'access_group_id': 'path',
                    'access_group_update_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_access_group
        )
