"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .availablemodels import AvailableModels
from .logicaloperator import LogicalOperator, LogicalOperatorTypedDict
from .querysettings import QuerySettings, QuerySettingsTypedDict
from enum import Enum
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class Type(str, Enum):
    r"""Type of input (text, url, or base64)"""

    TEXT = "text"
    URL = "url"
    BASE64 = "base64"


class SearchModelSearchQueryTypedDict(TypedDict):
    embedding_model: AvailableModels
    value: str
    r"""Query value - can be text, URL, or base64 encoded image"""
    type: Type
    r"""Type of input (text, url, or base64)"""
    filters: NotRequired[Nullable[LogicalOperatorTypedDict]]
    r"""Optional filters for the query, this is used for filtering individual vector indexes"""
    settings: NotRequired[Nullable[QuerySettingsTypedDict]]
    r"""Optional settings for this specific query"""


class SearchModelSearchQuery(BaseModel):
    embedding_model: AvailableModels

    value: str
    r"""Query value - can be text, URL, or base64 encoded image"""

    type: Type
    r"""Type of input (text, url, or base64)"""

    filters: OptionalNullable[LogicalOperator] = UNSET
    r"""Optional filters for the query, this is used for filtering individual vector indexes"""

    settings: OptionalNullable[QuerySettings] = UNSET
    r"""Optional settings for this specific query"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["filters", "settings"]
        nullable_fields = ["filters", "settings"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
