"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .featureoptions import FeatureOptions, FeatureOptionsTypedDict
from .logicaloperator import LogicalOperator, LogicalOperatorTypedDict
from .nodeoptions import NodeOptions, NodeOptionsTypedDict
from .sortoption import SortOption, SortOptionTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class ListClassificationsRequestTypedDict(TypedDict):
    r"""Request model for listing classifications with filters"""

    filters: NotRequired[Nullable[LogicalOperatorTypedDict]]
    r"""Complex nested query filters for classifications"""
    sort: NotRequired[Nullable[SortOptionTypedDict]]
    r"""Sort options for ordering classifications"""
    feature_options: NotRequired[Nullable[FeatureOptionsTypedDict]]
    r"""Controls what feature data to include in the response. Note: Including additional data increases response latency."""
    node_options: NotRequired[Nullable[NodeOptionsTypedDict]]
    r"""Controls what node data to include in the response. Note: Including additional data increases response latency."""


class ListClassificationsRequest(BaseModel):
    r"""Request model for listing classifications with filters"""

    filters: OptionalNullable[LogicalOperator] = UNSET
    r"""Complex nested query filters for classifications"""

    sort: OptionalNullable[SortOption] = UNSET
    r"""Sort options for ordering classifications"""

    feature_options: OptionalNullable[FeatureOptions] = UNSET
    r"""Controls what feature data to include in the response. Note: Including additional data increases response latency."""

    node_options: OptionalNullable[NodeOptions] = UNSET
    r"""Controls what node data to include in the response. Note: Including additional data increases response latency."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["filters", "sort", "feature_options", "node_options"]
        nullable_fields = ["filters", "sort", "feature_options", "node_options"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
