"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .denseembedding import DenseEmbedding, DenseEmbeddingTypedDict
from .sparseembedding import SparseEmbedding, SparseEmbeddingTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


EmbeddingTypedDict = TypeAliasType(
    "EmbeddingTypedDict", Union[DenseEmbeddingTypedDict, SparseEmbeddingTypedDict]
)
r"""The embedding of the processed data, either dense or sparse format"""


Embedding = TypeAliasType("Embedding", Union[DenseEmbedding, SparseEmbedding])
r"""The embedding of the processed data, either dense or sparse format"""


class EmbeddingResponseTypedDict(TypedDict):
    embedding: EmbeddingTypedDict
    r"""The embedding of the processed data, either dense or sparse format"""
    elapsed_time: NotRequired[Nullable[float]]
    r"""The time taken to process the data."""


class EmbeddingResponse(BaseModel):
    embedding: Embedding
    r"""The embedding of the processed data, either dense or sparse format"""

    elapsed_time: OptionalNullable[float] = UNSET
    r"""The time taken to process the data."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["elapsed_time"]
        nullable_fields = ["elapsed_time"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
