"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Any
from typing_extensions import NotRequired, TypedDict


class FileDataTypedDict(TypedDict):
    pass


class FileData(BaseModel):
    pass


class MetadataTypedDict(TypedDict):
    pass


class Metadata(BaseModel):
    pass


class AssetResponseTypedDict(TypedDict):
    asset_id: NotRequired[Nullable[str]]
    r"""The unique identifier for the asset"""
    collection_id: NotRequired[Nullable[str]]
    r"""The ID of the collection the asset belongs to"""
    status: NotRequired[Nullable[str]]
    r"""The current status of the asset processing"""
    file_data: NotRequired[Nullable[FileDataTypedDict]]
    r"""File data associated with the asset"""
    metadata: NotRequired[Nullable[MetadataTypedDict]]
    r"""Additional metadata associated with the asset"""
    error: NotRequired[Nullable[Any]]
    r"""The error message if the asset processing failed"""
    modality: NotRequired[Nullable[str]]
    r"""The type of media"""
    task_id: NotRequired[Nullable[str]]
    r"""The task ID"""
    file_hash: NotRequired[Nullable[str]]
    r"""The unique hash of the"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The timestamp when the asset was last updated"""
    created_at: NotRequired[Nullable[datetime]]
    r"""The timestamp when the asset was created"""
    score: NotRequired[Nullable[float]]
    r"""The relevance score of the asset"""
    url: NotRequired[Nullable[str]]
    r"""The presigned URL for accessing the asset"""
    preview_url: NotRequired[Nullable[str]]
    r"""The presigned URL for accessing the asset preview"""
    duplicate_of: NotRequired[Nullable[str]]
    r"""The asset_id of the asset that this asset is a duplicate of"""


class AssetResponse(BaseModel):
    asset_id: OptionalNullable[str] = UNSET
    r"""The unique identifier for the asset"""

    collection_id: OptionalNullable[str] = UNSET
    r"""The ID of the collection the asset belongs to"""

    status: OptionalNullable[str] = UNSET
    r"""The current status of the asset processing"""

    file_data: OptionalNullable[FileData] = UNSET
    r"""File data associated with the asset"""

    metadata: OptionalNullable[Metadata] = UNSET
    r"""Additional metadata associated with the asset"""

    error: OptionalNullable[Any] = UNSET
    r"""The error message if the asset processing failed"""

    modality: OptionalNullable[str] = UNSET
    r"""The type of media"""

    task_id: OptionalNullable[str] = UNSET
    r"""The task ID"""

    file_hash: OptionalNullable[str] = UNSET
    r"""The unique hash of the"""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The timestamp when the asset was last updated"""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The timestamp when the asset was created"""

    score: OptionalNullable[float] = UNSET
    r"""The relevance score of the asset"""

    url: OptionalNullable[str] = UNSET
    r"""The presigned URL for accessing the asset"""

    preview_url: OptionalNullable[str] = UNSET
    r"""The presigned URL for accessing the asset preview"""

    duplicate_of: OptionalNullable[str] = UNSET
    r"""The asset_id of the asset that this asset is a duplicate of"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "asset_id",
            "collection_id",
            "status",
            "file_data",
            "metadata",
            "error",
            "modality",
            "task_id",
            "file_hash",
            "updated_at",
            "created_at",
            "score",
            "url",
            "preview_url",
            "duplicate_of",
        ]
        nullable_fields = [
            "asset_id",
            "collection_id",
            "status",
            "file_data",
            "metadata",
            "error",
            "modality",
            "task_id",
            "file_hash",
            "updated_at",
            "created_at",
            "score",
            "url",
            "preview_url",
            "duplicate_of",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
