# Autosubmit API

# Table of Contents

1. [Overview](#overview)
2. [Autosubmit Big Picture](#autosubmit-big-picture)
3. [General Knowledge Requirements](#general-knowledge-requirements)
4. [Deployment](#deployment)

## Overview

Autosubmit API is a package that consumes the information generated by Autosubmit and serves it as an API.

Distribution: https://pypi.org/project/autosubmit-api/

See the wiki for documentation.

## Autosubmit Big Picture

![Autosubmit Big Picture](/docs/Total_Autosubmit_Diagram.png)

In this image you can see the flow of information in the **Autosubmit environment**.

* **Autosubmit**: Machines running Autosubmit.
* **Remote Platforms**: Platforms (HPCs in most cases) to which Autosubmit connects to run jobs. 
* **Experiment Database**: Starting from Autosubmit `3.13.0`, each experiment generates a set of databases that save important (reusable) information about it. We have the `historical database`, `graph database`, `structures database`.
* **File System**: The file system where the experiment files are stored.
* **Data Process Workers**: **Autosubmit API** implements a set of workers that periodically collect information from the experiments or complement that information. In the current **BSC** implementation, these workers are running no `bscesweb04` under `webadmin` user.
* **Main Database**: **Autosubmit API** uses a centralized database to keep track of important experiment information. The **workers** fill this information. **Autosubmit** also writes into this database.
* **Autosubmit API**: See [Autosubmit API](https://earth.bsc.es/gitlab/es/autosubmit_api). Currently, under **BSC** implementation, this API is running on `bscesweb04` under `webadmin` user. This API exposes a set of requests that **Autosubmit GUI** consumes and serves to the users through the front end.
* **Autosubmit GUI**: This project.
* **Authentication Server**: **BSC Central Authentication Service**.
* **Users**: Users that access the GUI through their web browsers from any device. The current implementation requires that an user generates a token using the Authentication server once every 5 days.

## General Knowledge Requirements

* Python 2.7
* Object Oriented Programming
* Flask
* Gunicorn
* Unit testing

## Deployment

Our local implementation is currently on `bscesweb04` under the user `webadmin`, make sure you have access to that server and that particular user. Once you have logged in to that machine under that user, follow these steps to start the API:

1. Activate the virtual environment: `source /srv/www/htdocs/AutosubmitAPI/venv27/bin/activate`.
    1. Once the virtual environment is active, you can uninstall and install `autosubmit_api` using `pip` to verify it is updated. 
2. Make sure `gunicorn` is not running: `pstree -ap | grep gunicorn`. This method may not be as effective to identify the API service if more than one `gunicorn` instance is running for different services, but so far it is the easy way to do it. If the process is running and you want to start over, `kill -9` it.
3. To start `gunicorn` for `autosubmit_api` execute: `gunicorn --error-logfile ~/logunicorn0320.txt --timeout 600 -b 0.0.0.0:8081 -w 4 autosubmit_api.app:app --daemon`, where `~/logunicorn0320.txt` is the path to the log file that will be used (it does not need to exist beforehand), `--timeout 600` indicates the number of seconds that `gunicorn` will wait for each process before killing it, `-b 0.0.0.0:8081` is the IP and port that will be used (two services cannot share the same IP and port, `0.0.0.0` is a shortcut for localhost, in practice, the public address will be `http://192.168.11.91:8081`), `autosubmit_api.app:app` is the name of the file that exposes the operations that the API will answer, and `--daemon` is a flag that indicates that this is a background process.
4. You can test if the process is running with the method mentioned before, or by checking the log files you set in the previous step.

**Autosubmit API** should be UP and RUNNING. 


