/*
 * Decompiled with CFR 0.152.
 */
package org.opendatakit.validate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.javarosa.core.reference.Reference;

public class StubReference
implements Reference {
    private String uri;

    public StubReference(String URI2) {
        this.uri = URI2;
    }

    @Override
    public boolean doesBinaryExist() {
        return true;
    }

    @Override
    public InputStream getStream() {
        return null;
    }

    @Override
    public String getURI() {
        return null;
    }

    @Override
    public String getLocalURI() {
        if (this.uri.toLowerCase().startsWith("jr://file/")) {
            return StubReference.getResourceAsFile("fake-itemset.xml").toURI().getPath();
        }
        if (this.uri.toLowerCase().startsWith("jr://file-csv/")) {
            return StubReference.getResourceAsFile("fake-itemset.csv").toURI().getPath();
        }
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public void remove() {
    }

    @Override
    public Reference[] probeAlternativeReferences() {
        return new Reference[0];
    }

    private static File getResourceAsFile(String resourcePath) {
        try {
            InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream(resourcePath);
            if (in == null) {
                return null;
            }
            File tempFile = File.createTempFile(String.valueOf(in.hashCode()), ".tmp");
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            return tempFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

