/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.parser.ast;

import java.util.Enumeration;
import java.util.Vector;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.parser.Parser;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.javarosa.xpath.parser.ast.ASTNodeAbstractExpr;
import org.javarosa.xpath.parser.ast.ASTNodeBinaryOp;
import org.javarosa.xpath.parser.ast.ASTNodeFilterExpr;
import org.javarosa.xpath.parser.ast.ASTNodeFunctionCall;
import org.javarosa.xpath.parser.ast.ASTNodeLocPath;
import org.javarosa.xpath.parser.ast.ASTNodePathStep;
import org.javarosa.xpath.parser.ast.ASTNodePredicate;
import org.javarosa.xpath.parser.ast.ASTNodeUnaryOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASTNode {
    private static final Logger logger = LoggerFactory.getLogger(ASTNode.class);
    int indent;

    public abstract Vector<ASTNode> getChildren();

    public abstract XPathExpression build() throws XPathSyntaxException;

    private void printStr(String s) {
        StringBuilder padding = new StringBuilder();
        for (int i = 0; i < 2 * this.indent; ++i) {
            padding.append(" ");
        }
        logger.info("{}{}", (Object)padding, (Object)s);
    }

    public void print() {
        this.indent = -1;
        this.print(this);
    }

    public void print(Object o) {
        ++this.indent;
        if (o instanceof ASTNodeAbstractExpr) {
            ASTNodeAbstractExpr x = (ASTNodeAbstractExpr)o;
            this.printStr("abstractexpr {");
            for (int i = 0; i < x.content.size(); ++i) {
                if (x.getType(i) == 1) {
                    this.print(x.content.elementAt(i));
                    continue;
                }
                this.printStr(x.getToken(i).toString());
            }
            this.printStr("}");
        } else if (o instanceof ASTNodePredicate) {
            ASTNodePredicate x = (ASTNodePredicate)o;
            this.printStr("predicate {");
            this.print(x.expr);
            this.printStr("}");
        } else if (o instanceof ASTNodeFunctionCall) {
            ASTNodeFunctionCall x = (ASTNodeFunctionCall)o;
            if (x.args.size() == 0) {
                this.printStr("func {" + x.name.toString() + ", args {none}}");
            } else {
                this.printStr("func {" + x.name.toString() + ", args {{");
                for (int i = 0; i < x.args.size(); ++i) {
                    this.print(x.args.elementAt(i));
                    if (i >= x.args.size() - 1) continue;
                    this.printStr(" } {");
                }
                this.printStr("}}}");
            }
        } else if (o instanceof ASTNodeBinaryOp) {
            ASTNodeBinaryOp x = (ASTNodeBinaryOp)o;
            this.printStr("opexpr {");
            block25: for (int i = 0; i < x.exprs.size(); ++i) {
                this.print(x.exprs.elementAt(i));
                if (i >= x.exprs.size() - 1) continue;
                switch (Parser.vectInt(x.ops, i)) {
                    case 1: {
                        this.printStr("and:");
                        continue block25;
                    }
                    case 22: {
                        this.printStr("or:");
                        continue block25;
                    }
                    case 9: {
                        this.printStr("eq:");
                        continue block25;
                    }
                    case 19: {
                        this.printStr("neq:");
                        continue block25;
                    }
                    case 14: {
                        this.printStr("lt:");
                        continue block25;
                    }
                    case 15: {
                        this.printStr("lte:");
                        continue block25;
                    }
                    case 10: {
                        this.printStr("gt:");
                        continue block25;
                    }
                    case 11: {
                        this.printStr("gte:");
                        continue block25;
                    }
                    case 23: {
                        this.printStr("plus:");
                        continue block25;
                    }
                    case 16: {
                        this.printStr("minus:");
                        continue block25;
                    }
                    case 7: {
                        this.printStr("div:");
                        continue block25;
                    }
                    case 17: {
                        this.printStr("mod:");
                        continue block25;
                    }
                    case 18: {
                        this.printStr("mult:");
                        continue block25;
                    }
                    case 30: {
                        this.printStr("union:");
                    }
                }
            }
            this.printStr("}");
        } else if (o instanceof ASTNodeUnaryOp) {
            ASTNodeUnaryOp x = (ASTNodeUnaryOp)o;
            this.printStr("opexpr {");
            switch (x.op) {
                case 29: {
                    this.printStr("num-neg:");
                }
            }
            this.print(x.expr);
            this.printStr("}");
        } else if (o instanceof ASTNodeLocPath) {
            ASTNodeLocPath x = (ASTNodeLocPath)o;
            this.printStr("pathexpr {");
            int offset = x.isAbsolute() ? 1 : 0;
            block26: for (int i = 0; i < x.clauses.size() + offset; ++i) {
                if (offset == 0 || i > 0) {
                    this.print(x.clauses.elementAt(i - offset));
                }
                if (i >= x.separators.size()) continue;
                switch (Parser.vectInt(x.separators, i)) {
                    case 6: {
                        this.printStr("dbl-slash:");
                        continue block26;
                    }
                    case 27: {
                        this.printStr("slash:");
                    }
                }
            }
            this.printStr("}");
        } else if (o instanceof ASTNodePathStep) {
            ASTNodePathStep x = (ASTNodePathStep)o;
            this.printStr("step {axis: " + x.axisType + " node test type: " + x.nodeTestType);
            if (x.axisType == 2) {
                this.printStr("  axis type: " + x.axisVal);
            }
            if (x.nodeTestType == 1) {
                this.printStr("  node test name: " + x.nodeTestQName.toString());
            }
            if (x.nodeTestType == 6) {
                this.print(x.nodeTestFunc);
            }
            this.printStr("predicates...");
            Enumeration<ASTNode> e = x.predicates.elements();
            while (e.hasMoreElements()) {
                this.print(e.nextElement());
            }
            this.printStr("}");
        } else if (o instanceof ASTNodeFilterExpr) {
            ASTNodeFilterExpr x = (ASTNodeFilterExpr)o;
            this.printStr("filter expr {");
            this.print(x.expr);
            this.printStr("predicates...");
            Enumeration<ASTNode> e = x.predicates.elements();
            while (e.hasMoreElements()) {
                this.print(e.nextElement());
            }
            this.printStr("}");
        }
        --this.indent;
    }
}

