/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.model.xform;

import java.io.IOException;
import org.javarosa.core.api.IModule;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.util.restorable.IXFormyFactory;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.services.PrototypeManager;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.model.xform.XFormSerializingVisitor;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xform.util.XFormAnswerDataParser;
import org.javarosa.xform.util.XFormAnswerDataSerializer;
import org.javarosa.xpath.XPathConditional;
import org.javarosa.xpath.XPathParseTool;
import org.javarosa.xpath.expr.XPathPathExpr;

public class XFormsModule
implements IModule {
    @Override
    public void registerModule() {
        String[] classes = new String[]{"org.javarosa.model.xform.XPathReference", "org.javarosa.xpath.XPathConditional"};
        PrototypeManager.registerPrototypes(classes);
        PrototypeManager.registerPrototypes(XPathParseTool.xpathClasses);
        RestoreUtils.xfFact = new IXFormyFactory(){

            @Override
            public TreeReference ref(String refStr) {
                return FormInstance.unpackReference(new XPathReference(refStr));
            }

            @Override
            public IDataPayload serializeInstance(FormInstance dm) {
                try {
                    return new XFormSerializingVisitor().createSerializedPayload(dm);
                }
                catch (IOException e) {
                    return null;
                }
            }

            @Override
            public FormInstance parseRestore(byte[] data, Class restorableType) {
                return XFormParser.restoreDataModel(data, restorableType);
            }

            @Override
            public IAnswerData parseData(String textVal, int dataType, TreeReference ref, FormDef f) {
                return XFormAnswerDataParser.getAnswerData(textVal, dataType, XFormParser.ghettoGetQuestionDef(dataType, f, ref));
            }

            @Override
            public String serializeData(IAnswerData data) {
                return (String)new XFormAnswerDataSerializer().serializeAnswerData(data);
            }

            @Override
            public IConditionExpr refToPathExpr(TreeReference ref) {
                return new XPathConditional(XPathPathExpr.fromRef(ref));
            }
        };
    }
}

