/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.model.xform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IAnswerDataSerializer;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.utils.IInstanceSerializingVisitor;
import org.javarosa.core.services.transport.payload.ByteArrayPayload;
import org.javarosa.core.services.transport.payload.DataPointerPayload;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.core.services.transport.payload.MultiMessagePayload;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.util.XFormAnswerDataSerializer;
import org.javarosa.xform.util.XFormSerializer;
import org.kxml2.kdom.Document;
import org.kxml2.kdom.Element;

public class XFormSerializingVisitor
implements IInstanceSerializingVisitor {
    Document theXmlDoc;
    IAnswerDataSerializer serializer;
    TreeReference rootRef;
    FormDef schema;
    List<IDataPointer> dataPointers;
    boolean respectRelevance = true;

    public XFormSerializingVisitor() {
        this(true);
    }

    public XFormSerializingVisitor(boolean respectRelevance) {
        this.respectRelevance = respectRelevance;
    }

    private void init() {
        this.theXmlDoc = null;
        this.schema = null;
        this.dataPointers = new ArrayList<IDataPointer>(0);
    }

    @Override
    public byte[] serializeInstance(FormInstance model, FormDef formDef) throws IOException {
        this.init();
        this.schema = formDef;
        return this.serializeInstance(model);
    }

    @Override
    public byte[] serializeInstance(FormInstance model) throws IOException {
        return this.serializeInstance(model, new XPathReference("/"));
    }

    @Override
    public byte[] serializeInstance(FormInstance model, IDataReference ref) throws IOException {
        this.init();
        this.rootRef = FormInstance.unpackReference(ref);
        if (this.serializer == null) {
            this.setAnswerDataSerializer(new XFormAnswerDataSerializer());
        }
        model.accept(this);
        if (this.theXmlDoc != null) {
            return XFormSerializer.getUtfBytes(this.theXmlDoc);
        }
        return null;
    }

    @Override
    public IDataPayload createSerializedPayload(FormInstance model) throws IOException {
        return this.createSerializedPayload(model, new XPathReference("/"));
    }

    @Override
    public IDataPayload createSerializedPayload(FormInstance model, IDataReference ref) throws IOException {
        this.init();
        this.rootRef = FormInstance.unpackReference(ref);
        if (this.serializer == null) {
            this.setAnswerDataSerializer(new XFormAnswerDataSerializer());
        }
        model.accept(this);
        if (this.theXmlDoc != null) {
            byte[] form = XFormSerializer.getUtfBytes(this.theXmlDoc);
            if (this.dataPointers.size() == 0) {
                return new ByteArrayPayload(form, null, 1);
            }
            MultiMessagePayload payload = new MultiMessagePayload();
            payload.addPayload(new ByteArrayPayload(form, "xml_submission_file", 1));
            for (IDataPointer pointer : this.dataPointers) {
                payload.addPayload(new DataPointerPayload(pointer));
            }
            return payload;
        }
        return null;
    }

    @Override
    public void visit(FormInstance tree) {
        this.theXmlDoc = new Document();
        TreeElement root = (TreeElement)tree.resolveReference(this.rootRef);
        if (root == null) {
            root = tree.getRoot();
        }
        if (root != null) {
            this.theXmlDoc.addChild(2, this.serializeNode(root));
        }
        Element top = this.theXmlDoc.getElement(0);
        String[] prefixes = tree.getNamespacePrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            top.setPrefix(prefixes[i], tree.getNamespaceURI(prefixes[i]));
        }
        if (tree.schema != null) {
            top.setNamespace(tree.schema);
            top.setPrefix("", tree.schema);
        }
    }

    public Element serializeNode(TreeElement instanceNode) {
        Element e = new Element();
        if (this.respectRelevance && !instanceNode.isRelevant() || instanceNode.getMult() == -2) {
            return null;
        }
        if (instanceNode.getValue() != null) {
            Object serializedAnswer;
            try {
                serializedAnswer = this.serializer.serializeAnswerData(instanceNode.getValue(), instanceNode.getDataType());
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("Unable to serialize " + instanceNode.getValue().toString() + ". Exception: " + ex.toString());
            }
            if (serializedAnswer instanceof Element) {
                e = (Element)serializedAnswer;
            } else if (serializedAnswer instanceof String) {
                e = new Element();
                e.addChild(4, (String)serializedAnswer);
            } else {
                throw new RuntimeException("Can't handle serialized output for" + instanceNode.getValue().toString() + ", " + serializedAnswer);
            }
            if (this.serializer.containsExternalData(instanceNode.getValue()).booleanValue()) {
                IDataPointer[] pointer = this.serializer.retrieveExternalDataPointer(instanceNode.getValue());
                for (int i = 0; i < pointer.length; ++i) {
                    this.dataPointers.add(pointer[i]);
                }
            }
        } else {
            String childName;
            int i;
            ArrayList<String> childNames = new ArrayList<String>(instanceNode.getNumChildren());
            for (i = 0; i < instanceNode.getNumChildren(); ++i) {
                childName = instanceNode.getChildAt(i).getName();
                if (childNames.contains(childName)) continue;
                childNames.add(childName);
            }
            for (i = 0; i < childNames.size(); ++i) {
                childName = (String)childNames.get(i);
                int mult = instanceNode.getChildMultiplicity(childName);
                for (int j = 0; j < mult; ++j) {
                    Element child = this.serializeNode(instanceNode.getChild(childName, j));
                    if (child == null) continue;
                    e.addChild(2, child);
                }
            }
        }
        e.setName(instanceNode.getName());
        for (int i = 0; i < instanceNode.getAttributeCount(); ++i) {
            String namespace = instanceNode.getAttributeNamespace(i);
            String name = instanceNode.getAttributeName(i);
            String val = instanceNode.getAttributeValue(i);
            if (val == null) {
                val = "";
            }
            e.setAttribute(namespace, name, val);
        }
        if (instanceNode.getNamespace() != null) {
            e.setNamespace(instanceNode.getNamespace());
        }
        return e;
    }

    @Override
    public void setAnswerDataSerializer(IAnswerDataSerializer ads) {
        this.serializer = ads;
    }

    @Override
    public IInstanceSerializingVisitor newInstance() {
        XFormSerializingVisitor modelSerializer = new XFormSerializingVisitor();
        modelSerializer.setAnswerDataSerializer(this.serializer);
        return modelSerializer;
    }
}

