/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.services.PrototypeManager;
import org.javarosa.core.util.CacheTable;
import org.javarosa.core.util.OrderedMap;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtWrapIntEncoding;
import org.javarosa.core.util.externalizable.ExtWrapIntEncodingUniform;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtUtil {
    public static boolean interning = true;
    public static CacheTable<String> stringCache;

    public static byte[] serialize(Object o) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ExtUtil.write(new DataOutputStream(baos), o);
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException writing to ByteArrayOutputStream; shouldn't happen!");
        }
        return baos.toByteArray();
    }

    public static Object deserialize(byte[] data, Class type) throws DeserializationException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            Object object = ExtUtil.read(new DataInputStream(bais), type);
            return object;
        }
        catch (EOFException | UTFDataFormatException eofe) {
            throw new DeserializationException("Unexpectedly reached end of stream when deserializing");
        }
        catch (IOException e) {
            throw new RuntimeException("Unknown IOException reading from ByteArrayInputStream; shouldn't happen!");
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Object deserialize(byte[] data, ExternalizableWrapper ew) throws DeserializationException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            Object object = ExtUtil.read(new DataInputStream(bais), ew);
            return object;
        }
        catch (EOFException | UTFDataFormatException eofe) {
            throw new DeserializationException("Unexpectedly reached end of stream when deserializing");
        }
        catch (IOException e) {
            throw new RuntimeException("Unknown IOException reading from ByteArrayInputStream; shouldn't happen!");
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static int getSize(Object o) {
        return ExtUtil.serialize(o).length;
    }

    public static PrototypeFactory defaultPrototypes() {
        return PrototypeManager.getDefault();
    }

    public static void write(DataOutputStream out, Object data) throws IOException {
        if (data instanceof Externalizable) {
            ((Externalizable)data).writeExternal(out);
        } else if (data instanceof Byte) {
            ExtUtil.writeNumeric(out, ((Byte)data).byteValue());
        } else if (data instanceof Short) {
            ExtUtil.writeNumeric(out, ((Short)data).shortValue());
        } else if (data instanceof Integer) {
            ExtUtil.writeNumeric(out, ((Integer)data).intValue());
        } else if (data instanceof Long) {
            ExtUtil.writeNumeric(out, (Long)data);
        } else if (data instanceof Character) {
            ExtUtil.writeChar(out, ((Character)data).charValue());
        } else if (data instanceof Float) {
            ExtUtil.writeDecimal(out, ((Float)data).floatValue());
        } else if (data instanceof Double) {
            ExtUtil.writeDecimal(out, (Double)data);
        } else if (data instanceof Boolean) {
            ExtUtil.writeBool(out, (Boolean)data);
        } else if (data instanceof String) {
            ExtUtil.writeString(out, (String)data);
        } else if (data instanceof Date) {
            ExtUtil.writeDate(out, (Date)data);
        } else if (data instanceof byte[]) {
            ExtUtil.writeBytes(out, (byte[])data);
        } else {
            throw new ClassCastException("Not a serializable datatype: " + data.getClass().getName());
        }
    }

    public static void writeNumeric(DataOutputStream out, long val) throws IOException {
        ExtUtil.writeNumeric(out, val, new ExtWrapIntEncodingUniform());
    }

    public static void writeNumeric(DataOutputStream out, long val, ExtWrapIntEncoding encoding) throws IOException {
        ExtUtil.write(out, encoding.clone(val));
    }

    public static void writeChar(DataOutputStream out, char val) throws IOException {
        out.writeChar(val);
    }

    public static void writeDecimal(DataOutputStream out, double val) throws IOException {
        out.writeDouble(val);
    }

    public static void writeBool(DataOutputStream out, boolean val) throws IOException {
        out.writeBoolean(val);
    }

    public static void writeString(DataOutputStream out, String val) throws IOException {
        out.writeUTF(val);
    }

    public static void writeDate(DataOutputStream out, Date val) throws IOException {
        ExtUtil.writeNumeric(out, val.getTime());
    }

    public static void writeBytes(DataOutputStream out, byte[] bytes) throws IOException {
        ExtUtil.writeNumeric(out, bytes.length);
        if (bytes.length > 0) {
            out.write(bytes);
        }
    }

    public static void writeInts(DataOutputStream out, int[] ints) throws IOException {
        ExtUtil.writeNumeric(out, ints.length);
        for (int i : ints) {
            ExtUtil.writeNumeric(out, i);
        }
    }

    public static void writeAttributes(DataOutputStream out, List<TreeElement> attributes) throws IOException {
        ExtUtil.writeNumeric(out, attributes.size());
        for (TreeElement e : attributes) {
            ExtUtil.write(out, e.getNamespace());
            ExtUtil.write(out, e.getName());
            ExtUtil.write(out, e.getAttributeValue());
        }
    }

    public static Object read(DataInputStream in, Class type) throws IOException, DeserializationException {
        return ExtUtil.read(in, type, null);
    }

    public static Object read(DataInputStream in, Class type, PrototypeFactory pf) throws IOException, DeserializationException {
        if (Externalizable.class.isAssignableFrom(type)) {
            Externalizable ext = (Externalizable)PrototypeFactory.getInstance(type);
            ext.readExternal(in, pf == null ? ExtUtil.defaultPrototypes() : pf);
            return ext;
        }
        if (type == Byte.class) {
            return ExtUtil.readByte(in);
        }
        if (type == Short.class) {
            return ExtUtil.readShort(in);
        }
        if (type == Integer.class) {
            return ExtUtil.readInt(in);
        }
        if (type == Long.class) {
            return ExtUtil.readNumeric(in);
        }
        if (type == Character.class) {
            return Character.valueOf(ExtUtil.readChar(in));
        }
        if (type == Float.class) {
            return Float.valueOf((float)ExtUtil.readDecimal(in));
        }
        if (type == Double.class) {
            return ExtUtil.readDecimal(in);
        }
        if (type == Boolean.class) {
            return ExtUtil.readBool(in);
        }
        if (type == String.class) {
            return ExtUtil.readString(in);
        }
        if (type == Date.class) {
            return ExtUtil.readDate(in);
        }
        if (type == byte[].class) {
            return ExtUtil.readBytes(in);
        }
        throw new ClassCastException("Not a deserializable datatype: " + type.getName());
    }

    public static Object read(DataInputStream in, ExternalizableWrapper ew) throws IOException, DeserializationException {
        return ExtUtil.read(in, ew, null);
    }

    public static Object read(DataInputStream in, ExternalizableWrapper ew, PrototypeFactory pf) throws IOException, DeserializationException {
        ew.readExternal(in, pf == null ? ExtUtil.defaultPrototypes() : pf);
        return ew.val;
    }

    public static long readNumeric(DataInputStream in) throws IOException {
        return ExtUtil.readNumeric(in, new ExtWrapIntEncodingUniform());
    }

    public static long readNumeric(DataInputStream in, ExtWrapIntEncoding encoding) throws IOException {
        try {
            return (Long)ExtUtil.read(in, encoding);
        }
        catch (DeserializationException de) {
            throw new RuntimeException("Shouldn't happen: Base-type encoding wrappers should never touch prototypes");
        }
    }

    public static int readInt(DataInputStream in) throws IOException {
        return ExtUtil.toInt(ExtUtil.readNumeric(in));
    }

    public static short readShort(DataInputStream in) throws IOException {
        return ExtUtil.toShort(ExtUtil.readNumeric(in));
    }

    public static byte readByte(DataInputStream in) throws IOException {
        return ExtUtil.toByte(ExtUtil.readNumeric(in));
    }

    public static char readChar(DataInputStream in) throws IOException {
        return in.readChar();
    }

    public static double readDecimal(DataInputStream in) throws IOException {
        return in.readDouble();
    }

    public static boolean readBool(DataInputStream in) throws IOException {
        return in.readBoolean();
    }

    public static String readString(DataInputStream in) throws IOException {
        String s = in.readUTF();
        return interning && stringCache != null ? stringCache.intern(s) : s;
    }

    public static Date readDate(DataInputStream in) throws IOException {
        return new Date(ExtUtil.readNumeric(in));
    }

    public static byte[] readBytes(DataInputStream in) throws IOException {
        int size = (int)ExtUtil.readNumeric(in);
        byte[] bytes = new byte[size];
        int read = 0;
        int toread = size;
        while (read != size) {
            read = in.read(bytes, 0, toread);
            toread -= read;
        }
        return bytes;
    }

    public static int[] readInts(DataInputStream in) throws IOException {
        int size = (int)ExtUtil.readNumeric(in);
        int[] ints = new int[size];
        for (int i = 0; i < size; ++i) {
            ints[i] = (int)ExtUtil.readNumeric(in);
        }
        return ints;
    }

    public static List<TreeElement> readAttributes(DataInputStream in, TreeElement parent) throws IOException {
        int size = (int)ExtUtil.readNumeric(in);
        ArrayList<TreeElement> attributes = new ArrayList<TreeElement>(size);
        for (int i = 0; i < size; ++i) {
            String namespace = ExtUtil.readString(in);
            String name = ExtUtil.readString(in);
            String value = ExtUtil.readString(in);
            TreeElement attr = TreeElement.constructAttributeElement(namespace, name, value);
            attr.setParent(parent);
            attributes.add(attr);
        }
        return attributes;
    }

    public static int toInt(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("Value (" + l + ") cannot fit into int");
        }
        return (int)l;
    }

    public static short toShort(long l) {
        if (l < -32768L || l > 32767L) {
            throw new ArithmeticException("Value (" + l + ") cannot fit into short");
        }
        return (short)l;
    }

    public static byte toByte(long l) {
        if (l < -128L || l > 127L) {
            throw new ArithmeticException("Value (" + l + ") cannot fit into byte");
        }
        return (byte)l;
    }

    public static long toLong(Object o) {
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        throw new ClassCastException();
    }

    public static byte[] nullIfEmpty(byte[] ba) {
        return ba == null ? null : (ba.length == 0 ? null : ba);
    }

    public static String nullIfEmpty(String s) {
        return s == null ? null : (s.length() == 0 ? null : s);
    }

    public static List nullIfEmpty(List v) {
        return v == null ? null : (v.size() == 0 ? null : v);
    }

    public static HashMap nullIfEmpty(HashMap h) {
        return h == null ? null : (h.size() == 0 ? null : h);
    }

    public static byte[] emptyIfNull(byte[] ba) {
        return ba == null ? new byte[]{} : ba;
    }

    public static String emptyIfNull(String s) {
        return s == null ? "" : s;
    }

    public static List emptyIfNull(List v) {
        return v == null ? new ArrayList(0) : v;
    }

    public static HashMap emptyIfNull(HashMap h) {
        return h == null ? new HashMap() : h;
    }

    public static Object unwrap(Object o) {
        return o instanceof ExternalizableWrapper ? ((ExternalizableWrapper)o).baseValue() : o;
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        a = ExtUtil.unwrap(a);
        b = ExtUtil.unwrap(b);
        if (a == null) {
            return b == null;
        }
        if (a instanceof List) {
            return b instanceof List && ExtUtil.listEquals((List)a, (List)b);
        }
        if (a instanceof HashMap) {
            return b instanceof HashMap && ExtUtil.hashMapEquals((HashMap)a, (HashMap)b);
        }
        return a.equals(b);
    }

    public static boolean listEquals(List a, List b) {
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (ExtUtil.equals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean arrayEquals(Object[] a, Object[] b) {
        if (a == b) {
            return true;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (ExtUtil.equals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hashMapEquals(HashMap a, HashMap b) {
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        if (a instanceof OrderedMap != b instanceof OrderedMap) {
            return false;
        }
        for (Object keyA : a.keySet()) {
            if (ExtUtil.equals(a.get(keyA), b.get(keyA))) continue;
            return false;
        }
        if (a instanceof OrderedMap && b instanceof OrderedMap) {
            Iterator ea = a.keySet().iterator();
            Iterator eb = b.keySet().iterator();
            while (ea.hasNext()) {
                Object keyB;
                Object keyA = ea.next();
                if (keyA.equals(keyB = eb.next())) continue;
                return false;
            }
        }
        return true;
    }

    public static String printBytes(byte[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i]);
            hex = hex.length() == 1 ? "0" + hex : hex.substring(hex.length() - 2);
            sb.append(hex);
            if (i >= data.length - 1) continue;
            if ((i + 1) % 30 == 0) {
                sb.append("\n ");
                continue;
            }
            if ((i + 1) % 10 == 0) {
                sb.append("  ");
                continue;
            }
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static void deserialize(byte[] data, Externalizable ext) throws IOException, DeserializationException {
        ext.readExternal(new DataInputStream(new ByteArrayInputStream(data)), ExtUtil.defaultPrototypes());
    }

    public static Object deserialize(byte[] data, Class type, PrototypeFactory pf) throws IOException, DeserializationException {
        return ExtUtil.read(new DataInputStream(new ByteArrayInputStream(data)), type, pf);
    }

    public static void attachCacheTable(CacheTable<String> stringCache) {
        ExtUtil.stringCache = stringCache;
    }
}

